#ifndef _DEMOKEYBOARD_H_
#define _DEMOKEYBOARD_H_

#include "DemoBase.h"

#include "GUIObserver.h"
#include "GUIValue.h"
#include "GUIGeneralResource.h"

#include "GUITextField.h"
#include "GUIBaseSlider.h"

class CGUIObject;
class CGUIBaseCheckBox;
class CGUIEdit;
class CGUIKeyboard;

/*Observer-Class for the checkbox controlling password-encryption
Alternative method, in contrast to DataPool*/
class ObsvShowPassword : public CGUIObserver
{
public:
    ObsvShowPassword(CGUIEdit* pkPasswordField, CGUIBaseCheckBox* pkCheckbox);

    virtual void OnNotification(const CGUIValue& kObservedValue, const CGUIObject* const pkUpdatedObject, const eC_UInt uiX = 0, const eC_UInt uiY = 0);

private:
    CGUIBaseCheckBox* m_pkCheckbox;
    CGUIEdit* m_pkPasswordField;
};

class ObsvTextWidth : public CGUIObserver
{
public:
    ObsvTextWidth(CGUITextField* pkField, CGUITextField* pkFieldRich, CGUIBaseSlider* pkSlider);

    virtual void OnNotification(const CGUIValue& kObservedValue, const CGUIObject* const pkUpdatedObject, const eC_UInt uiX = 0, const eC_UInt uiY = 0);

private:
    CGUITextField* m_pkTargetObject;
    CGUITextField* m_pkTargetObjectRich;
};

/*Class for the Carousel-Dialog*/
class DemoKeyboard : public DemoBase
{
public:
    DemoKeyboard();

    virtual ~DemoKeyboard();

    virtual void Init();

    virtual void DeInit();

    void LoadLayout(eC_Int iActiveLanguage);

private:
    ObsvShowPassword* m_pkShowPassword;
    CGUIKeyboard* m_pkKeyboard;

    ObsvTextWidth* m_pkWidthSlider;
};

#endif
