#ifndef _DEMODATA_H_
#define _DEMODATA_H_

#include "DemoBase.h"

#include "GUIAnimatable.h"
#include "GUIObserver.h"

#include "GUIBaseSlider.h"
#include "GUIChart.h"
#include "GUIGraph.h"
#include "GUIPlot.h"

class TestFunction1 : public CGUIGraphFunction
{
public:
    virtual ~TestFunction1() {}

    eC_Float Calculate(const eC_Float& fInput)
    {
        return fInput * fInput + fInput + 0.5f;
    }
};

class TestFunction2 : public CGUIGraphFunction
{
public:
    virtual ~TestFunction2() {}

    eC_Float Calculate(const eC_Float& fInput)
    {
        return 5.0f * fInput + 4.0f;
    }
};

class TestFunction3 : public CGUIGraphFunction
{
public:
    virtual ~TestFunction3() {}

    eC_Float Calculate(const eC_Float& fInput)
    {
        return (eC_Float)eC_Sin(fInput) * 20.0f;
    }
};

/*Class for the GaugeAndWheel-Dialog*/
class DemoData : public DemoBase, public CGUIAnimatable, public CGUIObserver
{
public:
    DemoData();

    virtual ~DemoData();

    virtual void Init();

    virtual void DeInit();

    virtual void HandleCallAPI(const eC_String& kAPI, const eC_String kParam);

    virtual void OnNotification(const CGUIValue& kObservedValue, const CGUIObject* const pkUpdatedObject, const eC_UInt uiX, const eC_UInt uiY);

    virtual void DoAnimate(const eC_Value &vTimes);

private:
    CGUIChart* m_pkChart;
    DataPoolResource_t m_eChartDatapool;

    CGUIGraph* m_pkGraph;
    TestFunction1* m_pkFunction1;
    TestFunction2* m_pkFunction2;
    TestFunction3* m_pkFunction3;

    CGUIPlot* m_pkPlot;
    eC_Bool m_bAutoRefresh;
    eC_UInt m_uiRefreshInterval;

    CGUIBaseSlider* m_pkRefreshSlider;
};

#endif
