#ifndef _DEMOCONTROLS_H_
#define _DEMOCONTROLS_H_

#include "DemoBase.h"

#include "GUIGeometryObject.h"
#include "GUIProgressBar.h"
#include "GUIImage.h"
#include "GUIRadialSlider.h"
#include "GUIRadialProgressBar.h"
#include "GUIBaseSlider.h"
#include "GUIBaseTextField.h"
#include "GUIRangeSlider.h"
#include "GUISegmentBar.h"

class ObsvProgressImg : public CGUIObserver
{
public:
    ObsvProgressImg(CGUIRadialProgressBar* pkCarousel, CGUIImage* pkImage, CGUIBaseSlider* pkSlider);

    virtual void OnNotification(const CGUIValue& kObservedValue, const CGUIObject* const pkUpdatedObject, const eC_UInt uiX = 0, const eC_UInt uiY = 0);

private:
    CGUIRadialProgressBar* m_pkTargetObject;
    CGUIImage* m_pkTargetImageObject;
};

class ObsvGeometry : public CGUIObserver
{
public:
    ObsvGeometry(CGUIBaseSlider* pkSliderR, CGUIBaseSlider* pkSliderG, CGUIBaseSlider* pkSliderB, CGUIGeometryObject* pkGeometry);

    virtual void OnNotification(const CGUIValue& kObservedValue, const CGUIObject* const pkUpdatedObject, const eC_UInt uiX = 0, const eC_UInt uiY = 0);

private:
    CGUIGeometryObject* m_pkGeometry;
    CGUIBaseSlider* m_pkSliderRed;
    CGUIBaseSlider* m_pkSliderGreen;
    CGUIBaseSlider* m_pkSliderBlue;
};

/* Class for the Controls-Dialog*/
class DemoControls : public DemoBase, CGUIObserver
{
public:

    DemoControls();

    virtual ~DemoControls();

    virtual void OnNotification(const CGUIValue& kObservedValue, const CGUIObject* const pkUpdatedObject, const eC_UInt uiX = 0, const eC_UInt uiY = 0);

    virtual void Init();

    virtual void DeInit();

    void SetColor(const eC_UInt& uiColor);
    eC_UInt GetColor();

    void HandleCallAPI(const eC_String& kAPI, const eC_String kParam);

private:
    ObsvProgressImg* m_pkProgressImg;
    ObsvGeometry* m_pkGeometryObserver;
    CGUIBaseSlider* m_pkSliderRed;
    CGUIBaseSlider* m_pkSliderGreen;
    CGUIBaseSlider* m_pkSliderBlue;
    CGUIGeometryObject* m_pkGeometry;
    CGUIRangeSlider* m_pkRangeSlider;
    CGUIBaseTextField* m_pkRangeText;
    CGUISegmentBar* m_pkSegmentBar;
};

#endif
