#ifndef _DEMOADVANCED_H_
#define _DEMOADVANCED_H_

#include "DemoBase.h"

#include "GUIBaseTextField.h"

#include "GUICalendar.h"
#include "GUIClock.h"

#include "GUIChart.h"
#include "GUIDataPoolResource.h"

#include "GUIKnob.h"
#include "GUICircularSlider.h"

#include "GUIAnimation.h"
#include "GUIGauge.h"
#include "GUIEasing.h"
#include "GUIWheel.h"
#include "GUIValue.h"

class CalendarObserver : public CGUIObserver
{
public:
    CalendarObserver(CGUIBaseTextField* pkTargetObject);

    virtual void OnNotification(const CGUIValue& kObservedValue, const CGUIObject* const pkUpdatedObject, const eC_UInt uiX = 0, const eC_UInt uiY = 0);

private:
    CGUIBaseTextField * m_pkTargetObject;
};

class ClockObserver : public CGUIObserver
{
public:
    ClockObserver(CGUIBaseTextField* pkTargetObject);

    virtual void OnNotification(const CGUIValue& kObservedValue, const CGUIObject* const pkUpdatedObject, const eC_UInt uiX = 0, const eC_UInt uiY = 0);

private:
    CGUIBaseTextField * m_pkTargetObject;
};

class KnobObserver : public CGUIObserver
{
public:
    KnobObserver(CGUIBaseTextField* pkTargetObject, CGUIKnob* pkKnob, CGUICircularSlider* pkCircularSlider);

    virtual void OnNotification(const CGUIValue& kObservedValue, const CGUIObject* const pkUpdatedObject, const eC_UInt uiX = 0, const eC_UInt uiY = 0);

private:
    CGUIBaseTextField * m_pkTargetObject;
    CGUIKnob* m_pkKnob;
    CGUICircularSlider* m_pkCircularSlider;
};

class GaugeAnimation : public CGUIAnimation
{
public:
    GaugeAnimation(CGUIGauge* pkGauge, eC_Int iTargetValue);
    virtual ~GaugeAnimation();

    virtual void ApplyAnimation(eC_UInt uiElapsedTime);

private:
    CGUIGauge* m_pkGauge;
    eC_Int m_iStartValue;
    eC_Int m_iTargetValue;
};

class DemoAdvanced : public DemoBase
{
public:
    DemoAdvanced(
        CGUIEasing::EasingType_t eEasingUp = CGUIEasing::EASE_LINEAR,
        CGUIEasing::EasingType_t eEasingDown = CGUIEasing::EASE_LINEAR);

    virtual ~DemoAdvanced();

    virtual void Init() {}
    virtual void Init(const eC_UInt& uiTime);

    virtual void DeInit();

    virtual void HandleCallAPI(const eC_String& kAPI, const eC_String kParam);

    eC_UInt GetTime() const;

    void SetLanguage(const eC_Int& iActiveLanguage);

    void SetEasing(CGUIEasing::EasingType_t eEasing)
    {
        m_eEasingUp = eEasing;
    }

private:
    CGUICalendar* m_pkCalendar;
    CGUIBaseTextField* m_pkCalendarTextField;
    CalendarObserver* m_pkCalendarObserver;

    CGUIClock* m_pkClock;
    CGUIBaseTextField* m_pkClockTextField;
    ClockObserver* m_pkClockObserver;

    CGUIKnob* m_pkKnob;
    CGUICircularSlider* m_pkCircularSlider;
    CGUIBaseTextField* m_pkKnobTextField;
    KnobObserver* m_pkKnobObserver;

    // gauge-subdialog
    CGUIValue m_vWheelValueFromDatapool;
    CGUIValue m_vValueBuffer;
    CGUIGauge* m_pkMainGauge;
    CGUIWheel* m_pkWheelControl;

    /*Easing types for the directions of scrolling*/
    CGUIEasing::EasingType_t m_eEasingUp;
    CGUIEasing::EasingType_t m_eEasingDown;

    GaugeAnimation* m_pkGaugeAnimation;
};

#endif
