/*
* Copyright (C) 2004 TES Electronic Solutions GmbH,
* All Rights Reserved.
* This source code and any compilation or derivative thereof is the
* proprietary information of TES Electronic Solutions GmbH
* and is confidential in nature.
* Under no circumstances is this software to be exposed to or placed
* under an Open Source License of any type without the expressed
* written permission of TES Electronic Solutions GmbH
*
*############################################################
*/

// Standard Headers
#include <new>
#include <string.h>

// Guiliani Headers
#include "GUIConfigDebug.h"

#include "GUITrace.h"
#include "GUIResourceFileHandler.h"
#include "StreamRuntimeConfig.h"
#include "StreamRuntimeStartup.h"

#include "GUIInputMedia.h"
#include "GUIEvent.h"

// Mem leak watcher need to be last
#include "GUIMemLeakFunctions.h"
#include "GUIMemLeakWatcher.h"

// specify resource-size according to configuration
#if defined(PLATFORM_RENESAS_GRPEACH)
const long resource_size = 0x004a0000;
#else
const long resource_size = 0x03000000;
#endif

// Resources FLASH section, size can be adapted here if needed
#if __ICCARM__ == 1
#pragma data_alignment=8
#define RES_FLASH  @ ".RES_FLASH"
uint8_t __guilianiResources[resource_size] @ "RES_FLASH";
#else
extern const uint8_t __attribute__ ((section (".RES_FLASH"))) __guilianiResources[resource_size];
#endif

#ifdef   __cplusplus
extern "C"
{
#endif
void GuilianiStart()
{
    GUI_REG_STDOUT_TRACE();

    GUILOG(GUI_TRACE_DEBUG, "CMyGUI::Init: RESOURCE FILE ACTIVE!\n");

    // use a resource file containing all required images, fonts, texts etc.
    GETRESHANDLER.SetResourceData(__guilianiResources);

    // Use CGUI::SetGuilianiLicenseKey("<ENTER YOUR CODE HERE>")) to set your Guiliani license key via code.
    // Alternatively use CGUI::LoadGuilianiLicenseKey("GuilianiLicense.key") to read your Guiliani license key from a file.

    NStreamRuntime::CStreamRuntimeStartup kStreamRuntime;

    try
    {
        // Load configuration (e.g. ScreenSize, initial Dialog etc.) from file
        if (kStreamRuntime.LoadConfiguration() == false)
        {
            return;
        }

        kStreamRuntime.ConstructWrapperClasses();

		kStreamRuntime.CreateGUI();
    }
    catch (...)
    {
        GUILOG( GUI_TRACE_ERROR, "An unrecoverable error occurred. Executing clean shutdown. \n");
    }

    kStreamRuntime.DestructWrapperClasses();

#ifdef GUILIANI_LEAK_DETECTION
    LEAK_DETECTION.ShowResults();
#endif

    GUILOG(GUI_TRACE_DEBUG, "Guiliani shutdown complete.\n");
}

#ifdef   __cplusplus
}
#endif
