/*
* Copyright (C) 2004 TES Electronic Solutions GmbH,
* All Rights Reserved.
* This source code and any compilation or derivative thereof is the
* proprietary information of TES Electronic Solutions GmbH
* and is confidential in nature.
* Under no circumstances is this software to be exposed to or placed
* under an Open Source License of any type without the expressed
* written permission of TES Electronic Solutions GmbH
*
*############################################################
*/

#include "StreamRuntimeStartup.h"

#include "GUIConfigDebug.h"

#include "MyGUI_SR.h"
#include "GUITrace.h"
#include "GUIResourceFileHandler.h"
#include "GUIImageCache.h"
#include "StreamRuntimeConfig.h"

// Graphic and Font Wrapper

#if defined GFX_USE_RGA
    #include "GfxWrapRGA.h"
    #include "FntWrapFreeTypeRGA.h"
#elif defined GFX_USE_EGML
    #include "GfxWrapeGML.h"
    #if defined FNT_USE_FREETYPE
        #include "FntWrapFreeTypeeGML.h"
    #elif defined FNT_USE_GLYPHLIB
        #include "FntWrapGlyphLibeGML.h"
    #endif
#elif defined GFX_USE_DAVE
    #if defined PLATFORM_RENESAS_RZA2M
        #include "GfxWrapDAVERZA2M.h"
    #elif defined PLATFORM_RENESAS_RA6M3
        #include "GfxWrapDAVERA6M3.h"
    #endif

    #if defined FNT_USE_FREETYPE
        #include "FntWrapFreeTypeDAVEUncached.h"
    #elif defined FNT_USE_GLYPHLIB
        #include "FntWrapGlyphLibDAVECached.h"
    #endif
#elif defined GFX_USE_BLU
    #include "GfxWrapBLU.h"
    #if defined FNT_USE_FREETYPE
        #include "FntWrapFreeTypeBLU.h"
    #elif defined FNT_USE_GLYPHLIB
        #include "FntWrapGlyphLibBLU.h"
    #endif
#else
    #include "GfxWrapNull.h"
#endif

#include "FntWrapNull.h"

// Sound Wrapper
#include "SndWrapNull.h"

#if defined GFX_USE_DCWRAP
#include "DCWrapRVAPI.h"
#include "r_vdc.h" // for VDC_LAYER_XXXX
#endif

// Input Wrapper
#ifdef PLATFORM_RENESAS_DISPLAYIT_V1      
    #include "GUIInputDisplayIt.h"
#elif defined PLATFORM_RENESAS_DISPLAYIT_V2
    #include "GUIInputStreamIt.h"
#elif defined PLATFORM_RENESAS_STREAMIT_V2
    #include "GUIInputStreamIt.h"
#elif defined PLATFORM_RENESAS_GRPEACH
    #include "GUIInputStreamIt.h"
#elif defined PLATFORM_RENESAS_RZA2M
    #include "GUIInputRZA2M.h"
#elif defined PLATFORM_RENESAS_GRMANGO
    #include "GUIInputRZA2M.h"
#elif defined PLATFORM_RENESAS_RA6M3
    #include "GUIInputRA6M3.h"
#else
    #include "GUIInputExample.h"
#endif

#include "GUIConfigDebug.h"
#include "GUIException.h"
#include "GUIThread.h"
#include "GUIPlaybackInput.h"

// Memory Leak Detection
#include "GUIMemLeakWatcher.h"

/* diplay layer for rectangle */
#if defined GFX_USE_RGB565
#define DATA_SIZE_PER_PIC      (2u)
#elif defined GFX_USE_ARGB32
#define DATA_SIZE_PER_PIC      (4u)
#else
#error "Set bits per pixel"
#endif

#define FRAMEBUFFER_LAYER_NUM      (2u)
#define FRAME_BUFFER_PADDED_WIDTH  (((FRAME_BUFFER_WIDTH) + 31u) & ~31u)

#define LAYER2_BUFFER_NUM 2
#define LAYER2_WIDTH 160
#define LAYER2_HEIGHT 120
#define LAYER2_PADDED_WIDTH  (((LAYER2_WIDTH) + 31u) & ~31u)

extern "C"
{
#if defined GFX_USE_DCWRAP
uint8_t framebuffer[FRAMEBUFFER_LAYER_NUM][FRAME_BUFFER_PADDED_WIDTH * FRAME_BUFFER_HEIGHT * DATA_SIZE_PER_PIC] __attribute__ ((section(".VRAM_SECTION0")));

uint8_t Layer2[LAYER2_BUFFER_NUM][LAYER2_PADDED_WIDTH * LAYER2_HEIGHT * DATA_SIZE_PER_PIC] __attribute__ ((section(".VRAM_SECTION0")));

// graphic buffer cursor_buffer is already defined in BSP/src/renesas/application/app_touchscreen/r_drawrectangle.c
volatile uint8_t *RZAFrameBuffers[2] =
{
    framebuffer[1],
    framebuffer[0],
};
#else
extern void *RZAFrameBuffers[];
#endif

extern void* GrpDrv_SetFrameBuffer(eC_UInt uiWidth, eC_UInt uiHeight, void* ptr);
}

namespace NStreamRuntime
{
  void CStreamRuntimeStartup::ConstructWrapperClasses()
  {
    /* Sets the graphics and font wrapper */
    try
    {

#if defined GFX_USE_DCWRAP
        CDCWrapRVAPI::CreateInstance(FRAME_BUFFER_WIDTH, FRAME_BUFFER_HEIGHT);

        LayerConfiguration_t kLayer0;
        kLayer0.m_uiLayerID = VDC_LAYER_ID_0_RD;
        kLayer0.m_bMainLayer = true;
        kLayer0.m_uiWidth = FRAME_BUFFER_WIDTH;
        kLayer0.m_uiHeight = FRAME_BUFFER_HEIGHT;
        kLayer0.m_uiPaddedWidth = FRAME_BUFFER_PADDED_WIDTH;
        kLayer0.m_uiVisibleWidth = FRAME_BUFFER_WIDTH;
        kLayer0.m_uiVisibleHeight = FRAME_BUFFER_HEIGHT;
#if defined GFX_USE_RGB565
        kLayer0.m_ePixFormat = LPF_RGB565;
#elif defined GFX_USE_ARGB32
        kLayer0.m_ePixFormat = LPF_RGB8888;
#endif
        kLayer0.m_uiNumBuffers = FRAMEBUFFER_LAYER_NUM;
        kLayer0.m_pkBuffers[0] = RZAFrameBuffers[0];
        kLayer0.m_pkBuffers[1] = RZAFrameBuffers[1];
        kLayer0.m_bCached = true;
        kLayer0.m_bVisible = true;

        LayerConfiguration_t kLayer2;
        kLayer2.m_uiLayerID = VDC_LAYER_ID_2_RD;
        kLayer2.m_uiWidth = LAYER2_WIDTH;
        kLayer2.m_uiHeight = LAYER2_HEIGHT;
        kLayer2.m_uiPaddedWidth = LAYER2_PADDED_WIDTH;
#if defined GFX_USE_RGB565
        kLayer2.m_ePixFormat = LPF_RGB565;
#elif defined GFX_USE_ARGB32
        kLayer2.m_ePixFormat = LPF_RGB8888;
#endif
        kLayer2.m_uiNumBuffers = LAYER2_BUFFER_NUM;
        kLayer2.m_pkBuffers[0] = Layer2[0];
        kLayer2.m_pkBuffers[1] = Layer2[1];
        kLayer2.m_bCached = true;
        kLayer2.m_bChromaKeyActive = true;
        kLayer2.m_uiChromaKey = 0xFFFF;

        GETDC.AddLayer(kLayer0);
        GETDC.AddLayer(kLayer2);

        memset(Layer2[0], 0xff, LAYER2_PADDED_WIDTH * LAYER2_HEIGHT * DATA_SIZE_PER_PIC);
        memset(Layer2[1], 0xff, LAYER2_PADDED_WIDTH * LAYER2_HEIGHT * DATA_SIZE_PER_PIC);
#endif

#if defined GFX_USE_RGA
        CGfxWrapRGA::CreateInstance(FRAME_BUFFER_WIDTH, FRAME_BUFFER_HEIGHT);
        CFntWrapFreeTypeRGA::CreateInstance(512*512, (static_cast<CGfxWrapRGA&> (CGfxWrapRGA::GetInstance())).GetContext(),
                                                     (static_cast<CGfxWrapRGA&> (CGfxWrapRGA::GetInstance())).GetFrameBuffer());
#elif defined GFX_USE_EGML

#ifdef GFX_USE_DCWRAP
        CGfxWrapeGML::CreateInstance(&GETDC);
#else
#if defined GFX_USE_RGB565
        CGfxWrapeGML::CreateInstance(FRAME_BUFFER_WIDTH, FRAME_BUFFER_HEIGHT, eGML::BM_RGB565, 2, RZAFrameBuffers);
#elif defined GFX_USE_ARGB32
        CGfxWrapeGML::CreateInstance(FRAME_BUFFER_WIDTH, FRAME_BUFFER_HEIGHT, eGML::BM_RGB32, 2, RZAFrameBuffers);
#endif
#endif

#if defined FNT_USE_FREETYPE
        CFntWrapFreeTypeeGML::CreateInstance(512 * 512, static_cast<CGfxWrapeGML&>(GETGFX).GetScreen());
#elif defined FNT_USE_GLYPHLIB
        CFntWrapGlyphLibeGML::CreateInstance(512 * 512, static_cast<CGfxWrapeGML&>(GETGFX).GetScreen());
#endif

        GETGFX.SetDoubleBufferingEnforcesFlipping(true);
#elif defined GFX_USE_BLU
#if defined GFX_USE_RGB565
        CGfxWrapBLU::CreateInstance(GETRUNTIMECONFIG.GetScreenWidth(), GETRUNTIMECONFIG.GetScreenHeight(), 16, 2, RZAFrameBuffers);
#elif defined GFX_USE_ARGB32
        CGfxWrapBLU::CreateInstance(GETRUNTIMECONFIG.GetScreenWidth(), GETRUNTIMECONFIG.GetScreenHeight(), 32, 2, RZAFrameBuffers);
#endif
        static_cast<CGfxWrapBLU&>(GETGFX).SetFrameBufferFP(GrpDrv_SetFrameBuffer);

#if defined FNT_USE_FREETYPE
        CFntWrapFreeTypeBLU::CreateInstance(512 * 512);
#elif defined FNT_USE_GLYPHLIB
        CFntWrapGlyphLibBLU::CreateInstance();
#endif

#elif defined GFX_USE_DAVE
#ifdef GFX_USE_DCWRAP
        CGfxWrapDAVERZA2M::CreateInstance(&GETDC);
#else
#if defined PLATFORM_RENESAS_RZA2M
        CGfxWrapDAVERZA2M::CreateInstance(FRAME_BUFFER_WIDTH, FRAME_BUFFER_HEIGHT, 2, RZAFrameBuffers);
#elif defined PLATFORM_RENESAS_RA6M3
        CGfxWrapDAVERA6M3::CreateInstance(FRAME_BUFFER_WIDTH, FRAME_BUFFER_HEIGHT, 2, RZAFrameBuffers);
#endif
#endif
#if defined FNT_USE_FREETYPE
        CFntWrapFreeTypeDAVEUncached::CreateInstance(1024 * 1024, static_cast<CGfxWrapDAVE&>(GETGFX).GetDaveDevice());
#elif defined FNT_USE_GLYPHLIB
        CFntWrapGlyphLibDAVEUncached::CreateInstance(static_cast<CGfxWrapDAVE&>(GETGFX).GetDaveDevice());
#endif
#endif
    }
    catch(...)
    {
      GUILOG_THROW_EXCEPTION(CGUIException(), "NStartup::ConstructResourceClasses: Could not allocate graphics wrapper.\n");
    }

    // Sets the sound wrapper
    try
    {
      CSndWrapNull::CreateInstance();
    }
    catch (...)
    {
      GUILOG_THROW_EXCEPTION(CGUIException(), "NStartup::ConstructResourceClasses: Could not allocate sound wrapper.\n");
    }

    // Set pointer to resource file handler instance
    try
    {
#ifdef PLATFORM_RENESAS_DISPLAYIT_V1      
      CGUIInputDisplayIt::CreateInstance();
#elif defined PLATFORM_RENESAS_DISPLAYIT_V2
      CGUIInputStreamIt::CreateInstance(0, 0, 800, 480, 2);
#elif defined PLATFORM_RENESAS_STREAMIT_V2
      CGUIInputStreamIt::CreateInstance(0, 0, 480, 272, 2);
#elif defined PLATFORM_RENESAS_GRPEACH
      CGUIInputStreamIt::CreateInstance(0, 0, 480, 272, 2);
#elif defined PLATFORM_RENESAS_RZA2M
      CGUIInputRZA2M::CreateInstance(0, 0, 800, 480, 2, 30, 10);
#elif defined PLATFORM_RENESAS_GRMANGO
      CGUIInputRZA2M::CreateInstance(0, 0, 800, 480, 2, 30, 10);
#elif defined PLATFORM_RENESAS_RA6M3
      CGUIInputRA6M3::CreateInstance(0, 0, 480, 272, 2);
#else
      CGUIInputExample::CreateInstance();
#endif
    }
    catch(...)
    {
      GUILOG_THROW_EXCEPTION(CGUIException(), "NStartup::ConstructResourceClasses: Could not create input media.\n");
    }
    GETRESHANDLER.SetResourcePathPrefix("./");
  }
}
