#include "CustomExtensionFuncs.h"

// Include any headers for custom extensions here.
#include "CustomExtensionFactory.h"
#include "ExampleControl.h"
#include "ExampleBehaviour.h"
#include "ExampleLayouter.h"
#include "ExampleCommand.h"

#include "GUIMemLeakWatcher.h" // <-- has to be the last include

void GetCustomEnumMappings(EnumMappingVector& rkEnumMappings)
{
    /* Add enum mappings for custom behaviours, controls, commands and layouters
       here. Example: your control 'MyControl' has an enum type 'MyEnum',
       values of which are written into streams with the XML tag 'MyEnumValue'.
       The enum values defined in the control are 'MY_VALUE_1' and 'MY_VALUE_2'.
       You would then add mappings as follows:
    rkEnumMappings.push_back(EnumMapping("MyEnumValue", MyControl::MY_VALUE_1, "MY_VALUE_1"));
    rkEnumMappings.push_back(EnumMapping("MyEnumValue", MyControl::MY_VALUE_2, "MY_VALUE_2"));
    */

    // Add the values for the DragAction enum in the ExampleBehaviour.
    rkEnumMappings.push_back(EnumMapping("DragAction", ExampleBehaviour::DA_MOVE, "DA_MOVE"));
    rkEnumMappings.push_back(EnumMapping("DragAction", ExampleBehaviour::DA_SIZE, "DA_SIZE"));
}

void GetCustomRepetitions(RepetitionVector& rkRepetitions)
{
    /* Add attribute repetition mappings for custom attribute repetitions here. 
       Example: your repetition 'NumberOfImages' has one containing attribute value with XMLTag "ImageID"
       of attribute type AT_IMAGEID.
       Example:
    rkRepetitions.push_back(AttributeRepetitionDescriptor("", "KeyID", "", AttributeRepetitionDescriptor::AT_INT));
    rkRepetitions.push_back(AttributeRepetitionDescriptor("", "KeyModifiers", "0", AttributeRepetitionDescriptor::AT_INT));
    rkRepetitions.push_back(AttributeRepetitionDescriptor("", "CheckForModifiers", "false", AttributeRepetitionDescriptor::AT_BOOL));
    rkRepetitions.push_back(AttributeRepetitionDescriptor("", "IsActivated", "true", AttributeRepetitionDescriptor::AT_BOOL));
    rkRepetitions.push_back(AttributeRepetitionDescriptor("", "MappedObjectID", "NO_HANDLE", AttributeRepetitionDescriptor::AT_OBJECTID));
    rkRepetitions.push_back(AttributeRepetitionDescriptor("", "ObjectIsAbstract", "false", AttributeRepetitionDescriptor::AT_BOOL));
    rkRepetitions.push_back(AttributeRepetitionDescriptor("NumberOfKeyMappings", "", "", AttributeRepetitionDescriptor::AT_COMMENT));
    */
}

