/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#if !defined(STREAMRUNTIMECONFIG_H)
#define STREAMRUNTIMECONFIG_H

#include "eC_String.h"
#include "GUIStreamTypes.h"

#define GETRUNTIMECONFIG (NStreamRuntime::Configurator::GetInstance())

/** The NStreamRuntime Namespace contains generic helper classes for initializing a default StreamRuntime application.
The code herein typically remains widely unchanged across most StreamRuntimes.
Feel free to remove these classes from your own application and replace them with custom code, if you wish.*/
namespace NStreamRuntime
{
    /** Helper class for reading the StreamRuntime Configuration from an XML file.
    The configuration does e.g. specifiy the first dialog to show after startup, the initial language file,
    image set, screen resolution etc. */
    class Configurator
    {
    public:
        static Configurator& GetInstance();
        eC_Bool LoadConfiguration(const eC_String& rkFileName);

        eC_Int GetScreenWidth() const
        {
            return m_iScreenWidth;
        }

        eC_Int GetScreenHeight() const
        {
            return m_iScreenHeight;
        }

        eC_Bool IsWindowResizable() const
        {
            return m_bResizable;
        }

        const eC_String& GetResourcePathPrefix() const
        {
            return m_kResourcePathPrefix;
        }

        const eC_String& GetImageFileName() const
        {
            return m_kImageResFile;
        }

        const eC_String& GetFontFileName() const
        {
            return m_kFontResFile;
        }

        const eC_String& GetSoundFileName() const
        {
            return m_kSoundResFile;
        }

        const eC_String& GetGenResFileName() const
        {
            return m_kGenResFile;
        }

        const eC_String& GetDataPoolFileName() const
        {
            return m_kDataPoolFile;
        }

        const eC_String& GetPropertyFileName() const
        {
            return m_kPropResFile;
        }

        const eC_String& GetLanguageFileName() const
        {
            return m_kLanguageFile;
        }

        const eC_String& GetAnimationsFileName() const
        {
            return m_kAnimationsResFile;
        }

        eC_Bool IsBackgroundEnabled() const
        {
            return m_bBkgEnabled;
        }

        eC_UInt GetBackgroundColor() const
        {
            return m_uiBkgColor;
        }

        eC_String GetDialogFileName() const
        {
            return m_kDialogFile;
        }

        FileType_t GetStreamingMode() const
        {
            return m_eStreamingMode;
        }

        eC_UInt GetVersion() const
        {
            return m_uiVersion;
        }

    private:
        Configurator() :
            m_uiVersion(0),
            m_kConfigFileName(""),
            m_iScreenWidth(0),
            m_iScreenHeight(0),
            m_bResizable(false),
            m_kResourcePathPrefix(""),
            m_kAnimationsResFile(""),
            m_kImageResFile(""),
            m_kFontResFile(""),
            m_kSoundResFile(""),
            m_kGenResFile(""),
            m_kDataPoolFile(""),
            m_kPropResFile(""),
            m_kLanguageFile(""),
            m_bBkgEnabled(false),
            m_uiBkgColor(0xff000000),
            m_kDialogFile(""),
            m_eStreamingMode()
        {
        };

        ~Configurator()
        {
        };

    private:
        eC_UInt m_uiVersion;
        eC_String m_kConfigFileName;
        eC_Int m_iScreenWidth;
        eC_Int m_iScreenHeight;
        eC_Bool m_bResizable;
        eC_String m_kResourcePathPrefix;
        eC_String m_kAnimationsResFile;
        eC_String m_kImageResFile;
        eC_String m_kFontResFile;
        eC_String m_kSoundResFile;
        eC_String m_kGenResFile;
        eC_String m_kDataPoolFile;
        eC_String m_kPropResFile;
        eC_String m_kLanguageFile;
        eC_Bool m_bBkgEnabled;
        eC_UInt m_uiBkgColor;
        eC_String m_kDialogFile;
        FileType_t m_eStreamingMode;
    };
}
#endif // STREAMRUNTIMECONFIG_H
