
#
# Windows-MSVC-x86 specific settings
#

# Set output dirs
SET_TARGET_PROPERTIES(${PROJECT_NAME} PROPERTIES RUNTIME_OUTPUT_DIRECTORY "${PROJECT_SOURCE_DIR}/Binary/${CMAKE_SYSTEM_NAME}-${CMAKE_SYSTEM_ARCH}/${CMAKE_PLATFORM_NAME}_${CMAKE_CXX_COMPILER_ID}")

IF(STREAMRUNTIME_SDK_PROJECT)
  TARGET_LINK_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_EGAC}/Libraries/${CMAKE_SYSTEM_NAME}-${CMAKE_SYSTEM_ARCH}/${CMAKE_CXX_COMPILER_ID}"
    PRIVATE "${PATH_GUILIANI}/Libraries/${CMAKE_SYSTEM_NAME}-${CMAKE_SYSTEM_ARCH}/${CMAKE_CXX_COMPILER_ID}"
    )
ENDIF(STREAMRUNTIME_SDK_PROJECT)

# Set compiler parameters for VS
SET(CMAKE_CXX_FLAGS_DEBUGFIXPOINT "${CMAKE_CXX_FLAGS_DEBUG}")
SET(CMAKE_CXX_FLAGS_RELEASEFIXPOINT "${CMAKE_CXX_FLAGS_RELEASE}")

# Same as for C++
SET(CMAKE_C_FLAGS_DEBUGEFIXPOINT "${CMAKE_CXX_FLAGS_DEBUGFIXPOINT}")
SET(CMAKE_C_FLAGS_RELEASEFIXPOINT "${CMAKE_CXX_FLAGS_RELEASEFIXPOINT}")

SET(CMAKE_EXE_LINKER_FLAGS_DEBUG "${CMAKE_EXE_LINKER_FLAGS_DEBUG} /LIBPATH:\"${PROJECT_SOURCE_DIR}/Libraries/${CMAKE_SYSTEM_NAME}-${CMAKE_SYSTEM_ARCH}/${CMAKE_CXX_COMPILER_ID}/${CMAKE_BUILD_TYPE}\"")
SET(CMAKE_EXE_LINKER_FLAGS_RELEASE "${CMAKE_EXE_LINKER_FLAGS_RELEASE} /LIBPATH:\"${PROJECT_SOURCE_DIR}/Libraries/${CMAKE_SYSTEM_NAME}-${CMAKE_SYSTEM_ARCH}/${CMAKE_CXX_COMPILER_ID}/${CMAKE_BUILD_TYPE}\"")
SET(CMAKE_EXE_LINKER_FLAGS_DEBUGFIXPOINT "${CMAKE_EXE_LINKER_FLAGS_DEBUG}")
SET(CMAKE_EXE_LINKER_FLAGS_RELEASEFIXPOINT "${CMAKE_EXE_LINKER_FLAGS_RELEASE}")

# Includes - SDK independent
TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
  PRIVATE "${PATH_GUILIANI}/Include/Platform/win"
  PRIVATE "${PATH_GUILIANI}/Include/Platform/win/pc"
  PRIVATE "${PROJECT_SOURCE_DIR}/Resources/win/pc"
  PRIVATE "${PROJECT_SOURCE_DIR}/Common/Include/Platform/win/pc"
)

# Includes - SDK dependent
IF(STREAMRUNTIME_SDK_PROJECT)
  TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_EGAC}/Include/eC/x86_win32"
  )
ELSE(STREAMRUNTIME_SDK_PROJECT)
  TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_EGAC}/comps/eC/code/x86_win32"
  )
ENDIF(STREAMRUNTIME_SDK_PROJECT)

FILE(GLOB PLATFORM_WIN_PC_CPP 
    "${PROJECT_SOURCE_DIR}/Common/Source/Platform/win/pc/StreamRuntime.cpp" 
    "${PROJECT_SOURCE_DIR}/Common/Source/Platform/win/pc/StreamRuntimeStartup.cpp"
    )
SOURCE_GROUP("Source Files\\Platform\\Windows\\PC" FILES ${PLATFORM_WIN_PC_CPP})

FILE(GLOB PLATFORM_WIN_PC_H 
    "${PROJECT_SOURCE_DIR}/Common/Include/Platform/win/pc/*.h"
    "${PROJECT_SOURCE_DIR}/Resources/win/pc/*.h")
SOURCE_GROUP("Header Files\\Platform\\Windows\\PC" FILES ${PLATFORM_WIN_PC_H})

SET(RESOURCE_FILE "${PROJECT_SOURCE_DIR}/Resources/win/pc/StreamRuntime.rc")
SOURCE_GROUP("Resource Files" FILES ${RESOURCE_FILE})

SET(PLATFORM_FILES
  ${PLATFORM_WIN_PC_CPP}
  ${PLATFORM_WIN_PC_H}
  ${RESOURCE_FILE}
)
  
#eGML
IF(GUILIANI_ADD_EGML_PLATFORM)
  TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_GUILIANI}/Include/Platform/eGML"
    PRIVATE "${PATH_GUILIANI}/Include/Platform/eGML/win"
)
ENDIF(GUILIANI_ADD_EGML_PLATFORM)

# ogl
IF("${GUILIANI_OGL_PLATFORM}" STREQUAL "OpenGL")
  TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_GUILIANI}/Include/Platform/GL"
    PRIVATE "${PATH_GUILIANI}/Include/Platform/GL/OGL"
    PRIVATE "${PATH_GUILIANI}/Include/Platform/GL/OGL/win"
    PRIVATE "${PATH_LIBS}/opengl/include"
    )
ENDIF("${GUILIANI_OGL_PLATFORM}" STREQUAL "OpenGL")

#DAVE
IF(GUILIANI_ADD_DAVE_PLATFORM)
  TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_GUILIANI}/Include/Platform/DAVE"
    PRIVATE "${PATH_GUILIANI}/Include/Platform/DAVE/win"
    )
  SET(PLATFORM_DEFINES "SCRXSIZE=480;SCRYSIZE=272;WITH_MM_DYNAMIC;D2_WIN32")
ENDIF(GUILIANI_ADD_DAVE_PLATFORM)

#BLU
IF(GUILIANI_ADD_BLU_PLATFORM)
  TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_GUILIANI}/Include/Platform/BLU"
    PRIVATE "${PATH_GUILIANI}/Include/Platform/BLU/win"
    PRIVATE "${PATH_BLU}/Include"
  )
ENDIF(GUILIANI_ADD_BLU_PLATFORM)

#GlyphLib
IF(GUILIANI_ADD_GLYPHLIB_PLATFORM)
  TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_GLYPHLIB}/Include"
  )
ENDIF(GUILIANI_ADD_GLYPHLIB_PLATFORM)

#FREETYPE
IF(LIBS_BUILD_FREETYPE)
  TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_FREETYPE}/include" 
    )
ELSE(LIBS_BUILD_FREETYPE)
  TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_LIBS}/freetype/include" 
    PRIVATE "${PATH_LIBS}/freetype/include/freetype" 
    )
ENDIF(LIBS_BUILD_FREETYPE)
