
#
# Generic-GNU-arm-rsk_rza1_FreeRTOS specific settings
#

# set outputs
SET_TARGET_PROPERTIES(${PROJECT_NAME} PROPERTIES RUNTIME_OUTPUT_DIRECTORY "${PROJECT_SOURCE_DIR}/Binary/${CMAKE_SYSTEM_NAME}/${CMAKE_PLATFORM_NAME}_${CMAKE_CXX_COMPILER_ID}/${CMAKE_BUILD_TYPE}")

FILE(GLOB PLATFORM_COMMON_RZA_CPP "${PROJECT_SOURCE_DIR}/Common/Source/Platform/FreeRTOS/StreamRuntimeStartup.cpp")

IF(${PLATFORM_NAME} STREQUAL "PLATFORM_RENESAS_DISPLAYIT_V1")
    FILE(GLOB PLATFORM_RZA_CPP "${PROJECT_SOURCE_DIR}/Common/Source/Platform/FreeRTOS/StreamRuntime_FreeRTOS8.cpp")
ENDIF(${PLATFORM_NAME} STREQUAL "PLATFORM_RENESAS_DISPLAYIT_V1")
IF(${PLATFORM_NAME} STREQUAL "PLATFORM_RENESAS_DISPLAYIT_V2")
    FILE(GLOB PLATFORM_RZA_CPP
        "${PROJECT_SOURCE_DIR}/Common/Source/Platform/FreeRTOS/from_Cpp.cpp"
        "${PROJECT_SOURCE_DIR}/Common/Source/Platform/FreeRTOS/StreamRuntime_FreeRTOS10.cpp"
        "${PROJECT_SOURCE_DIR}/Common/Source/Platform/FreeRTOS/StreamRuntime_GraphicRZA.cpp"
        "${PROJECT_SOURCE_DIR}/Common/Source/Platform/FreeRTOS/StreamRuntime_FreeRTOS10_main.c"
        )
ENDIF(${PLATFORM_NAME} STREQUAL "PLATFORM_RENESAS_DISPLAYIT_V2")
IF(${PLATFORM_NAME} STREQUAL "PLATFORM_RENESAS_STREAMIT_V2")
    FILE(GLOB PLATFORM_RZA_CPP
        "${PROJECT_SOURCE_DIR}/Common/Source/Platform/FreeRTOS/from_Cpp.cpp"
        "${PROJECT_SOURCE_DIR}/Common/Source/Platform/FreeRTOS/StreamRuntime_FreeRTOS10.cpp"
        "${PROJECT_SOURCE_DIR}/Common/Source/Platform/FreeRTOS/StreamRuntime_GraphicRZA.cpp"
        "${PROJECT_SOURCE_DIR}/Common/Source/Platform/FreeRTOS/StreamRuntime_FreeRTOS10_main.c"
        )
ENDIF(${PLATFORM_NAME} STREQUAL "PLATFORM_RENESAS_STREAMIT_V2")

SET(PLATFORM_FILES 
    ${PLATFORM_RZA_CPP}
    ${PLATFORM_COMMON_RZA_CPP}
    ${SYSCALLS_C}
)

TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
  PRIVATE "${PATH_GUILIANI}/Include/Platform/RZA1H"
)

IF(STREAMRUNTIME_SDK_PROJECT)
  # Some platform depenant include directories.
  TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_EGAC}/Include/eGML"
    PRIVATE "${PATH_EGAC}/Include/eGML/eGML_RZA1H"
    PRIVATE "${PATH_EGAC}/Include/eDBG"
    PRIVATE "${PATH_EGAC}/Include/eC/FreeRTOS"
    PRIVATE "${PATH_EGAC}/Include/eC/RZA1H"
    PRIVATE "${PATH_LIBS}/freetype/include"
    PRIVATE "${PATH_LIBS}/freetype/include/freetype"
  )
ELSE(STREAMRUNTIME_SDK_PROJECT)
  IF(LIBS_BUILD_FREETYPE)
    TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
      PRIVATE "${PATH_FREETYPE}/include/freetype"
    )
  ELSE(LIBS_BUILD_FREETYPE)
    TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
      PRIVATE "${PATH_LIBS}/freetype/include"
    )
  ENDIF(LIBS_BUILD_FREETYPE)
ENDIF(STREAMRUNTIME_SDK_PROJECT)

IF(STREAMRUNTIME_SDK_PROJECT)
    TARGET_LINK_DIRECTORIES(${PROJECT_NAME}
        PRIVATE "${CMAKE_BINARY_DIR}"
        PRIVATE "${PATH_LIBS}/FreeRTOS/rza"
        PRIVATE "${PATH_LIBS}/FreeRTOS/rza/${CMAKE_BUILD_TYPE}"
    )
ELSE(STREAMRUNTIME_SDK_PROJECT)
    TARGET_LINK_DIRECTORIES(${PROJECT_NAME}
        PRIVATE "${PATH_LIBS}/freetype/lib"
        PRIVATE "${CMAKE_BINARY_DIR}"
    )
ENDIF(STREAMRUNTIME_SDK_PROJECT)

ADD_SUBDIRECTORY(${CMAKE_BSP_SUBDIRECTORY} ./BSP)

SET(PLATFORM_LIBS
    ${PLATFORM_LIBS}
    "BSP"
)

TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PROJECT_SOURCE_DIR}/Common/Include/Platform/FreeRTOS/"
)

SET(CMAKE_EXE_LINKER_FLAGS "${CMAKE_EXE_LINKER_FLAGS} ${LINKER_SCRIPT}")

IF(CMAKE_ASM_COMPILER_ID STREQUAL "IAR")
  ADD_CUSTOM_TARGET(PostBuildTarget ALL
      COMMAND "${CMAKE_OBJCOPY}" --bin --verbose $<TARGET_FILE:${PROJECT_NAME}> $<TARGET_FILE_DIR:${PROJECT_NAME}>/${PROJECT_NAME}.bin
      COMMENT "create binary file"
      DEPENDS ${PROJECT_NAME}
  )
ELSE(CMAKE_ASM_COMPILER_ID STREQUAL "IAR")
  ADD_CUSTOM_TARGET(PostBuildTarget ALL
      COMMAND "${CMAKE_OBJCOPY}" --verbose -O binary $<TARGET_FILE:${PROJECT_NAME}> $<TARGET_FILE_DIR:${PROJECT_NAME}>/${PROJECT_NAME}.bin
      COMMENT "create binary file"
      DEPENDS ${PROJECT_NAME}
  )
ENDIF(CMAKE_ASM_COMPILER_ID STREQUAL "IAR")
