/******************************************************************************
 * DISCLAIMER
 * This software is supplied by Renesas Electronics Corporation and is only
 * intended for use with Renesas products. No other uses are authorized. This
 * software is owned by Renesas Electronics Corporation and is protected under
 * all applicable laws, including copyright laws.
 * THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
 * THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT
 * LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
 * AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED.
 * TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS
 * ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE
 * FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR
 * ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
 * BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 * Renesas reserves the right, without notice, to make changes to this software
 * and to discontinue the availability of this software. By using this software,
 * you agree to the additional terms and conditions found by accessing the
 * following link:
 * http://www.renesas.com/disclaimer
 * Copyright (C) 2014 Renesas Electronics Corporation. All rights reserved.
 *****************************************************************************/
/******************************************************************************
 * File Name    : devdrv_common.h
 * Device(s)    : Renesas
 * Tool-Chain   : GNUARM-NONE-EABI v14.02
 * H/W Platform : RSK+
 * $Rev         : 0 $
 * $Date        : 0#$
 * Description  : Aragon Sample Program - Common driver header
 *****************************************************************************/
/******************************************************************************
 * History : DD.MM.YYYY Version  Description
 *         : 15.01.2007 1.00     First Release
 *****************************************************************************/

#ifndef DEVDRV_COMMON_H_

#include "r_bsc_userdef.h"

#define DEVDRV_COMMON_H_

/******************************************************************************
 Includes   <System Includes> , "Project Includes"
 *****************************************************************************/

/******************************************************************************
 Macro definitions
 *****************************************************************************/
#define BSC_AREA_CS0    (0x01)          /* CS0 */
#define BSC_AREA_CS1    (0x02)          /* CS1 */
#define BSC_AREA_CS2    (0x04)          /* CS2 */
#define BSC_AREA_CS3    (0x08)          /* CS3 */
#define BSC_AREA_CS4    (0x10)          /* CS4 */
#define BSC_AREA_CS5    (0x20)          /* CS5 */

/******************************************************************************
 Typedef definitions
 *****************************************************************************/

/******************************************************************************
 Variable External definitions and Function External definitions
 *****************************************************************************/

/******************************************************************************
 Exported global functions (to be accessed by other files)
 *****************************************************************************/
void R_BSC_Init (uint8_t area);


#endif  /* DEVDRV_COMMON_H_ */

/******************************************************************************
 End  Of File
 *****************************************************************************/
