/*******************************************************************************
 * DISCLAIMER
 * This software is supplied by Renesas Electronics Corporation and is only
 * intended for use with Renesas products. No other uses are authorized. This
 * software is owned by Renesas Electronics Corporation and is protected under
 * all applicable laws, including copyright laws.
 * THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
 * THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT
 * LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
 * AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED.
 * TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS
 * ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE
 * FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR
 * ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
 * BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 * Renesas reserves the right, without notice, to make changes to this software
 * and to discontinue the availability of this software. By using this
 * software, you agree to the additional terms and conditions found by
 * accessing the following link:
 * http://www.renesas.com/disclaimer
 *******************************************************************************
 * Copyright (C) 2018 Renesas Electronics Corporation. All rights reserved.
 *****************************************************************************/
/******************************************************************************
 * @headerfile     r_riic_drv_sc_cfg.h
 * @brief          RIIC low layer driver smart configuration header, part of
 *                 the low layer driver.
 * @version        1.00
 * @date           27.06.2018
 * H/W Platform    RZ/A1LU Stream-IT
 *****************************************************************************/
/*****************************************************************************
 * History      : DD.MM.YYYY Ver. Description
 *              : 30.06.2018 1.00 First Release
 *****************************************************************************/

/* Multiple inclusion prevention macro */
#ifndef SRC_RENESAS_CONFIG_R_RIIC_DRV_SC_CFG_H_
    #define SRC_RENESAS_CONFIG_R_RIIC_DRV_SC_CFG_H_

/*******************************************************************************************************************//**
 * @ingroup SSGSTARC_56_RIIC_API
 * @ingroup R_SW_PKG_93_SC_CFG
 * @defgroup RIIC_SC_IF SC RIIC API Interface
 * @brief Interface between Smart Configurator and the RIIC module.
 *
 * @anchor RIIC_DRIVER_SC_SUMMARY
 * @par Summary
 * @brief The interface allows Smart Configurator (SC) to manage the configuration of the RIIC driver.
 * Do not edit this file if using SC
 *
 * @anchor RZA1H_RIIC_SC_IF_API_LIMITATIONS
 * @par Known Limitations
 * DMA startup not implemented at this time
 *
 * @anchor RZA1H_RIIC_SC_IF_API_INSTANCES
 * @par Known Implementations
 * @ref NONE_YET
 *
 * @anchor RZA1H_RIIC_SC_IF_API_RELATED
 * @par Related modules
 * @ref RZA1H_RSK_RIIC,
 * @{
 **********************************************************************************************************************/

    #include "r_typedefs.h"

/* List channels supported */
    #define R_CFG_RIIC_CHANNELS_SUPPORTED         ( R_CH0 | R_CH1 )

/* Maximum number of modules that can be granted simultaneous access to this driver  */
    #define  R_CFG_RIIC_DRV_MAXIMUM_ACCESS_PRV (1)

/*
 * @anchor RIIC_SC_IF_CONTROL
 * @par Control Interface
 */

/** Control commands for RIIC driver */
typedef enum
{
    CTL_RIIC_CREATE, /*!<  Create driver, uses parameter @ref st_r_drv_riic_create_t */
    CTL_RIIC_READ, /*!<  Read (with restart condition), uses parameter @ref st_r_drv_riic_config_t */
    CTL_RIIC_READ_NEXT, /*!<  Read (without restart condition), uses parameter @ref st_r_drv_riic_config_t */
    CTL_RIIC_WRITE, /*!<  Write to RIIC control function, uses parameter @ref st_r_drv_riic_config_t */
} e_ctrl_code_riic_t;

/** RIIC clock frequency options */
typedef enum
{
    RIIC_FREQUENCY_100KHZ, /*!<  100kHz clock frequency */
    RIIC_FREQUENCY_400KHZ, /*!<  400kHz clock frequency */
    RIIC_FREQUENCY_1MHZ, /*!<  1MHz clock frequency */
} e_clk_frequency_riic_t;

/** parameters required to configure RIIC peripheral */
typedef struct r_drv_riic_create_t
{
    e_clk_frequency_riic_t frequency; /*!<  RIIC Clock Frequency */
} st_r_drv_riic_create_t;

/** Configuration of access to i2c peripheral */
typedef struct r_drv_riic_config_t
{
    uint8_t  pad;
    uint8_t  device_address; /*!<  Device I2C address */
    uint16_t sub_address; /*!<  Start address of registers to access in device */
    uint32_t number_of_bytes; /*!<  Number of bytes to read */
    uint8_t  *p_data_buffer; /*!<  Pointer to source/destination buffer */
} st_r_drv_riic_config_t;

/** status of i2c channel */
typedef struct r_drv_riic_lld_config_t
{
    int_t ch_avaliable; /* R_CFG_RIIC_DRV_CHANNELS_AVAIL */
    int_t ch_supported; /* R_CFG_RIIC_CHANNELS_SUPPORTED */
} st_r_drv_riic_lld_config_t;

#endif /* SRC_RENESAS_CONFIG_R_RIIC_DRV_SC_CFG_H_ */

/*******************************************************************************************************************//**
 * @} (end addtogroup RIIC_SC_IF)
 ***********************************************************************************************************************/

/*******************************************************************************************************************//**
 End  Of File
 ***********************************************************************************************************************/
