/**********************************************************************************************************************
 * DISCLAIMER
 * This software is supplied by Renesas Electronics Corporation and is only intended for use with Renesas products. No
 * other uses are authorized. This software is owned by Renesas Electronics Corporation and is protected under all
 * applicable laws, including copyright laws.
 * THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
 * THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED. TO THE MAXIMUM
 * EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES
 * SHALL BE LIABLE FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR ANY REASON RELATED TO
 * THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 * Renesas reserves the right, without notice, to make changes to this software and to discontinue the availability of
 * this software. By using this software, you agree to the additional terms and conditions found by accessing the
 * following link:
 * http://www.renesas.com/disclaimer
 *
 * Copyright (C) 2018 Renesas Electronics Corporation. All rights reserved.
 *********************************************************************************************************************/
/**********************************************************************************************************************
 * File Name    : r_ostm_drv_sc_cfg.h
 * Version      : 1.0
 * Description  : OS timer low layer driver configuration header, part of the low layer driver.
 *                This file uses the same name for any low layer driver that is supported by a compatible high layer
 *                driver.
 *                File is included in the high layer driver to allow the low layer driver to be swapped at build time
 *                and share the same high layer code.
 *********************************************************************************************************************/

#ifndef SRC_RENESAS_CONFIG_R_OSTM_DRV_SC_CFG_H_
    #define SRC_RENESAS_CONFIG_R_OSTM_DRV_SC_CFG_H_

/******************************************************************************************************************//**
 * @ingroup SSGSTARC_37_OSTM_DRIVER
 * @ingroup R_SW_PKG_93_SC_CFG
 * @defgroup OSTM_DRIVER_SC_CFG OSTM SC Interface
 * @brief Interface between Smart Configurator and the OSTM module.
 *
 * @anchor OSTM_DRIVER_SC_CFG_SUMMARY 
 * @par Summary
 * The interface allows Smart Configurator (SC) to manage the configuration of the OSTM driver.
 * Do not edit this file if using SC
 *
 * @anchor OSTM_DRIVER_SC_CFG_LIMITATIONS 
 * @par Known Limitations
 * @ref NONE_YET
 *
 * @anchor OSTM_DRIVER_SC_CFG_INSTANCES 
 * @par Known Implementations
 * @ref NONE_YET
 *
 * @anchor OSTM_DRIVER_SC_CFG_RELATED 
 * @par Related modules
 * @ref RENESAS_OS_ABSTRACTION  Renesas OS Abstraction interface
 * @{
 *********************************************************************************************************************/

/** List of OSTM channels supported */
    #define R_CFG_OSTM_CHANNELS_SUPPORTED         ( R_CH0 | R_CH1 )

/** Maximum number of modules that can be granted simultaneous access to this driver  */
    #define  R_CFG_OSTM_DRV_MAXIMUM_ACCESS_PRV (1)

/*
 * @section OSTM_DRIVER_SC_CFG_SUMMARY
 * @brief Control interface */
/** ostm control codes */
typedef enum
{
    CTL_OSTM_CREATE_TIMER = (REQUIRES_CFG_STDIO_OSTM_RZ_HLD_UID << 8), /*!<  Create timer control function Uses @ref st_r_drv_ostm_config_t parameter*/
    CTL_OSTM_DESTORY_TIMER, /*!<  Destroy timer control function    */
    CTL_OSTM_START_TIMER, /*!<  Start timer control function      */
    CTL_OSTM_STOP_TIMER, /*!<  Stop timer control function       */
} e_ctrl_code_ostm_t;

/** Timer mode settings */
typedef enum
{
    OSTM_MODE_INTERVAL = 0, /*!< Interval timer mode (default)    */
    OSTM_MODE_COMPARE /*!< Free running compare mode   */
} e_ctrl_mode_ostm_t;

/** Timer configuration settings */
typedef struct r_drv_ostm_config_t
{
        int_t              channel; /*!< OSTM_CH_X specific channel, or R_OSTM_CH_ANY Request next available channel */
        uint32_t           frequency; /*!< duration in milliseconds */
        void               *callback_fn; /*!< user function to be called when the timer interrupt has triggered */
        e_ctrl_mode_ostm_t mode; /*!< timer mode setting @ref e_ctrl_mode_ostm_t for available options */

} st_r_drv_ostm_config_t;

/** Low level channel configuration structure */
typedef struct r_drv_ostm_lld_ch_config_t
{
        int_t            channel; /* specific channel */

        /* These elements can be modified using configurations from smart configurator */
        uint16_t         isr_priority;

        /* These elements should not be modified */
        void             *ostm; /* Enable channel in the peripheral, must exist */
        volatile uint8_t *cpg_reg;
        uint8_t          cpg_shift;
        uint8_t          cpg_mask;

        uint8_t          ostm_ctl_mdx_shift;
        uint8_t          ostm_ctl_mdx_mask;

        uint16_t         isr_id;
} st_r_drv_ostm_lld_ch_config_t;

/** Low level channel availability */
typedef struct r_drv_ostm_lld_config_t
{
        int_t ch_avaliable; /* R_CFG_OSTM_DRV_CHANNELS_AVAIL */
        int_t ch_supported; /* R_CFG_OSTM_CHANNELS_SUPPORTED */
} st_r_drv_ostm_lld_config_t;

/*******************************************************************************************************************//**
 * @} (end addtogroup OSTM_DRIVER_SC_CFG_SUMMARY)
 ***********************************************************************************************************************/

#endif /* SRC_RENESAS_CONFIG_R_OSTM_DRV_SC_CFG_H_ */

/******************************************************************************************************************//**
 End  Of File
 *********************************************************************************************************************/
