/***********************************************************************************************************************
 * DISCLAIMER
 * This software is supplied by Renesas Electronics Corporation and is only intended for use with Renesas products. No
 * other uses are authorized. This software is owned by Renesas Electronics Corporation and is protected under all
 * applicable laws, including copyright laws.
 * THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
 * THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED. TO THE MAXIMUM
 * EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES
 * SHALL BE LIABLE FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR ANY REASON RELATED TO THIS
 * SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 * Renesas reserves the right, without notice, to make changes to this software and to discontinue the availability of
 * this software. By using this software, you agree to the additional terms and conditions found by accessing the
 * following link:
 * http://www.renesas.com/disclaimer
 *
 * Copyright (C) 2017 Renesas Electronics Corporation. All rights reserved.
 **********************************************************************************************************************/
/***********************************************************************************************************************
 * File Name    : r_ostm_drv_link.h
 * Description  : This module solves all the world's problems
 **********************************************************************************************************************/
/***********************************************************************************************************************
 * History : DD.MM.YYYY Version  Description
 *         : 09.12.2017 1.00     First Release
 **********************************************************************************************************************/

/***********************************************************************************************************************
 Includes   <System Includes> , "Project Includes"
 **********************************************************************************************************************/

/*******************************************************************************************************************//**
 * @ingroup R_SW_PKG_93_POSIX_Drivers
 * @defgroup SSGSTARC_37_OSTM_DRIVER RZA1LU Stream-IT OSTM driver
 * @brief This interface provides access to the OSTM peripheral
 * See @ref OSTM_HLD_DRIVER for details.
 *
 * @anchor SSGSTARC_37_OSTM_DRIVER_SUMMARY
 * @par Summary
 * @brief The OSTM driver for the RSK+RZA1H is comprised of the following components ...
 *
 * @anchor SSGSTARC_37_OSTM_DRIVER_LIMITATIONS
 * @par Known Limitations
 * NONE_YET
 *
 * @anchor SSGSTARC_37_OSTM_DRIVER_INSTANCES
 * @par Known Implementations
 * @ref RENESAS_APPLICATION_SOFTWARE_PACKAGE
 *
 * @anchor SSGSTARC_37_OSTM_DRIVER_RELATED
 * @par Related modules *
 * @ref RENESAS_OS_ABSTRACTION  Renesas OS Abstraction interface
 * @{
 **********************************************************************************************************************/

#include "r_rskrza1h_ostm_lld.h"

#ifndef SRC_RENESAS_DRIVERS_R_OSTM_INC_R_OSTM_DRV_LINK_H_
#define SRC_RENESAS_DRIVERS_R_OSTM_INC_R_OSTM_DRV_LINK_H_

/***********************************************************************************************************************
 Macro definitions
 **********************************************************************************************************************/

/***********************************************************************************************************************
 Typedef definitions
 **********************************************************************************************************************/

/***********************************************************************************************************************
 Exported global variables
 **********************************************************************************************************************/

/***********************************************************************************************************************
 Exported global functions (to be accessed by other files)
 **********************************************************************************************************************/

#endif /* SRC_RENESAS_DRIVERS_R_OSTM_INC_R_OSTM_DRV_LINK_H_ */

/******************************************************************************
 End  Of File
 ******************************************************************************/

/*******************************************************************************************************************//**
 * @} (end addtogroup RZA1H_RSK_OSTM_LINK)
 ***********************************************************************************************************************/
