/*******************************************************************************
* DISCLAIMER
* This software is supplied by Renesas Electronics Corporation and is only
* intended for use with Renesas products. No other uses are authorized. This
* software is owned by Renesas Electronics Corporation and is protected under
* all applicable laws, including copyright laws.
* THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
* THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT
* LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
* AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED.
* TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS
* ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE
* FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR
* ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
* BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
* Renesas reserves the right, without notice, to make changes to this software
* and to discontinue the availability of this software. By using this software,
* you agree to the additional terms and conditions found by accessing the
* following link:
* http://www.renesas.com/disclaimer*
* Copyright (C) 2013-2016 Renesas Electronics Corporation. All rights reserved.
*******************************************************************************/
/*******************************************************************************
* File Name : rscan0_iodefine.h
* $Rev: 2941 $
* $Date:: 2017-02-20 14:49:23 +0000#$
* Description : Definition of I/O Register for RZ/A1LU (V3.00l)
******************************************************************************/
#ifndef RSCAN0_IODEFINE_H
#define RSCAN0_IODEFINE_H
/* ->QAC 0639 : Over 127 members (C90) */
/* ->QAC 0857 : Over 1024 #define (C90) */
/* ->MISRA 18.4 : Pack unpack union */ /* ->SEC M1.6.2 */
/* ->SEC M1.10.1 : Not magic number */

#define RSCAN0  (*(struct st_rscan0  *)0xE803A000uL) /* RSCAN0 */


/* Start of channel array defines of RSCAN0 */

/* Channel array defines of RSCAN_FROM_RSCAN0_CFIDm */
/*(Sample) value = RSCAN_FROM_RSCAN0_CFIDm[ channel ]->CFIDm.UINT32; */
#define RSCAN_FROM_RSCAN0_CFIDm_COUNT  (6)
#define RSCAN_FROM_RSCAN0_CFIDm_ADDRESS_LIST \
{   /* ->MISRA 11.3 */ /* ->SEC R2.7.1 */ \
    &RSCAN_FROM_RSCAN0CFID0, &RSCAN_FROM_RSCAN0CFID1, &RSCAN_FROM_RSCAN0CFID2, &RSCAN_FROM_RSCAN0CFID3, &RSCAN_FROM_RSCAN0CFID4, &RSCAN_FROM_RSCAN0CFID5 \
}   /* <-MISRA 11.3 */ /* <-SEC R2.7.1 */ /* { } is for MISRA 19.4 */
#define RSCAN_FROM_RSCAN0CFID0 (*(struct st_rscan_from_rscan0cfidm *)&RSCAN0.CFID0) /* RSCAN_FROM_RSCAN0CFID0 */
#define RSCAN_FROM_RSCAN0CFID1 (*(struct st_rscan_from_rscan0cfidm *)&RSCAN0.CFID1) /* RSCAN_FROM_RSCAN0CFID1 */
#define RSCAN_FROM_RSCAN0CFID2 (*(struct st_rscan_from_rscan0cfidm *)&RSCAN0.CFID2) /* RSCAN_FROM_RSCAN0CFID2 */
#define RSCAN_FROM_RSCAN0CFID3 (*(struct st_rscan_from_rscan0cfidm *)&RSCAN0.CFID3) /* RSCAN_FROM_RSCAN0CFID3 */
#define RSCAN_FROM_RSCAN0CFID4 (*(struct st_rscan_from_rscan0cfidm *)&RSCAN0.CFID4) /* RSCAN_FROM_RSCAN0CFID4 */
#define RSCAN_FROM_RSCAN0CFID5 (*(struct st_rscan_from_rscan0cfidm *)&RSCAN0.CFID5) /* RSCAN_FROM_RSCAN0CFID5 */


/* Channel array defines of RSCAN_FROM_RSCAN0_TMIDp */
/*(Sample) value = RSCAN_FROM_RSCAN0_TMIDp[ channel ]->TMIDp.UINT32; */
#define RSCAN_FROM_RSCAN0_TMIDp_COUNT  (32)
#define RSCAN_FROM_RSCAN0_TMIDp_ADDRESS_LIST \
{   /* ->MISRA 11.3 */ /* ->SEC R2.7.1 */ \
    &RSCAN_FROM_RSCAN0TMID0, &RSCAN_FROM_RSCAN0TMID1, &RSCAN_FROM_RSCAN0TMID2, &RSCAN_FROM_RSCAN0TMID3, &RSCAN_FROM_RSCAN0TMID4, &RSCAN_FROM_RSCAN0TMID5, &RSCAN_FROM_RSCAN0TMID6, &RSCAN_FROM_RSCAN0TMID7, \
    &RSCAN_FROM_RSCAN0TMID8, &RSCAN_FROM_RSCAN0TMID9, &RSCAN_FROM_RSCAN0TMID10, &RSCAN_FROM_RSCAN0TMID11, &RSCAN_FROM_RSCAN0TMID12, &RSCAN_FROM_RSCAN0TMID13, &RSCAN_FROM_RSCAN0TMID14, &RSCAN_FROM_RSCAN0TMID15, \
    &RSCAN_FROM_RSCAN0TMID16, &RSCAN_FROM_RSCAN0TMID17, &RSCAN_FROM_RSCAN0TMID18, &RSCAN_FROM_RSCAN0TMID19, &RSCAN_FROM_RSCAN0TMID20, &RSCAN_FROM_RSCAN0TMID21, &RSCAN_FROM_RSCAN0TMID22, &RSCAN_FROM_RSCAN0TMID23, \
    &RSCAN_FROM_RSCAN0TMID24, &RSCAN_FROM_RSCAN0TMID25, &RSCAN_FROM_RSCAN0TMID26, &RSCAN_FROM_RSCAN0TMID27, &RSCAN_FROM_RSCAN0TMID28, &RSCAN_FROM_RSCAN0TMID29, &RSCAN_FROM_RSCAN0TMID30, &RSCAN_FROM_RSCAN0TMID31 \
}   /* <-MISRA 11.3 */ /* <-SEC R2.7.1 */ /* { } is for MISRA 19.4 */
#define RSCAN_FROM_RSCAN0TMID0 (*(struct st_rscan_from_rscan0tmidp *)&RSCAN0.TMID0) /* RSCAN_FROM_RSCAN0TMID0 */
#define RSCAN_FROM_RSCAN0TMID1 (*(struct st_rscan_from_rscan0tmidp *)&RSCAN0.TMID1) /* RSCAN_FROM_RSCAN0TMID1 */
#define RSCAN_FROM_RSCAN0TMID2 (*(struct st_rscan_from_rscan0tmidp *)&RSCAN0.TMID2) /* RSCAN_FROM_RSCAN0TMID2 */
#define RSCAN_FROM_RSCAN0TMID3 (*(struct st_rscan_from_rscan0tmidp *)&RSCAN0.TMID3) /* RSCAN_FROM_RSCAN0TMID3 */
#define RSCAN_FROM_RSCAN0TMID4 (*(struct st_rscan_from_rscan0tmidp *)&RSCAN0.TMID4) /* RSCAN_FROM_RSCAN0TMID4 */
#define RSCAN_FROM_RSCAN0TMID5 (*(struct st_rscan_from_rscan0tmidp *)&RSCAN0.TMID5) /* RSCAN_FROM_RSCAN0TMID5 */
#define RSCAN_FROM_RSCAN0TMID6 (*(struct st_rscan_from_rscan0tmidp *)&RSCAN0.TMID6) /* RSCAN_FROM_RSCAN0TMID6 */
#define RSCAN_FROM_RSCAN0TMID7 (*(struct st_rscan_from_rscan0tmidp *)&RSCAN0.TMID7) /* RSCAN_FROM_RSCAN0TMID7 */
#define RSCAN_FROM_RSCAN0TMID8 (*(struct st_rscan_from_rscan0tmidp *)&RSCAN0.TMID8) /* RSCAN_FROM_RSCAN0TMID8 */
#define RSCAN_FROM_RSCAN0TMID9 (*(struct st_rscan_from_rscan0tmidp *)&RSCAN0.TMID9) /* RSCAN_FROM_RSCAN0TMID9 */
#define RSCAN_FROM_RSCAN0TMID10 (*(struct st_rscan_from_rscan0tmidp *)&RSCAN0.TMID10) /* RSCAN_FROM_RSCAN0TMID10 */
#define RSCAN_FROM_RSCAN0TMID11 (*(struct st_rscan_from_rscan0tmidp *)&RSCAN0.TMID11) /* RSCAN_FROM_RSCAN0TMID11 */
#define RSCAN_FROM_RSCAN0TMID12 (*(struct st_rscan_from_rscan0tmidp *)&RSCAN0.TMID12) /* RSCAN_FROM_RSCAN0TMID12 */
#define RSCAN_FROM_RSCAN0TMID13 (*(struct st_rscan_from_rscan0tmidp *)&RSCAN0.TMID13) /* RSCAN_FROM_RSCAN0TMID13 */
#define RSCAN_FROM_RSCAN0TMID14 (*(struct st_rscan_from_rscan0tmidp *)&RSCAN0.TMID14) /* RSCAN_FROM_RSCAN0TMID14 */
#define RSCAN_FROM_RSCAN0TMID15 (*(struct st_rscan_from_rscan0tmidp *)&RSCAN0.TMID15) /* RSCAN_FROM_RSCAN0TMID15 */
#define RSCAN_FROM_RSCAN0TMID16 (*(struct st_rscan_from_rscan0tmidp *)&RSCAN0.TMID16) /* RSCAN_FROM_RSCAN0TMID16 */
#define RSCAN_FROM_RSCAN0TMID17 (*(struct st_rscan_from_rscan0tmidp *)&RSCAN0.TMID17) /* RSCAN_FROM_RSCAN0TMID17 */
#define RSCAN_FROM_RSCAN0TMID18 (*(struct st_rscan_from_rscan0tmidp *)&RSCAN0.TMID18) /* RSCAN_FROM_RSCAN0TMID18 */
#define RSCAN_FROM_RSCAN0TMID19 (*(struct st_rscan_from_rscan0tmidp *)&RSCAN0.TMID19) /* RSCAN_FROM_RSCAN0TMID19 */
#define RSCAN_FROM_RSCAN0TMID20 (*(struct st_rscan_from_rscan0tmidp *)&RSCAN0.TMID20) /* RSCAN_FROM_RSCAN0TMID20 */
#define RSCAN_FROM_RSCAN0TMID21 (*(struct st_rscan_from_rscan0tmidp *)&RSCAN0.TMID21) /* RSCAN_FROM_RSCAN0TMID21 */
#define RSCAN_FROM_RSCAN0TMID22 (*(struct st_rscan_from_rscan0tmidp *)&RSCAN0.TMID22) /* RSCAN_FROM_RSCAN0TMID22 */
#define RSCAN_FROM_RSCAN0TMID23 (*(struct st_rscan_from_rscan0tmidp *)&RSCAN0.TMID23) /* RSCAN_FROM_RSCAN0TMID23 */
#define RSCAN_FROM_RSCAN0TMID24 (*(struct st_rscan_from_rscan0tmidp *)&RSCAN0.TMID24) /* RSCAN_FROM_RSCAN0TMID24 */
#define RSCAN_FROM_RSCAN0TMID25 (*(struct st_rscan_from_rscan0tmidp *)&RSCAN0.TMID25) /* RSCAN_FROM_RSCAN0TMID25 */
#define RSCAN_FROM_RSCAN0TMID26 (*(struct st_rscan_from_rscan0tmidp *)&RSCAN0.TMID26) /* RSCAN_FROM_RSCAN0TMID26 */
#define RSCAN_FROM_RSCAN0TMID27 (*(struct st_rscan_from_rscan0tmidp *)&RSCAN0.TMID27) /* RSCAN_FROM_RSCAN0TMID27 */
#define RSCAN_FROM_RSCAN0TMID28 (*(struct st_rscan_from_rscan0tmidp *)&RSCAN0.TMID28) /* RSCAN_FROM_RSCAN0TMID28 */
#define RSCAN_FROM_RSCAN0TMID29 (*(struct st_rscan_from_rscan0tmidp *)&RSCAN0.TMID29) /* RSCAN_FROM_RSCAN0TMID29 */
#define RSCAN_FROM_RSCAN0TMID30 (*(struct st_rscan_from_rscan0tmidp *)&RSCAN0.TMID30) /* RSCAN_FROM_RSCAN0TMID30 */
#define RSCAN_FROM_RSCAN0TMID31 (*(struct st_rscan_from_rscan0tmidp *)&RSCAN0.TMID31) /* RSCAN_FROM_RSCAN0TMID31 */


/* Channel array defines of RSCAN_FROM_RSCAN0_RFIDm */
/*(Sample) value = RSCAN_FROM_RSCAN0_RFIDm[ channel ]->RFIDm.UINT32; */
#define RSCAN_FROM_RSCAN0_RFIDm_COUNT  (8)
#define RSCAN_FROM_RSCAN0_RFIDm_ADDRESS_LIST \
{   /* ->MISRA 11.3 */ /* ->SEC R2.7.1 */ \
    &RSCAN_FROM_RSCAN0RFID0, &RSCAN_FROM_RSCAN0RFID1, &RSCAN_FROM_RSCAN0RFID2, &RSCAN_FROM_RSCAN0RFID3, &RSCAN_FROM_RSCAN0RFID4, &RSCAN_FROM_RSCAN0RFID5, &RSCAN_FROM_RSCAN0RFID6, &RSCAN_FROM_RSCAN0RFID7 \
}   /* <-MISRA 11.3 */ /* <-SEC R2.7.1 */ /* { } is for MISRA 19.4 */
#define RSCAN_FROM_RSCAN0RFID0 (*(struct st_rscan_from_rscan0rfidm *)&RSCAN0.RFID0) /* RSCAN_FROM_RSCAN0RFID0 */
#define RSCAN_FROM_RSCAN0RFID1 (*(struct st_rscan_from_rscan0rfidm *)&RSCAN0.RFID1) /* RSCAN_FROM_RSCAN0RFID1 */
#define RSCAN_FROM_RSCAN0RFID2 (*(struct st_rscan_from_rscan0rfidm *)&RSCAN0.RFID2) /* RSCAN_FROM_RSCAN0RFID2 */
#define RSCAN_FROM_RSCAN0RFID3 (*(struct st_rscan_from_rscan0rfidm *)&RSCAN0.RFID3) /* RSCAN_FROM_RSCAN0RFID3 */
#define RSCAN_FROM_RSCAN0RFID4 (*(struct st_rscan_from_rscan0rfidm *)&RSCAN0.RFID4) /* RSCAN_FROM_RSCAN0RFID4 */
#define RSCAN_FROM_RSCAN0RFID5 (*(struct st_rscan_from_rscan0rfidm *)&RSCAN0.RFID5) /* RSCAN_FROM_RSCAN0RFID5 */
#define RSCAN_FROM_RSCAN0RFID6 (*(struct st_rscan_from_rscan0rfidm *)&RSCAN0.RFID6) /* RSCAN_FROM_RSCAN0RFID6 */
#define RSCAN_FROM_RSCAN0RFID7 (*(struct st_rscan_from_rscan0rfidm *)&RSCAN0.RFID7) /* RSCAN_FROM_RSCAN0RFID7 */


/* Channel array defines of RSCAN_FROM_RSCAN0_RMIDp */
/*(Sample) value = RSCAN_FROM_RSCAN0_RMIDp[ channel ]->RMIDp.UINT32; */
#define RSCAN_FROM_RSCAN0_RMIDp_COUNT  (32)
#define RSCAN_FROM_RSCAN0_RMIDp_ADDRESS_LIST \
{   /* ->MISRA 11.3 */ /* ->SEC R2.7.1 */ \
    &RSCAN_FROM_RSCAN0RMID0, &RSCAN_FROM_RSCAN0RMID1, &RSCAN_FROM_RSCAN0RMID2, &RSCAN_FROM_RSCAN0RMID3, &RSCAN_FROM_RSCAN0RMID4, &RSCAN_FROM_RSCAN0RMID5, &RSCAN_FROM_RSCAN0RMID6, &RSCAN_FROM_RSCAN0RMID7, \
    &RSCAN_FROM_RSCAN0RMID8, &RSCAN_FROM_RSCAN0RMID9, &RSCAN_FROM_RSCAN0RMID10, &RSCAN_FROM_RSCAN0RMID11, &RSCAN_FROM_RSCAN0RMID12, &RSCAN_FROM_RSCAN0RMID13, &RSCAN_FROM_RSCAN0RMID14, &RSCAN_FROM_RSCAN0RMID15, \
    &RSCAN_FROM_RSCAN0RMID16, &RSCAN_FROM_RSCAN0RMID17, &RSCAN_FROM_RSCAN0RMID18, &RSCAN_FROM_RSCAN0RMID19, &RSCAN_FROM_RSCAN0RMID20, &RSCAN_FROM_RSCAN0RMID21, &RSCAN_FROM_RSCAN0RMID22, &RSCAN_FROM_RSCAN0RMID23, \
    &RSCAN_FROM_RSCAN0RMID24, &RSCAN_FROM_RSCAN0RMID25, &RSCAN_FROM_RSCAN0RMID26, &RSCAN_FROM_RSCAN0RMID27, &RSCAN_FROM_RSCAN0RMID28, &RSCAN_FROM_RSCAN0RMID29, &RSCAN_FROM_RSCAN0RMID30, &RSCAN_FROM_RSCAN0RMID31 \
}   /* <-MISRA 11.3 */ /* <-SEC R2.7.1 */ /* { } is for MISRA 19.4 */
#define RSCAN_FROM_RSCAN0RMID0 (*(struct st_rscan_from_rscan0rmidp *)&RSCAN0.RMID0) /* RSCAN_FROM_RSCAN0RMID0 */
#define RSCAN_FROM_RSCAN0RMID1 (*(struct st_rscan_from_rscan0rmidp *)&RSCAN0.RMID1) /* RSCAN_FROM_RSCAN0RMID1 */
#define RSCAN_FROM_RSCAN0RMID2 (*(struct st_rscan_from_rscan0rmidp *)&RSCAN0.RMID2) /* RSCAN_FROM_RSCAN0RMID2 */
#define RSCAN_FROM_RSCAN0RMID3 (*(struct st_rscan_from_rscan0rmidp *)&RSCAN0.RMID3) /* RSCAN_FROM_RSCAN0RMID3 */
#define RSCAN_FROM_RSCAN0RMID4 (*(struct st_rscan_from_rscan0rmidp *)&RSCAN0.RMID4) /* RSCAN_FROM_RSCAN0RMID4 */
#define RSCAN_FROM_RSCAN0RMID5 (*(struct st_rscan_from_rscan0rmidp *)&RSCAN0.RMID5) /* RSCAN_FROM_RSCAN0RMID5 */
#define RSCAN_FROM_RSCAN0RMID6 (*(struct st_rscan_from_rscan0rmidp *)&RSCAN0.RMID6) /* RSCAN_FROM_RSCAN0RMID6 */
#define RSCAN_FROM_RSCAN0RMID7 (*(struct st_rscan_from_rscan0rmidp *)&RSCAN0.RMID7) /* RSCAN_FROM_RSCAN0RMID7 */
#define RSCAN_FROM_RSCAN0RMID8 (*(struct st_rscan_from_rscan0rmidp *)&RSCAN0.RMID8) /* RSCAN_FROM_RSCAN0RMID8 */
#define RSCAN_FROM_RSCAN0RMID9 (*(struct st_rscan_from_rscan0rmidp *)&RSCAN0.RMID9) /* RSCAN_FROM_RSCAN0RMID9 */
#define RSCAN_FROM_RSCAN0RMID10 (*(struct st_rscan_from_rscan0rmidp *)&RSCAN0.RMID10) /* RSCAN_FROM_RSCAN0RMID10 */
#define RSCAN_FROM_RSCAN0RMID11 (*(struct st_rscan_from_rscan0rmidp *)&RSCAN0.RMID11) /* RSCAN_FROM_RSCAN0RMID11 */
#define RSCAN_FROM_RSCAN0RMID12 (*(struct st_rscan_from_rscan0rmidp *)&RSCAN0.RMID12) /* RSCAN_FROM_RSCAN0RMID12 */
#define RSCAN_FROM_RSCAN0RMID13 (*(struct st_rscan_from_rscan0rmidp *)&RSCAN0.RMID13) /* RSCAN_FROM_RSCAN0RMID13 */
#define RSCAN_FROM_RSCAN0RMID14 (*(struct st_rscan_from_rscan0rmidp *)&RSCAN0.RMID14) /* RSCAN_FROM_RSCAN0RMID14 */
#define RSCAN_FROM_RSCAN0RMID15 (*(struct st_rscan_from_rscan0rmidp *)&RSCAN0.RMID15) /* RSCAN_FROM_RSCAN0RMID15 */
#define RSCAN_FROM_RSCAN0RMID16 (*(struct st_rscan_from_rscan0rmidp *)&RSCAN0.RMID16) /* RSCAN_FROM_RSCAN0RMID16 */
#define RSCAN_FROM_RSCAN0RMID17 (*(struct st_rscan_from_rscan0rmidp *)&RSCAN0.RMID17) /* RSCAN_FROM_RSCAN0RMID17 */
#define RSCAN_FROM_RSCAN0RMID18 (*(struct st_rscan_from_rscan0rmidp *)&RSCAN0.RMID18) /* RSCAN_FROM_RSCAN0RMID18 */
#define RSCAN_FROM_RSCAN0RMID19 (*(struct st_rscan_from_rscan0rmidp *)&RSCAN0.RMID19) /* RSCAN_FROM_RSCAN0RMID19 */
#define RSCAN_FROM_RSCAN0RMID20 (*(struct st_rscan_from_rscan0rmidp *)&RSCAN0.RMID20) /* RSCAN_FROM_RSCAN0RMID20 */
#define RSCAN_FROM_RSCAN0RMID21 (*(struct st_rscan_from_rscan0rmidp *)&RSCAN0.RMID21) /* RSCAN_FROM_RSCAN0RMID21 */
#define RSCAN_FROM_RSCAN0RMID22 (*(struct st_rscan_from_rscan0rmidp *)&RSCAN0.RMID22) /* RSCAN_FROM_RSCAN0RMID22 */
#define RSCAN_FROM_RSCAN0RMID23 (*(struct st_rscan_from_rscan0rmidp *)&RSCAN0.RMID23) /* RSCAN_FROM_RSCAN0RMID23 */
#define RSCAN_FROM_RSCAN0RMID24 (*(struct st_rscan_from_rscan0rmidp *)&RSCAN0.RMID24) /* RSCAN_FROM_RSCAN0RMID24 */
#define RSCAN_FROM_RSCAN0RMID25 (*(struct st_rscan_from_rscan0rmidp *)&RSCAN0.RMID25) /* RSCAN_FROM_RSCAN0RMID25 */
#define RSCAN_FROM_RSCAN0RMID26 (*(struct st_rscan_from_rscan0rmidp *)&RSCAN0.RMID26) /* RSCAN_FROM_RSCAN0RMID26 */
#define RSCAN_FROM_RSCAN0RMID27 (*(struct st_rscan_from_rscan0rmidp *)&RSCAN0.RMID27) /* RSCAN_FROM_RSCAN0RMID27 */
#define RSCAN_FROM_RSCAN0RMID28 (*(struct st_rscan_from_rscan0rmidp *)&RSCAN0.RMID28) /* RSCAN_FROM_RSCAN0RMID28 */
#define RSCAN_FROM_RSCAN0RMID29 (*(struct st_rscan_from_rscan0rmidp *)&RSCAN0.RMID29) /* RSCAN_FROM_RSCAN0RMID29 */
#define RSCAN_FROM_RSCAN0RMID30 (*(struct st_rscan_from_rscan0rmidp *)&RSCAN0.RMID30) /* RSCAN_FROM_RSCAN0RMID30 */
#define RSCAN_FROM_RSCAN0RMID31 (*(struct st_rscan_from_rscan0rmidp *)&RSCAN0.RMID31) /* RSCAN_FROM_RSCAN0RMID31 */


/* Channel array defines of RSCAN_FROM_RSCAN0_GAFLIDj */
/*(Sample) value = RSCAN_FROM_RSCAN0_GAFLIDj[ channel ]->GAFLIDj.UINT32; */
#define RSCAN_FROM_RSCAN0_GAFLIDj_COUNT  (16)
#define RSCAN_FROM_RSCAN0_GAFLIDj_ADDRESS_LIST \
{   /* ->MISRA 11.3 */ /* ->SEC R2.7.1 */ \
    &RSCAN_FROM_RSCAN0GAFLID0, &RSCAN_FROM_RSCAN0GAFLID1, &RSCAN_FROM_RSCAN0GAFLID2, &RSCAN_FROM_RSCAN0GAFLID3, &RSCAN_FROM_RSCAN0GAFLID4, &RSCAN_FROM_RSCAN0GAFLID5, &RSCAN_FROM_RSCAN0GAFLID6, &RSCAN_FROM_RSCAN0GAFLID7, \
    &RSCAN_FROM_RSCAN0GAFLID8, &RSCAN_FROM_RSCAN0GAFLID9, &RSCAN_FROM_RSCAN0GAFLID10, &RSCAN_FROM_RSCAN0GAFLID11, &RSCAN_FROM_RSCAN0GAFLID12, &RSCAN_FROM_RSCAN0GAFLID13, &RSCAN_FROM_RSCAN0GAFLID14, &RSCAN_FROM_RSCAN0GAFLID15 \
}   /* <-MISRA 11.3 */ /* <-SEC R2.7.1 */ /* { } is for MISRA 19.4 */
#define RSCAN_FROM_RSCAN0GAFLID0 (*(struct st_rscan_from_rscan0gaflidj *)&RSCAN0.GAFLID0) /* RSCAN_FROM_RSCAN0GAFLID0 */
#define RSCAN_FROM_RSCAN0GAFLID1 (*(struct st_rscan_from_rscan0gaflidj *)&RSCAN0.GAFLID1) /* RSCAN_FROM_RSCAN0GAFLID1 */
#define RSCAN_FROM_RSCAN0GAFLID2 (*(struct st_rscan_from_rscan0gaflidj *)&RSCAN0.GAFLID2) /* RSCAN_FROM_RSCAN0GAFLID2 */
#define RSCAN_FROM_RSCAN0GAFLID3 (*(struct st_rscan_from_rscan0gaflidj *)&RSCAN0.GAFLID3) /* RSCAN_FROM_RSCAN0GAFLID3 */
#define RSCAN_FROM_RSCAN0GAFLID4 (*(struct st_rscan_from_rscan0gaflidj *)&RSCAN0.GAFLID4) /* RSCAN_FROM_RSCAN0GAFLID4 */
#define RSCAN_FROM_RSCAN0GAFLID5 (*(struct st_rscan_from_rscan0gaflidj *)&RSCAN0.GAFLID5) /* RSCAN_FROM_RSCAN0GAFLID5 */
#define RSCAN_FROM_RSCAN0GAFLID6 (*(struct st_rscan_from_rscan0gaflidj *)&RSCAN0.GAFLID6) /* RSCAN_FROM_RSCAN0GAFLID6 */
#define RSCAN_FROM_RSCAN0GAFLID7 (*(struct st_rscan_from_rscan0gaflidj *)&RSCAN0.GAFLID7) /* RSCAN_FROM_RSCAN0GAFLID7 */
#define RSCAN_FROM_RSCAN0GAFLID8 (*(struct st_rscan_from_rscan0gaflidj *)&RSCAN0.GAFLID8) /* RSCAN_FROM_RSCAN0GAFLID8 */
#define RSCAN_FROM_RSCAN0GAFLID9 (*(struct st_rscan_from_rscan0gaflidj *)&RSCAN0.GAFLID9) /* RSCAN_FROM_RSCAN0GAFLID9 */
#define RSCAN_FROM_RSCAN0GAFLID10 (*(struct st_rscan_from_rscan0gaflidj *)&RSCAN0.GAFLID10) /* RSCAN_FROM_RSCAN0GAFLID10 */
#define RSCAN_FROM_RSCAN0GAFLID11 (*(struct st_rscan_from_rscan0gaflidj *)&RSCAN0.GAFLID11) /* RSCAN_FROM_RSCAN0GAFLID11 */
#define RSCAN_FROM_RSCAN0GAFLID12 (*(struct st_rscan_from_rscan0gaflidj *)&RSCAN0.GAFLID12) /* RSCAN_FROM_RSCAN0GAFLID12 */
#define RSCAN_FROM_RSCAN0GAFLID13 (*(struct st_rscan_from_rscan0gaflidj *)&RSCAN0.GAFLID13) /* RSCAN_FROM_RSCAN0GAFLID13 */
#define RSCAN_FROM_RSCAN0GAFLID14 (*(struct st_rscan_from_rscan0gaflidj *)&RSCAN0.GAFLID14) /* RSCAN_FROM_RSCAN0GAFLID14 */
#define RSCAN_FROM_RSCAN0GAFLID15 (*(struct st_rscan_from_rscan0gaflidj *)&RSCAN0.GAFLID15) /* RSCAN_FROM_RSCAN0GAFLID15 */


/* Channel array defines of RSCAN_FROM_RSCAN0_CnCFG */
/*(Sample) value = RSCAN_FROM_RSCAN0_CnCFG[ channel ]->CnCFG.UINT32; */
#define RSCAN_FROM_RSCAN0_CnCFG_COUNT  (2)
#define RSCAN_FROM_RSCAN0_CnCFG_ADDRESS_LIST \
{   /* ->MISRA 11.3 */ /* ->SEC R2.7.1 */ \
    &RSCAN_FROM_RSCAN0C0CFG, &RSCAN_FROM_RSCAN0C1CFG \
}   /* <-MISRA 11.3 */ /* <-SEC R2.7.1 */ /* { } is for MISRA 19.4 */
#define RSCAN_FROM_RSCAN0C0CFG (*(struct st_rscan_from_rscan0cncfg *)&RSCAN0.C0CFG) /* RSCAN_FROM_RSCAN0C0CFG */
#define RSCAN_FROM_RSCAN0C1CFG (*(struct st_rscan_from_rscan0cncfg *)&RSCAN0.C1CFG) /* RSCAN_FROM_RSCAN0C1CFG */

/* End of channel array defines of RSCAN0 */


#define RSCAN0C0CFG (RSCAN0.C0CFG.UINT32)
#define RSCAN0C0CFGL (RSCAN0.C0CFG.UINT16[R_IO_L])
#define RSCAN0C0CFGLL (RSCAN0.C0CFG.UINT8[R_IO_LL])
#define RSCAN0C0CFGLH (RSCAN0.C0CFG.UINT8[R_IO_LH])
#define RSCAN0C0CFGH (RSCAN0.C0CFG.UINT16[R_IO_H])
#define RSCAN0C0CFGHL (RSCAN0.C0CFG.UINT8[R_IO_HL])
#define RSCAN0C0CFGHH (RSCAN0.C0CFG.UINT8[R_IO_HH])
#define RSCAN0C0CTR (RSCAN0.C0CTR.UINT32)
#define RSCAN0C0CTRL (RSCAN0.C0CTR.UINT16[R_IO_L])
#define RSCAN0C0CTRLL (RSCAN0.C0CTR.UINT8[R_IO_LL])
#define RSCAN0C0CTRLH (RSCAN0.C0CTR.UINT8[R_IO_LH])
#define RSCAN0C0CTRH (RSCAN0.C0CTR.UINT16[R_IO_H])
#define RSCAN0C0CTRHL (RSCAN0.C0CTR.UINT8[R_IO_HL])
#define RSCAN0C0CTRHH (RSCAN0.C0CTR.UINT8[R_IO_HH])
#define RSCAN0C0STS (RSCAN0.C0STS.UINT32)
#define RSCAN0C0STSL (RSCAN0.C0STS.UINT16[R_IO_L])
#define RSCAN0C0STSLL (RSCAN0.C0STS.UINT8[R_IO_LL])
#define RSCAN0C0STSLH (RSCAN0.C0STS.UINT8[R_IO_LH])
#define RSCAN0C0STSH (RSCAN0.C0STS.UINT16[R_IO_H])
#define RSCAN0C0STSHL (RSCAN0.C0STS.UINT8[R_IO_HL])
#define RSCAN0C0STSHH (RSCAN0.C0STS.UINT8[R_IO_HH])
#define RSCAN0C0ERFL (RSCAN0.C0ERFL.UINT32)
#define RSCAN0C0ERFLL (RSCAN0.C0ERFL.UINT16[R_IO_L])
#define RSCAN0C0ERFLLL (RSCAN0.C0ERFL.UINT8[R_IO_LL])
#define RSCAN0C0ERFLLH (RSCAN0.C0ERFL.UINT8[R_IO_LH])
#define RSCAN0C0ERFLH (RSCAN0.C0ERFL.UINT16[R_IO_H])
#define RSCAN0C0ERFLHL (RSCAN0.C0ERFL.UINT8[R_IO_HL])
#define RSCAN0C0ERFLHH (RSCAN0.C0ERFL.UINT8[R_IO_HH])
#define RSCAN0C1CFG (RSCAN0.C1CFG.UINT32)
#define RSCAN0C1CFGL (RSCAN0.C1CFG.UINT16[R_IO_L])
#define RSCAN0C1CFGLL (RSCAN0.C1CFG.UINT8[R_IO_LL])
#define RSCAN0C1CFGLH (RSCAN0.C1CFG.UINT8[R_IO_LH])
#define RSCAN0C1CFGH (RSCAN0.C1CFG.UINT16[R_IO_H])
#define RSCAN0C1CFGHL (RSCAN0.C1CFG.UINT8[R_IO_HL])
#define RSCAN0C1CFGHH (RSCAN0.C1CFG.UINT8[R_IO_HH])
#define RSCAN0C1CTR (RSCAN0.C1CTR.UINT32)
#define RSCAN0C1CTRL (RSCAN0.C1CTR.UINT16[R_IO_L])
#define RSCAN0C1CTRLL (RSCAN0.C1CTR.UINT8[R_IO_LL])
#define RSCAN0C1CTRLH (RSCAN0.C1CTR.UINT8[R_IO_LH])
#define RSCAN0C1CTRH (RSCAN0.C1CTR.UINT16[R_IO_H])
#define RSCAN0C1CTRHL (RSCAN0.C1CTR.UINT8[R_IO_HL])
#define RSCAN0C1CTRHH (RSCAN0.C1CTR.UINT8[R_IO_HH])
#define RSCAN0C1STS (RSCAN0.C1STS.UINT32)
#define RSCAN0C1STSL (RSCAN0.C1STS.UINT16[R_IO_L])
#define RSCAN0C1STSLL (RSCAN0.C1STS.UINT8[R_IO_LL])
#define RSCAN0C1STSLH (RSCAN0.C1STS.UINT8[R_IO_LH])
#define RSCAN0C1STSH (RSCAN0.C1STS.UINT16[R_IO_H])
#define RSCAN0C1STSHL (RSCAN0.C1STS.UINT8[R_IO_HL])
#define RSCAN0C1STSHH (RSCAN0.C1STS.UINT8[R_IO_HH])
#define RSCAN0C1ERFL (RSCAN0.C1ERFL.UINT32)
#define RSCAN0C1ERFLL (RSCAN0.C1ERFL.UINT16[R_IO_L])
#define RSCAN0C1ERFLLL (RSCAN0.C1ERFL.UINT8[R_IO_LL])
#define RSCAN0C1ERFLLH (RSCAN0.C1ERFL.UINT8[R_IO_LH])
#define RSCAN0C1ERFLH (RSCAN0.C1ERFL.UINT16[R_IO_H])
#define RSCAN0C1ERFLHL (RSCAN0.C1ERFL.UINT8[R_IO_HL])
#define RSCAN0C1ERFLHH (RSCAN0.C1ERFL.UINT8[R_IO_HH])
#define RSCAN0GCFG (RSCAN0.GCFG.UINT32)
#define RSCAN0GCFGL (RSCAN0.GCFG.UINT16[R_IO_L])
#define RSCAN0GCFGLL (RSCAN0.GCFG.UINT8[R_IO_LL])
#define RSCAN0GCFGLH (RSCAN0.GCFG.UINT8[R_IO_LH])
#define RSCAN0GCFGH (RSCAN0.GCFG.UINT16[R_IO_H])
#define RSCAN0GCFGHL (RSCAN0.GCFG.UINT8[R_IO_HL])
#define RSCAN0GCFGHH (RSCAN0.GCFG.UINT8[R_IO_HH])
#define RSCAN0GCTR (RSCAN0.GCTR.UINT32)
#define RSCAN0GCTRL (RSCAN0.GCTR.UINT16[R_IO_L])
#define RSCAN0GCTRLL (RSCAN0.GCTR.UINT8[R_IO_LL])
#define RSCAN0GCTRLH (RSCAN0.GCTR.UINT8[R_IO_LH])
#define RSCAN0GCTRH (RSCAN0.GCTR.UINT16[R_IO_H])
#define RSCAN0GCTRHL (RSCAN0.GCTR.UINT8[R_IO_HL])
#define RSCAN0GCTRHH (RSCAN0.GCTR.UINT8[R_IO_HH])
#define RSCAN0GSTS (RSCAN0.GSTS.UINT32)
#define RSCAN0GSTSL (RSCAN0.GSTS.UINT16[R_IO_L])
#define RSCAN0GSTSLL (RSCAN0.GSTS.UINT8[R_IO_LL])
#define RSCAN0GSTSLH (RSCAN0.GSTS.UINT8[R_IO_LH])
#define RSCAN0GSTSH (RSCAN0.GSTS.UINT16[R_IO_H])
#define RSCAN0GSTSHL (RSCAN0.GSTS.UINT8[R_IO_HL])
#define RSCAN0GSTSHH (RSCAN0.GSTS.UINT8[R_IO_HH])
#define RSCAN0GERFL (RSCAN0.GERFL.UINT32)
#define RSCAN0GERFLL (RSCAN0.GERFL.UINT16[R_IO_L])
#define RSCAN0GERFLLL (RSCAN0.GERFL.UINT8[R_IO_LL])
#define RSCAN0GERFLLH (RSCAN0.GERFL.UINT8[R_IO_LH])
#define RSCAN0GERFLH (RSCAN0.GERFL.UINT16[R_IO_H])
#define RSCAN0GERFLHL (RSCAN0.GERFL.UINT8[R_IO_HL])
#define RSCAN0GERFLHH (RSCAN0.GERFL.UINT8[R_IO_HH])
#define RSCAN0GTSC (RSCAN0.GTSC.UINT32)
#define RSCAN0GTSCL (RSCAN0.GTSC.UINT16[R_IO_L])
#define RSCAN0GTSCH (RSCAN0.GTSC.UINT16[R_IO_H])
#define RSCAN0GAFLECTR (RSCAN0.GAFLECTR.UINT32)
#define RSCAN0GAFLECTRL (RSCAN0.GAFLECTR.UINT16[R_IO_L])
#define RSCAN0GAFLECTRLL (RSCAN0.GAFLECTR.UINT8[R_IO_LL])
#define RSCAN0GAFLECTRLH (RSCAN0.GAFLECTR.UINT8[R_IO_LH])
#define RSCAN0GAFLECTRH (RSCAN0.GAFLECTR.UINT16[R_IO_H])
#define RSCAN0GAFLECTRHL (RSCAN0.GAFLECTR.UINT8[R_IO_HL])
#define RSCAN0GAFLECTRHH (RSCAN0.GAFLECTR.UINT8[R_IO_HH])
#define RSCAN0GAFLCFG0 (RSCAN0.GAFLCFG0.UINT32)
#define RSCAN0GAFLCFG0L (RSCAN0.GAFLCFG0.UINT16[R_IO_L])
#define RSCAN0GAFLCFG0LL (RSCAN0.GAFLCFG0.UINT8[R_IO_LL])
#define RSCAN0GAFLCFG0LH (RSCAN0.GAFLCFG0.UINT8[R_IO_LH])
#define RSCAN0GAFLCFG0H (RSCAN0.GAFLCFG0.UINT16[R_IO_H])
#define RSCAN0GAFLCFG0HL (RSCAN0.GAFLCFG0.UINT8[R_IO_HL])
#define RSCAN0GAFLCFG0HH (RSCAN0.GAFLCFG0.UINT8[R_IO_HH])
#define RSCAN0RMNB (RSCAN0.RMNB.UINT32)
#define RSCAN0RMNBL (RSCAN0.RMNB.UINT16[R_IO_L])
#define RSCAN0RMNBLL (RSCAN0.RMNB.UINT8[R_IO_LL])
#define RSCAN0RMNBLH (RSCAN0.RMNB.UINT8[R_IO_LH])
#define RSCAN0RMNBH (RSCAN0.RMNB.UINT16[R_IO_H])
#define RSCAN0RMNBHL (RSCAN0.RMNB.UINT8[R_IO_HL])
#define RSCAN0RMNBHH (RSCAN0.RMNB.UINT8[R_IO_HH])
#define RSCAN0RMND0 (RSCAN0.RMND0.UINT32)
#define RSCAN0RMND0L (RSCAN0.RMND0.UINT16[R_IO_L])
#define RSCAN0RMND0LL (RSCAN0.RMND0.UINT8[R_IO_LL])
#define RSCAN0RMND0LH (RSCAN0.RMND0.UINT8[R_IO_LH])
#define RSCAN0RMND0H (RSCAN0.RMND0.UINT16[R_IO_H])
#define RSCAN0RMND0HL (RSCAN0.RMND0.UINT8[R_IO_HL])
#define RSCAN0RMND0HH (RSCAN0.RMND0.UINT8[R_IO_HH])
#define RSCAN0RFCC0 (RSCAN0.RFCC0.UINT32)
#define RSCAN0RFCC0L (RSCAN0.RFCC0.UINT16[R_IO_L])
#define RSCAN0RFCC0LL (RSCAN0.RFCC0.UINT8[R_IO_LL])
#define RSCAN0RFCC0LH (RSCAN0.RFCC0.UINT8[R_IO_LH])
#define RSCAN0RFCC0H (RSCAN0.RFCC0.UINT16[R_IO_H])
#define RSCAN0RFCC0HL (RSCAN0.RFCC0.UINT8[R_IO_HL])
#define RSCAN0RFCC0HH (RSCAN0.RFCC0.UINT8[R_IO_HH])
#define RSCAN0RFCC1 (RSCAN0.RFCC1.UINT32)
#define RSCAN0RFCC1L (RSCAN0.RFCC1.UINT16[R_IO_L])
#define RSCAN0RFCC1LL (RSCAN0.RFCC1.UINT8[R_IO_LL])
#define RSCAN0RFCC1LH (RSCAN0.RFCC1.UINT8[R_IO_LH])
#define RSCAN0RFCC1H (RSCAN0.RFCC1.UINT16[R_IO_H])
#define RSCAN0RFCC1HL (RSCAN0.RFCC1.UINT8[R_IO_HL])
#define RSCAN0RFCC1HH (RSCAN0.RFCC1.UINT8[R_IO_HH])
#define RSCAN0RFCC2 (RSCAN0.RFCC2.UINT32)
#define RSCAN0RFCC2L (RSCAN0.RFCC2.UINT16[R_IO_L])
#define RSCAN0RFCC2LL (RSCAN0.RFCC2.UINT8[R_IO_LL])
#define RSCAN0RFCC2LH (RSCAN0.RFCC2.UINT8[R_IO_LH])
#define RSCAN0RFCC2H (RSCAN0.RFCC2.UINT16[R_IO_H])
#define RSCAN0RFCC2HL (RSCAN0.RFCC2.UINT8[R_IO_HL])
#define RSCAN0RFCC2HH (RSCAN0.RFCC2.UINT8[R_IO_HH])
#define RSCAN0RFCC3 (RSCAN0.RFCC3.UINT32)
#define RSCAN0RFCC3L (RSCAN0.RFCC3.UINT16[R_IO_L])
#define RSCAN0RFCC3LL (RSCAN0.RFCC3.UINT8[R_IO_LL])
#define RSCAN0RFCC3LH (RSCAN0.RFCC3.UINT8[R_IO_LH])
#define RSCAN0RFCC3H (RSCAN0.RFCC3.UINT16[R_IO_H])
#define RSCAN0RFCC3HL (RSCAN0.RFCC3.UINT8[R_IO_HL])
#define RSCAN0RFCC3HH (RSCAN0.RFCC3.UINT8[R_IO_HH])
#define RSCAN0RFCC4 (RSCAN0.RFCC4.UINT32)
#define RSCAN0RFCC4L (RSCAN0.RFCC4.UINT16[R_IO_L])
#define RSCAN0RFCC4LL (RSCAN0.RFCC4.UINT8[R_IO_LL])
#define RSCAN0RFCC4LH (RSCAN0.RFCC4.UINT8[R_IO_LH])
#define RSCAN0RFCC4H (RSCAN0.RFCC4.UINT16[R_IO_H])
#define RSCAN0RFCC4HL (RSCAN0.RFCC4.UINT8[R_IO_HL])
#define RSCAN0RFCC4HH (RSCAN0.RFCC4.UINT8[R_IO_HH])
#define RSCAN0RFCC5 (RSCAN0.RFCC5.UINT32)
#define RSCAN0RFCC5L (RSCAN0.RFCC5.UINT16[R_IO_L])
#define RSCAN0RFCC5LL (RSCAN0.RFCC5.UINT8[R_IO_LL])
#define RSCAN0RFCC5LH (RSCAN0.RFCC5.UINT8[R_IO_LH])
#define RSCAN0RFCC5H (RSCAN0.RFCC5.UINT16[R_IO_H])
#define RSCAN0RFCC5HL (RSCAN0.RFCC5.UINT8[R_IO_HL])
#define RSCAN0RFCC5HH (RSCAN0.RFCC5.UINT8[R_IO_HH])
#define RSCAN0RFCC6 (RSCAN0.RFCC6.UINT32)
#define RSCAN0RFCC6L (RSCAN0.RFCC6.UINT16[R_IO_L])
#define RSCAN0RFCC6LL (RSCAN0.RFCC6.UINT8[R_IO_LL])
#define RSCAN0RFCC6LH (RSCAN0.RFCC6.UINT8[R_IO_LH])
#define RSCAN0RFCC6H (RSCAN0.RFCC6.UINT16[R_IO_H])
#define RSCAN0RFCC6HL (RSCAN0.RFCC6.UINT8[R_IO_HL])
#define RSCAN0RFCC6HH (RSCAN0.RFCC6.UINT8[R_IO_HH])
#define RSCAN0RFCC7 (RSCAN0.RFCC7.UINT32)
#define RSCAN0RFCC7L (RSCAN0.RFCC7.UINT16[R_IO_L])
#define RSCAN0RFCC7LL (RSCAN0.RFCC7.UINT8[R_IO_LL])
#define RSCAN0RFCC7LH (RSCAN0.RFCC7.UINT8[R_IO_LH])
#define RSCAN0RFCC7H (RSCAN0.RFCC7.UINT16[R_IO_H])
#define RSCAN0RFCC7HL (RSCAN0.RFCC7.UINT8[R_IO_HL])
#define RSCAN0RFCC7HH (RSCAN0.RFCC7.UINT8[R_IO_HH])
#define RSCAN0RFSTS0 (RSCAN0.RFSTS0.UINT32)
#define RSCAN0RFSTS0L (RSCAN0.RFSTS0.UINT16[R_IO_L])
#define RSCAN0RFSTS0LL (RSCAN0.RFSTS0.UINT8[R_IO_LL])
#define RSCAN0RFSTS0LH (RSCAN0.RFSTS0.UINT8[R_IO_LH])
#define RSCAN0RFSTS0H (RSCAN0.RFSTS0.UINT16[R_IO_H])
#define RSCAN0RFSTS0HL (RSCAN0.RFSTS0.UINT8[R_IO_HL])
#define RSCAN0RFSTS0HH (RSCAN0.RFSTS0.UINT8[R_IO_HH])
#define RSCAN0RFSTS1 (RSCAN0.RFSTS1.UINT32)
#define RSCAN0RFSTS1L (RSCAN0.RFSTS1.UINT16[R_IO_L])
#define RSCAN0RFSTS1LL (RSCAN0.RFSTS1.UINT8[R_IO_LL])
#define RSCAN0RFSTS1LH (RSCAN0.RFSTS1.UINT8[R_IO_LH])
#define RSCAN0RFSTS1H (RSCAN0.RFSTS1.UINT16[R_IO_H])
#define RSCAN0RFSTS1HL (RSCAN0.RFSTS1.UINT8[R_IO_HL])
#define RSCAN0RFSTS1HH (RSCAN0.RFSTS1.UINT8[R_IO_HH])
#define RSCAN0RFSTS2 (RSCAN0.RFSTS2.UINT32)
#define RSCAN0RFSTS2L (RSCAN0.RFSTS2.UINT16[R_IO_L])
#define RSCAN0RFSTS2LL (RSCAN0.RFSTS2.UINT8[R_IO_LL])
#define RSCAN0RFSTS2LH (RSCAN0.RFSTS2.UINT8[R_IO_LH])
#define RSCAN0RFSTS2H (RSCAN0.RFSTS2.UINT16[R_IO_H])
#define RSCAN0RFSTS2HL (RSCAN0.RFSTS2.UINT8[R_IO_HL])
#define RSCAN0RFSTS2HH (RSCAN0.RFSTS2.UINT8[R_IO_HH])
#define RSCAN0RFSTS3 (RSCAN0.RFSTS3.UINT32)
#define RSCAN0RFSTS3L (RSCAN0.RFSTS3.UINT16[R_IO_L])
#define RSCAN0RFSTS3LL (RSCAN0.RFSTS3.UINT8[R_IO_LL])
#define RSCAN0RFSTS3LH (RSCAN0.RFSTS3.UINT8[R_IO_LH])
#define RSCAN0RFSTS3H (RSCAN0.RFSTS3.UINT16[R_IO_H])
#define RSCAN0RFSTS3HL (RSCAN0.RFSTS3.UINT8[R_IO_HL])
#define RSCAN0RFSTS3HH (RSCAN0.RFSTS3.UINT8[R_IO_HH])
#define RSCAN0RFSTS4 (RSCAN0.RFSTS4.UINT32)
#define RSCAN0RFSTS4L (RSCAN0.RFSTS4.UINT16[R_IO_L])
#define RSCAN0RFSTS4LL (RSCAN0.RFSTS4.UINT8[R_IO_LL])
#define RSCAN0RFSTS4LH (RSCAN0.RFSTS4.UINT8[R_IO_LH])
#define RSCAN0RFSTS4H (RSCAN0.RFSTS4.UINT16[R_IO_H])
#define RSCAN0RFSTS4HL (RSCAN0.RFSTS4.UINT8[R_IO_HL])
#define RSCAN0RFSTS4HH (RSCAN0.RFSTS4.UINT8[R_IO_HH])
#define RSCAN0RFSTS5 (RSCAN0.RFSTS5.UINT32)
#define RSCAN0RFSTS5L (RSCAN0.RFSTS5.UINT16[R_IO_L])
#define RSCAN0RFSTS5LL (RSCAN0.RFSTS5.UINT8[R_IO_LL])
#define RSCAN0RFSTS5LH (RSCAN0.RFSTS5.UINT8[R_IO_LH])
#define RSCAN0RFSTS5H (RSCAN0.RFSTS5.UINT16[R_IO_H])
#define RSCAN0RFSTS5HL (RSCAN0.RFSTS5.UINT8[R_IO_HL])
#define RSCAN0RFSTS5HH (RSCAN0.RFSTS5.UINT8[R_IO_HH])
#define RSCAN0RFSTS6 (RSCAN0.RFSTS6.UINT32)
#define RSCAN0RFSTS6L (RSCAN0.RFSTS6.UINT16[R_IO_L])
#define RSCAN0RFSTS6LL (RSCAN0.RFSTS6.UINT8[R_IO_LL])
#define RSCAN0RFSTS6LH (RSCAN0.RFSTS6.UINT8[R_IO_LH])
#define RSCAN0RFSTS6H (RSCAN0.RFSTS6.UINT16[R_IO_H])
#define RSCAN0RFSTS6HL (RSCAN0.RFSTS6.UINT8[R_IO_HL])
#define RSCAN0RFSTS6HH (RSCAN0.RFSTS6.UINT8[R_IO_HH])
#define RSCAN0RFSTS7 (RSCAN0.RFSTS7.UINT32)
#define RSCAN0RFSTS7L (RSCAN0.RFSTS7.UINT16[R_IO_L])
#define RSCAN0RFSTS7LL (RSCAN0.RFSTS7.UINT8[R_IO_LL])
#define RSCAN0RFSTS7LH (RSCAN0.RFSTS7.UINT8[R_IO_LH])
#define RSCAN0RFSTS7H (RSCAN0.RFSTS7.UINT16[R_IO_H])
#define RSCAN0RFSTS7HL (RSCAN0.RFSTS7.UINT8[R_IO_HL])
#define RSCAN0RFSTS7HH (RSCAN0.RFSTS7.UINT8[R_IO_HH])
#define RSCAN0RFPCTR0 (RSCAN0.RFPCTR0.UINT32)
#define RSCAN0RFPCTR0L (RSCAN0.RFPCTR0.UINT16[R_IO_L])
#define RSCAN0RFPCTR0LL (RSCAN0.RFPCTR0.UINT8[R_IO_LL])
#define RSCAN0RFPCTR0LH (RSCAN0.RFPCTR0.UINT8[R_IO_LH])
#define RSCAN0RFPCTR0H (RSCAN0.RFPCTR0.UINT16[R_IO_H])
#define RSCAN0RFPCTR0HL (RSCAN0.RFPCTR0.UINT8[R_IO_HL])
#define RSCAN0RFPCTR0HH (RSCAN0.RFPCTR0.UINT8[R_IO_HH])
#define RSCAN0RFPCTR1 (RSCAN0.RFPCTR1.UINT32)
#define RSCAN0RFPCTR1L (RSCAN0.RFPCTR1.UINT16[R_IO_L])
#define RSCAN0RFPCTR1LL (RSCAN0.RFPCTR1.UINT8[R_IO_LL])
#define RSCAN0RFPCTR1LH (RSCAN0.RFPCTR1.UINT8[R_IO_LH])
#define RSCAN0RFPCTR1H (RSCAN0.RFPCTR1.UINT16[R_IO_H])
#define RSCAN0RFPCTR1HL (RSCAN0.RFPCTR1.UINT8[R_IO_HL])
#define RSCAN0RFPCTR1HH (RSCAN0.RFPCTR1.UINT8[R_IO_HH])
#define RSCAN0RFPCTR2 (RSCAN0.RFPCTR2.UINT32)
#define RSCAN0RFPCTR2L (RSCAN0.RFPCTR2.UINT16[R_IO_L])
#define RSCAN0RFPCTR2LL (RSCAN0.RFPCTR2.UINT8[R_IO_LL])
#define RSCAN0RFPCTR2LH (RSCAN0.RFPCTR2.UINT8[R_IO_LH])
#define RSCAN0RFPCTR2H (RSCAN0.RFPCTR2.UINT16[R_IO_H])
#define RSCAN0RFPCTR2HL (RSCAN0.RFPCTR2.UINT8[R_IO_HL])
#define RSCAN0RFPCTR2HH (RSCAN0.RFPCTR2.UINT8[R_IO_HH])
#define RSCAN0RFPCTR3 (RSCAN0.RFPCTR3.UINT32)
#define RSCAN0RFPCTR3L (RSCAN0.RFPCTR3.UINT16[R_IO_L])
#define RSCAN0RFPCTR3LL (RSCAN0.RFPCTR3.UINT8[R_IO_LL])
#define RSCAN0RFPCTR3LH (RSCAN0.RFPCTR3.UINT8[R_IO_LH])
#define RSCAN0RFPCTR3H (RSCAN0.RFPCTR3.UINT16[R_IO_H])
#define RSCAN0RFPCTR3HL (RSCAN0.RFPCTR3.UINT8[R_IO_HL])
#define RSCAN0RFPCTR3HH (RSCAN0.RFPCTR3.UINT8[R_IO_HH])
#define RSCAN0RFPCTR4 (RSCAN0.RFPCTR4.UINT32)
#define RSCAN0RFPCTR4L (RSCAN0.RFPCTR4.UINT16[R_IO_L])
#define RSCAN0RFPCTR4LL (RSCAN0.RFPCTR4.UINT8[R_IO_LL])
#define RSCAN0RFPCTR4LH (RSCAN0.RFPCTR4.UINT8[R_IO_LH])
#define RSCAN0RFPCTR4H (RSCAN0.RFPCTR4.UINT16[R_IO_H])
#define RSCAN0RFPCTR4HL (RSCAN0.RFPCTR4.UINT8[R_IO_HL])
#define RSCAN0RFPCTR4HH (RSCAN0.RFPCTR4.UINT8[R_IO_HH])
#define RSCAN0RFPCTR5 (RSCAN0.RFPCTR5.UINT32)
#define RSCAN0RFPCTR5L (RSCAN0.RFPCTR5.UINT16[R_IO_L])
#define RSCAN0RFPCTR5LL (RSCAN0.RFPCTR5.UINT8[R_IO_LL])
#define RSCAN0RFPCTR5LH (RSCAN0.RFPCTR5.UINT8[R_IO_LH])
#define RSCAN0RFPCTR5H (RSCAN0.RFPCTR5.UINT16[R_IO_H])
#define RSCAN0RFPCTR5HL (RSCAN0.RFPCTR5.UINT8[R_IO_HL])
#define RSCAN0RFPCTR5HH (RSCAN0.RFPCTR5.UINT8[R_IO_HH])
#define RSCAN0RFPCTR6 (RSCAN0.RFPCTR6.UINT32)
#define RSCAN0RFPCTR6L (RSCAN0.RFPCTR6.UINT16[R_IO_L])
#define RSCAN0RFPCTR6LL (RSCAN0.RFPCTR6.UINT8[R_IO_LL])
#define RSCAN0RFPCTR6LH (RSCAN0.RFPCTR6.UINT8[R_IO_LH])
#define RSCAN0RFPCTR6H (RSCAN0.RFPCTR6.UINT16[R_IO_H])
#define RSCAN0RFPCTR6HL (RSCAN0.RFPCTR6.UINT8[R_IO_HL])
#define RSCAN0RFPCTR6HH (RSCAN0.RFPCTR6.UINT8[R_IO_HH])
#define RSCAN0RFPCTR7 (RSCAN0.RFPCTR7.UINT32)
#define RSCAN0RFPCTR7L (RSCAN0.RFPCTR7.UINT16[R_IO_L])
#define RSCAN0RFPCTR7LL (RSCAN0.RFPCTR7.UINT8[R_IO_LL])
#define RSCAN0RFPCTR7LH (RSCAN0.RFPCTR7.UINT8[R_IO_LH])
#define RSCAN0RFPCTR7H (RSCAN0.RFPCTR7.UINT16[R_IO_H])
#define RSCAN0RFPCTR7HL (RSCAN0.RFPCTR7.UINT8[R_IO_HL])
#define RSCAN0RFPCTR7HH (RSCAN0.RFPCTR7.UINT8[R_IO_HH])
#define RSCAN0CFCC0 (RSCAN0.CFCC0.UINT32)
#define RSCAN0CFCC0L (RSCAN0.CFCC0.UINT16[R_IO_L])
#define RSCAN0CFCC0LL (RSCAN0.CFCC0.UINT8[R_IO_LL])
#define RSCAN0CFCC0LH (RSCAN0.CFCC0.UINT8[R_IO_LH])
#define RSCAN0CFCC0H (RSCAN0.CFCC0.UINT16[R_IO_H])
#define RSCAN0CFCC0HL (RSCAN0.CFCC0.UINT8[R_IO_HL])
#define RSCAN0CFCC0HH (RSCAN0.CFCC0.UINT8[R_IO_HH])
#define RSCAN0CFCC1 (RSCAN0.CFCC1.UINT32)
#define RSCAN0CFCC1L (RSCAN0.CFCC1.UINT16[R_IO_L])
#define RSCAN0CFCC1LL (RSCAN0.CFCC1.UINT8[R_IO_LL])
#define RSCAN0CFCC1LH (RSCAN0.CFCC1.UINT8[R_IO_LH])
#define RSCAN0CFCC1H (RSCAN0.CFCC1.UINT16[R_IO_H])
#define RSCAN0CFCC1HL (RSCAN0.CFCC1.UINT8[R_IO_HL])
#define RSCAN0CFCC1HH (RSCAN0.CFCC1.UINT8[R_IO_HH])
#define RSCAN0CFCC2 (RSCAN0.CFCC2.UINT32)
#define RSCAN0CFCC2L (RSCAN0.CFCC2.UINT16[R_IO_L])
#define RSCAN0CFCC2LL (RSCAN0.CFCC2.UINT8[R_IO_LL])
#define RSCAN0CFCC2LH (RSCAN0.CFCC2.UINT8[R_IO_LH])
#define RSCAN0CFCC2H (RSCAN0.CFCC2.UINT16[R_IO_H])
#define RSCAN0CFCC2HL (RSCAN0.CFCC2.UINT8[R_IO_HL])
#define RSCAN0CFCC2HH (RSCAN0.CFCC2.UINT8[R_IO_HH])
#define RSCAN0CFCC3 (RSCAN0.CFCC3.UINT32)
#define RSCAN0CFCC3L (RSCAN0.CFCC3.UINT16[R_IO_L])
#define RSCAN0CFCC3LL (RSCAN0.CFCC3.UINT8[R_IO_LL])
#define RSCAN0CFCC3LH (RSCAN0.CFCC3.UINT8[R_IO_LH])
#define RSCAN0CFCC3H (RSCAN0.CFCC3.UINT16[R_IO_H])
#define RSCAN0CFCC3HL (RSCAN0.CFCC3.UINT8[R_IO_HL])
#define RSCAN0CFCC3HH (RSCAN0.CFCC3.UINT8[R_IO_HH])
#define RSCAN0CFCC4 (RSCAN0.CFCC4.UINT32)
#define RSCAN0CFCC4L (RSCAN0.CFCC4.UINT16[R_IO_L])
#define RSCAN0CFCC4LL (RSCAN0.CFCC4.UINT8[R_IO_LL])
#define RSCAN0CFCC4LH (RSCAN0.CFCC4.UINT8[R_IO_LH])
#define RSCAN0CFCC4H (RSCAN0.CFCC4.UINT16[R_IO_H])
#define RSCAN0CFCC4HL (RSCAN0.CFCC4.UINT8[R_IO_HL])
#define RSCAN0CFCC4HH (RSCAN0.CFCC4.UINT8[R_IO_HH])
#define RSCAN0CFCC5 (RSCAN0.CFCC5.UINT32)
#define RSCAN0CFCC5L (RSCAN0.CFCC5.UINT16[R_IO_L])
#define RSCAN0CFCC5LL (RSCAN0.CFCC5.UINT8[R_IO_LL])
#define RSCAN0CFCC5LH (RSCAN0.CFCC5.UINT8[R_IO_LH])
#define RSCAN0CFCC5H (RSCAN0.CFCC5.UINT16[R_IO_H])
#define RSCAN0CFCC5HL (RSCAN0.CFCC5.UINT8[R_IO_HL])
#define RSCAN0CFCC5HH (RSCAN0.CFCC5.UINT8[R_IO_HH])
#define RSCAN0CFSTS0 (RSCAN0.CFSTS0.UINT32)
#define RSCAN0CFSTS0L (RSCAN0.CFSTS0.UINT16[R_IO_L])
#define RSCAN0CFSTS0LL (RSCAN0.CFSTS0.UINT8[R_IO_LL])
#define RSCAN0CFSTS0LH (RSCAN0.CFSTS0.UINT8[R_IO_LH])
#define RSCAN0CFSTS0H (RSCAN0.CFSTS0.UINT16[R_IO_H])
#define RSCAN0CFSTS0HL (RSCAN0.CFSTS0.UINT8[R_IO_HL])
#define RSCAN0CFSTS0HH (RSCAN0.CFSTS0.UINT8[R_IO_HH])
#define RSCAN0CFSTS1 (RSCAN0.CFSTS1.UINT32)
#define RSCAN0CFSTS1L (RSCAN0.CFSTS1.UINT16[R_IO_L])
#define RSCAN0CFSTS1LL (RSCAN0.CFSTS1.UINT8[R_IO_LL])
#define RSCAN0CFSTS1LH (RSCAN0.CFSTS1.UINT8[R_IO_LH])
#define RSCAN0CFSTS1H (RSCAN0.CFSTS1.UINT16[R_IO_H])
#define RSCAN0CFSTS1HL (RSCAN0.CFSTS1.UINT8[R_IO_HL])
#define RSCAN0CFSTS1HH (RSCAN0.CFSTS1.UINT8[R_IO_HH])
#define RSCAN0CFSTS2 (RSCAN0.CFSTS2.UINT32)
#define RSCAN0CFSTS2L (RSCAN0.CFSTS2.UINT16[R_IO_L])
#define RSCAN0CFSTS2LL (RSCAN0.CFSTS2.UINT8[R_IO_LL])
#define RSCAN0CFSTS2LH (RSCAN0.CFSTS2.UINT8[R_IO_LH])
#define RSCAN0CFSTS2H (RSCAN0.CFSTS2.UINT16[R_IO_H])
#define RSCAN0CFSTS2HL (RSCAN0.CFSTS2.UINT8[R_IO_HL])
#define RSCAN0CFSTS2HH (RSCAN0.CFSTS2.UINT8[R_IO_HH])
#define RSCAN0CFSTS3 (RSCAN0.CFSTS3.UINT32)
#define RSCAN0CFSTS3L (RSCAN0.CFSTS3.UINT16[R_IO_L])
#define RSCAN0CFSTS3LL (RSCAN0.CFSTS3.UINT8[R_IO_LL])
#define RSCAN0CFSTS3LH (RSCAN0.CFSTS3.UINT8[R_IO_LH])
#define RSCAN0CFSTS3H (RSCAN0.CFSTS3.UINT16[R_IO_H])
#define RSCAN0CFSTS3HL (RSCAN0.CFSTS3.UINT8[R_IO_HL])
#define RSCAN0CFSTS3HH (RSCAN0.CFSTS3.UINT8[R_IO_HH])
#define RSCAN0CFSTS4 (RSCAN0.CFSTS4.UINT32)
#define RSCAN0CFSTS4L (RSCAN0.CFSTS4.UINT16[R_IO_L])
#define RSCAN0CFSTS4LL (RSCAN0.CFSTS4.UINT8[R_IO_LL])
#define RSCAN0CFSTS4LH (RSCAN0.CFSTS4.UINT8[R_IO_LH])
#define RSCAN0CFSTS4H (RSCAN0.CFSTS4.UINT16[R_IO_H])
#define RSCAN0CFSTS4HL (RSCAN0.CFSTS4.UINT8[R_IO_HL])
#define RSCAN0CFSTS4HH (RSCAN0.CFSTS4.UINT8[R_IO_HH])
#define RSCAN0CFSTS5 (RSCAN0.CFSTS5.UINT32)
#define RSCAN0CFSTS5L (RSCAN0.CFSTS5.UINT16[R_IO_L])
#define RSCAN0CFSTS5LL (RSCAN0.CFSTS5.UINT8[R_IO_LL])
#define RSCAN0CFSTS5LH (RSCAN0.CFSTS5.UINT8[R_IO_LH])
#define RSCAN0CFSTS5H (RSCAN0.CFSTS5.UINT16[R_IO_H])
#define RSCAN0CFSTS5HL (RSCAN0.CFSTS5.UINT8[R_IO_HL])
#define RSCAN0CFSTS5HH (RSCAN0.CFSTS5.UINT8[R_IO_HH])
#define RSCAN0CFPCTR0 (RSCAN0.CFPCTR0.UINT32)
#define RSCAN0CFPCTR0L (RSCAN0.CFPCTR0.UINT16[R_IO_L])
#define RSCAN0CFPCTR0LL (RSCAN0.CFPCTR0.UINT8[R_IO_LL])
#define RSCAN0CFPCTR0LH (RSCAN0.CFPCTR0.UINT8[R_IO_LH])
#define RSCAN0CFPCTR0H (RSCAN0.CFPCTR0.UINT16[R_IO_H])
#define RSCAN0CFPCTR0HL (RSCAN0.CFPCTR0.UINT8[R_IO_HL])
#define RSCAN0CFPCTR0HH (RSCAN0.CFPCTR0.UINT8[R_IO_HH])
#define RSCAN0CFPCTR1 (RSCAN0.CFPCTR1.UINT32)
#define RSCAN0CFPCTR1L (RSCAN0.CFPCTR1.UINT16[R_IO_L])
#define RSCAN0CFPCTR1LL (RSCAN0.CFPCTR1.UINT8[R_IO_LL])
#define RSCAN0CFPCTR1LH (RSCAN0.CFPCTR1.UINT8[R_IO_LH])
#define RSCAN0CFPCTR1H (RSCAN0.CFPCTR1.UINT16[R_IO_H])
#define RSCAN0CFPCTR1HL (RSCAN0.CFPCTR1.UINT8[R_IO_HL])
#define RSCAN0CFPCTR1HH (RSCAN0.CFPCTR1.UINT8[R_IO_HH])
#define RSCAN0CFPCTR2 (RSCAN0.CFPCTR2.UINT32)
#define RSCAN0CFPCTR2L (RSCAN0.CFPCTR2.UINT16[R_IO_L])
#define RSCAN0CFPCTR2LL (RSCAN0.CFPCTR2.UINT8[R_IO_LL])
#define RSCAN0CFPCTR2LH (RSCAN0.CFPCTR2.UINT8[R_IO_LH])
#define RSCAN0CFPCTR2H (RSCAN0.CFPCTR2.UINT16[R_IO_H])
#define RSCAN0CFPCTR2HL (RSCAN0.CFPCTR2.UINT8[R_IO_HL])
#define RSCAN0CFPCTR2HH (RSCAN0.CFPCTR2.UINT8[R_IO_HH])
#define RSCAN0CFPCTR3 (RSCAN0.CFPCTR3.UINT32)
#define RSCAN0CFPCTR3L (RSCAN0.CFPCTR3.UINT16[R_IO_L])
#define RSCAN0CFPCTR3LL (RSCAN0.CFPCTR3.UINT8[R_IO_LL])
#define RSCAN0CFPCTR3LH (RSCAN0.CFPCTR3.UINT8[R_IO_LH])
#define RSCAN0CFPCTR3H (RSCAN0.CFPCTR3.UINT16[R_IO_H])
#define RSCAN0CFPCTR3HL (RSCAN0.CFPCTR3.UINT8[R_IO_HL])
#define RSCAN0CFPCTR3HH (RSCAN0.CFPCTR3.UINT8[R_IO_HH])
#define RSCAN0CFPCTR4 (RSCAN0.CFPCTR4.UINT32)
#define RSCAN0CFPCTR4L (RSCAN0.CFPCTR4.UINT16[R_IO_L])
#define RSCAN0CFPCTR4LL (RSCAN0.CFPCTR4.UINT8[R_IO_LL])
#define RSCAN0CFPCTR4LH (RSCAN0.CFPCTR4.UINT8[R_IO_LH])
#define RSCAN0CFPCTR4H (RSCAN0.CFPCTR4.UINT16[R_IO_H])
#define RSCAN0CFPCTR4HL (RSCAN0.CFPCTR4.UINT8[R_IO_HL])
#define RSCAN0CFPCTR4HH (RSCAN0.CFPCTR4.UINT8[R_IO_HH])
#define RSCAN0CFPCTR5 (RSCAN0.CFPCTR5.UINT32)
#define RSCAN0CFPCTR5L (RSCAN0.CFPCTR5.UINT16[R_IO_L])
#define RSCAN0CFPCTR5LL (RSCAN0.CFPCTR5.UINT8[R_IO_LL])
#define RSCAN0CFPCTR5LH (RSCAN0.CFPCTR5.UINT8[R_IO_LH])
#define RSCAN0CFPCTR5H (RSCAN0.CFPCTR5.UINT16[R_IO_H])
#define RSCAN0CFPCTR5HL (RSCAN0.CFPCTR5.UINT8[R_IO_HL])
#define RSCAN0CFPCTR5HH (RSCAN0.CFPCTR5.UINT8[R_IO_HH])
#define RSCAN0FESTS (RSCAN0.FESTS.UINT32)
#define RSCAN0FESTSL (RSCAN0.FESTS.UINT16[R_IO_L])
#define RSCAN0FESTSLL (RSCAN0.FESTS.UINT8[R_IO_LL])
#define RSCAN0FESTSLH (RSCAN0.FESTS.UINT8[R_IO_LH])
#define RSCAN0FESTSH (RSCAN0.FESTS.UINT16[R_IO_H])
#define RSCAN0FESTSHL (RSCAN0.FESTS.UINT8[R_IO_HL])
#define RSCAN0FESTSHH (RSCAN0.FESTS.UINT8[R_IO_HH])
#define RSCAN0FFSTS (RSCAN0.FFSTS.UINT32)
#define RSCAN0FFSTSL (RSCAN0.FFSTS.UINT16[R_IO_L])
#define RSCAN0FFSTSLL (RSCAN0.FFSTS.UINT8[R_IO_LL])
#define RSCAN0FFSTSLH (RSCAN0.FFSTS.UINT8[R_IO_LH])
#define RSCAN0FFSTSH (RSCAN0.FFSTS.UINT16[R_IO_H])
#define RSCAN0FFSTSHL (RSCAN0.FFSTS.UINT8[R_IO_HL])
#define RSCAN0FFSTSHH (RSCAN0.FFSTS.UINT8[R_IO_HH])
#define RSCAN0FMSTS (RSCAN0.FMSTS.UINT32)
#define RSCAN0FMSTSL (RSCAN0.FMSTS.UINT16[R_IO_L])
#define RSCAN0FMSTSLL (RSCAN0.FMSTS.UINT8[R_IO_LL])
#define RSCAN0FMSTSLH (RSCAN0.FMSTS.UINT8[R_IO_LH])
#define RSCAN0FMSTSH (RSCAN0.FMSTS.UINT16[R_IO_H])
#define RSCAN0FMSTSHL (RSCAN0.FMSTS.UINT8[R_IO_HL])
#define RSCAN0FMSTSHH (RSCAN0.FMSTS.UINT8[R_IO_HH])
#define RSCAN0RFISTS (RSCAN0.RFISTS.UINT32)
#define RSCAN0RFISTSL (RSCAN0.RFISTS.UINT16[R_IO_L])
#define RSCAN0RFISTSLL (RSCAN0.RFISTS.UINT8[R_IO_LL])
#define RSCAN0RFISTSLH (RSCAN0.RFISTS.UINT8[R_IO_LH])
#define RSCAN0RFISTSH (RSCAN0.RFISTS.UINT16[R_IO_H])
#define RSCAN0RFISTSHL (RSCAN0.RFISTS.UINT8[R_IO_HL])
#define RSCAN0RFISTSHH (RSCAN0.RFISTS.UINT8[R_IO_HH])
#define RSCAN0CFRISTS (RSCAN0.CFRISTS.UINT32)
#define RSCAN0CFRISTSL (RSCAN0.CFRISTS.UINT16[R_IO_L])
#define RSCAN0CFRISTSLL (RSCAN0.CFRISTS.UINT8[R_IO_LL])
#define RSCAN0CFRISTSLH (RSCAN0.CFRISTS.UINT8[R_IO_LH])
#define RSCAN0CFRISTSH (RSCAN0.CFRISTS.UINT16[R_IO_H])
#define RSCAN0CFRISTSHL (RSCAN0.CFRISTS.UINT8[R_IO_HL])
#define RSCAN0CFRISTSHH (RSCAN0.CFRISTS.UINT8[R_IO_HH])
#define RSCAN0CFTISTS (RSCAN0.CFTISTS.UINT32)
#define RSCAN0CFTISTSL (RSCAN0.CFTISTS.UINT16[R_IO_L])
#define RSCAN0CFTISTSLL (RSCAN0.CFTISTS.UINT8[R_IO_LL])
#define RSCAN0CFTISTSLH (RSCAN0.CFTISTS.UINT8[R_IO_LH])
#define RSCAN0CFTISTSH (RSCAN0.CFTISTS.UINT16[R_IO_H])
#define RSCAN0CFTISTSHL (RSCAN0.CFTISTS.UINT8[R_IO_HL])
#define RSCAN0CFTISTSHH (RSCAN0.CFTISTS.UINT8[R_IO_HH])
#define RSCAN0TMC0 (RSCAN0.TMC0)
#define RSCAN0TMC1 (RSCAN0.TMC1)
#define RSCAN0TMC2 (RSCAN0.TMC2)
#define RSCAN0TMC3 (RSCAN0.TMC3)
#define RSCAN0TMC4 (RSCAN0.TMC4)
#define RSCAN0TMC5 (RSCAN0.TMC5)
#define RSCAN0TMC6 (RSCAN0.TMC6)
#define RSCAN0TMC7 (RSCAN0.TMC7)
#define RSCAN0TMC8 (RSCAN0.TMC8)
#define RSCAN0TMC9 (RSCAN0.TMC9)
#define RSCAN0TMC10 (RSCAN0.TMC10)
#define RSCAN0TMC11 (RSCAN0.TMC11)
#define RSCAN0TMC12 (RSCAN0.TMC12)
#define RSCAN0TMC13 (RSCAN0.TMC13)
#define RSCAN0TMC14 (RSCAN0.TMC14)
#define RSCAN0TMC15 (RSCAN0.TMC15)
#define RSCAN0TMC16 (RSCAN0.TMC16)
#define RSCAN0TMC17 (RSCAN0.TMC17)
#define RSCAN0TMC18 (RSCAN0.TMC18)
#define RSCAN0TMC19 (RSCAN0.TMC19)
#define RSCAN0TMC20 (RSCAN0.TMC20)
#define RSCAN0TMC21 (RSCAN0.TMC21)
#define RSCAN0TMC22 (RSCAN0.TMC22)
#define RSCAN0TMC23 (RSCAN0.TMC23)
#define RSCAN0TMC24 (RSCAN0.TMC24)
#define RSCAN0TMC25 (RSCAN0.TMC25)
#define RSCAN0TMC26 (RSCAN0.TMC26)
#define RSCAN0TMC27 (RSCAN0.TMC27)
#define RSCAN0TMC28 (RSCAN0.TMC28)
#define RSCAN0TMC29 (RSCAN0.TMC29)
#define RSCAN0TMC30 (RSCAN0.TMC30)
#define RSCAN0TMC31 (RSCAN0.TMC31)
#define RSCAN0TMSTS0 (RSCAN0.TMSTS0)
#define RSCAN0TMSTS1 (RSCAN0.TMSTS1)
#define RSCAN0TMSTS2 (RSCAN0.TMSTS2)
#define RSCAN0TMSTS3 (RSCAN0.TMSTS3)
#define RSCAN0TMSTS4 (RSCAN0.TMSTS4)
#define RSCAN0TMSTS5 (RSCAN0.TMSTS5)
#define RSCAN0TMSTS6 (RSCAN0.TMSTS6)
#define RSCAN0TMSTS7 (RSCAN0.TMSTS7)
#define RSCAN0TMSTS8 (RSCAN0.TMSTS8)
#define RSCAN0TMSTS9 (RSCAN0.TMSTS9)
#define RSCAN0TMSTS10 (RSCAN0.TMSTS10)
#define RSCAN0TMSTS11 (RSCAN0.TMSTS11)
#define RSCAN0TMSTS12 (RSCAN0.TMSTS12)
#define RSCAN0TMSTS13 (RSCAN0.TMSTS13)
#define RSCAN0TMSTS14 (RSCAN0.TMSTS14)
#define RSCAN0TMSTS15 (RSCAN0.TMSTS15)
#define RSCAN0TMSTS16 (RSCAN0.TMSTS16)
#define RSCAN0TMSTS17 (RSCAN0.TMSTS17)
#define RSCAN0TMSTS18 (RSCAN0.TMSTS18)
#define RSCAN0TMSTS19 (RSCAN0.TMSTS19)
#define RSCAN0TMSTS20 (RSCAN0.TMSTS20)
#define RSCAN0TMSTS21 (RSCAN0.TMSTS21)
#define RSCAN0TMSTS22 (RSCAN0.TMSTS22)
#define RSCAN0TMSTS23 (RSCAN0.TMSTS23)
#define RSCAN0TMSTS24 (RSCAN0.TMSTS24)
#define RSCAN0TMSTS25 (RSCAN0.TMSTS25)
#define RSCAN0TMSTS26 (RSCAN0.TMSTS26)
#define RSCAN0TMSTS27 (RSCAN0.TMSTS27)
#define RSCAN0TMSTS28 (RSCAN0.TMSTS28)
#define RSCAN0TMSTS29 (RSCAN0.TMSTS29)
#define RSCAN0TMSTS30 (RSCAN0.TMSTS30)
#define RSCAN0TMSTS31 (RSCAN0.TMSTS31)
#define RSCAN0TMTRSTS0 (RSCAN0.TMTRSTS0.UINT32)
#define RSCAN0TMTRSTS0L (RSCAN0.TMTRSTS0.UINT16[R_IO_L])
#define RSCAN0TMTRSTS0LL (RSCAN0.TMTRSTS0.UINT8[R_IO_LL])
#define RSCAN0TMTRSTS0LH (RSCAN0.TMTRSTS0.UINT8[R_IO_LH])
#define RSCAN0TMTRSTS0H (RSCAN0.TMTRSTS0.UINT16[R_IO_H])
#define RSCAN0TMTRSTS0HL (RSCAN0.TMTRSTS0.UINT8[R_IO_HL])
#define RSCAN0TMTRSTS0HH (RSCAN0.TMTRSTS0.UINT8[R_IO_HH])
#define RSCAN0TMTARSTS0 (RSCAN0.TMTARSTS0.UINT32)
#define RSCAN0TMTARSTS0L (RSCAN0.TMTARSTS0.UINT16[R_IO_L])
#define RSCAN0TMTARSTS0LL (RSCAN0.TMTARSTS0.UINT8[R_IO_LL])
#define RSCAN0TMTARSTS0LH (RSCAN0.TMTARSTS0.UINT8[R_IO_LH])
#define RSCAN0TMTARSTS0H (RSCAN0.TMTARSTS0.UINT16[R_IO_H])
#define RSCAN0TMTARSTS0HL (RSCAN0.TMTARSTS0.UINT8[R_IO_HL])
#define RSCAN0TMTARSTS0HH (RSCAN0.TMTARSTS0.UINT8[R_IO_HH])
#define RSCAN0TMTCSTS0 (RSCAN0.TMTCSTS0.UINT32)
#define RSCAN0TMTCSTS0L (RSCAN0.TMTCSTS0.UINT16[R_IO_L])
#define RSCAN0TMTCSTS0LL (RSCAN0.TMTCSTS0.UINT8[R_IO_LL])
#define RSCAN0TMTCSTS0LH (RSCAN0.TMTCSTS0.UINT8[R_IO_LH])
#define RSCAN0TMTCSTS0H (RSCAN0.TMTCSTS0.UINT16[R_IO_H])
#define RSCAN0TMTCSTS0HL (RSCAN0.TMTCSTS0.UINT8[R_IO_HL])
#define RSCAN0TMTCSTS0HH (RSCAN0.TMTCSTS0.UINT8[R_IO_HH])
#define RSCAN0TMTASTS0 (RSCAN0.TMTASTS0.UINT32)
#define RSCAN0TMTASTS0L (RSCAN0.TMTASTS0.UINT16[R_IO_L])
#define RSCAN0TMTASTS0LL (RSCAN0.TMTASTS0.UINT8[R_IO_LL])
#define RSCAN0TMTASTS0LH (RSCAN0.TMTASTS0.UINT8[R_IO_LH])
#define RSCAN0TMTASTS0H (RSCAN0.TMTASTS0.UINT16[R_IO_H])
#define RSCAN0TMTASTS0HL (RSCAN0.TMTASTS0.UINT8[R_IO_HL])
#define RSCAN0TMTASTS0HH (RSCAN0.TMTASTS0.UINT8[R_IO_HH])
#define RSCAN0TMIEC0 (RSCAN0.TMIEC0.UINT32)
#define RSCAN0TMIEC0L (RSCAN0.TMIEC0.UINT16[R_IO_L])
#define RSCAN0TMIEC0LL (RSCAN0.TMIEC0.UINT8[R_IO_LL])
#define RSCAN0TMIEC0LH (RSCAN0.TMIEC0.UINT8[R_IO_LH])
#define RSCAN0TMIEC0H (RSCAN0.TMIEC0.UINT16[R_IO_H])
#define RSCAN0TMIEC0HL (RSCAN0.TMIEC0.UINT8[R_IO_HL])
#define RSCAN0TMIEC0HH (RSCAN0.TMIEC0.UINT8[R_IO_HH])
#define RSCAN0TXQCC0 (RSCAN0.TXQCC0.UINT32)
#define RSCAN0TXQCC0L (RSCAN0.TXQCC0.UINT16[R_IO_L])
#define RSCAN0TXQCC0LL (RSCAN0.TXQCC0.UINT8[R_IO_LL])
#define RSCAN0TXQCC0LH (RSCAN0.TXQCC0.UINT8[R_IO_LH])
#define RSCAN0TXQCC0H (RSCAN0.TXQCC0.UINT16[R_IO_H])
#define RSCAN0TXQCC0HL (RSCAN0.TXQCC0.UINT8[R_IO_HL])
#define RSCAN0TXQCC0HH (RSCAN0.TXQCC0.UINT8[R_IO_HH])
#define RSCAN0TXQCC1 (RSCAN0.TXQCC1.UINT32)
#define RSCAN0TXQCC1L (RSCAN0.TXQCC1.UINT16[R_IO_L])
#define RSCAN0TXQCC1LL (RSCAN0.TXQCC1.UINT8[R_IO_LL])
#define RSCAN0TXQCC1LH (RSCAN0.TXQCC1.UINT8[R_IO_LH])
#define RSCAN0TXQCC1H (RSCAN0.TXQCC1.UINT16[R_IO_H])
#define RSCAN0TXQCC1HL (RSCAN0.TXQCC1.UINT8[R_IO_HL])
#define RSCAN0TXQCC1HH (RSCAN0.TXQCC1.UINT8[R_IO_HH])
#define RSCAN0TXQSTS0 (RSCAN0.TXQSTS0.UINT32)
#define RSCAN0TXQSTS0L (RSCAN0.TXQSTS0.UINT16[R_IO_L])
#define RSCAN0TXQSTS0LL (RSCAN0.TXQSTS0.UINT8[R_IO_LL])
#define RSCAN0TXQSTS0LH (RSCAN0.TXQSTS0.UINT8[R_IO_LH])
#define RSCAN0TXQSTS0H (RSCAN0.TXQSTS0.UINT16[R_IO_H])
#define RSCAN0TXQSTS0HL (RSCAN0.TXQSTS0.UINT8[R_IO_HL])
#define RSCAN0TXQSTS0HH (RSCAN0.TXQSTS0.UINT8[R_IO_HH])
#define RSCAN0TXQSTS1 (RSCAN0.TXQSTS1.UINT32)
#define RSCAN0TXQSTS1L (RSCAN0.TXQSTS1.UINT16[R_IO_L])
#define RSCAN0TXQSTS1LL (RSCAN0.TXQSTS1.UINT8[R_IO_LL])
#define RSCAN0TXQSTS1LH (RSCAN0.TXQSTS1.UINT8[R_IO_LH])
#define RSCAN0TXQSTS1H (RSCAN0.TXQSTS1.UINT16[R_IO_H])
#define RSCAN0TXQSTS1HL (RSCAN0.TXQSTS1.UINT8[R_IO_HL])
#define RSCAN0TXQSTS1HH (RSCAN0.TXQSTS1.UINT8[R_IO_HH])
#define RSCAN0TXQPCTR0 (RSCAN0.TXQPCTR0.UINT32)
#define RSCAN0TXQPCTR0L (RSCAN0.TXQPCTR0.UINT16[R_IO_L])
#define RSCAN0TXQPCTR0LL (RSCAN0.TXQPCTR0.UINT8[R_IO_LL])
#define RSCAN0TXQPCTR0LH (RSCAN0.TXQPCTR0.UINT8[R_IO_LH])
#define RSCAN0TXQPCTR0H (RSCAN0.TXQPCTR0.UINT16[R_IO_H])
#define RSCAN0TXQPCTR0HL (RSCAN0.TXQPCTR0.UINT8[R_IO_HL])
#define RSCAN0TXQPCTR0HH (RSCAN0.TXQPCTR0.UINT8[R_IO_HH])
#define RSCAN0TXQPCTR1 (RSCAN0.TXQPCTR1.UINT32)
#define RSCAN0TXQPCTR1L (RSCAN0.TXQPCTR1.UINT16[R_IO_L])
#define RSCAN0TXQPCTR1LL (RSCAN0.TXQPCTR1.UINT8[R_IO_LL])
#define RSCAN0TXQPCTR1LH (RSCAN0.TXQPCTR1.UINT8[R_IO_LH])
#define RSCAN0TXQPCTR1H (RSCAN0.TXQPCTR1.UINT16[R_IO_H])
#define RSCAN0TXQPCTR1HL (RSCAN0.TXQPCTR1.UINT8[R_IO_HL])
#define RSCAN0TXQPCTR1HH (RSCAN0.TXQPCTR1.UINT8[R_IO_HH])
#define RSCAN0THLCC0 (RSCAN0.THLCC0.UINT32)
#define RSCAN0THLCC0L (RSCAN0.THLCC0.UINT16[R_IO_L])
#define RSCAN0THLCC0LL (RSCAN0.THLCC0.UINT8[R_IO_LL])
#define RSCAN0THLCC0LH (RSCAN0.THLCC0.UINT8[R_IO_LH])
#define RSCAN0THLCC0H (RSCAN0.THLCC0.UINT16[R_IO_H])
#define RSCAN0THLCC0HL (RSCAN0.THLCC0.UINT8[R_IO_HL])
#define RSCAN0THLCC0HH (RSCAN0.THLCC0.UINT8[R_IO_HH])
#define RSCAN0THLCC1 (RSCAN0.THLCC1.UINT32)
#define RSCAN0THLCC1L (RSCAN0.THLCC1.UINT16[R_IO_L])
#define RSCAN0THLCC1LL (RSCAN0.THLCC1.UINT8[R_IO_LL])
#define RSCAN0THLCC1LH (RSCAN0.THLCC1.UINT8[R_IO_LH])
#define RSCAN0THLCC1H (RSCAN0.THLCC1.UINT16[R_IO_H])
#define RSCAN0THLCC1HL (RSCAN0.THLCC1.UINT8[R_IO_HL])
#define RSCAN0THLCC1HH (RSCAN0.THLCC1.UINT8[R_IO_HH])
#define RSCAN0THLSTS0 (RSCAN0.THLSTS0.UINT32)
#define RSCAN0THLSTS0L (RSCAN0.THLSTS0.UINT16[R_IO_L])
#define RSCAN0THLSTS0LL (RSCAN0.THLSTS0.UINT8[R_IO_LL])
#define RSCAN0THLSTS0LH (RSCAN0.THLSTS0.UINT8[R_IO_LH])
#define RSCAN0THLSTS0H (RSCAN0.THLSTS0.UINT16[R_IO_H])
#define RSCAN0THLSTS0HL (RSCAN0.THLSTS0.UINT8[R_IO_HL])
#define RSCAN0THLSTS0HH (RSCAN0.THLSTS0.UINT8[R_IO_HH])
#define RSCAN0THLSTS1 (RSCAN0.THLSTS1.UINT32)
#define RSCAN0THLSTS1L (RSCAN0.THLSTS1.UINT16[R_IO_L])
#define RSCAN0THLSTS1LL (RSCAN0.THLSTS1.UINT8[R_IO_LL])
#define RSCAN0THLSTS1LH (RSCAN0.THLSTS1.UINT8[R_IO_LH])
#define RSCAN0THLSTS1H (RSCAN0.THLSTS1.UINT16[R_IO_H])
#define RSCAN0THLSTS1HL (RSCAN0.THLSTS1.UINT8[R_IO_HL])
#define RSCAN0THLSTS1HH (RSCAN0.THLSTS1.UINT8[R_IO_HH])
#define RSCAN0THLPCTR0 (RSCAN0.THLPCTR0.UINT32)
#define RSCAN0THLPCTR0L (RSCAN0.THLPCTR0.UINT16[R_IO_L])
#define RSCAN0THLPCTR0LL (RSCAN0.THLPCTR0.UINT8[R_IO_LL])
#define RSCAN0THLPCTR0LH (RSCAN0.THLPCTR0.UINT8[R_IO_LH])
#define RSCAN0THLPCTR0H (RSCAN0.THLPCTR0.UINT16[R_IO_H])
#define RSCAN0THLPCTR0HL (RSCAN0.THLPCTR0.UINT8[R_IO_HL])
#define RSCAN0THLPCTR0HH (RSCAN0.THLPCTR0.UINT8[R_IO_HH])
#define RSCAN0THLPCTR1 (RSCAN0.THLPCTR1.UINT32)
#define RSCAN0THLPCTR1L (RSCAN0.THLPCTR1.UINT16[R_IO_L])
#define RSCAN0THLPCTR1LL (RSCAN0.THLPCTR1.UINT8[R_IO_LL])
#define RSCAN0THLPCTR1LH (RSCAN0.THLPCTR1.UINT8[R_IO_LH])
#define RSCAN0THLPCTR1H (RSCAN0.THLPCTR1.UINT16[R_IO_H])
#define RSCAN0THLPCTR1HL (RSCAN0.THLPCTR1.UINT8[R_IO_HL])
#define RSCAN0THLPCTR1HH (RSCAN0.THLPCTR1.UINT8[R_IO_HH])
#define RSCAN0GTINTSTS0 (RSCAN0.GTINTSTS0.UINT32)
#define RSCAN0GTINTSTS0L (RSCAN0.GTINTSTS0.UINT16[R_IO_L])
#define RSCAN0GTINTSTS0LL (RSCAN0.GTINTSTS0.UINT8[R_IO_LL])
#define RSCAN0GTINTSTS0LH (RSCAN0.GTINTSTS0.UINT8[R_IO_LH])
#define RSCAN0GTINTSTS0H (RSCAN0.GTINTSTS0.UINT16[R_IO_H])
#define RSCAN0GTINTSTS0HL (RSCAN0.GTINTSTS0.UINT8[R_IO_HL])
#define RSCAN0GTINTSTS0HH (RSCAN0.GTINTSTS0.UINT8[R_IO_HH])
#define RSCAN0GTSTCFG (RSCAN0.GTSTCFG.UINT32)
#define RSCAN0GTSTCFGL (RSCAN0.GTSTCFG.UINT16[R_IO_L])
#define RSCAN0GTSTCFGLL (RSCAN0.GTSTCFG.UINT8[R_IO_LL])
#define RSCAN0GTSTCFGLH (RSCAN0.GTSTCFG.UINT8[R_IO_LH])
#define RSCAN0GTSTCFGH (RSCAN0.GTSTCFG.UINT16[R_IO_H])
#define RSCAN0GTSTCFGHL (RSCAN0.GTSTCFG.UINT8[R_IO_HL])
#define RSCAN0GTSTCFGHH (RSCAN0.GTSTCFG.UINT8[R_IO_HH])
#define RSCAN0GTSTCTR (RSCAN0.GTSTCTR.UINT32)
#define RSCAN0GTSTCTRL (RSCAN0.GTSTCTR.UINT16[R_IO_L])
#define RSCAN0GTSTCTRLL (RSCAN0.GTSTCTR.UINT8[R_IO_LL])
#define RSCAN0GTSTCTRLH (RSCAN0.GTSTCTR.UINT8[R_IO_LH])
#define RSCAN0GTSTCTRH (RSCAN0.GTSTCTR.UINT16[R_IO_H])
#define RSCAN0GTSTCTRHL (RSCAN0.GTSTCTR.UINT8[R_IO_HL])
#define RSCAN0GTSTCTRHH (RSCAN0.GTSTCTR.UINT8[R_IO_HH])
#define RSCAN0GLOCKK (RSCAN0.GLOCKK.UINT32)
#define RSCAN0GLOCKKL (RSCAN0.GLOCKK.UINT16[R_IO_L])
#define RSCAN0GLOCKKH (RSCAN0.GLOCKK.UINT16[R_IO_H])
#define RSCAN0GAFLID0 (RSCAN0.GAFLID0.UINT32)
#define RSCAN0GAFLID0L (RSCAN0.GAFLID0.UINT16[R_IO_L])
#define RSCAN0GAFLID0LL (RSCAN0.GAFLID0.UINT8[R_IO_LL])
#define RSCAN0GAFLID0LH (RSCAN0.GAFLID0.UINT8[R_IO_LH])
#define RSCAN0GAFLID0H (RSCAN0.GAFLID0.UINT16[R_IO_H])
#define RSCAN0GAFLID0HL (RSCAN0.GAFLID0.UINT8[R_IO_HL])
#define RSCAN0GAFLID0HH (RSCAN0.GAFLID0.UINT8[R_IO_HH])
#define RSCAN0GAFLM0 (RSCAN0.GAFLM0.UINT32)
#define RSCAN0GAFLM0L (RSCAN0.GAFLM0.UINT16[R_IO_L])
#define RSCAN0GAFLM0LL (RSCAN0.GAFLM0.UINT8[R_IO_LL])
#define RSCAN0GAFLM0LH (RSCAN0.GAFLM0.UINT8[R_IO_LH])
#define RSCAN0GAFLM0H (RSCAN0.GAFLM0.UINT16[R_IO_H])
#define RSCAN0GAFLM0HL (RSCAN0.GAFLM0.UINT8[R_IO_HL])
#define RSCAN0GAFLM0HH (RSCAN0.GAFLM0.UINT8[R_IO_HH])
#define RSCAN0GAFLP00 (RSCAN0.GAFLP00.UINT32)
#define RSCAN0GAFLP00L (RSCAN0.GAFLP00.UINT16[R_IO_L])
#define RSCAN0GAFLP00LL (RSCAN0.GAFLP00.UINT8[R_IO_LL])
#define RSCAN0GAFLP00LH (RSCAN0.GAFLP00.UINT8[R_IO_LH])
#define RSCAN0GAFLP00H (RSCAN0.GAFLP00.UINT16[R_IO_H])
#define RSCAN0GAFLP00HL (RSCAN0.GAFLP00.UINT8[R_IO_HL])
#define RSCAN0GAFLP00HH (RSCAN0.GAFLP00.UINT8[R_IO_HH])
#define RSCAN0GAFLP10 (RSCAN0.GAFLP10.UINT32)
#define RSCAN0GAFLP10L (RSCAN0.GAFLP10.UINT16[R_IO_L])
#define RSCAN0GAFLP10LL (RSCAN0.GAFLP10.UINT8[R_IO_LL])
#define RSCAN0GAFLP10LH (RSCAN0.GAFLP10.UINT8[R_IO_LH])
#define RSCAN0GAFLP10H (RSCAN0.GAFLP10.UINT16[R_IO_H])
#define RSCAN0GAFLP10HL (RSCAN0.GAFLP10.UINT8[R_IO_HL])
#define RSCAN0GAFLP10HH (RSCAN0.GAFLP10.UINT8[R_IO_HH])
#define RSCAN0GAFLID1 (RSCAN0.GAFLID1.UINT32)
#define RSCAN0GAFLID1L (RSCAN0.GAFLID1.UINT16[R_IO_L])
#define RSCAN0GAFLID1LL (RSCAN0.GAFLID1.UINT8[R_IO_LL])
#define RSCAN0GAFLID1LH (RSCAN0.GAFLID1.UINT8[R_IO_LH])
#define RSCAN0GAFLID1H (RSCAN0.GAFLID1.UINT16[R_IO_H])
#define RSCAN0GAFLID1HL (RSCAN0.GAFLID1.UINT8[R_IO_HL])
#define RSCAN0GAFLID1HH (RSCAN0.GAFLID1.UINT8[R_IO_HH])
#define RSCAN0GAFLM1 (RSCAN0.GAFLM1.UINT32)
#define RSCAN0GAFLM1L (RSCAN0.GAFLM1.UINT16[R_IO_L])
#define RSCAN0GAFLM1LL (RSCAN0.GAFLM1.UINT8[R_IO_LL])
#define RSCAN0GAFLM1LH (RSCAN0.GAFLM1.UINT8[R_IO_LH])
#define RSCAN0GAFLM1H (RSCAN0.GAFLM1.UINT16[R_IO_H])
#define RSCAN0GAFLM1HL (RSCAN0.GAFLM1.UINT8[R_IO_HL])
#define RSCAN0GAFLM1HH (RSCAN0.GAFLM1.UINT8[R_IO_HH])
#define RSCAN0GAFLP01 (RSCAN0.GAFLP01.UINT32)
#define RSCAN0GAFLP01L (RSCAN0.GAFLP01.UINT16[R_IO_L])
#define RSCAN0GAFLP01LL (RSCAN0.GAFLP01.UINT8[R_IO_LL])
#define RSCAN0GAFLP01LH (RSCAN0.GAFLP01.UINT8[R_IO_LH])
#define RSCAN0GAFLP01H (RSCAN0.GAFLP01.UINT16[R_IO_H])
#define RSCAN0GAFLP01HL (RSCAN0.GAFLP01.UINT8[R_IO_HL])
#define RSCAN0GAFLP01HH (RSCAN0.GAFLP01.UINT8[R_IO_HH])
#define RSCAN0GAFLP11 (RSCAN0.GAFLP11.UINT32)
#define RSCAN0GAFLP11L (RSCAN0.GAFLP11.UINT16[R_IO_L])
#define RSCAN0GAFLP11LL (RSCAN0.GAFLP11.UINT8[R_IO_LL])
#define RSCAN0GAFLP11LH (RSCAN0.GAFLP11.UINT8[R_IO_LH])
#define RSCAN0GAFLP11H (RSCAN0.GAFLP11.UINT16[R_IO_H])
#define RSCAN0GAFLP11HL (RSCAN0.GAFLP11.UINT8[R_IO_HL])
#define RSCAN0GAFLP11HH (RSCAN0.GAFLP11.UINT8[R_IO_HH])
#define RSCAN0GAFLID2 (RSCAN0.GAFLID2.UINT32)
#define RSCAN0GAFLID2L (RSCAN0.GAFLID2.UINT16[R_IO_L])
#define RSCAN0GAFLID2LL (RSCAN0.GAFLID2.UINT8[R_IO_LL])
#define RSCAN0GAFLID2LH (RSCAN0.GAFLID2.UINT8[R_IO_LH])
#define RSCAN0GAFLID2H (RSCAN0.GAFLID2.UINT16[R_IO_H])
#define RSCAN0GAFLID2HL (RSCAN0.GAFLID2.UINT8[R_IO_HL])
#define RSCAN0GAFLID2HH (RSCAN0.GAFLID2.UINT8[R_IO_HH])
#define RSCAN0GAFLM2 (RSCAN0.GAFLM2.UINT32)
#define RSCAN0GAFLM2L (RSCAN0.GAFLM2.UINT16[R_IO_L])
#define RSCAN0GAFLM2LL (RSCAN0.GAFLM2.UINT8[R_IO_LL])
#define RSCAN0GAFLM2LH (RSCAN0.GAFLM2.UINT8[R_IO_LH])
#define RSCAN0GAFLM2H (RSCAN0.GAFLM2.UINT16[R_IO_H])
#define RSCAN0GAFLM2HL (RSCAN0.GAFLM2.UINT8[R_IO_HL])
#define RSCAN0GAFLM2HH (RSCAN0.GAFLM2.UINT8[R_IO_HH])
#define RSCAN0GAFLP02 (RSCAN0.GAFLP02.UINT32)
#define RSCAN0GAFLP02L (RSCAN0.GAFLP02.UINT16[R_IO_L])
#define RSCAN0GAFLP02LL (RSCAN0.GAFLP02.UINT8[R_IO_LL])
#define RSCAN0GAFLP02LH (RSCAN0.GAFLP02.UINT8[R_IO_LH])
#define RSCAN0GAFLP02H (RSCAN0.GAFLP02.UINT16[R_IO_H])
#define RSCAN0GAFLP02HL (RSCAN0.GAFLP02.UINT8[R_IO_HL])
#define RSCAN0GAFLP02HH (RSCAN0.GAFLP02.UINT8[R_IO_HH])
#define RSCAN0GAFLP12 (RSCAN0.GAFLP12.UINT32)
#define RSCAN0GAFLP12L (RSCAN0.GAFLP12.UINT16[R_IO_L])
#define RSCAN0GAFLP12LL (RSCAN0.GAFLP12.UINT8[R_IO_LL])
#define RSCAN0GAFLP12LH (RSCAN0.GAFLP12.UINT8[R_IO_LH])
#define RSCAN0GAFLP12H (RSCAN0.GAFLP12.UINT16[R_IO_H])
#define RSCAN0GAFLP12HL (RSCAN0.GAFLP12.UINT8[R_IO_HL])
#define RSCAN0GAFLP12HH (RSCAN0.GAFLP12.UINT8[R_IO_HH])
#define RSCAN0GAFLID3 (RSCAN0.GAFLID3.UINT32)
#define RSCAN0GAFLID3L (RSCAN0.GAFLID3.UINT16[R_IO_L])
#define RSCAN0GAFLID3LL (RSCAN0.GAFLID3.UINT8[R_IO_LL])
#define RSCAN0GAFLID3LH (RSCAN0.GAFLID3.UINT8[R_IO_LH])
#define RSCAN0GAFLID3H (RSCAN0.GAFLID3.UINT16[R_IO_H])
#define RSCAN0GAFLID3HL (RSCAN0.GAFLID3.UINT8[R_IO_HL])
#define RSCAN0GAFLID3HH (RSCAN0.GAFLID3.UINT8[R_IO_HH])
#define RSCAN0GAFLM3 (RSCAN0.GAFLM3.UINT32)
#define RSCAN0GAFLM3L (RSCAN0.GAFLM3.UINT16[R_IO_L])
#define RSCAN0GAFLM3LL (RSCAN0.GAFLM3.UINT8[R_IO_LL])
#define RSCAN0GAFLM3LH (RSCAN0.GAFLM3.UINT8[R_IO_LH])
#define RSCAN0GAFLM3H (RSCAN0.GAFLM3.UINT16[R_IO_H])
#define RSCAN0GAFLM3HL (RSCAN0.GAFLM3.UINT8[R_IO_HL])
#define RSCAN0GAFLM3HH (RSCAN0.GAFLM3.UINT8[R_IO_HH])
#define RSCAN0GAFLP03 (RSCAN0.GAFLP03.UINT32)
#define RSCAN0GAFLP03L (RSCAN0.GAFLP03.UINT16[R_IO_L])
#define RSCAN0GAFLP03LL (RSCAN0.GAFLP03.UINT8[R_IO_LL])
#define RSCAN0GAFLP03LH (RSCAN0.GAFLP03.UINT8[R_IO_LH])
#define RSCAN0GAFLP03H (RSCAN0.GAFLP03.UINT16[R_IO_H])
#define RSCAN0GAFLP03HL (RSCAN0.GAFLP03.UINT8[R_IO_HL])
#define RSCAN0GAFLP03HH (RSCAN0.GAFLP03.UINT8[R_IO_HH])
#define RSCAN0GAFLP13 (RSCAN0.GAFLP13.UINT32)
#define RSCAN0GAFLP13L (RSCAN0.GAFLP13.UINT16[R_IO_L])
#define RSCAN0GAFLP13LL (RSCAN0.GAFLP13.UINT8[R_IO_LL])
#define RSCAN0GAFLP13LH (RSCAN0.GAFLP13.UINT8[R_IO_LH])
#define RSCAN0GAFLP13H (RSCAN0.GAFLP13.UINT16[R_IO_H])
#define RSCAN0GAFLP13HL (RSCAN0.GAFLP13.UINT8[R_IO_HL])
#define RSCAN0GAFLP13HH (RSCAN0.GAFLP13.UINT8[R_IO_HH])
#define RSCAN0GAFLID4 (RSCAN0.GAFLID4.UINT32)
#define RSCAN0GAFLID4L (RSCAN0.GAFLID4.UINT16[R_IO_L])
#define RSCAN0GAFLID4LL (RSCAN0.GAFLID4.UINT8[R_IO_LL])
#define RSCAN0GAFLID4LH (RSCAN0.GAFLID4.UINT8[R_IO_LH])
#define RSCAN0GAFLID4H (RSCAN0.GAFLID4.UINT16[R_IO_H])
#define RSCAN0GAFLID4HL (RSCAN0.GAFLID4.UINT8[R_IO_HL])
#define RSCAN0GAFLID4HH (RSCAN0.GAFLID4.UINT8[R_IO_HH])
#define RSCAN0GAFLM4 (RSCAN0.GAFLM4.UINT32)
#define RSCAN0GAFLM4L (RSCAN0.GAFLM4.UINT16[R_IO_L])
#define RSCAN0GAFLM4LL (RSCAN0.GAFLM4.UINT8[R_IO_LL])
#define RSCAN0GAFLM4LH (RSCAN0.GAFLM4.UINT8[R_IO_LH])
#define RSCAN0GAFLM4H (RSCAN0.GAFLM4.UINT16[R_IO_H])
#define RSCAN0GAFLM4HL (RSCAN0.GAFLM4.UINT8[R_IO_HL])
#define RSCAN0GAFLM4HH (RSCAN0.GAFLM4.UINT8[R_IO_HH])
#define RSCAN0GAFLP04 (RSCAN0.GAFLP04.UINT32)
#define RSCAN0GAFLP04L (RSCAN0.GAFLP04.UINT16[R_IO_L])
#define RSCAN0GAFLP04LL (RSCAN0.GAFLP04.UINT8[R_IO_LL])
#define RSCAN0GAFLP04LH (RSCAN0.GAFLP04.UINT8[R_IO_LH])
#define RSCAN0GAFLP04H (RSCAN0.GAFLP04.UINT16[R_IO_H])
#define RSCAN0GAFLP04HL (RSCAN0.GAFLP04.UINT8[R_IO_HL])
#define RSCAN0GAFLP04HH (RSCAN0.GAFLP04.UINT8[R_IO_HH])
#define RSCAN0GAFLP14 (RSCAN0.GAFLP14.UINT32)
#define RSCAN0GAFLP14L (RSCAN0.GAFLP14.UINT16[R_IO_L])
#define RSCAN0GAFLP14LL (RSCAN0.GAFLP14.UINT8[R_IO_LL])
#define RSCAN0GAFLP14LH (RSCAN0.GAFLP14.UINT8[R_IO_LH])
#define RSCAN0GAFLP14H (RSCAN0.GAFLP14.UINT16[R_IO_H])
#define RSCAN0GAFLP14HL (RSCAN0.GAFLP14.UINT8[R_IO_HL])
#define RSCAN0GAFLP14HH (RSCAN0.GAFLP14.UINT8[R_IO_HH])
#define RSCAN0GAFLID5 (RSCAN0.GAFLID5.UINT32)
#define RSCAN0GAFLID5L (RSCAN0.GAFLID5.UINT16[R_IO_L])
#define RSCAN0GAFLID5LL (RSCAN0.GAFLID5.UINT8[R_IO_LL])
#define RSCAN0GAFLID5LH (RSCAN0.GAFLID5.UINT8[R_IO_LH])
#define RSCAN0GAFLID5H (RSCAN0.GAFLID5.UINT16[R_IO_H])
#define RSCAN0GAFLID5HL (RSCAN0.GAFLID5.UINT8[R_IO_HL])
#define RSCAN0GAFLID5HH (RSCAN0.GAFLID5.UINT8[R_IO_HH])
#define RSCAN0GAFLM5 (RSCAN0.GAFLM5.UINT32)
#define RSCAN0GAFLM5L (RSCAN0.GAFLM5.UINT16[R_IO_L])
#define RSCAN0GAFLM5LL (RSCAN0.GAFLM5.UINT8[R_IO_LL])
#define RSCAN0GAFLM5LH (RSCAN0.GAFLM5.UINT8[R_IO_LH])
#define RSCAN0GAFLM5H (RSCAN0.GAFLM5.UINT16[R_IO_H])
#define RSCAN0GAFLM5HL (RSCAN0.GAFLM5.UINT8[R_IO_HL])
#define RSCAN0GAFLM5HH (RSCAN0.GAFLM5.UINT8[R_IO_HH])
#define RSCAN0GAFLP05 (RSCAN0.GAFLP05.UINT32)
#define RSCAN0GAFLP05L (RSCAN0.GAFLP05.UINT16[R_IO_L])
#define RSCAN0GAFLP05LL (RSCAN0.GAFLP05.UINT8[R_IO_LL])
#define RSCAN0GAFLP05LH (RSCAN0.GAFLP05.UINT8[R_IO_LH])
#define RSCAN0GAFLP05H (RSCAN0.GAFLP05.UINT16[R_IO_H])
#define RSCAN0GAFLP05HL (RSCAN0.GAFLP05.UINT8[R_IO_HL])
#define RSCAN0GAFLP05HH (RSCAN0.GAFLP05.UINT8[R_IO_HH])
#define RSCAN0GAFLP15 (RSCAN0.GAFLP15.UINT32)
#define RSCAN0GAFLP15L (RSCAN0.GAFLP15.UINT16[R_IO_L])
#define RSCAN0GAFLP15LL (RSCAN0.GAFLP15.UINT8[R_IO_LL])
#define RSCAN0GAFLP15LH (RSCAN0.GAFLP15.UINT8[R_IO_LH])
#define RSCAN0GAFLP15H (RSCAN0.GAFLP15.UINT16[R_IO_H])
#define RSCAN0GAFLP15HL (RSCAN0.GAFLP15.UINT8[R_IO_HL])
#define RSCAN0GAFLP15HH (RSCAN0.GAFLP15.UINT8[R_IO_HH])
#define RSCAN0GAFLID6 (RSCAN0.GAFLID6.UINT32)
#define RSCAN0GAFLID6L (RSCAN0.GAFLID6.UINT16[R_IO_L])
#define RSCAN0GAFLID6LL (RSCAN0.GAFLID6.UINT8[R_IO_LL])
#define RSCAN0GAFLID6LH (RSCAN0.GAFLID6.UINT8[R_IO_LH])
#define RSCAN0GAFLID6H (RSCAN0.GAFLID6.UINT16[R_IO_H])
#define RSCAN0GAFLID6HL (RSCAN0.GAFLID6.UINT8[R_IO_HL])
#define RSCAN0GAFLID6HH (RSCAN0.GAFLID6.UINT8[R_IO_HH])
#define RSCAN0GAFLM6 (RSCAN0.GAFLM6.UINT32)
#define RSCAN0GAFLM6L (RSCAN0.GAFLM6.UINT16[R_IO_L])
#define RSCAN0GAFLM6LL (RSCAN0.GAFLM6.UINT8[R_IO_LL])
#define RSCAN0GAFLM6LH (RSCAN0.GAFLM6.UINT8[R_IO_LH])
#define RSCAN0GAFLM6H (RSCAN0.GAFLM6.UINT16[R_IO_H])
#define RSCAN0GAFLM6HL (RSCAN0.GAFLM6.UINT8[R_IO_HL])
#define RSCAN0GAFLM6HH (RSCAN0.GAFLM6.UINT8[R_IO_HH])
#define RSCAN0GAFLP06 (RSCAN0.GAFLP06.UINT32)
#define RSCAN0GAFLP06L (RSCAN0.GAFLP06.UINT16[R_IO_L])
#define RSCAN0GAFLP06LL (RSCAN0.GAFLP06.UINT8[R_IO_LL])
#define RSCAN0GAFLP06LH (RSCAN0.GAFLP06.UINT8[R_IO_LH])
#define RSCAN0GAFLP06H (RSCAN0.GAFLP06.UINT16[R_IO_H])
#define RSCAN0GAFLP06HL (RSCAN0.GAFLP06.UINT8[R_IO_HL])
#define RSCAN0GAFLP06HH (RSCAN0.GAFLP06.UINT8[R_IO_HH])
#define RSCAN0GAFLP16 (RSCAN0.GAFLP16.UINT32)
#define RSCAN0GAFLP16L (RSCAN0.GAFLP16.UINT16[R_IO_L])
#define RSCAN0GAFLP16LL (RSCAN0.GAFLP16.UINT8[R_IO_LL])
#define RSCAN0GAFLP16LH (RSCAN0.GAFLP16.UINT8[R_IO_LH])
#define RSCAN0GAFLP16H (RSCAN0.GAFLP16.UINT16[R_IO_H])
#define RSCAN0GAFLP16HL (RSCAN0.GAFLP16.UINT8[R_IO_HL])
#define RSCAN0GAFLP16HH (RSCAN0.GAFLP16.UINT8[R_IO_HH])
#define RSCAN0GAFLID7 (RSCAN0.GAFLID7.UINT32)
#define RSCAN0GAFLID7L (RSCAN0.GAFLID7.UINT16[R_IO_L])
#define RSCAN0GAFLID7LL (RSCAN0.GAFLID7.UINT8[R_IO_LL])
#define RSCAN0GAFLID7LH (RSCAN0.GAFLID7.UINT8[R_IO_LH])
#define RSCAN0GAFLID7H (RSCAN0.GAFLID7.UINT16[R_IO_H])
#define RSCAN0GAFLID7HL (RSCAN0.GAFLID7.UINT8[R_IO_HL])
#define RSCAN0GAFLID7HH (RSCAN0.GAFLID7.UINT8[R_IO_HH])
#define RSCAN0GAFLM7 (RSCAN0.GAFLM7.UINT32)
#define RSCAN0GAFLM7L (RSCAN0.GAFLM7.UINT16[R_IO_L])
#define RSCAN0GAFLM7LL (RSCAN0.GAFLM7.UINT8[R_IO_LL])
#define RSCAN0GAFLM7LH (RSCAN0.GAFLM7.UINT8[R_IO_LH])
#define RSCAN0GAFLM7H (RSCAN0.GAFLM7.UINT16[R_IO_H])
#define RSCAN0GAFLM7HL (RSCAN0.GAFLM7.UINT8[R_IO_HL])
#define RSCAN0GAFLM7HH (RSCAN0.GAFLM7.UINT8[R_IO_HH])
#define RSCAN0GAFLP07 (RSCAN0.GAFLP07.UINT32)
#define RSCAN0GAFLP07L (RSCAN0.GAFLP07.UINT16[R_IO_L])
#define RSCAN0GAFLP07LL (RSCAN0.GAFLP07.UINT8[R_IO_LL])
#define RSCAN0GAFLP07LH (RSCAN0.GAFLP07.UINT8[R_IO_LH])
#define RSCAN0GAFLP07H (RSCAN0.GAFLP07.UINT16[R_IO_H])
#define RSCAN0GAFLP07HL (RSCAN0.GAFLP07.UINT8[R_IO_HL])
#define RSCAN0GAFLP07HH (RSCAN0.GAFLP07.UINT8[R_IO_HH])
#define RSCAN0GAFLP17 (RSCAN0.GAFLP17.UINT32)
#define RSCAN0GAFLP17L (RSCAN0.GAFLP17.UINT16[R_IO_L])
#define RSCAN0GAFLP17LL (RSCAN0.GAFLP17.UINT8[R_IO_LL])
#define RSCAN0GAFLP17LH (RSCAN0.GAFLP17.UINT8[R_IO_LH])
#define RSCAN0GAFLP17H (RSCAN0.GAFLP17.UINT16[R_IO_H])
#define RSCAN0GAFLP17HL (RSCAN0.GAFLP17.UINT8[R_IO_HL])
#define RSCAN0GAFLP17HH (RSCAN0.GAFLP17.UINT8[R_IO_HH])
#define RSCAN0GAFLID8 (RSCAN0.GAFLID8.UINT32)
#define RSCAN0GAFLID8L (RSCAN0.GAFLID8.UINT16[R_IO_L])
#define RSCAN0GAFLID8LL (RSCAN0.GAFLID8.UINT8[R_IO_LL])
#define RSCAN0GAFLID8LH (RSCAN0.GAFLID8.UINT8[R_IO_LH])
#define RSCAN0GAFLID8H (RSCAN0.GAFLID8.UINT16[R_IO_H])
#define RSCAN0GAFLID8HL (RSCAN0.GAFLID8.UINT8[R_IO_HL])
#define RSCAN0GAFLID8HH (RSCAN0.GAFLID8.UINT8[R_IO_HH])
#define RSCAN0GAFLM8 (RSCAN0.GAFLM8.UINT32)
#define RSCAN0GAFLM8L (RSCAN0.GAFLM8.UINT16[R_IO_L])
#define RSCAN0GAFLM8LL (RSCAN0.GAFLM8.UINT8[R_IO_LL])
#define RSCAN0GAFLM8LH (RSCAN0.GAFLM8.UINT8[R_IO_LH])
#define RSCAN0GAFLM8H (RSCAN0.GAFLM8.UINT16[R_IO_H])
#define RSCAN0GAFLM8HL (RSCAN0.GAFLM8.UINT8[R_IO_HL])
#define RSCAN0GAFLM8HH (RSCAN0.GAFLM8.UINT8[R_IO_HH])
#define RSCAN0GAFLP08 (RSCAN0.GAFLP08.UINT32)
#define RSCAN0GAFLP08L (RSCAN0.GAFLP08.UINT16[R_IO_L])
#define RSCAN0GAFLP08LL (RSCAN0.GAFLP08.UINT8[R_IO_LL])
#define RSCAN0GAFLP08LH (RSCAN0.GAFLP08.UINT8[R_IO_LH])
#define RSCAN0GAFLP08H (RSCAN0.GAFLP08.UINT16[R_IO_H])
#define RSCAN0GAFLP08HL (RSCAN0.GAFLP08.UINT8[R_IO_HL])
#define RSCAN0GAFLP08HH (RSCAN0.GAFLP08.UINT8[R_IO_HH])
#define RSCAN0GAFLP18 (RSCAN0.GAFLP18.UINT32)
#define RSCAN0GAFLP18L (RSCAN0.GAFLP18.UINT16[R_IO_L])
#define RSCAN0GAFLP18LL (RSCAN0.GAFLP18.UINT8[R_IO_LL])
#define RSCAN0GAFLP18LH (RSCAN0.GAFLP18.UINT8[R_IO_LH])
#define RSCAN0GAFLP18H (RSCAN0.GAFLP18.UINT16[R_IO_H])
#define RSCAN0GAFLP18HL (RSCAN0.GAFLP18.UINT8[R_IO_HL])
#define RSCAN0GAFLP18HH (RSCAN0.GAFLP18.UINT8[R_IO_HH])
#define RSCAN0GAFLID9 (RSCAN0.GAFLID9.UINT32)
#define RSCAN0GAFLID9L (RSCAN0.GAFLID9.UINT16[R_IO_L])
#define RSCAN0GAFLID9LL (RSCAN0.GAFLID9.UINT8[R_IO_LL])
#define RSCAN0GAFLID9LH (RSCAN0.GAFLID9.UINT8[R_IO_LH])
#define RSCAN0GAFLID9H (RSCAN0.GAFLID9.UINT16[R_IO_H])
#define RSCAN0GAFLID9HL (RSCAN0.GAFLID9.UINT8[R_IO_HL])
#define RSCAN0GAFLID9HH (RSCAN0.GAFLID9.UINT8[R_IO_HH])
#define RSCAN0GAFLM9 (RSCAN0.GAFLM9.UINT32)
#define RSCAN0GAFLM9L (RSCAN0.GAFLM9.UINT16[R_IO_L])
#define RSCAN0GAFLM9LL (RSCAN0.GAFLM9.UINT8[R_IO_LL])
#define RSCAN0GAFLM9LH (RSCAN0.GAFLM9.UINT8[R_IO_LH])
#define RSCAN0GAFLM9H (RSCAN0.GAFLM9.UINT16[R_IO_H])
#define RSCAN0GAFLM9HL (RSCAN0.GAFLM9.UINT8[R_IO_HL])
#define RSCAN0GAFLM9HH (RSCAN0.GAFLM9.UINT8[R_IO_HH])
#define RSCAN0GAFLP09 (RSCAN0.GAFLP09.UINT32)
#define RSCAN0GAFLP09L (RSCAN0.GAFLP09.UINT16[R_IO_L])
#define RSCAN0GAFLP09LL (RSCAN0.GAFLP09.UINT8[R_IO_LL])
#define RSCAN0GAFLP09LH (RSCAN0.GAFLP09.UINT8[R_IO_LH])
#define RSCAN0GAFLP09H (RSCAN0.GAFLP09.UINT16[R_IO_H])
#define RSCAN0GAFLP09HL (RSCAN0.GAFLP09.UINT8[R_IO_HL])
#define RSCAN0GAFLP09HH (RSCAN0.GAFLP09.UINT8[R_IO_HH])
#define RSCAN0GAFLP19 (RSCAN0.GAFLP19.UINT32)
#define RSCAN0GAFLP19L (RSCAN0.GAFLP19.UINT16[R_IO_L])
#define RSCAN0GAFLP19LL (RSCAN0.GAFLP19.UINT8[R_IO_LL])
#define RSCAN0GAFLP19LH (RSCAN0.GAFLP19.UINT8[R_IO_LH])
#define RSCAN0GAFLP19H (RSCAN0.GAFLP19.UINT16[R_IO_H])
#define RSCAN0GAFLP19HL (RSCAN0.GAFLP19.UINT8[R_IO_HL])
#define RSCAN0GAFLP19HH (RSCAN0.GAFLP19.UINT8[R_IO_HH])
#define RSCAN0GAFLID10 (RSCAN0.GAFLID10.UINT32)
#define RSCAN0GAFLID10L (RSCAN0.GAFLID10.UINT16[R_IO_L])
#define RSCAN0GAFLID10LL (RSCAN0.GAFLID10.UINT8[R_IO_LL])
#define RSCAN0GAFLID10LH (RSCAN0.GAFLID10.UINT8[R_IO_LH])
#define RSCAN0GAFLID10H (RSCAN0.GAFLID10.UINT16[R_IO_H])
#define RSCAN0GAFLID10HL (RSCAN0.GAFLID10.UINT8[R_IO_HL])
#define RSCAN0GAFLID10HH (RSCAN0.GAFLID10.UINT8[R_IO_HH])
#define RSCAN0GAFLM10 (RSCAN0.GAFLM10.UINT32)
#define RSCAN0GAFLM10L (RSCAN0.GAFLM10.UINT16[R_IO_L])
#define RSCAN0GAFLM10LL (RSCAN0.GAFLM10.UINT8[R_IO_LL])
#define RSCAN0GAFLM10LH (RSCAN0.GAFLM10.UINT8[R_IO_LH])
#define RSCAN0GAFLM10H (RSCAN0.GAFLM10.UINT16[R_IO_H])
#define RSCAN0GAFLM10HL (RSCAN0.GAFLM10.UINT8[R_IO_HL])
#define RSCAN0GAFLM10HH (RSCAN0.GAFLM10.UINT8[R_IO_HH])
#define RSCAN0GAFLP010 (RSCAN0.GAFLP010.UINT32)
#define RSCAN0GAFLP010L (RSCAN0.GAFLP010.UINT16[R_IO_L])
#define RSCAN0GAFLP010LL (RSCAN0.GAFLP010.UINT8[R_IO_LL])
#define RSCAN0GAFLP010LH (RSCAN0.GAFLP010.UINT8[R_IO_LH])
#define RSCAN0GAFLP010H (RSCAN0.GAFLP010.UINT16[R_IO_H])
#define RSCAN0GAFLP010HL (RSCAN0.GAFLP010.UINT8[R_IO_HL])
#define RSCAN0GAFLP010HH (RSCAN0.GAFLP010.UINT8[R_IO_HH])
#define RSCAN0GAFLP110 (RSCAN0.GAFLP110.UINT32)
#define RSCAN0GAFLP110L (RSCAN0.GAFLP110.UINT16[R_IO_L])
#define RSCAN0GAFLP110LL (RSCAN0.GAFLP110.UINT8[R_IO_LL])
#define RSCAN0GAFLP110LH (RSCAN0.GAFLP110.UINT8[R_IO_LH])
#define RSCAN0GAFLP110H (RSCAN0.GAFLP110.UINT16[R_IO_H])
#define RSCAN0GAFLP110HL (RSCAN0.GAFLP110.UINT8[R_IO_HL])
#define RSCAN0GAFLP110HH (RSCAN0.GAFLP110.UINT8[R_IO_HH])
#define RSCAN0GAFLID11 (RSCAN0.GAFLID11.UINT32)
#define RSCAN0GAFLID11L (RSCAN0.GAFLID11.UINT16[R_IO_L])
#define RSCAN0GAFLID11LL (RSCAN0.GAFLID11.UINT8[R_IO_LL])
#define RSCAN0GAFLID11LH (RSCAN0.GAFLID11.UINT8[R_IO_LH])
#define RSCAN0GAFLID11H (RSCAN0.GAFLID11.UINT16[R_IO_H])
#define RSCAN0GAFLID11HL (RSCAN0.GAFLID11.UINT8[R_IO_HL])
#define RSCAN0GAFLID11HH (RSCAN0.GAFLID11.UINT8[R_IO_HH])
#define RSCAN0GAFLM11 (RSCAN0.GAFLM11.UINT32)
#define RSCAN0GAFLM11L (RSCAN0.GAFLM11.UINT16[R_IO_L])
#define RSCAN0GAFLM11LL (RSCAN0.GAFLM11.UINT8[R_IO_LL])
#define RSCAN0GAFLM11LH (RSCAN0.GAFLM11.UINT8[R_IO_LH])
#define RSCAN0GAFLM11H (RSCAN0.GAFLM11.UINT16[R_IO_H])
#define RSCAN0GAFLM11HL (RSCAN0.GAFLM11.UINT8[R_IO_HL])
#define RSCAN0GAFLM11HH (RSCAN0.GAFLM11.UINT8[R_IO_HH])
#define RSCAN0GAFLP011 (RSCAN0.GAFLP011.UINT32)
#define RSCAN0GAFLP011L (RSCAN0.GAFLP011.UINT16[R_IO_L])
#define RSCAN0GAFLP011LL (RSCAN0.GAFLP011.UINT8[R_IO_LL])
#define RSCAN0GAFLP011LH (RSCAN0.GAFLP011.UINT8[R_IO_LH])
#define RSCAN0GAFLP011H (RSCAN0.GAFLP011.UINT16[R_IO_H])
#define RSCAN0GAFLP011HL (RSCAN0.GAFLP011.UINT8[R_IO_HL])
#define RSCAN0GAFLP011HH (RSCAN0.GAFLP011.UINT8[R_IO_HH])
#define RSCAN0GAFLP111 (RSCAN0.GAFLP111.UINT32)
#define RSCAN0GAFLP111L (RSCAN0.GAFLP111.UINT16[R_IO_L])
#define RSCAN0GAFLP111LL (RSCAN0.GAFLP111.UINT8[R_IO_LL])
#define RSCAN0GAFLP111LH (RSCAN0.GAFLP111.UINT8[R_IO_LH])
#define RSCAN0GAFLP111H (RSCAN0.GAFLP111.UINT16[R_IO_H])
#define RSCAN0GAFLP111HL (RSCAN0.GAFLP111.UINT8[R_IO_HL])
#define RSCAN0GAFLP111HH (RSCAN0.GAFLP111.UINT8[R_IO_HH])
#define RSCAN0GAFLID12 (RSCAN0.GAFLID12.UINT32)
#define RSCAN0GAFLID12L (RSCAN0.GAFLID12.UINT16[R_IO_L])
#define RSCAN0GAFLID12LL (RSCAN0.GAFLID12.UINT8[R_IO_LL])
#define RSCAN0GAFLID12LH (RSCAN0.GAFLID12.UINT8[R_IO_LH])
#define RSCAN0GAFLID12H (RSCAN0.GAFLID12.UINT16[R_IO_H])
#define RSCAN0GAFLID12HL (RSCAN0.GAFLID12.UINT8[R_IO_HL])
#define RSCAN0GAFLID12HH (RSCAN0.GAFLID12.UINT8[R_IO_HH])
#define RSCAN0GAFLM12 (RSCAN0.GAFLM12.UINT32)
#define RSCAN0GAFLM12L (RSCAN0.GAFLM12.UINT16[R_IO_L])
#define RSCAN0GAFLM12LL (RSCAN0.GAFLM12.UINT8[R_IO_LL])
#define RSCAN0GAFLM12LH (RSCAN0.GAFLM12.UINT8[R_IO_LH])
#define RSCAN0GAFLM12H (RSCAN0.GAFLM12.UINT16[R_IO_H])
#define RSCAN0GAFLM12HL (RSCAN0.GAFLM12.UINT8[R_IO_HL])
#define RSCAN0GAFLM12HH (RSCAN0.GAFLM12.UINT8[R_IO_HH])
#define RSCAN0GAFLP012 (RSCAN0.GAFLP012.UINT32)
#define RSCAN0GAFLP012L (RSCAN0.GAFLP012.UINT16[R_IO_L])
#define RSCAN0GAFLP012LL (RSCAN0.GAFLP012.UINT8[R_IO_LL])
#define RSCAN0GAFLP012LH (RSCAN0.GAFLP012.UINT8[R_IO_LH])
#define RSCAN0GAFLP012H (RSCAN0.GAFLP012.UINT16[R_IO_H])
#define RSCAN0GAFLP012HL (RSCAN0.GAFLP012.UINT8[R_IO_HL])
#define RSCAN0GAFLP012HH (RSCAN0.GAFLP012.UINT8[R_IO_HH])
#define RSCAN0GAFLP112 (RSCAN0.GAFLP112.UINT32)
#define RSCAN0GAFLP112L (RSCAN0.GAFLP112.UINT16[R_IO_L])
#define RSCAN0GAFLP112LL (RSCAN0.GAFLP112.UINT8[R_IO_LL])
#define RSCAN0GAFLP112LH (RSCAN0.GAFLP112.UINT8[R_IO_LH])
#define RSCAN0GAFLP112H (RSCAN0.GAFLP112.UINT16[R_IO_H])
#define RSCAN0GAFLP112HL (RSCAN0.GAFLP112.UINT8[R_IO_HL])
#define RSCAN0GAFLP112HH (RSCAN0.GAFLP112.UINT8[R_IO_HH])
#define RSCAN0GAFLID13 (RSCAN0.GAFLID13.UINT32)
#define RSCAN0GAFLID13L (RSCAN0.GAFLID13.UINT16[R_IO_L])
#define RSCAN0GAFLID13LL (RSCAN0.GAFLID13.UINT8[R_IO_LL])
#define RSCAN0GAFLID13LH (RSCAN0.GAFLID13.UINT8[R_IO_LH])
#define RSCAN0GAFLID13H (RSCAN0.GAFLID13.UINT16[R_IO_H])
#define RSCAN0GAFLID13HL (RSCAN0.GAFLID13.UINT8[R_IO_HL])
#define RSCAN0GAFLID13HH (RSCAN0.GAFLID13.UINT8[R_IO_HH])
#define RSCAN0GAFLM13 (RSCAN0.GAFLM13.UINT32)
#define RSCAN0GAFLM13L (RSCAN0.GAFLM13.UINT16[R_IO_L])
#define RSCAN0GAFLM13LL (RSCAN0.GAFLM13.UINT8[R_IO_LL])
#define RSCAN0GAFLM13LH (RSCAN0.GAFLM13.UINT8[R_IO_LH])
#define RSCAN0GAFLM13H (RSCAN0.GAFLM13.UINT16[R_IO_H])
#define RSCAN0GAFLM13HL (RSCAN0.GAFLM13.UINT8[R_IO_HL])
#define RSCAN0GAFLM13HH (RSCAN0.GAFLM13.UINT8[R_IO_HH])
#define RSCAN0GAFLP013 (RSCAN0.GAFLP013.UINT32)
#define RSCAN0GAFLP013L (RSCAN0.GAFLP013.UINT16[R_IO_L])
#define RSCAN0GAFLP013LL (RSCAN0.GAFLP013.UINT8[R_IO_LL])
#define RSCAN0GAFLP013LH (RSCAN0.GAFLP013.UINT8[R_IO_LH])
#define RSCAN0GAFLP013H (RSCAN0.GAFLP013.UINT16[R_IO_H])
#define RSCAN0GAFLP013HL (RSCAN0.GAFLP013.UINT8[R_IO_HL])
#define RSCAN0GAFLP013HH (RSCAN0.GAFLP013.UINT8[R_IO_HH])
#define RSCAN0GAFLP113 (RSCAN0.GAFLP113.UINT32)
#define RSCAN0GAFLP113L (RSCAN0.GAFLP113.UINT16[R_IO_L])
#define RSCAN0GAFLP113LL (RSCAN0.GAFLP113.UINT8[R_IO_LL])
#define RSCAN0GAFLP113LH (RSCAN0.GAFLP113.UINT8[R_IO_LH])
#define RSCAN0GAFLP113H (RSCAN0.GAFLP113.UINT16[R_IO_H])
#define RSCAN0GAFLP113HL (RSCAN0.GAFLP113.UINT8[R_IO_HL])
#define RSCAN0GAFLP113HH (RSCAN0.GAFLP113.UINT8[R_IO_HH])
#define RSCAN0GAFLID14 (RSCAN0.GAFLID14.UINT32)
#define RSCAN0GAFLID14L (RSCAN0.GAFLID14.UINT16[R_IO_L])
#define RSCAN0GAFLID14LL (RSCAN0.GAFLID14.UINT8[R_IO_LL])
#define RSCAN0GAFLID14LH (RSCAN0.GAFLID14.UINT8[R_IO_LH])
#define RSCAN0GAFLID14H (RSCAN0.GAFLID14.UINT16[R_IO_H])
#define RSCAN0GAFLID14HL (RSCAN0.GAFLID14.UINT8[R_IO_HL])
#define RSCAN0GAFLID14HH (RSCAN0.GAFLID14.UINT8[R_IO_HH])
#define RSCAN0GAFLM14 (RSCAN0.GAFLM14.UINT32)
#define RSCAN0GAFLM14L (RSCAN0.GAFLM14.UINT16[R_IO_L])
#define RSCAN0GAFLM14LL (RSCAN0.GAFLM14.UINT8[R_IO_LL])
#define RSCAN0GAFLM14LH (RSCAN0.GAFLM14.UINT8[R_IO_LH])
#define RSCAN0GAFLM14H (RSCAN0.GAFLM14.UINT16[R_IO_H])
#define RSCAN0GAFLM14HL (RSCAN0.GAFLM14.UINT8[R_IO_HL])
#define RSCAN0GAFLM14HH (RSCAN0.GAFLM14.UINT8[R_IO_HH])
#define RSCAN0GAFLP014 (RSCAN0.GAFLP014.UINT32)
#define RSCAN0GAFLP014L (RSCAN0.GAFLP014.UINT16[R_IO_L])
#define RSCAN0GAFLP014LL (RSCAN0.GAFLP014.UINT8[R_IO_LL])
#define RSCAN0GAFLP014LH (RSCAN0.GAFLP014.UINT8[R_IO_LH])
#define RSCAN0GAFLP014H (RSCAN0.GAFLP014.UINT16[R_IO_H])
#define RSCAN0GAFLP014HL (RSCAN0.GAFLP014.UINT8[R_IO_HL])
#define RSCAN0GAFLP014HH (RSCAN0.GAFLP014.UINT8[R_IO_HH])
#define RSCAN0GAFLP114 (RSCAN0.GAFLP114.UINT32)
#define RSCAN0GAFLP114L (RSCAN0.GAFLP114.UINT16[R_IO_L])
#define RSCAN0GAFLP114LL (RSCAN0.GAFLP114.UINT8[R_IO_LL])
#define RSCAN0GAFLP114LH (RSCAN0.GAFLP114.UINT8[R_IO_LH])
#define RSCAN0GAFLP114H (RSCAN0.GAFLP114.UINT16[R_IO_H])
#define RSCAN0GAFLP114HL (RSCAN0.GAFLP114.UINT8[R_IO_HL])
#define RSCAN0GAFLP114HH (RSCAN0.GAFLP114.UINT8[R_IO_HH])
#define RSCAN0GAFLID15 (RSCAN0.GAFLID15.UINT32)
#define RSCAN0GAFLID15L (RSCAN0.GAFLID15.UINT16[R_IO_L])
#define RSCAN0GAFLID15LL (RSCAN0.GAFLID15.UINT8[R_IO_LL])
#define RSCAN0GAFLID15LH (RSCAN0.GAFLID15.UINT8[R_IO_LH])
#define RSCAN0GAFLID15H (RSCAN0.GAFLID15.UINT16[R_IO_H])
#define RSCAN0GAFLID15HL (RSCAN0.GAFLID15.UINT8[R_IO_HL])
#define RSCAN0GAFLID15HH (RSCAN0.GAFLID15.UINT8[R_IO_HH])
#define RSCAN0GAFLM15 (RSCAN0.GAFLM15.UINT32)
#define RSCAN0GAFLM15L (RSCAN0.GAFLM15.UINT16[R_IO_L])
#define RSCAN0GAFLM15LL (RSCAN0.GAFLM15.UINT8[R_IO_LL])
#define RSCAN0GAFLM15LH (RSCAN0.GAFLM15.UINT8[R_IO_LH])
#define RSCAN0GAFLM15H (RSCAN0.GAFLM15.UINT16[R_IO_H])
#define RSCAN0GAFLM15HL (RSCAN0.GAFLM15.UINT8[R_IO_HL])
#define RSCAN0GAFLM15HH (RSCAN0.GAFLM15.UINT8[R_IO_HH])
#define RSCAN0GAFLP015 (RSCAN0.GAFLP015.UINT32)
#define RSCAN0GAFLP015L (RSCAN0.GAFLP015.UINT16[R_IO_L])
#define RSCAN0GAFLP015LL (RSCAN0.GAFLP015.UINT8[R_IO_LL])
#define RSCAN0GAFLP015LH (RSCAN0.GAFLP015.UINT8[R_IO_LH])
#define RSCAN0GAFLP015H (RSCAN0.GAFLP015.UINT16[R_IO_H])
#define RSCAN0GAFLP015HL (RSCAN0.GAFLP015.UINT8[R_IO_HL])
#define RSCAN0GAFLP015HH (RSCAN0.GAFLP015.UINT8[R_IO_HH])
#define RSCAN0GAFLP115 (RSCAN0.GAFLP115.UINT32)
#define RSCAN0GAFLP115L (RSCAN0.GAFLP115.UINT16[R_IO_L])
#define RSCAN0GAFLP115LL (RSCAN0.GAFLP115.UINT8[R_IO_LL])
#define RSCAN0GAFLP115LH (RSCAN0.GAFLP115.UINT8[R_IO_LH])
#define RSCAN0GAFLP115H (RSCAN0.GAFLP115.UINT16[R_IO_H])
#define RSCAN0GAFLP115HL (RSCAN0.GAFLP115.UINT8[R_IO_HL])
#define RSCAN0GAFLP115HH (RSCAN0.GAFLP115.UINT8[R_IO_HH])
#define RSCAN0RMID0 (RSCAN0.RMID0.UINT32)
#define RSCAN0RMID0L (RSCAN0.RMID0.UINT16[R_IO_L])
#define RSCAN0RMID0LL (RSCAN0.RMID0.UINT8[R_IO_LL])
#define RSCAN0RMID0LH (RSCAN0.RMID0.UINT8[R_IO_LH])
#define RSCAN0RMID0H (RSCAN0.RMID0.UINT16[R_IO_H])
#define RSCAN0RMID0HL (RSCAN0.RMID0.UINT8[R_IO_HL])
#define RSCAN0RMID0HH (RSCAN0.RMID0.UINT8[R_IO_HH])
#define RSCAN0RMPTR0 (RSCAN0.RMPTR0.UINT32)
#define RSCAN0RMPTR0L (RSCAN0.RMPTR0.UINT16[R_IO_L])
#define RSCAN0RMPTR0LL (RSCAN0.RMPTR0.UINT8[R_IO_LL])
#define RSCAN0RMPTR0LH (RSCAN0.RMPTR0.UINT8[R_IO_LH])
#define RSCAN0RMPTR0H (RSCAN0.RMPTR0.UINT16[R_IO_H])
#define RSCAN0RMPTR0HL (RSCAN0.RMPTR0.UINT8[R_IO_HL])
#define RSCAN0RMPTR0HH (RSCAN0.RMPTR0.UINT8[R_IO_HH])
#define RSCAN0RMDF00 (RSCAN0.RMDF00.UINT32)
#define RSCAN0RMDF00L (RSCAN0.RMDF00.UINT16[R_IO_L])
#define RSCAN0RMDF00LL (RSCAN0.RMDF00.UINT8[R_IO_LL])
#define RSCAN0RMDF00LH (RSCAN0.RMDF00.UINT8[R_IO_LH])
#define RSCAN0RMDF00H (RSCAN0.RMDF00.UINT16[R_IO_H])
#define RSCAN0RMDF00HL (RSCAN0.RMDF00.UINT8[R_IO_HL])
#define RSCAN0RMDF00HH (RSCAN0.RMDF00.UINT8[R_IO_HH])
#define RSCAN0RMDF10 (RSCAN0.RMDF10.UINT32)
#define RSCAN0RMDF10L (RSCAN0.RMDF10.UINT16[R_IO_L])
#define RSCAN0RMDF10LL (RSCAN0.RMDF10.UINT8[R_IO_LL])
#define RSCAN0RMDF10LH (RSCAN0.RMDF10.UINT8[R_IO_LH])
#define RSCAN0RMDF10H (RSCAN0.RMDF10.UINT16[R_IO_H])
#define RSCAN0RMDF10HL (RSCAN0.RMDF10.UINT8[R_IO_HL])
#define RSCAN0RMDF10HH (RSCAN0.RMDF10.UINT8[R_IO_HH])
#define RSCAN0RMID1 (RSCAN0.RMID1.UINT32)
#define RSCAN0RMID1L (RSCAN0.RMID1.UINT16[R_IO_L])
#define RSCAN0RMID1LL (RSCAN0.RMID1.UINT8[R_IO_LL])
#define RSCAN0RMID1LH (RSCAN0.RMID1.UINT8[R_IO_LH])
#define RSCAN0RMID1H (RSCAN0.RMID1.UINT16[R_IO_H])
#define RSCAN0RMID1HL (RSCAN0.RMID1.UINT8[R_IO_HL])
#define RSCAN0RMID1HH (RSCAN0.RMID1.UINT8[R_IO_HH])
#define RSCAN0RMPTR1 (RSCAN0.RMPTR1.UINT32)
#define RSCAN0RMPTR1L (RSCAN0.RMPTR1.UINT16[R_IO_L])
#define RSCAN0RMPTR1LL (RSCAN0.RMPTR1.UINT8[R_IO_LL])
#define RSCAN0RMPTR1LH (RSCAN0.RMPTR1.UINT8[R_IO_LH])
#define RSCAN0RMPTR1H (RSCAN0.RMPTR1.UINT16[R_IO_H])
#define RSCAN0RMPTR1HL (RSCAN0.RMPTR1.UINT8[R_IO_HL])
#define RSCAN0RMPTR1HH (RSCAN0.RMPTR1.UINT8[R_IO_HH])
#define RSCAN0RMDF01 (RSCAN0.RMDF01.UINT32)
#define RSCAN0RMDF01L (RSCAN0.RMDF01.UINT16[R_IO_L])
#define RSCAN0RMDF01LL (RSCAN0.RMDF01.UINT8[R_IO_LL])
#define RSCAN0RMDF01LH (RSCAN0.RMDF01.UINT8[R_IO_LH])
#define RSCAN0RMDF01H (RSCAN0.RMDF01.UINT16[R_IO_H])
#define RSCAN0RMDF01HL (RSCAN0.RMDF01.UINT8[R_IO_HL])
#define RSCAN0RMDF01HH (RSCAN0.RMDF01.UINT8[R_IO_HH])
#define RSCAN0RMDF11 (RSCAN0.RMDF11.UINT32)
#define RSCAN0RMDF11L (RSCAN0.RMDF11.UINT16[R_IO_L])
#define RSCAN0RMDF11LL (RSCAN0.RMDF11.UINT8[R_IO_LL])
#define RSCAN0RMDF11LH (RSCAN0.RMDF11.UINT8[R_IO_LH])
#define RSCAN0RMDF11H (RSCAN0.RMDF11.UINT16[R_IO_H])
#define RSCAN0RMDF11HL (RSCAN0.RMDF11.UINT8[R_IO_HL])
#define RSCAN0RMDF11HH (RSCAN0.RMDF11.UINT8[R_IO_HH])
#define RSCAN0RMID2 (RSCAN0.RMID2.UINT32)
#define RSCAN0RMID2L (RSCAN0.RMID2.UINT16[R_IO_L])
#define RSCAN0RMID2LL (RSCAN0.RMID2.UINT8[R_IO_LL])
#define RSCAN0RMID2LH (RSCAN0.RMID2.UINT8[R_IO_LH])
#define RSCAN0RMID2H (RSCAN0.RMID2.UINT16[R_IO_H])
#define RSCAN0RMID2HL (RSCAN0.RMID2.UINT8[R_IO_HL])
#define RSCAN0RMID2HH (RSCAN0.RMID2.UINT8[R_IO_HH])
#define RSCAN0RMPTR2 (RSCAN0.RMPTR2.UINT32)
#define RSCAN0RMPTR2L (RSCAN0.RMPTR2.UINT16[R_IO_L])
#define RSCAN0RMPTR2LL (RSCAN0.RMPTR2.UINT8[R_IO_LL])
#define RSCAN0RMPTR2LH (RSCAN0.RMPTR2.UINT8[R_IO_LH])
#define RSCAN0RMPTR2H (RSCAN0.RMPTR2.UINT16[R_IO_H])
#define RSCAN0RMPTR2HL (RSCAN0.RMPTR2.UINT8[R_IO_HL])
#define RSCAN0RMPTR2HH (RSCAN0.RMPTR2.UINT8[R_IO_HH])
#define RSCAN0RMDF02 (RSCAN0.RMDF02.UINT32)
#define RSCAN0RMDF02L (RSCAN0.RMDF02.UINT16[R_IO_L])
#define RSCAN0RMDF02LL (RSCAN0.RMDF02.UINT8[R_IO_LL])
#define RSCAN0RMDF02LH (RSCAN0.RMDF02.UINT8[R_IO_LH])
#define RSCAN0RMDF02H (RSCAN0.RMDF02.UINT16[R_IO_H])
#define RSCAN0RMDF02HL (RSCAN0.RMDF02.UINT8[R_IO_HL])
#define RSCAN0RMDF02HH (RSCAN0.RMDF02.UINT8[R_IO_HH])
#define RSCAN0RMDF12 (RSCAN0.RMDF12.UINT32)
#define RSCAN0RMDF12L (RSCAN0.RMDF12.UINT16[R_IO_L])
#define RSCAN0RMDF12LL (RSCAN0.RMDF12.UINT8[R_IO_LL])
#define RSCAN0RMDF12LH (RSCAN0.RMDF12.UINT8[R_IO_LH])
#define RSCAN0RMDF12H (RSCAN0.RMDF12.UINT16[R_IO_H])
#define RSCAN0RMDF12HL (RSCAN0.RMDF12.UINT8[R_IO_HL])
#define RSCAN0RMDF12HH (RSCAN0.RMDF12.UINT8[R_IO_HH])
#define RSCAN0RMID3 (RSCAN0.RMID3.UINT32)
#define RSCAN0RMID3L (RSCAN0.RMID3.UINT16[R_IO_L])
#define RSCAN0RMID3LL (RSCAN0.RMID3.UINT8[R_IO_LL])
#define RSCAN0RMID3LH (RSCAN0.RMID3.UINT8[R_IO_LH])
#define RSCAN0RMID3H (RSCAN0.RMID3.UINT16[R_IO_H])
#define RSCAN0RMID3HL (RSCAN0.RMID3.UINT8[R_IO_HL])
#define RSCAN0RMID3HH (RSCAN0.RMID3.UINT8[R_IO_HH])
#define RSCAN0RMPTR3 (RSCAN0.RMPTR3.UINT32)
#define RSCAN0RMPTR3L (RSCAN0.RMPTR3.UINT16[R_IO_L])
#define RSCAN0RMPTR3LL (RSCAN0.RMPTR3.UINT8[R_IO_LL])
#define RSCAN0RMPTR3LH (RSCAN0.RMPTR3.UINT8[R_IO_LH])
#define RSCAN0RMPTR3H (RSCAN0.RMPTR3.UINT16[R_IO_H])
#define RSCAN0RMPTR3HL (RSCAN0.RMPTR3.UINT8[R_IO_HL])
#define RSCAN0RMPTR3HH (RSCAN0.RMPTR3.UINT8[R_IO_HH])
#define RSCAN0RMDF03 (RSCAN0.RMDF03.UINT32)
#define RSCAN0RMDF03L (RSCAN0.RMDF03.UINT16[R_IO_L])
#define RSCAN0RMDF03LL (RSCAN0.RMDF03.UINT8[R_IO_LL])
#define RSCAN0RMDF03LH (RSCAN0.RMDF03.UINT8[R_IO_LH])
#define RSCAN0RMDF03H (RSCAN0.RMDF03.UINT16[R_IO_H])
#define RSCAN0RMDF03HL (RSCAN0.RMDF03.UINT8[R_IO_HL])
#define RSCAN0RMDF03HH (RSCAN0.RMDF03.UINT8[R_IO_HH])
#define RSCAN0RMDF13 (RSCAN0.RMDF13.UINT32)
#define RSCAN0RMDF13L (RSCAN0.RMDF13.UINT16[R_IO_L])
#define RSCAN0RMDF13LL (RSCAN0.RMDF13.UINT8[R_IO_LL])
#define RSCAN0RMDF13LH (RSCAN0.RMDF13.UINT8[R_IO_LH])
#define RSCAN0RMDF13H (RSCAN0.RMDF13.UINT16[R_IO_H])
#define RSCAN0RMDF13HL (RSCAN0.RMDF13.UINT8[R_IO_HL])
#define RSCAN0RMDF13HH (RSCAN0.RMDF13.UINT8[R_IO_HH])
#define RSCAN0RMID4 (RSCAN0.RMID4.UINT32)
#define RSCAN0RMID4L (RSCAN0.RMID4.UINT16[R_IO_L])
#define RSCAN0RMID4LL (RSCAN0.RMID4.UINT8[R_IO_LL])
#define RSCAN0RMID4LH (RSCAN0.RMID4.UINT8[R_IO_LH])
#define RSCAN0RMID4H (RSCAN0.RMID4.UINT16[R_IO_H])
#define RSCAN0RMID4HL (RSCAN0.RMID4.UINT8[R_IO_HL])
#define RSCAN0RMID4HH (RSCAN0.RMID4.UINT8[R_IO_HH])
#define RSCAN0RMPTR4 (RSCAN0.RMPTR4.UINT32)
#define RSCAN0RMPTR4L (RSCAN0.RMPTR4.UINT16[R_IO_L])
#define RSCAN0RMPTR4LL (RSCAN0.RMPTR4.UINT8[R_IO_LL])
#define RSCAN0RMPTR4LH (RSCAN0.RMPTR4.UINT8[R_IO_LH])
#define RSCAN0RMPTR4H (RSCAN0.RMPTR4.UINT16[R_IO_H])
#define RSCAN0RMPTR4HL (RSCAN0.RMPTR4.UINT8[R_IO_HL])
#define RSCAN0RMPTR4HH (RSCAN0.RMPTR4.UINT8[R_IO_HH])
#define RSCAN0RMDF04 (RSCAN0.RMDF04.UINT32)
#define RSCAN0RMDF04L (RSCAN0.RMDF04.UINT16[R_IO_L])
#define RSCAN0RMDF04LL (RSCAN0.RMDF04.UINT8[R_IO_LL])
#define RSCAN0RMDF04LH (RSCAN0.RMDF04.UINT8[R_IO_LH])
#define RSCAN0RMDF04H (RSCAN0.RMDF04.UINT16[R_IO_H])
#define RSCAN0RMDF04HL (RSCAN0.RMDF04.UINT8[R_IO_HL])
#define RSCAN0RMDF04HH (RSCAN0.RMDF04.UINT8[R_IO_HH])
#define RSCAN0RMDF14 (RSCAN0.RMDF14.UINT32)
#define RSCAN0RMDF14L (RSCAN0.RMDF14.UINT16[R_IO_L])
#define RSCAN0RMDF14LL (RSCAN0.RMDF14.UINT8[R_IO_LL])
#define RSCAN0RMDF14LH (RSCAN0.RMDF14.UINT8[R_IO_LH])
#define RSCAN0RMDF14H (RSCAN0.RMDF14.UINT16[R_IO_H])
#define RSCAN0RMDF14HL (RSCAN0.RMDF14.UINT8[R_IO_HL])
#define RSCAN0RMDF14HH (RSCAN0.RMDF14.UINT8[R_IO_HH])
#define RSCAN0RMID5 (RSCAN0.RMID5.UINT32)
#define RSCAN0RMID5L (RSCAN0.RMID5.UINT16[R_IO_L])
#define RSCAN0RMID5LL (RSCAN0.RMID5.UINT8[R_IO_LL])
#define RSCAN0RMID5LH (RSCAN0.RMID5.UINT8[R_IO_LH])
#define RSCAN0RMID5H (RSCAN0.RMID5.UINT16[R_IO_H])
#define RSCAN0RMID5HL (RSCAN0.RMID5.UINT8[R_IO_HL])
#define RSCAN0RMID5HH (RSCAN0.RMID5.UINT8[R_IO_HH])
#define RSCAN0RMPTR5 (RSCAN0.RMPTR5.UINT32)
#define RSCAN0RMPTR5L (RSCAN0.RMPTR5.UINT16[R_IO_L])
#define RSCAN0RMPTR5LL (RSCAN0.RMPTR5.UINT8[R_IO_LL])
#define RSCAN0RMPTR5LH (RSCAN0.RMPTR5.UINT8[R_IO_LH])
#define RSCAN0RMPTR5H (RSCAN0.RMPTR5.UINT16[R_IO_H])
#define RSCAN0RMPTR5HL (RSCAN0.RMPTR5.UINT8[R_IO_HL])
#define RSCAN0RMPTR5HH (RSCAN0.RMPTR5.UINT8[R_IO_HH])
#define RSCAN0RMDF05 (RSCAN0.RMDF05.UINT32)
#define RSCAN0RMDF05L (RSCAN0.RMDF05.UINT16[R_IO_L])
#define RSCAN0RMDF05LL (RSCAN0.RMDF05.UINT8[R_IO_LL])
#define RSCAN0RMDF05LH (RSCAN0.RMDF05.UINT8[R_IO_LH])
#define RSCAN0RMDF05H (RSCAN0.RMDF05.UINT16[R_IO_H])
#define RSCAN0RMDF05HL (RSCAN0.RMDF05.UINT8[R_IO_HL])
#define RSCAN0RMDF05HH (RSCAN0.RMDF05.UINT8[R_IO_HH])
#define RSCAN0RMDF15 (RSCAN0.RMDF15.UINT32)
#define RSCAN0RMDF15L (RSCAN0.RMDF15.UINT16[R_IO_L])
#define RSCAN0RMDF15LL (RSCAN0.RMDF15.UINT8[R_IO_LL])
#define RSCAN0RMDF15LH (RSCAN0.RMDF15.UINT8[R_IO_LH])
#define RSCAN0RMDF15H (RSCAN0.RMDF15.UINT16[R_IO_H])
#define RSCAN0RMDF15HL (RSCAN0.RMDF15.UINT8[R_IO_HL])
#define RSCAN0RMDF15HH (RSCAN0.RMDF15.UINT8[R_IO_HH])
#define RSCAN0RMID6 (RSCAN0.RMID6.UINT32)
#define RSCAN0RMID6L (RSCAN0.RMID6.UINT16[R_IO_L])
#define RSCAN0RMID6LL (RSCAN0.RMID6.UINT8[R_IO_LL])
#define RSCAN0RMID6LH (RSCAN0.RMID6.UINT8[R_IO_LH])
#define RSCAN0RMID6H (RSCAN0.RMID6.UINT16[R_IO_H])
#define RSCAN0RMID6HL (RSCAN0.RMID6.UINT8[R_IO_HL])
#define RSCAN0RMID6HH (RSCAN0.RMID6.UINT8[R_IO_HH])
#define RSCAN0RMPTR6 (RSCAN0.RMPTR6.UINT32)
#define RSCAN0RMPTR6L (RSCAN0.RMPTR6.UINT16[R_IO_L])
#define RSCAN0RMPTR6LL (RSCAN0.RMPTR6.UINT8[R_IO_LL])
#define RSCAN0RMPTR6LH (RSCAN0.RMPTR6.UINT8[R_IO_LH])
#define RSCAN0RMPTR6H (RSCAN0.RMPTR6.UINT16[R_IO_H])
#define RSCAN0RMPTR6HL (RSCAN0.RMPTR6.UINT8[R_IO_HL])
#define RSCAN0RMPTR6HH (RSCAN0.RMPTR6.UINT8[R_IO_HH])
#define RSCAN0RMDF06 (RSCAN0.RMDF06.UINT32)
#define RSCAN0RMDF06L (RSCAN0.RMDF06.UINT16[R_IO_L])
#define RSCAN0RMDF06LL (RSCAN0.RMDF06.UINT8[R_IO_LL])
#define RSCAN0RMDF06LH (RSCAN0.RMDF06.UINT8[R_IO_LH])
#define RSCAN0RMDF06H (RSCAN0.RMDF06.UINT16[R_IO_H])
#define RSCAN0RMDF06HL (RSCAN0.RMDF06.UINT8[R_IO_HL])
#define RSCAN0RMDF06HH (RSCAN0.RMDF06.UINT8[R_IO_HH])
#define RSCAN0RMDF16 (RSCAN0.RMDF16.UINT32)
#define RSCAN0RMDF16L (RSCAN0.RMDF16.UINT16[R_IO_L])
#define RSCAN0RMDF16LL (RSCAN0.RMDF16.UINT8[R_IO_LL])
#define RSCAN0RMDF16LH (RSCAN0.RMDF16.UINT8[R_IO_LH])
#define RSCAN0RMDF16H (RSCAN0.RMDF16.UINT16[R_IO_H])
#define RSCAN0RMDF16HL (RSCAN0.RMDF16.UINT8[R_IO_HL])
#define RSCAN0RMDF16HH (RSCAN0.RMDF16.UINT8[R_IO_HH])
#define RSCAN0RMID7 (RSCAN0.RMID7.UINT32)
#define RSCAN0RMID7L (RSCAN0.RMID7.UINT16[R_IO_L])
#define RSCAN0RMID7LL (RSCAN0.RMID7.UINT8[R_IO_LL])
#define RSCAN0RMID7LH (RSCAN0.RMID7.UINT8[R_IO_LH])
#define RSCAN0RMID7H (RSCAN0.RMID7.UINT16[R_IO_H])
#define RSCAN0RMID7HL (RSCAN0.RMID7.UINT8[R_IO_HL])
#define RSCAN0RMID7HH (RSCAN0.RMID7.UINT8[R_IO_HH])
#define RSCAN0RMPTR7 (RSCAN0.RMPTR7.UINT32)
#define RSCAN0RMPTR7L (RSCAN0.RMPTR7.UINT16[R_IO_L])
#define RSCAN0RMPTR7LL (RSCAN0.RMPTR7.UINT8[R_IO_LL])
#define RSCAN0RMPTR7LH (RSCAN0.RMPTR7.UINT8[R_IO_LH])
#define RSCAN0RMPTR7H (RSCAN0.RMPTR7.UINT16[R_IO_H])
#define RSCAN0RMPTR7HL (RSCAN0.RMPTR7.UINT8[R_IO_HL])
#define RSCAN0RMPTR7HH (RSCAN0.RMPTR7.UINT8[R_IO_HH])
#define RSCAN0RMDF07 (RSCAN0.RMDF07.UINT32)
#define RSCAN0RMDF07L (RSCAN0.RMDF07.UINT16[R_IO_L])
#define RSCAN0RMDF07LL (RSCAN0.RMDF07.UINT8[R_IO_LL])
#define RSCAN0RMDF07LH (RSCAN0.RMDF07.UINT8[R_IO_LH])
#define RSCAN0RMDF07H (RSCAN0.RMDF07.UINT16[R_IO_H])
#define RSCAN0RMDF07HL (RSCAN0.RMDF07.UINT8[R_IO_HL])
#define RSCAN0RMDF07HH (RSCAN0.RMDF07.UINT8[R_IO_HH])
#define RSCAN0RMDF17 (RSCAN0.RMDF17.UINT32)
#define RSCAN0RMDF17L (RSCAN0.RMDF17.UINT16[R_IO_L])
#define RSCAN0RMDF17LL (RSCAN0.RMDF17.UINT8[R_IO_LL])
#define RSCAN0RMDF17LH (RSCAN0.RMDF17.UINT8[R_IO_LH])
#define RSCAN0RMDF17H (RSCAN0.RMDF17.UINT16[R_IO_H])
#define RSCAN0RMDF17HL (RSCAN0.RMDF17.UINT8[R_IO_HL])
#define RSCAN0RMDF17HH (RSCAN0.RMDF17.UINT8[R_IO_HH])
#define RSCAN0RMID8 (RSCAN0.RMID8.UINT32)
#define RSCAN0RMID8L (RSCAN0.RMID8.UINT16[R_IO_L])
#define RSCAN0RMID8LL (RSCAN0.RMID8.UINT8[R_IO_LL])
#define RSCAN0RMID8LH (RSCAN0.RMID8.UINT8[R_IO_LH])
#define RSCAN0RMID8H (RSCAN0.RMID8.UINT16[R_IO_H])
#define RSCAN0RMID8HL (RSCAN0.RMID8.UINT8[R_IO_HL])
#define RSCAN0RMID8HH (RSCAN0.RMID8.UINT8[R_IO_HH])
#define RSCAN0RMPTR8 (RSCAN0.RMPTR8.UINT32)
#define RSCAN0RMPTR8L (RSCAN0.RMPTR8.UINT16[R_IO_L])
#define RSCAN0RMPTR8LL (RSCAN0.RMPTR8.UINT8[R_IO_LL])
#define RSCAN0RMPTR8LH (RSCAN0.RMPTR8.UINT8[R_IO_LH])
#define RSCAN0RMPTR8H (RSCAN0.RMPTR8.UINT16[R_IO_H])
#define RSCAN0RMPTR8HL (RSCAN0.RMPTR8.UINT8[R_IO_HL])
#define RSCAN0RMPTR8HH (RSCAN0.RMPTR8.UINT8[R_IO_HH])
#define RSCAN0RMDF08 (RSCAN0.RMDF08.UINT32)
#define RSCAN0RMDF08L (RSCAN0.RMDF08.UINT16[R_IO_L])
#define RSCAN0RMDF08LL (RSCAN0.RMDF08.UINT8[R_IO_LL])
#define RSCAN0RMDF08LH (RSCAN0.RMDF08.UINT8[R_IO_LH])
#define RSCAN0RMDF08H (RSCAN0.RMDF08.UINT16[R_IO_H])
#define RSCAN0RMDF08HL (RSCAN0.RMDF08.UINT8[R_IO_HL])
#define RSCAN0RMDF08HH (RSCAN0.RMDF08.UINT8[R_IO_HH])
#define RSCAN0RMDF18 (RSCAN0.RMDF18.UINT32)
#define RSCAN0RMDF18L (RSCAN0.RMDF18.UINT16[R_IO_L])
#define RSCAN0RMDF18LL (RSCAN0.RMDF18.UINT8[R_IO_LL])
#define RSCAN0RMDF18LH (RSCAN0.RMDF18.UINT8[R_IO_LH])
#define RSCAN0RMDF18H (RSCAN0.RMDF18.UINT16[R_IO_H])
#define RSCAN0RMDF18HL (RSCAN0.RMDF18.UINT8[R_IO_HL])
#define RSCAN0RMDF18HH (RSCAN0.RMDF18.UINT8[R_IO_HH])
#define RSCAN0RMID9 (RSCAN0.RMID9.UINT32)
#define RSCAN0RMID9L (RSCAN0.RMID9.UINT16[R_IO_L])
#define RSCAN0RMID9LL (RSCAN0.RMID9.UINT8[R_IO_LL])
#define RSCAN0RMID9LH (RSCAN0.RMID9.UINT8[R_IO_LH])
#define RSCAN0RMID9H (RSCAN0.RMID9.UINT16[R_IO_H])
#define RSCAN0RMID9HL (RSCAN0.RMID9.UINT8[R_IO_HL])
#define RSCAN0RMID9HH (RSCAN0.RMID9.UINT8[R_IO_HH])
#define RSCAN0RMPTR9 (RSCAN0.RMPTR9.UINT32)
#define RSCAN0RMPTR9L (RSCAN0.RMPTR9.UINT16[R_IO_L])
#define RSCAN0RMPTR9LL (RSCAN0.RMPTR9.UINT8[R_IO_LL])
#define RSCAN0RMPTR9LH (RSCAN0.RMPTR9.UINT8[R_IO_LH])
#define RSCAN0RMPTR9H (RSCAN0.RMPTR9.UINT16[R_IO_H])
#define RSCAN0RMPTR9HL (RSCAN0.RMPTR9.UINT8[R_IO_HL])
#define RSCAN0RMPTR9HH (RSCAN0.RMPTR9.UINT8[R_IO_HH])
#define RSCAN0RMDF09 (RSCAN0.RMDF09.UINT32)
#define RSCAN0RMDF09L (RSCAN0.RMDF09.UINT16[R_IO_L])
#define RSCAN0RMDF09LL (RSCAN0.RMDF09.UINT8[R_IO_LL])
#define RSCAN0RMDF09LH (RSCAN0.RMDF09.UINT8[R_IO_LH])
#define RSCAN0RMDF09H (RSCAN0.RMDF09.UINT16[R_IO_H])
#define RSCAN0RMDF09HL (RSCAN0.RMDF09.UINT8[R_IO_HL])
#define RSCAN0RMDF09HH (RSCAN0.RMDF09.UINT8[R_IO_HH])
#define RSCAN0RMDF19 (RSCAN0.RMDF19.UINT32)
#define RSCAN0RMDF19L (RSCAN0.RMDF19.UINT16[R_IO_L])
#define RSCAN0RMDF19LL (RSCAN0.RMDF19.UINT8[R_IO_LL])
#define RSCAN0RMDF19LH (RSCAN0.RMDF19.UINT8[R_IO_LH])
#define RSCAN0RMDF19H (RSCAN0.RMDF19.UINT16[R_IO_H])
#define RSCAN0RMDF19HL (RSCAN0.RMDF19.UINT8[R_IO_HL])
#define RSCAN0RMDF19HH (RSCAN0.RMDF19.UINT8[R_IO_HH])
#define RSCAN0RMID10 (RSCAN0.RMID10.UINT32)
#define RSCAN0RMID10L (RSCAN0.RMID10.UINT16[R_IO_L])
#define RSCAN0RMID10LL (RSCAN0.RMID10.UINT8[R_IO_LL])
#define RSCAN0RMID10LH (RSCAN0.RMID10.UINT8[R_IO_LH])
#define RSCAN0RMID10H (RSCAN0.RMID10.UINT16[R_IO_H])
#define RSCAN0RMID10HL (RSCAN0.RMID10.UINT8[R_IO_HL])
#define RSCAN0RMID10HH (RSCAN0.RMID10.UINT8[R_IO_HH])
#define RSCAN0RMPTR10 (RSCAN0.RMPTR10.UINT32)
#define RSCAN0RMPTR10L (RSCAN0.RMPTR10.UINT16[R_IO_L])
#define RSCAN0RMPTR10LL (RSCAN0.RMPTR10.UINT8[R_IO_LL])
#define RSCAN0RMPTR10LH (RSCAN0.RMPTR10.UINT8[R_IO_LH])
#define RSCAN0RMPTR10H (RSCAN0.RMPTR10.UINT16[R_IO_H])
#define RSCAN0RMPTR10HL (RSCAN0.RMPTR10.UINT8[R_IO_HL])
#define RSCAN0RMPTR10HH (RSCAN0.RMPTR10.UINT8[R_IO_HH])
#define RSCAN0RMDF010 (RSCAN0.RMDF010.UINT32)
#define RSCAN0RMDF010L (RSCAN0.RMDF010.UINT16[R_IO_L])
#define RSCAN0RMDF010LL (RSCAN0.RMDF010.UINT8[R_IO_LL])
#define RSCAN0RMDF010LH (RSCAN0.RMDF010.UINT8[R_IO_LH])
#define RSCAN0RMDF010H (RSCAN0.RMDF010.UINT16[R_IO_H])
#define RSCAN0RMDF010HL (RSCAN0.RMDF010.UINT8[R_IO_HL])
#define RSCAN0RMDF010HH (RSCAN0.RMDF010.UINT8[R_IO_HH])
#define RSCAN0RMDF110 (RSCAN0.RMDF110.UINT32)
#define RSCAN0RMDF110L (RSCAN0.RMDF110.UINT16[R_IO_L])
#define RSCAN0RMDF110LL (RSCAN0.RMDF110.UINT8[R_IO_LL])
#define RSCAN0RMDF110LH (RSCAN0.RMDF110.UINT8[R_IO_LH])
#define RSCAN0RMDF110H (RSCAN0.RMDF110.UINT16[R_IO_H])
#define RSCAN0RMDF110HL (RSCAN0.RMDF110.UINT8[R_IO_HL])
#define RSCAN0RMDF110HH (RSCAN0.RMDF110.UINT8[R_IO_HH])
#define RSCAN0RMID11 (RSCAN0.RMID11.UINT32)
#define RSCAN0RMID11L (RSCAN0.RMID11.UINT16[R_IO_L])
#define RSCAN0RMID11LL (RSCAN0.RMID11.UINT8[R_IO_LL])
#define RSCAN0RMID11LH (RSCAN0.RMID11.UINT8[R_IO_LH])
#define RSCAN0RMID11H (RSCAN0.RMID11.UINT16[R_IO_H])
#define RSCAN0RMID11HL (RSCAN0.RMID11.UINT8[R_IO_HL])
#define RSCAN0RMID11HH (RSCAN0.RMID11.UINT8[R_IO_HH])
#define RSCAN0RMPTR11 (RSCAN0.RMPTR11.UINT32)
#define RSCAN0RMPTR11L (RSCAN0.RMPTR11.UINT16[R_IO_L])
#define RSCAN0RMPTR11LL (RSCAN0.RMPTR11.UINT8[R_IO_LL])
#define RSCAN0RMPTR11LH (RSCAN0.RMPTR11.UINT8[R_IO_LH])
#define RSCAN0RMPTR11H (RSCAN0.RMPTR11.UINT16[R_IO_H])
#define RSCAN0RMPTR11HL (RSCAN0.RMPTR11.UINT8[R_IO_HL])
#define RSCAN0RMPTR11HH (RSCAN0.RMPTR11.UINT8[R_IO_HH])
#define RSCAN0RMDF011 (RSCAN0.RMDF011.UINT32)
#define RSCAN0RMDF011L (RSCAN0.RMDF011.UINT16[R_IO_L])
#define RSCAN0RMDF011LL (RSCAN0.RMDF011.UINT8[R_IO_LL])
#define RSCAN0RMDF011LH (RSCAN0.RMDF011.UINT8[R_IO_LH])
#define RSCAN0RMDF011H (RSCAN0.RMDF011.UINT16[R_IO_H])
#define RSCAN0RMDF011HL (RSCAN0.RMDF011.UINT8[R_IO_HL])
#define RSCAN0RMDF011HH (RSCAN0.RMDF011.UINT8[R_IO_HH])
#define RSCAN0RMDF111 (RSCAN0.RMDF111.UINT32)
#define RSCAN0RMDF111L (RSCAN0.RMDF111.UINT16[R_IO_L])
#define RSCAN0RMDF111LL (RSCAN0.RMDF111.UINT8[R_IO_LL])
#define RSCAN0RMDF111LH (RSCAN0.RMDF111.UINT8[R_IO_LH])
#define RSCAN0RMDF111H (RSCAN0.RMDF111.UINT16[R_IO_H])
#define RSCAN0RMDF111HL (RSCAN0.RMDF111.UINT8[R_IO_HL])
#define RSCAN0RMDF111HH (RSCAN0.RMDF111.UINT8[R_IO_HH])
#define RSCAN0RMID12 (RSCAN0.RMID12.UINT32)
#define RSCAN0RMID12L (RSCAN0.RMID12.UINT16[R_IO_L])
#define RSCAN0RMID12LL (RSCAN0.RMID12.UINT8[R_IO_LL])
#define RSCAN0RMID12LH (RSCAN0.RMID12.UINT8[R_IO_LH])
#define RSCAN0RMID12H (RSCAN0.RMID12.UINT16[R_IO_H])
#define RSCAN0RMID12HL (RSCAN0.RMID12.UINT8[R_IO_HL])
#define RSCAN0RMID12HH (RSCAN0.RMID12.UINT8[R_IO_HH])
#define RSCAN0RMPTR12 (RSCAN0.RMPTR12.UINT32)
#define RSCAN0RMPTR12L (RSCAN0.RMPTR12.UINT16[R_IO_L])
#define RSCAN0RMPTR12LL (RSCAN0.RMPTR12.UINT8[R_IO_LL])
#define RSCAN0RMPTR12LH (RSCAN0.RMPTR12.UINT8[R_IO_LH])
#define RSCAN0RMPTR12H (RSCAN0.RMPTR12.UINT16[R_IO_H])
#define RSCAN0RMPTR12HL (RSCAN0.RMPTR12.UINT8[R_IO_HL])
#define RSCAN0RMPTR12HH (RSCAN0.RMPTR12.UINT8[R_IO_HH])
#define RSCAN0RMDF012 (RSCAN0.RMDF012.UINT32)
#define RSCAN0RMDF012L (RSCAN0.RMDF012.UINT16[R_IO_L])
#define RSCAN0RMDF012LL (RSCAN0.RMDF012.UINT8[R_IO_LL])
#define RSCAN0RMDF012LH (RSCAN0.RMDF012.UINT8[R_IO_LH])
#define RSCAN0RMDF012H (RSCAN0.RMDF012.UINT16[R_IO_H])
#define RSCAN0RMDF012HL (RSCAN0.RMDF012.UINT8[R_IO_HL])
#define RSCAN0RMDF012HH (RSCAN0.RMDF012.UINT8[R_IO_HH])
#define RSCAN0RMDF112 (RSCAN0.RMDF112.UINT32)
#define RSCAN0RMDF112L (RSCAN0.RMDF112.UINT16[R_IO_L])
#define RSCAN0RMDF112LL (RSCAN0.RMDF112.UINT8[R_IO_LL])
#define RSCAN0RMDF112LH (RSCAN0.RMDF112.UINT8[R_IO_LH])
#define RSCAN0RMDF112H (RSCAN0.RMDF112.UINT16[R_IO_H])
#define RSCAN0RMDF112HL (RSCAN0.RMDF112.UINT8[R_IO_HL])
#define RSCAN0RMDF112HH (RSCAN0.RMDF112.UINT8[R_IO_HH])
#define RSCAN0RMID13 (RSCAN0.RMID13.UINT32)
#define RSCAN0RMID13L (RSCAN0.RMID13.UINT16[R_IO_L])
#define RSCAN0RMID13LL (RSCAN0.RMID13.UINT8[R_IO_LL])
#define RSCAN0RMID13LH (RSCAN0.RMID13.UINT8[R_IO_LH])
#define RSCAN0RMID13H (RSCAN0.RMID13.UINT16[R_IO_H])
#define RSCAN0RMID13HL (RSCAN0.RMID13.UINT8[R_IO_HL])
#define RSCAN0RMID13HH (RSCAN0.RMID13.UINT8[R_IO_HH])
#define RSCAN0RMPTR13 (RSCAN0.RMPTR13.UINT32)
#define RSCAN0RMPTR13L (RSCAN0.RMPTR13.UINT16[R_IO_L])
#define RSCAN0RMPTR13LL (RSCAN0.RMPTR13.UINT8[R_IO_LL])
#define RSCAN0RMPTR13LH (RSCAN0.RMPTR13.UINT8[R_IO_LH])
#define RSCAN0RMPTR13H (RSCAN0.RMPTR13.UINT16[R_IO_H])
#define RSCAN0RMPTR13HL (RSCAN0.RMPTR13.UINT8[R_IO_HL])
#define RSCAN0RMPTR13HH (RSCAN0.RMPTR13.UINT8[R_IO_HH])
#define RSCAN0RMDF013 (RSCAN0.RMDF013.UINT32)
#define RSCAN0RMDF013L (RSCAN0.RMDF013.UINT16[R_IO_L])
#define RSCAN0RMDF013LL (RSCAN0.RMDF013.UINT8[R_IO_LL])
#define RSCAN0RMDF013LH (RSCAN0.RMDF013.UINT8[R_IO_LH])
#define RSCAN0RMDF013H (RSCAN0.RMDF013.UINT16[R_IO_H])
#define RSCAN0RMDF013HL (RSCAN0.RMDF013.UINT8[R_IO_HL])
#define RSCAN0RMDF013HH (RSCAN0.RMDF013.UINT8[R_IO_HH])
#define RSCAN0RMDF113 (RSCAN0.RMDF113.UINT32)
#define RSCAN0RMDF113L (RSCAN0.RMDF113.UINT16[R_IO_L])
#define RSCAN0RMDF113LL (RSCAN0.RMDF113.UINT8[R_IO_LL])
#define RSCAN0RMDF113LH (RSCAN0.RMDF113.UINT8[R_IO_LH])
#define RSCAN0RMDF113H (RSCAN0.RMDF113.UINT16[R_IO_H])
#define RSCAN0RMDF113HL (RSCAN0.RMDF113.UINT8[R_IO_HL])
#define RSCAN0RMDF113HH (RSCAN0.RMDF113.UINT8[R_IO_HH])
#define RSCAN0RMID14 (RSCAN0.RMID14.UINT32)
#define RSCAN0RMID14L (RSCAN0.RMID14.UINT16[R_IO_L])
#define RSCAN0RMID14LL (RSCAN0.RMID14.UINT8[R_IO_LL])
#define RSCAN0RMID14LH (RSCAN0.RMID14.UINT8[R_IO_LH])
#define RSCAN0RMID14H (RSCAN0.RMID14.UINT16[R_IO_H])
#define RSCAN0RMID14HL (RSCAN0.RMID14.UINT8[R_IO_HL])
#define RSCAN0RMID14HH (RSCAN0.RMID14.UINT8[R_IO_HH])
#define RSCAN0RMPTR14 (RSCAN0.RMPTR14.UINT32)
#define RSCAN0RMPTR14L (RSCAN0.RMPTR14.UINT16[R_IO_L])
#define RSCAN0RMPTR14LL (RSCAN0.RMPTR14.UINT8[R_IO_LL])
#define RSCAN0RMPTR14LH (RSCAN0.RMPTR14.UINT8[R_IO_LH])
#define RSCAN0RMPTR14H (RSCAN0.RMPTR14.UINT16[R_IO_H])
#define RSCAN0RMPTR14HL (RSCAN0.RMPTR14.UINT8[R_IO_HL])
#define RSCAN0RMPTR14HH (RSCAN0.RMPTR14.UINT8[R_IO_HH])
#define RSCAN0RMDF014 (RSCAN0.RMDF014.UINT32)
#define RSCAN0RMDF014L (RSCAN0.RMDF014.UINT16[R_IO_L])
#define RSCAN0RMDF014LL (RSCAN0.RMDF014.UINT8[R_IO_LL])
#define RSCAN0RMDF014LH (RSCAN0.RMDF014.UINT8[R_IO_LH])
#define RSCAN0RMDF014H (RSCAN0.RMDF014.UINT16[R_IO_H])
#define RSCAN0RMDF014HL (RSCAN0.RMDF014.UINT8[R_IO_HL])
#define RSCAN0RMDF014HH (RSCAN0.RMDF014.UINT8[R_IO_HH])
#define RSCAN0RMDF114 (RSCAN0.RMDF114.UINT32)
#define RSCAN0RMDF114L (RSCAN0.RMDF114.UINT16[R_IO_L])
#define RSCAN0RMDF114LL (RSCAN0.RMDF114.UINT8[R_IO_LL])
#define RSCAN0RMDF114LH (RSCAN0.RMDF114.UINT8[R_IO_LH])
#define RSCAN0RMDF114H (RSCAN0.RMDF114.UINT16[R_IO_H])
#define RSCAN0RMDF114HL (RSCAN0.RMDF114.UINT8[R_IO_HL])
#define RSCAN0RMDF114HH (RSCAN0.RMDF114.UINT8[R_IO_HH])
#define RSCAN0RMID15 (RSCAN0.RMID15.UINT32)
#define RSCAN0RMID15L (RSCAN0.RMID15.UINT16[R_IO_L])
#define RSCAN0RMID15LL (RSCAN0.RMID15.UINT8[R_IO_LL])
#define RSCAN0RMID15LH (RSCAN0.RMID15.UINT8[R_IO_LH])
#define RSCAN0RMID15H (RSCAN0.RMID15.UINT16[R_IO_H])
#define RSCAN0RMID15HL (RSCAN0.RMID15.UINT8[R_IO_HL])
#define RSCAN0RMID15HH (RSCAN0.RMID15.UINT8[R_IO_HH])
#define RSCAN0RMPTR15 (RSCAN0.RMPTR15.UINT32)
#define RSCAN0RMPTR15L (RSCAN0.RMPTR15.UINT16[R_IO_L])
#define RSCAN0RMPTR15LL (RSCAN0.RMPTR15.UINT8[R_IO_LL])
#define RSCAN0RMPTR15LH (RSCAN0.RMPTR15.UINT8[R_IO_LH])
#define RSCAN0RMPTR15H (RSCAN0.RMPTR15.UINT16[R_IO_H])
#define RSCAN0RMPTR15HL (RSCAN0.RMPTR15.UINT8[R_IO_HL])
#define RSCAN0RMPTR15HH (RSCAN0.RMPTR15.UINT8[R_IO_HH])
#define RSCAN0RMDF015 (RSCAN0.RMDF015.UINT32)
#define RSCAN0RMDF015L (RSCAN0.RMDF015.UINT16[R_IO_L])
#define RSCAN0RMDF015LL (RSCAN0.RMDF015.UINT8[R_IO_LL])
#define RSCAN0RMDF015LH (RSCAN0.RMDF015.UINT8[R_IO_LH])
#define RSCAN0RMDF015H (RSCAN0.RMDF015.UINT16[R_IO_H])
#define RSCAN0RMDF015HL (RSCAN0.RMDF015.UINT8[R_IO_HL])
#define RSCAN0RMDF015HH (RSCAN0.RMDF015.UINT8[R_IO_HH])
#define RSCAN0RMDF115 (RSCAN0.RMDF115.UINT32)
#define RSCAN0RMDF115L (RSCAN0.RMDF115.UINT16[R_IO_L])
#define RSCAN0RMDF115LL (RSCAN0.RMDF115.UINT8[R_IO_LL])
#define RSCAN0RMDF115LH (RSCAN0.RMDF115.UINT8[R_IO_LH])
#define RSCAN0RMDF115H (RSCAN0.RMDF115.UINT16[R_IO_H])
#define RSCAN0RMDF115HL (RSCAN0.RMDF115.UINT8[R_IO_HL])
#define RSCAN0RMDF115HH (RSCAN0.RMDF115.UINT8[R_IO_HH])
#define RSCAN0RMID16 (RSCAN0.RMID16.UINT32)
#define RSCAN0RMID16L (RSCAN0.RMID16.UINT16[R_IO_L])
#define RSCAN0RMID16LL (RSCAN0.RMID16.UINT8[R_IO_LL])
#define RSCAN0RMID16LH (RSCAN0.RMID16.UINT8[R_IO_LH])
#define RSCAN0RMID16H (RSCAN0.RMID16.UINT16[R_IO_H])
#define RSCAN0RMID16HL (RSCAN0.RMID16.UINT8[R_IO_HL])
#define RSCAN0RMID16HH (RSCAN0.RMID16.UINT8[R_IO_HH])
#define RSCAN0RMPTR16 (RSCAN0.RMPTR16.UINT32)
#define RSCAN0RMPTR16L (RSCAN0.RMPTR16.UINT16[R_IO_L])
#define RSCAN0RMPTR16LL (RSCAN0.RMPTR16.UINT8[R_IO_LL])
#define RSCAN0RMPTR16LH (RSCAN0.RMPTR16.UINT8[R_IO_LH])
#define RSCAN0RMPTR16H (RSCAN0.RMPTR16.UINT16[R_IO_H])
#define RSCAN0RMPTR16HL (RSCAN0.RMPTR16.UINT8[R_IO_HL])
#define RSCAN0RMPTR16HH (RSCAN0.RMPTR16.UINT8[R_IO_HH])
#define RSCAN0RMDF016 (RSCAN0.RMDF016.UINT32)
#define RSCAN0RMDF016L (RSCAN0.RMDF016.UINT16[R_IO_L])
#define RSCAN0RMDF016LL (RSCAN0.RMDF016.UINT8[R_IO_LL])
#define RSCAN0RMDF016LH (RSCAN0.RMDF016.UINT8[R_IO_LH])
#define RSCAN0RMDF016H (RSCAN0.RMDF016.UINT16[R_IO_H])
#define RSCAN0RMDF016HL (RSCAN0.RMDF016.UINT8[R_IO_HL])
#define RSCAN0RMDF016HH (RSCAN0.RMDF016.UINT8[R_IO_HH])
#define RSCAN0RMDF116 (RSCAN0.RMDF116.UINT32)
#define RSCAN0RMDF116L (RSCAN0.RMDF116.UINT16[R_IO_L])
#define RSCAN0RMDF116LL (RSCAN0.RMDF116.UINT8[R_IO_LL])
#define RSCAN0RMDF116LH (RSCAN0.RMDF116.UINT8[R_IO_LH])
#define RSCAN0RMDF116H (RSCAN0.RMDF116.UINT16[R_IO_H])
#define RSCAN0RMDF116HL (RSCAN0.RMDF116.UINT8[R_IO_HL])
#define RSCAN0RMDF116HH (RSCAN0.RMDF116.UINT8[R_IO_HH])
#define RSCAN0RMID17 (RSCAN0.RMID17.UINT32)
#define RSCAN0RMID17L (RSCAN0.RMID17.UINT16[R_IO_L])
#define RSCAN0RMID17LL (RSCAN0.RMID17.UINT8[R_IO_LL])
#define RSCAN0RMID17LH (RSCAN0.RMID17.UINT8[R_IO_LH])
#define RSCAN0RMID17H (RSCAN0.RMID17.UINT16[R_IO_H])
#define RSCAN0RMID17HL (RSCAN0.RMID17.UINT8[R_IO_HL])
#define RSCAN0RMID17HH (RSCAN0.RMID17.UINT8[R_IO_HH])
#define RSCAN0RMPTR17 (RSCAN0.RMPTR17.UINT32)
#define RSCAN0RMPTR17L (RSCAN0.RMPTR17.UINT16[R_IO_L])
#define RSCAN0RMPTR17LL (RSCAN0.RMPTR17.UINT8[R_IO_LL])
#define RSCAN0RMPTR17LH (RSCAN0.RMPTR17.UINT8[R_IO_LH])
#define RSCAN0RMPTR17H (RSCAN0.RMPTR17.UINT16[R_IO_H])
#define RSCAN0RMPTR17HL (RSCAN0.RMPTR17.UINT8[R_IO_HL])
#define RSCAN0RMPTR17HH (RSCAN0.RMPTR17.UINT8[R_IO_HH])
#define RSCAN0RMDF017 (RSCAN0.RMDF017.UINT32)
#define RSCAN0RMDF017L (RSCAN0.RMDF017.UINT16[R_IO_L])
#define RSCAN0RMDF017LL (RSCAN0.RMDF017.UINT8[R_IO_LL])
#define RSCAN0RMDF017LH (RSCAN0.RMDF017.UINT8[R_IO_LH])
#define RSCAN0RMDF017H (RSCAN0.RMDF017.UINT16[R_IO_H])
#define RSCAN0RMDF017HL (RSCAN0.RMDF017.UINT8[R_IO_HL])
#define RSCAN0RMDF017HH (RSCAN0.RMDF017.UINT8[R_IO_HH])
#define RSCAN0RMDF117 (RSCAN0.RMDF117.UINT32)
#define RSCAN0RMDF117L (RSCAN0.RMDF117.UINT16[R_IO_L])
#define RSCAN0RMDF117LL (RSCAN0.RMDF117.UINT8[R_IO_LL])
#define RSCAN0RMDF117LH (RSCAN0.RMDF117.UINT8[R_IO_LH])
#define RSCAN0RMDF117H (RSCAN0.RMDF117.UINT16[R_IO_H])
#define RSCAN0RMDF117HL (RSCAN0.RMDF117.UINT8[R_IO_HL])
#define RSCAN0RMDF117HH (RSCAN0.RMDF117.UINT8[R_IO_HH])
#define RSCAN0RMID18 (RSCAN0.RMID18.UINT32)
#define RSCAN0RMID18L (RSCAN0.RMID18.UINT16[R_IO_L])
#define RSCAN0RMID18LL (RSCAN0.RMID18.UINT8[R_IO_LL])
#define RSCAN0RMID18LH (RSCAN0.RMID18.UINT8[R_IO_LH])
#define RSCAN0RMID18H (RSCAN0.RMID18.UINT16[R_IO_H])
#define RSCAN0RMID18HL (RSCAN0.RMID18.UINT8[R_IO_HL])
#define RSCAN0RMID18HH (RSCAN0.RMID18.UINT8[R_IO_HH])
#define RSCAN0RMPTR18 (RSCAN0.RMPTR18.UINT32)
#define RSCAN0RMPTR18L (RSCAN0.RMPTR18.UINT16[R_IO_L])
#define RSCAN0RMPTR18LL (RSCAN0.RMPTR18.UINT8[R_IO_LL])
#define RSCAN0RMPTR18LH (RSCAN0.RMPTR18.UINT8[R_IO_LH])
#define RSCAN0RMPTR18H (RSCAN0.RMPTR18.UINT16[R_IO_H])
#define RSCAN0RMPTR18HL (RSCAN0.RMPTR18.UINT8[R_IO_HL])
#define RSCAN0RMPTR18HH (RSCAN0.RMPTR18.UINT8[R_IO_HH])
#define RSCAN0RMDF018 (RSCAN0.RMDF018.UINT32)
#define RSCAN0RMDF018L (RSCAN0.RMDF018.UINT16[R_IO_L])
#define RSCAN0RMDF018LL (RSCAN0.RMDF018.UINT8[R_IO_LL])
#define RSCAN0RMDF018LH (RSCAN0.RMDF018.UINT8[R_IO_LH])
#define RSCAN0RMDF018H (RSCAN0.RMDF018.UINT16[R_IO_H])
#define RSCAN0RMDF018HL (RSCAN0.RMDF018.UINT8[R_IO_HL])
#define RSCAN0RMDF018HH (RSCAN0.RMDF018.UINT8[R_IO_HH])
#define RSCAN0RMDF118 (RSCAN0.RMDF118.UINT32)
#define RSCAN0RMDF118L (RSCAN0.RMDF118.UINT16[R_IO_L])
#define RSCAN0RMDF118LL (RSCAN0.RMDF118.UINT8[R_IO_LL])
#define RSCAN0RMDF118LH (RSCAN0.RMDF118.UINT8[R_IO_LH])
#define RSCAN0RMDF118H (RSCAN0.RMDF118.UINT16[R_IO_H])
#define RSCAN0RMDF118HL (RSCAN0.RMDF118.UINT8[R_IO_HL])
#define RSCAN0RMDF118HH (RSCAN0.RMDF118.UINT8[R_IO_HH])
#define RSCAN0RMID19 (RSCAN0.RMID19.UINT32)
#define RSCAN0RMID19L (RSCAN0.RMID19.UINT16[R_IO_L])
#define RSCAN0RMID19LL (RSCAN0.RMID19.UINT8[R_IO_LL])
#define RSCAN0RMID19LH (RSCAN0.RMID19.UINT8[R_IO_LH])
#define RSCAN0RMID19H (RSCAN0.RMID19.UINT16[R_IO_H])
#define RSCAN0RMID19HL (RSCAN0.RMID19.UINT8[R_IO_HL])
#define RSCAN0RMID19HH (RSCAN0.RMID19.UINT8[R_IO_HH])
#define RSCAN0RMPTR19 (RSCAN0.RMPTR19.UINT32)
#define RSCAN0RMPTR19L (RSCAN0.RMPTR19.UINT16[R_IO_L])
#define RSCAN0RMPTR19LL (RSCAN0.RMPTR19.UINT8[R_IO_LL])
#define RSCAN0RMPTR19LH (RSCAN0.RMPTR19.UINT8[R_IO_LH])
#define RSCAN0RMPTR19H (RSCAN0.RMPTR19.UINT16[R_IO_H])
#define RSCAN0RMPTR19HL (RSCAN0.RMPTR19.UINT8[R_IO_HL])
#define RSCAN0RMPTR19HH (RSCAN0.RMPTR19.UINT8[R_IO_HH])
#define RSCAN0RMDF019 (RSCAN0.RMDF019.UINT32)
#define RSCAN0RMDF019L (RSCAN0.RMDF019.UINT16[R_IO_L])
#define RSCAN0RMDF019LL (RSCAN0.RMDF019.UINT8[R_IO_LL])
#define RSCAN0RMDF019LH (RSCAN0.RMDF019.UINT8[R_IO_LH])
#define RSCAN0RMDF019H (RSCAN0.RMDF019.UINT16[R_IO_H])
#define RSCAN0RMDF019HL (RSCAN0.RMDF019.UINT8[R_IO_HL])
#define RSCAN0RMDF019HH (RSCAN0.RMDF019.UINT8[R_IO_HH])
#define RSCAN0RMDF119 (RSCAN0.RMDF119.UINT32)
#define RSCAN0RMDF119L (RSCAN0.RMDF119.UINT16[R_IO_L])
#define RSCAN0RMDF119LL (RSCAN0.RMDF119.UINT8[R_IO_LL])
#define RSCAN0RMDF119LH (RSCAN0.RMDF119.UINT8[R_IO_LH])
#define RSCAN0RMDF119H (RSCAN0.RMDF119.UINT16[R_IO_H])
#define RSCAN0RMDF119HL (RSCAN0.RMDF119.UINT8[R_IO_HL])
#define RSCAN0RMDF119HH (RSCAN0.RMDF119.UINT8[R_IO_HH])
#define RSCAN0RMID20 (RSCAN0.RMID20.UINT32)
#define RSCAN0RMID20L (RSCAN0.RMID20.UINT16[R_IO_L])
#define RSCAN0RMID20LL (RSCAN0.RMID20.UINT8[R_IO_LL])
#define RSCAN0RMID20LH (RSCAN0.RMID20.UINT8[R_IO_LH])
#define RSCAN0RMID20H (RSCAN0.RMID20.UINT16[R_IO_H])
#define RSCAN0RMID20HL (RSCAN0.RMID20.UINT8[R_IO_HL])
#define RSCAN0RMID20HH (RSCAN0.RMID20.UINT8[R_IO_HH])
#define RSCAN0RMPTR20 (RSCAN0.RMPTR20.UINT32)
#define RSCAN0RMPTR20L (RSCAN0.RMPTR20.UINT16[R_IO_L])
#define RSCAN0RMPTR20LL (RSCAN0.RMPTR20.UINT8[R_IO_LL])
#define RSCAN0RMPTR20LH (RSCAN0.RMPTR20.UINT8[R_IO_LH])
#define RSCAN0RMPTR20H (RSCAN0.RMPTR20.UINT16[R_IO_H])
#define RSCAN0RMPTR20HL (RSCAN0.RMPTR20.UINT8[R_IO_HL])
#define RSCAN0RMPTR20HH (RSCAN0.RMPTR20.UINT8[R_IO_HH])
#define RSCAN0RMDF020 (RSCAN0.RMDF020.UINT32)
#define RSCAN0RMDF020L (RSCAN0.RMDF020.UINT16[R_IO_L])
#define RSCAN0RMDF020LL (RSCAN0.RMDF020.UINT8[R_IO_LL])
#define RSCAN0RMDF020LH (RSCAN0.RMDF020.UINT8[R_IO_LH])
#define RSCAN0RMDF020H (RSCAN0.RMDF020.UINT16[R_IO_H])
#define RSCAN0RMDF020HL (RSCAN0.RMDF020.UINT8[R_IO_HL])
#define RSCAN0RMDF020HH (RSCAN0.RMDF020.UINT8[R_IO_HH])
#define RSCAN0RMDF120 (RSCAN0.RMDF120.UINT32)
#define RSCAN0RMDF120L (RSCAN0.RMDF120.UINT16[R_IO_L])
#define RSCAN0RMDF120LL (RSCAN0.RMDF120.UINT8[R_IO_LL])
#define RSCAN0RMDF120LH (RSCAN0.RMDF120.UINT8[R_IO_LH])
#define RSCAN0RMDF120H (RSCAN0.RMDF120.UINT16[R_IO_H])
#define RSCAN0RMDF120HL (RSCAN0.RMDF120.UINT8[R_IO_HL])
#define RSCAN0RMDF120HH (RSCAN0.RMDF120.UINT8[R_IO_HH])
#define RSCAN0RMID21 (RSCAN0.RMID21.UINT32)
#define RSCAN0RMID21L (RSCAN0.RMID21.UINT16[R_IO_L])
#define RSCAN0RMID21LL (RSCAN0.RMID21.UINT8[R_IO_LL])
#define RSCAN0RMID21LH (RSCAN0.RMID21.UINT8[R_IO_LH])
#define RSCAN0RMID21H (RSCAN0.RMID21.UINT16[R_IO_H])
#define RSCAN0RMID21HL (RSCAN0.RMID21.UINT8[R_IO_HL])
#define RSCAN0RMID21HH (RSCAN0.RMID21.UINT8[R_IO_HH])
#define RSCAN0RMPTR21 (RSCAN0.RMPTR21.UINT32)
#define RSCAN0RMPTR21L (RSCAN0.RMPTR21.UINT16[R_IO_L])
#define RSCAN0RMPTR21LL (RSCAN0.RMPTR21.UINT8[R_IO_LL])
#define RSCAN0RMPTR21LH (RSCAN0.RMPTR21.UINT8[R_IO_LH])
#define RSCAN0RMPTR21H (RSCAN0.RMPTR21.UINT16[R_IO_H])
#define RSCAN0RMPTR21HL (RSCAN0.RMPTR21.UINT8[R_IO_HL])
#define RSCAN0RMPTR21HH (RSCAN0.RMPTR21.UINT8[R_IO_HH])
#define RSCAN0RMDF021 (RSCAN0.RMDF021.UINT32)
#define RSCAN0RMDF021L (RSCAN0.RMDF021.UINT16[R_IO_L])
#define RSCAN0RMDF021LL (RSCAN0.RMDF021.UINT8[R_IO_LL])
#define RSCAN0RMDF021LH (RSCAN0.RMDF021.UINT8[R_IO_LH])
#define RSCAN0RMDF021H (RSCAN0.RMDF021.UINT16[R_IO_H])
#define RSCAN0RMDF021HL (RSCAN0.RMDF021.UINT8[R_IO_HL])
#define RSCAN0RMDF021HH (RSCAN0.RMDF021.UINT8[R_IO_HH])
#define RSCAN0RMDF121 (RSCAN0.RMDF121.UINT32)
#define RSCAN0RMDF121L (RSCAN0.RMDF121.UINT16[R_IO_L])
#define RSCAN0RMDF121LL (RSCAN0.RMDF121.UINT8[R_IO_LL])
#define RSCAN0RMDF121LH (RSCAN0.RMDF121.UINT8[R_IO_LH])
#define RSCAN0RMDF121H (RSCAN0.RMDF121.UINT16[R_IO_H])
#define RSCAN0RMDF121HL (RSCAN0.RMDF121.UINT8[R_IO_HL])
#define RSCAN0RMDF121HH (RSCAN0.RMDF121.UINT8[R_IO_HH])
#define RSCAN0RMID22 (RSCAN0.RMID22.UINT32)
#define RSCAN0RMID22L (RSCAN0.RMID22.UINT16[R_IO_L])
#define RSCAN0RMID22LL (RSCAN0.RMID22.UINT8[R_IO_LL])
#define RSCAN0RMID22LH (RSCAN0.RMID22.UINT8[R_IO_LH])
#define RSCAN0RMID22H (RSCAN0.RMID22.UINT16[R_IO_H])
#define RSCAN0RMID22HL (RSCAN0.RMID22.UINT8[R_IO_HL])
#define RSCAN0RMID22HH (RSCAN0.RMID22.UINT8[R_IO_HH])
#define RSCAN0RMPTR22 (RSCAN0.RMPTR22.UINT32)
#define RSCAN0RMPTR22L (RSCAN0.RMPTR22.UINT16[R_IO_L])
#define RSCAN0RMPTR22LL (RSCAN0.RMPTR22.UINT8[R_IO_LL])
#define RSCAN0RMPTR22LH (RSCAN0.RMPTR22.UINT8[R_IO_LH])
#define RSCAN0RMPTR22H (RSCAN0.RMPTR22.UINT16[R_IO_H])
#define RSCAN0RMPTR22HL (RSCAN0.RMPTR22.UINT8[R_IO_HL])
#define RSCAN0RMPTR22HH (RSCAN0.RMPTR22.UINT8[R_IO_HH])
#define RSCAN0RMDF022 (RSCAN0.RMDF022.UINT32)
#define RSCAN0RMDF022L (RSCAN0.RMDF022.UINT16[R_IO_L])
#define RSCAN0RMDF022LL (RSCAN0.RMDF022.UINT8[R_IO_LL])
#define RSCAN0RMDF022LH (RSCAN0.RMDF022.UINT8[R_IO_LH])
#define RSCAN0RMDF022H (RSCAN0.RMDF022.UINT16[R_IO_H])
#define RSCAN0RMDF022HL (RSCAN0.RMDF022.UINT8[R_IO_HL])
#define RSCAN0RMDF022HH (RSCAN0.RMDF022.UINT8[R_IO_HH])
#define RSCAN0RMDF122 (RSCAN0.RMDF122.UINT32)
#define RSCAN0RMDF122L (RSCAN0.RMDF122.UINT16[R_IO_L])
#define RSCAN0RMDF122LL (RSCAN0.RMDF122.UINT8[R_IO_LL])
#define RSCAN0RMDF122LH (RSCAN0.RMDF122.UINT8[R_IO_LH])
#define RSCAN0RMDF122H (RSCAN0.RMDF122.UINT16[R_IO_H])
#define RSCAN0RMDF122HL (RSCAN0.RMDF122.UINT8[R_IO_HL])
#define RSCAN0RMDF122HH (RSCAN0.RMDF122.UINT8[R_IO_HH])
#define RSCAN0RMID23 (RSCAN0.RMID23.UINT32)
#define RSCAN0RMID23L (RSCAN0.RMID23.UINT16[R_IO_L])
#define RSCAN0RMID23LL (RSCAN0.RMID23.UINT8[R_IO_LL])
#define RSCAN0RMID23LH (RSCAN0.RMID23.UINT8[R_IO_LH])
#define RSCAN0RMID23H (RSCAN0.RMID23.UINT16[R_IO_H])
#define RSCAN0RMID23HL (RSCAN0.RMID23.UINT8[R_IO_HL])
#define RSCAN0RMID23HH (RSCAN0.RMID23.UINT8[R_IO_HH])
#define RSCAN0RMPTR23 (RSCAN0.RMPTR23.UINT32)
#define RSCAN0RMPTR23L (RSCAN0.RMPTR23.UINT16[R_IO_L])
#define RSCAN0RMPTR23LL (RSCAN0.RMPTR23.UINT8[R_IO_LL])
#define RSCAN0RMPTR23LH (RSCAN0.RMPTR23.UINT8[R_IO_LH])
#define RSCAN0RMPTR23H (RSCAN0.RMPTR23.UINT16[R_IO_H])
#define RSCAN0RMPTR23HL (RSCAN0.RMPTR23.UINT8[R_IO_HL])
#define RSCAN0RMPTR23HH (RSCAN0.RMPTR23.UINT8[R_IO_HH])
#define RSCAN0RMDF023 (RSCAN0.RMDF023.UINT32)
#define RSCAN0RMDF023L (RSCAN0.RMDF023.UINT16[R_IO_L])
#define RSCAN0RMDF023LL (RSCAN0.RMDF023.UINT8[R_IO_LL])
#define RSCAN0RMDF023LH (RSCAN0.RMDF023.UINT8[R_IO_LH])
#define RSCAN0RMDF023H (RSCAN0.RMDF023.UINT16[R_IO_H])
#define RSCAN0RMDF023HL (RSCAN0.RMDF023.UINT8[R_IO_HL])
#define RSCAN0RMDF023HH (RSCAN0.RMDF023.UINT8[R_IO_HH])
#define RSCAN0RMDF123 (RSCAN0.RMDF123.UINT32)
#define RSCAN0RMDF123L (RSCAN0.RMDF123.UINT16[R_IO_L])
#define RSCAN0RMDF123LL (RSCAN0.RMDF123.UINT8[R_IO_LL])
#define RSCAN0RMDF123LH (RSCAN0.RMDF123.UINT8[R_IO_LH])
#define RSCAN0RMDF123H (RSCAN0.RMDF123.UINT16[R_IO_H])
#define RSCAN0RMDF123HL (RSCAN0.RMDF123.UINT8[R_IO_HL])
#define RSCAN0RMDF123HH (RSCAN0.RMDF123.UINT8[R_IO_HH])
#define RSCAN0RMID24 (RSCAN0.RMID24.UINT32)
#define RSCAN0RMID24L (RSCAN0.RMID24.UINT16[R_IO_L])
#define RSCAN0RMID24LL (RSCAN0.RMID24.UINT8[R_IO_LL])
#define RSCAN0RMID24LH (RSCAN0.RMID24.UINT8[R_IO_LH])
#define RSCAN0RMID24H (RSCAN0.RMID24.UINT16[R_IO_H])
#define RSCAN0RMID24HL (RSCAN0.RMID24.UINT8[R_IO_HL])
#define RSCAN0RMID24HH (RSCAN0.RMID24.UINT8[R_IO_HH])
#define RSCAN0RMPTR24 (RSCAN0.RMPTR24.UINT32)
#define RSCAN0RMPTR24L (RSCAN0.RMPTR24.UINT16[R_IO_L])
#define RSCAN0RMPTR24LL (RSCAN0.RMPTR24.UINT8[R_IO_LL])
#define RSCAN0RMPTR24LH (RSCAN0.RMPTR24.UINT8[R_IO_LH])
#define RSCAN0RMPTR24H (RSCAN0.RMPTR24.UINT16[R_IO_H])
#define RSCAN0RMPTR24HL (RSCAN0.RMPTR24.UINT8[R_IO_HL])
#define RSCAN0RMPTR24HH (RSCAN0.RMPTR24.UINT8[R_IO_HH])
#define RSCAN0RMDF024 (RSCAN0.RMDF024.UINT32)
#define RSCAN0RMDF024L (RSCAN0.RMDF024.UINT16[R_IO_L])
#define RSCAN0RMDF024LL (RSCAN0.RMDF024.UINT8[R_IO_LL])
#define RSCAN0RMDF024LH (RSCAN0.RMDF024.UINT8[R_IO_LH])
#define RSCAN0RMDF024H (RSCAN0.RMDF024.UINT16[R_IO_H])
#define RSCAN0RMDF024HL (RSCAN0.RMDF024.UINT8[R_IO_HL])
#define RSCAN0RMDF024HH (RSCAN0.RMDF024.UINT8[R_IO_HH])
#define RSCAN0RMDF124 (RSCAN0.RMDF124.UINT32)
#define RSCAN0RMDF124L (RSCAN0.RMDF124.UINT16[R_IO_L])
#define RSCAN0RMDF124LL (RSCAN0.RMDF124.UINT8[R_IO_LL])
#define RSCAN0RMDF124LH (RSCAN0.RMDF124.UINT8[R_IO_LH])
#define RSCAN0RMDF124H (RSCAN0.RMDF124.UINT16[R_IO_H])
#define RSCAN0RMDF124HL (RSCAN0.RMDF124.UINT8[R_IO_HL])
#define RSCAN0RMDF124HH (RSCAN0.RMDF124.UINT8[R_IO_HH])
#define RSCAN0RMID25 (RSCAN0.RMID25.UINT32)
#define RSCAN0RMID25L (RSCAN0.RMID25.UINT16[R_IO_L])
#define RSCAN0RMID25LL (RSCAN0.RMID25.UINT8[R_IO_LL])
#define RSCAN0RMID25LH (RSCAN0.RMID25.UINT8[R_IO_LH])
#define RSCAN0RMID25H (RSCAN0.RMID25.UINT16[R_IO_H])
#define RSCAN0RMID25HL (RSCAN0.RMID25.UINT8[R_IO_HL])
#define RSCAN0RMID25HH (RSCAN0.RMID25.UINT8[R_IO_HH])
#define RSCAN0RMPTR25 (RSCAN0.RMPTR25.UINT32)
#define RSCAN0RMPTR25L (RSCAN0.RMPTR25.UINT16[R_IO_L])
#define RSCAN0RMPTR25LL (RSCAN0.RMPTR25.UINT8[R_IO_LL])
#define RSCAN0RMPTR25LH (RSCAN0.RMPTR25.UINT8[R_IO_LH])
#define RSCAN0RMPTR25H (RSCAN0.RMPTR25.UINT16[R_IO_H])
#define RSCAN0RMPTR25HL (RSCAN0.RMPTR25.UINT8[R_IO_HL])
#define RSCAN0RMPTR25HH (RSCAN0.RMPTR25.UINT8[R_IO_HH])
#define RSCAN0RMDF025 (RSCAN0.RMDF025.UINT32)
#define RSCAN0RMDF025L (RSCAN0.RMDF025.UINT16[R_IO_L])
#define RSCAN0RMDF025LL (RSCAN0.RMDF025.UINT8[R_IO_LL])
#define RSCAN0RMDF025LH (RSCAN0.RMDF025.UINT8[R_IO_LH])
#define RSCAN0RMDF025H (RSCAN0.RMDF025.UINT16[R_IO_H])
#define RSCAN0RMDF025HL (RSCAN0.RMDF025.UINT8[R_IO_HL])
#define RSCAN0RMDF025HH (RSCAN0.RMDF025.UINT8[R_IO_HH])
#define RSCAN0RMDF125 (RSCAN0.RMDF125.UINT32)
#define RSCAN0RMDF125L (RSCAN0.RMDF125.UINT16[R_IO_L])
#define RSCAN0RMDF125LL (RSCAN0.RMDF125.UINT8[R_IO_LL])
#define RSCAN0RMDF125LH (RSCAN0.RMDF125.UINT8[R_IO_LH])
#define RSCAN0RMDF125H (RSCAN0.RMDF125.UINT16[R_IO_H])
#define RSCAN0RMDF125HL (RSCAN0.RMDF125.UINT8[R_IO_HL])
#define RSCAN0RMDF125HH (RSCAN0.RMDF125.UINT8[R_IO_HH])
#define RSCAN0RMID26 (RSCAN0.RMID26.UINT32)
#define RSCAN0RMID26L (RSCAN0.RMID26.UINT16[R_IO_L])
#define RSCAN0RMID26LL (RSCAN0.RMID26.UINT8[R_IO_LL])
#define RSCAN0RMID26LH (RSCAN0.RMID26.UINT8[R_IO_LH])
#define RSCAN0RMID26H (RSCAN0.RMID26.UINT16[R_IO_H])
#define RSCAN0RMID26HL (RSCAN0.RMID26.UINT8[R_IO_HL])
#define RSCAN0RMID26HH (RSCAN0.RMID26.UINT8[R_IO_HH])
#define RSCAN0RMPTR26 (RSCAN0.RMPTR26.UINT32)
#define RSCAN0RMPTR26L (RSCAN0.RMPTR26.UINT16[R_IO_L])
#define RSCAN0RMPTR26LL (RSCAN0.RMPTR26.UINT8[R_IO_LL])
#define RSCAN0RMPTR26LH (RSCAN0.RMPTR26.UINT8[R_IO_LH])
#define RSCAN0RMPTR26H (RSCAN0.RMPTR26.UINT16[R_IO_H])
#define RSCAN0RMPTR26HL (RSCAN0.RMPTR26.UINT8[R_IO_HL])
#define RSCAN0RMPTR26HH (RSCAN0.RMPTR26.UINT8[R_IO_HH])
#define RSCAN0RMDF026 (RSCAN0.RMDF026.UINT32)
#define RSCAN0RMDF026L (RSCAN0.RMDF026.UINT16[R_IO_L])
#define RSCAN0RMDF026LL (RSCAN0.RMDF026.UINT8[R_IO_LL])
#define RSCAN0RMDF026LH (RSCAN0.RMDF026.UINT8[R_IO_LH])
#define RSCAN0RMDF026H (RSCAN0.RMDF026.UINT16[R_IO_H])
#define RSCAN0RMDF026HL (RSCAN0.RMDF026.UINT8[R_IO_HL])
#define RSCAN0RMDF026HH (RSCAN0.RMDF026.UINT8[R_IO_HH])
#define RSCAN0RMDF126 (RSCAN0.RMDF126.UINT32)
#define RSCAN0RMDF126L (RSCAN0.RMDF126.UINT16[R_IO_L])
#define RSCAN0RMDF126LL (RSCAN0.RMDF126.UINT8[R_IO_LL])
#define RSCAN0RMDF126LH (RSCAN0.RMDF126.UINT8[R_IO_LH])
#define RSCAN0RMDF126H (RSCAN0.RMDF126.UINT16[R_IO_H])
#define RSCAN0RMDF126HL (RSCAN0.RMDF126.UINT8[R_IO_HL])
#define RSCAN0RMDF126HH (RSCAN0.RMDF126.UINT8[R_IO_HH])
#define RSCAN0RMID27 (RSCAN0.RMID27.UINT32)
#define RSCAN0RMID27L (RSCAN0.RMID27.UINT16[R_IO_L])
#define RSCAN0RMID27LL (RSCAN0.RMID27.UINT8[R_IO_LL])
#define RSCAN0RMID27LH (RSCAN0.RMID27.UINT8[R_IO_LH])
#define RSCAN0RMID27H (RSCAN0.RMID27.UINT16[R_IO_H])
#define RSCAN0RMID27HL (RSCAN0.RMID27.UINT8[R_IO_HL])
#define RSCAN0RMID27HH (RSCAN0.RMID27.UINT8[R_IO_HH])
#define RSCAN0RMPTR27 (RSCAN0.RMPTR27.UINT32)
#define RSCAN0RMPTR27L (RSCAN0.RMPTR27.UINT16[R_IO_L])
#define RSCAN0RMPTR27LL (RSCAN0.RMPTR27.UINT8[R_IO_LL])
#define RSCAN0RMPTR27LH (RSCAN0.RMPTR27.UINT8[R_IO_LH])
#define RSCAN0RMPTR27H (RSCAN0.RMPTR27.UINT16[R_IO_H])
#define RSCAN0RMPTR27HL (RSCAN0.RMPTR27.UINT8[R_IO_HL])
#define RSCAN0RMPTR27HH (RSCAN0.RMPTR27.UINT8[R_IO_HH])
#define RSCAN0RMDF027 (RSCAN0.RMDF027.UINT32)
#define RSCAN0RMDF027L (RSCAN0.RMDF027.UINT16[R_IO_L])
#define RSCAN0RMDF027LL (RSCAN0.RMDF027.UINT8[R_IO_LL])
#define RSCAN0RMDF027LH (RSCAN0.RMDF027.UINT8[R_IO_LH])
#define RSCAN0RMDF027H (RSCAN0.RMDF027.UINT16[R_IO_H])
#define RSCAN0RMDF027HL (RSCAN0.RMDF027.UINT8[R_IO_HL])
#define RSCAN0RMDF027HH (RSCAN0.RMDF027.UINT8[R_IO_HH])
#define RSCAN0RMDF127 (RSCAN0.RMDF127.UINT32)
#define RSCAN0RMDF127L (RSCAN0.RMDF127.UINT16[R_IO_L])
#define RSCAN0RMDF127LL (RSCAN0.RMDF127.UINT8[R_IO_LL])
#define RSCAN0RMDF127LH (RSCAN0.RMDF127.UINT8[R_IO_LH])
#define RSCAN0RMDF127H (RSCAN0.RMDF127.UINT16[R_IO_H])
#define RSCAN0RMDF127HL (RSCAN0.RMDF127.UINT8[R_IO_HL])
#define RSCAN0RMDF127HH (RSCAN0.RMDF127.UINT8[R_IO_HH])
#define RSCAN0RMID28 (RSCAN0.RMID28.UINT32)
#define RSCAN0RMID28L (RSCAN0.RMID28.UINT16[R_IO_L])
#define RSCAN0RMID28LL (RSCAN0.RMID28.UINT8[R_IO_LL])
#define RSCAN0RMID28LH (RSCAN0.RMID28.UINT8[R_IO_LH])
#define RSCAN0RMID28H (RSCAN0.RMID28.UINT16[R_IO_H])
#define RSCAN0RMID28HL (RSCAN0.RMID28.UINT8[R_IO_HL])
#define RSCAN0RMID28HH (RSCAN0.RMID28.UINT8[R_IO_HH])
#define RSCAN0RMPTR28 (RSCAN0.RMPTR28.UINT32)
#define RSCAN0RMPTR28L (RSCAN0.RMPTR28.UINT16[R_IO_L])
#define RSCAN0RMPTR28LL (RSCAN0.RMPTR28.UINT8[R_IO_LL])
#define RSCAN0RMPTR28LH (RSCAN0.RMPTR28.UINT8[R_IO_LH])
#define RSCAN0RMPTR28H (RSCAN0.RMPTR28.UINT16[R_IO_H])
#define RSCAN0RMPTR28HL (RSCAN0.RMPTR28.UINT8[R_IO_HL])
#define RSCAN0RMPTR28HH (RSCAN0.RMPTR28.UINT8[R_IO_HH])
#define RSCAN0RMDF028 (RSCAN0.RMDF028.UINT32)
#define RSCAN0RMDF028L (RSCAN0.RMDF028.UINT16[R_IO_L])
#define RSCAN0RMDF028LL (RSCAN0.RMDF028.UINT8[R_IO_LL])
#define RSCAN0RMDF028LH (RSCAN0.RMDF028.UINT8[R_IO_LH])
#define RSCAN0RMDF028H (RSCAN0.RMDF028.UINT16[R_IO_H])
#define RSCAN0RMDF028HL (RSCAN0.RMDF028.UINT8[R_IO_HL])
#define RSCAN0RMDF028HH (RSCAN0.RMDF028.UINT8[R_IO_HH])
#define RSCAN0RMDF128 (RSCAN0.RMDF128.UINT32)
#define RSCAN0RMDF128L (RSCAN0.RMDF128.UINT16[R_IO_L])
#define RSCAN0RMDF128LL (RSCAN0.RMDF128.UINT8[R_IO_LL])
#define RSCAN0RMDF128LH (RSCAN0.RMDF128.UINT8[R_IO_LH])
#define RSCAN0RMDF128H (RSCAN0.RMDF128.UINT16[R_IO_H])
#define RSCAN0RMDF128HL (RSCAN0.RMDF128.UINT8[R_IO_HL])
#define RSCAN0RMDF128HH (RSCAN0.RMDF128.UINT8[R_IO_HH])
#define RSCAN0RMID29 (RSCAN0.RMID29.UINT32)
#define RSCAN0RMID29L (RSCAN0.RMID29.UINT16[R_IO_L])
#define RSCAN0RMID29LL (RSCAN0.RMID29.UINT8[R_IO_LL])
#define RSCAN0RMID29LH (RSCAN0.RMID29.UINT8[R_IO_LH])
#define RSCAN0RMID29H (RSCAN0.RMID29.UINT16[R_IO_H])
#define RSCAN0RMID29HL (RSCAN0.RMID29.UINT8[R_IO_HL])
#define RSCAN0RMID29HH (RSCAN0.RMID29.UINT8[R_IO_HH])
#define RSCAN0RMPTR29 (RSCAN0.RMPTR29.UINT32)
#define RSCAN0RMPTR29L (RSCAN0.RMPTR29.UINT16[R_IO_L])
#define RSCAN0RMPTR29LL (RSCAN0.RMPTR29.UINT8[R_IO_LL])
#define RSCAN0RMPTR29LH (RSCAN0.RMPTR29.UINT8[R_IO_LH])
#define RSCAN0RMPTR29H (RSCAN0.RMPTR29.UINT16[R_IO_H])
#define RSCAN0RMPTR29HL (RSCAN0.RMPTR29.UINT8[R_IO_HL])
#define RSCAN0RMPTR29HH (RSCAN0.RMPTR29.UINT8[R_IO_HH])
#define RSCAN0RMDF029 (RSCAN0.RMDF029.UINT32)
#define RSCAN0RMDF029L (RSCAN0.RMDF029.UINT16[R_IO_L])
#define RSCAN0RMDF029LL (RSCAN0.RMDF029.UINT8[R_IO_LL])
#define RSCAN0RMDF029LH (RSCAN0.RMDF029.UINT8[R_IO_LH])
#define RSCAN0RMDF029H (RSCAN0.RMDF029.UINT16[R_IO_H])
#define RSCAN0RMDF029HL (RSCAN0.RMDF029.UINT8[R_IO_HL])
#define RSCAN0RMDF029HH (RSCAN0.RMDF029.UINT8[R_IO_HH])
#define RSCAN0RMDF129 (RSCAN0.RMDF129.UINT32)
#define RSCAN0RMDF129L (RSCAN0.RMDF129.UINT16[R_IO_L])
#define RSCAN0RMDF129LL (RSCAN0.RMDF129.UINT8[R_IO_LL])
#define RSCAN0RMDF129LH (RSCAN0.RMDF129.UINT8[R_IO_LH])
#define RSCAN0RMDF129H (RSCAN0.RMDF129.UINT16[R_IO_H])
#define RSCAN0RMDF129HL (RSCAN0.RMDF129.UINT8[R_IO_HL])
#define RSCAN0RMDF129HH (RSCAN0.RMDF129.UINT8[R_IO_HH])
#define RSCAN0RMID30 (RSCAN0.RMID30.UINT32)
#define RSCAN0RMID30L (RSCAN0.RMID30.UINT16[R_IO_L])
#define RSCAN0RMID30LL (RSCAN0.RMID30.UINT8[R_IO_LL])
#define RSCAN0RMID30LH (RSCAN0.RMID30.UINT8[R_IO_LH])
#define RSCAN0RMID30H (RSCAN0.RMID30.UINT16[R_IO_H])
#define RSCAN0RMID30HL (RSCAN0.RMID30.UINT8[R_IO_HL])
#define RSCAN0RMID30HH (RSCAN0.RMID30.UINT8[R_IO_HH])
#define RSCAN0RMPTR30 (RSCAN0.RMPTR30.UINT32)
#define RSCAN0RMPTR30L (RSCAN0.RMPTR30.UINT16[R_IO_L])
#define RSCAN0RMPTR30LL (RSCAN0.RMPTR30.UINT8[R_IO_LL])
#define RSCAN0RMPTR30LH (RSCAN0.RMPTR30.UINT8[R_IO_LH])
#define RSCAN0RMPTR30H (RSCAN0.RMPTR30.UINT16[R_IO_H])
#define RSCAN0RMPTR30HL (RSCAN0.RMPTR30.UINT8[R_IO_HL])
#define RSCAN0RMPTR30HH (RSCAN0.RMPTR30.UINT8[R_IO_HH])
#define RSCAN0RMDF030 (RSCAN0.RMDF030.UINT32)
#define RSCAN0RMDF030L (RSCAN0.RMDF030.UINT16[R_IO_L])
#define RSCAN0RMDF030LL (RSCAN0.RMDF030.UINT8[R_IO_LL])
#define RSCAN0RMDF030LH (RSCAN0.RMDF030.UINT8[R_IO_LH])
#define RSCAN0RMDF030H (RSCAN0.RMDF030.UINT16[R_IO_H])
#define RSCAN0RMDF030HL (RSCAN0.RMDF030.UINT8[R_IO_HL])
#define RSCAN0RMDF030HH (RSCAN0.RMDF030.UINT8[R_IO_HH])
#define RSCAN0RMDF130 (RSCAN0.RMDF130.UINT32)
#define RSCAN0RMDF130L (RSCAN0.RMDF130.UINT16[R_IO_L])
#define RSCAN0RMDF130LL (RSCAN0.RMDF130.UINT8[R_IO_LL])
#define RSCAN0RMDF130LH (RSCAN0.RMDF130.UINT8[R_IO_LH])
#define RSCAN0RMDF130H (RSCAN0.RMDF130.UINT16[R_IO_H])
#define RSCAN0RMDF130HL (RSCAN0.RMDF130.UINT8[R_IO_HL])
#define RSCAN0RMDF130HH (RSCAN0.RMDF130.UINT8[R_IO_HH])
#define RSCAN0RMID31 (RSCAN0.RMID31.UINT32)
#define RSCAN0RMID31L (RSCAN0.RMID31.UINT16[R_IO_L])
#define RSCAN0RMID31LL (RSCAN0.RMID31.UINT8[R_IO_LL])
#define RSCAN0RMID31LH (RSCAN0.RMID31.UINT8[R_IO_LH])
#define RSCAN0RMID31H (RSCAN0.RMID31.UINT16[R_IO_H])
#define RSCAN0RMID31HL (RSCAN0.RMID31.UINT8[R_IO_HL])
#define RSCAN0RMID31HH (RSCAN0.RMID31.UINT8[R_IO_HH])
#define RSCAN0RMPTR31 (RSCAN0.RMPTR31.UINT32)
#define RSCAN0RMPTR31L (RSCAN0.RMPTR31.UINT16[R_IO_L])
#define RSCAN0RMPTR31LL (RSCAN0.RMPTR31.UINT8[R_IO_LL])
#define RSCAN0RMPTR31LH (RSCAN0.RMPTR31.UINT8[R_IO_LH])
#define RSCAN0RMPTR31H (RSCAN0.RMPTR31.UINT16[R_IO_H])
#define RSCAN0RMPTR31HL (RSCAN0.RMPTR31.UINT8[R_IO_HL])
#define RSCAN0RMPTR31HH (RSCAN0.RMPTR31.UINT8[R_IO_HH])
#define RSCAN0RMDF031 (RSCAN0.RMDF031.UINT32)
#define RSCAN0RMDF031L (RSCAN0.RMDF031.UINT16[R_IO_L])
#define RSCAN0RMDF031LL (RSCAN0.RMDF031.UINT8[R_IO_LL])
#define RSCAN0RMDF031LH (RSCAN0.RMDF031.UINT8[R_IO_LH])
#define RSCAN0RMDF031H (RSCAN0.RMDF031.UINT16[R_IO_H])
#define RSCAN0RMDF031HL (RSCAN0.RMDF031.UINT8[R_IO_HL])
#define RSCAN0RMDF031HH (RSCAN0.RMDF031.UINT8[R_IO_HH])
#define RSCAN0RMDF131 (RSCAN0.RMDF131.UINT32)
#define RSCAN0RMDF131L (RSCAN0.RMDF131.UINT16[R_IO_L])
#define RSCAN0RMDF131LL (RSCAN0.RMDF131.UINT8[R_IO_LL])
#define RSCAN0RMDF131LH (RSCAN0.RMDF131.UINT8[R_IO_LH])
#define RSCAN0RMDF131H (RSCAN0.RMDF131.UINT16[R_IO_H])
#define RSCAN0RMDF131HL (RSCAN0.RMDF131.UINT8[R_IO_HL])
#define RSCAN0RMDF131HH (RSCAN0.RMDF131.UINT8[R_IO_HH])
#define RSCAN0RFID0 (RSCAN0.RFID0.UINT32)
#define RSCAN0RFID0L (RSCAN0.RFID0.UINT16[R_IO_L])
#define RSCAN0RFID0LL (RSCAN0.RFID0.UINT8[R_IO_LL])
#define RSCAN0RFID0LH (RSCAN0.RFID0.UINT8[R_IO_LH])
#define RSCAN0RFID0H (RSCAN0.RFID0.UINT16[R_IO_H])
#define RSCAN0RFID0HL (RSCAN0.RFID0.UINT8[R_IO_HL])
#define RSCAN0RFID0HH (RSCAN0.RFID0.UINT8[R_IO_HH])
#define RSCAN0RFPTR0 (RSCAN0.RFPTR0.UINT32)
#define RSCAN0RFPTR0L (RSCAN0.RFPTR0.UINT16[R_IO_L])
#define RSCAN0RFPTR0LL (RSCAN0.RFPTR0.UINT8[R_IO_LL])
#define RSCAN0RFPTR0LH (RSCAN0.RFPTR0.UINT8[R_IO_LH])
#define RSCAN0RFPTR0H (RSCAN0.RFPTR0.UINT16[R_IO_H])
#define RSCAN0RFPTR0HL (RSCAN0.RFPTR0.UINT8[R_IO_HL])
#define RSCAN0RFPTR0HH (RSCAN0.RFPTR0.UINT8[R_IO_HH])
#define RSCAN0RFDF00 (RSCAN0.RFDF00.UINT32)
#define RSCAN0RFDF00L (RSCAN0.RFDF00.UINT16[R_IO_L])
#define RSCAN0RFDF00LL (RSCAN0.RFDF00.UINT8[R_IO_LL])
#define RSCAN0RFDF00LH (RSCAN0.RFDF00.UINT8[R_IO_LH])
#define RSCAN0RFDF00H (RSCAN0.RFDF00.UINT16[R_IO_H])
#define RSCAN0RFDF00HL (RSCAN0.RFDF00.UINT8[R_IO_HL])
#define RSCAN0RFDF00HH (RSCAN0.RFDF00.UINT8[R_IO_HH])
#define RSCAN0RFDF10 (RSCAN0.RFDF10.UINT32)
#define RSCAN0RFDF10L (RSCAN0.RFDF10.UINT16[R_IO_L])
#define RSCAN0RFDF10LL (RSCAN0.RFDF10.UINT8[R_IO_LL])
#define RSCAN0RFDF10LH (RSCAN0.RFDF10.UINT8[R_IO_LH])
#define RSCAN0RFDF10H (RSCAN0.RFDF10.UINT16[R_IO_H])
#define RSCAN0RFDF10HL (RSCAN0.RFDF10.UINT8[R_IO_HL])
#define RSCAN0RFDF10HH (RSCAN0.RFDF10.UINT8[R_IO_HH])
#define RSCAN0RFID1 (RSCAN0.RFID1.UINT32)
#define RSCAN0RFID1L (RSCAN0.RFID1.UINT16[R_IO_L])
#define RSCAN0RFID1LL (RSCAN0.RFID1.UINT8[R_IO_LL])
#define RSCAN0RFID1LH (RSCAN0.RFID1.UINT8[R_IO_LH])
#define RSCAN0RFID1H (RSCAN0.RFID1.UINT16[R_IO_H])
#define RSCAN0RFID1HL (RSCAN0.RFID1.UINT8[R_IO_HL])
#define RSCAN0RFID1HH (RSCAN0.RFID1.UINT8[R_IO_HH])
#define RSCAN0RFPTR1 (RSCAN0.RFPTR1.UINT32)
#define RSCAN0RFPTR1L (RSCAN0.RFPTR1.UINT16[R_IO_L])
#define RSCAN0RFPTR1LL (RSCAN0.RFPTR1.UINT8[R_IO_LL])
#define RSCAN0RFPTR1LH (RSCAN0.RFPTR1.UINT8[R_IO_LH])
#define RSCAN0RFPTR1H (RSCAN0.RFPTR1.UINT16[R_IO_H])
#define RSCAN0RFPTR1HL (RSCAN0.RFPTR1.UINT8[R_IO_HL])
#define RSCAN0RFPTR1HH (RSCAN0.RFPTR1.UINT8[R_IO_HH])
#define RSCAN0RFDF01 (RSCAN0.RFDF01.UINT32)
#define RSCAN0RFDF01L (RSCAN0.RFDF01.UINT16[R_IO_L])
#define RSCAN0RFDF01LL (RSCAN0.RFDF01.UINT8[R_IO_LL])
#define RSCAN0RFDF01LH (RSCAN0.RFDF01.UINT8[R_IO_LH])
#define RSCAN0RFDF01H (RSCAN0.RFDF01.UINT16[R_IO_H])
#define RSCAN0RFDF01HL (RSCAN0.RFDF01.UINT8[R_IO_HL])
#define RSCAN0RFDF01HH (RSCAN0.RFDF01.UINT8[R_IO_HH])
#define RSCAN0RFDF11 (RSCAN0.RFDF11.UINT32)
#define RSCAN0RFDF11L (RSCAN0.RFDF11.UINT16[R_IO_L])
#define RSCAN0RFDF11LL (RSCAN0.RFDF11.UINT8[R_IO_LL])
#define RSCAN0RFDF11LH (RSCAN0.RFDF11.UINT8[R_IO_LH])
#define RSCAN0RFDF11H (RSCAN0.RFDF11.UINT16[R_IO_H])
#define RSCAN0RFDF11HL (RSCAN0.RFDF11.UINT8[R_IO_HL])
#define RSCAN0RFDF11HH (RSCAN0.RFDF11.UINT8[R_IO_HH])
#define RSCAN0RFID2 (RSCAN0.RFID2.UINT32)
#define RSCAN0RFID2L (RSCAN0.RFID2.UINT16[R_IO_L])
#define RSCAN0RFID2LL (RSCAN0.RFID2.UINT8[R_IO_LL])
#define RSCAN0RFID2LH (RSCAN0.RFID2.UINT8[R_IO_LH])
#define RSCAN0RFID2H (RSCAN0.RFID2.UINT16[R_IO_H])
#define RSCAN0RFID2HL (RSCAN0.RFID2.UINT8[R_IO_HL])
#define RSCAN0RFID2HH (RSCAN0.RFID2.UINT8[R_IO_HH])
#define RSCAN0RFPTR2 (RSCAN0.RFPTR2.UINT32)
#define RSCAN0RFPTR2L (RSCAN0.RFPTR2.UINT16[R_IO_L])
#define RSCAN0RFPTR2LL (RSCAN0.RFPTR2.UINT8[R_IO_LL])
#define RSCAN0RFPTR2LH (RSCAN0.RFPTR2.UINT8[R_IO_LH])
#define RSCAN0RFPTR2H (RSCAN0.RFPTR2.UINT16[R_IO_H])
#define RSCAN0RFPTR2HL (RSCAN0.RFPTR2.UINT8[R_IO_HL])
#define RSCAN0RFPTR2HH (RSCAN0.RFPTR2.UINT8[R_IO_HH])
#define RSCAN0RFDF02 (RSCAN0.RFDF02.UINT32)
#define RSCAN0RFDF02L (RSCAN0.RFDF02.UINT16[R_IO_L])
#define RSCAN0RFDF02LL (RSCAN0.RFDF02.UINT8[R_IO_LL])
#define RSCAN0RFDF02LH (RSCAN0.RFDF02.UINT8[R_IO_LH])
#define RSCAN0RFDF02H (RSCAN0.RFDF02.UINT16[R_IO_H])
#define RSCAN0RFDF02HL (RSCAN0.RFDF02.UINT8[R_IO_HL])
#define RSCAN0RFDF02HH (RSCAN0.RFDF02.UINT8[R_IO_HH])
#define RSCAN0RFDF12 (RSCAN0.RFDF12.UINT32)
#define RSCAN0RFDF12L (RSCAN0.RFDF12.UINT16[R_IO_L])
#define RSCAN0RFDF12LL (RSCAN0.RFDF12.UINT8[R_IO_LL])
#define RSCAN0RFDF12LH (RSCAN0.RFDF12.UINT8[R_IO_LH])
#define RSCAN0RFDF12H (RSCAN0.RFDF12.UINT16[R_IO_H])
#define RSCAN0RFDF12HL (RSCAN0.RFDF12.UINT8[R_IO_HL])
#define RSCAN0RFDF12HH (RSCAN0.RFDF12.UINT8[R_IO_HH])
#define RSCAN0RFID3 (RSCAN0.RFID3.UINT32)
#define RSCAN0RFID3L (RSCAN0.RFID3.UINT16[R_IO_L])
#define RSCAN0RFID3LL (RSCAN0.RFID3.UINT8[R_IO_LL])
#define RSCAN0RFID3LH (RSCAN0.RFID3.UINT8[R_IO_LH])
#define RSCAN0RFID3H (RSCAN0.RFID3.UINT16[R_IO_H])
#define RSCAN0RFID3HL (RSCAN0.RFID3.UINT8[R_IO_HL])
#define RSCAN0RFID3HH (RSCAN0.RFID3.UINT8[R_IO_HH])
#define RSCAN0RFPTR3 (RSCAN0.RFPTR3.UINT32)
#define RSCAN0RFPTR3L (RSCAN0.RFPTR3.UINT16[R_IO_L])
#define RSCAN0RFPTR3LL (RSCAN0.RFPTR3.UINT8[R_IO_LL])
#define RSCAN0RFPTR3LH (RSCAN0.RFPTR3.UINT8[R_IO_LH])
#define RSCAN0RFPTR3H (RSCAN0.RFPTR3.UINT16[R_IO_H])
#define RSCAN0RFPTR3HL (RSCAN0.RFPTR3.UINT8[R_IO_HL])
#define RSCAN0RFPTR3HH (RSCAN0.RFPTR3.UINT8[R_IO_HH])
#define RSCAN0RFDF03 (RSCAN0.RFDF03.UINT32)
#define RSCAN0RFDF03L (RSCAN0.RFDF03.UINT16[R_IO_L])
#define RSCAN0RFDF03LL (RSCAN0.RFDF03.UINT8[R_IO_LL])
#define RSCAN0RFDF03LH (RSCAN0.RFDF03.UINT8[R_IO_LH])
#define RSCAN0RFDF03H (RSCAN0.RFDF03.UINT16[R_IO_H])
#define RSCAN0RFDF03HL (RSCAN0.RFDF03.UINT8[R_IO_HL])
#define RSCAN0RFDF03HH (RSCAN0.RFDF03.UINT8[R_IO_HH])
#define RSCAN0RFDF13 (RSCAN0.RFDF13.UINT32)
#define RSCAN0RFDF13L (RSCAN0.RFDF13.UINT16[R_IO_L])
#define RSCAN0RFDF13LL (RSCAN0.RFDF13.UINT8[R_IO_LL])
#define RSCAN0RFDF13LH (RSCAN0.RFDF13.UINT8[R_IO_LH])
#define RSCAN0RFDF13H (RSCAN0.RFDF13.UINT16[R_IO_H])
#define RSCAN0RFDF13HL (RSCAN0.RFDF13.UINT8[R_IO_HL])
#define RSCAN0RFDF13HH (RSCAN0.RFDF13.UINT8[R_IO_HH])
#define RSCAN0RFID4 (RSCAN0.RFID4.UINT32)
#define RSCAN0RFID4L (RSCAN0.RFID4.UINT16[R_IO_L])
#define RSCAN0RFID4LL (RSCAN0.RFID4.UINT8[R_IO_LL])
#define RSCAN0RFID4LH (RSCAN0.RFID4.UINT8[R_IO_LH])
#define RSCAN0RFID4H (RSCAN0.RFID4.UINT16[R_IO_H])
#define RSCAN0RFID4HL (RSCAN0.RFID4.UINT8[R_IO_HL])
#define RSCAN0RFID4HH (RSCAN0.RFID4.UINT8[R_IO_HH])
#define RSCAN0RFPTR4 (RSCAN0.RFPTR4.UINT32)
#define RSCAN0RFPTR4L (RSCAN0.RFPTR4.UINT16[R_IO_L])
#define RSCAN0RFPTR4LL (RSCAN0.RFPTR4.UINT8[R_IO_LL])
#define RSCAN0RFPTR4LH (RSCAN0.RFPTR4.UINT8[R_IO_LH])
#define RSCAN0RFPTR4H (RSCAN0.RFPTR4.UINT16[R_IO_H])
#define RSCAN0RFPTR4HL (RSCAN0.RFPTR4.UINT8[R_IO_HL])
#define RSCAN0RFPTR4HH (RSCAN0.RFPTR4.UINT8[R_IO_HH])
#define RSCAN0RFDF04 (RSCAN0.RFDF04.UINT32)
#define RSCAN0RFDF04L (RSCAN0.RFDF04.UINT16[R_IO_L])
#define RSCAN0RFDF04LL (RSCAN0.RFDF04.UINT8[R_IO_LL])
#define RSCAN0RFDF04LH (RSCAN0.RFDF04.UINT8[R_IO_LH])
#define RSCAN0RFDF04H (RSCAN0.RFDF04.UINT16[R_IO_H])
#define RSCAN0RFDF04HL (RSCAN0.RFDF04.UINT8[R_IO_HL])
#define RSCAN0RFDF04HH (RSCAN0.RFDF04.UINT8[R_IO_HH])
#define RSCAN0RFDF14 (RSCAN0.RFDF14.UINT32)
#define RSCAN0RFDF14L (RSCAN0.RFDF14.UINT16[R_IO_L])
#define RSCAN0RFDF14LL (RSCAN0.RFDF14.UINT8[R_IO_LL])
#define RSCAN0RFDF14LH (RSCAN0.RFDF14.UINT8[R_IO_LH])
#define RSCAN0RFDF14H (RSCAN0.RFDF14.UINT16[R_IO_H])
#define RSCAN0RFDF14HL (RSCAN0.RFDF14.UINT8[R_IO_HL])
#define RSCAN0RFDF14HH (RSCAN0.RFDF14.UINT8[R_IO_HH])
#define RSCAN0RFID5 (RSCAN0.RFID5.UINT32)
#define RSCAN0RFID5L (RSCAN0.RFID5.UINT16[R_IO_L])
#define RSCAN0RFID5LL (RSCAN0.RFID5.UINT8[R_IO_LL])
#define RSCAN0RFID5LH (RSCAN0.RFID5.UINT8[R_IO_LH])
#define RSCAN0RFID5H (RSCAN0.RFID5.UINT16[R_IO_H])
#define RSCAN0RFID5HL (RSCAN0.RFID5.UINT8[R_IO_HL])
#define RSCAN0RFID5HH (RSCAN0.RFID5.UINT8[R_IO_HH])
#define RSCAN0RFPTR5 (RSCAN0.RFPTR5.UINT32)
#define RSCAN0RFPTR5L (RSCAN0.RFPTR5.UINT16[R_IO_L])
#define RSCAN0RFPTR5LL (RSCAN0.RFPTR5.UINT8[R_IO_LL])
#define RSCAN0RFPTR5LH (RSCAN0.RFPTR5.UINT8[R_IO_LH])
#define RSCAN0RFPTR5H (RSCAN0.RFPTR5.UINT16[R_IO_H])
#define RSCAN0RFPTR5HL (RSCAN0.RFPTR5.UINT8[R_IO_HL])
#define RSCAN0RFPTR5HH (RSCAN0.RFPTR5.UINT8[R_IO_HH])
#define RSCAN0RFDF05 (RSCAN0.RFDF05.UINT32)
#define RSCAN0RFDF05L (RSCAN0.RFDF05.UINT16[R_IO_L])
#define RSCAN0RFDF05LL (RSCAN0.RFDF05.UINT8[R_IO_LL])
#define RSCAN0RFDF05LH (RSCAN0.RFDF05.UINT8[R_IO_LH])
#define RSCAN0RFDF05H (RSCAN0.RFDF05.UINT16[R_IO_H])
#define RSCAN0RFDF05HL (RSCAN0.RFDF05.UINT8[R_IO_HL])
#define RSCAN0RFDF05HH (RSCAN0.RFDF05.UINT8[R_IO_HH])
#define RSCAN0RFDF15 (RSCAN0.RFDF15.UINT32)
#define RSCAN0RFDF15L (RSCAN0.RFDF15.UINT16[R_IO_L])
#define RSCAN0RFDF15LL (RSCAN0.RFDF15.UINT8[R_IO_LL])
#define RSCAN0RFDF15LH (RSCAN0.RFDF15.UINT8[R_IO_LH])
#define RSCAN0RFDF15H (RSCAN0.RFDF15.UINT16[R_IO_H])
#define RSCAN0RFDF15HL (RSCAN0.RFDF15.UINT8[R_IO_HL])
#define RSCAN0RFDF15HH (RSCAN0.RFDF15.UINT8[R_IO_HH])
#define RSCAN0RFID6 (RSCAN0.RFID6.UINT32)
#define RSCAN0RFID6L (RSCAN0.RFID6.UINT16[R_IO_L])
#define RSCAN0RFID6LL (RSCAN0.RFID6.UINT8[R_IO_LL])
#define RSCAN0RFID6LH (RSCAN0.RFID6.UINT8[R_IO_LH])
#define RSCAN0RFID6H (RSCAN0.RFID6.UINT16[R_IO_H])
#define RSCAN0RFID6HL (RSCAN0.RFID6.UINT8[R_IO_HL])
#define RSCAN0RFID6HH (RSCAN0.RFID6.UINT8[R_IO_HH])
#define RSCAN0RFPTR6 (RSCAN0.RFPTR6.UINT32)
#define RSCAN0RFPTR6L (RSCAN0.RFPTR6.UINT16[R_IO_L])
#define RSCAN0RFPTR6LL (RSCAN0.RFPTR6.UINT8[R_IO_LL])
#define RSCAN0RFPTR6LH (RSCAN0.RFPTR6.UINT8[R_IO_LH])
#define RSCAN0RFPTR6H (RSCAN0.RFPTR6.UINT16[R_IO_H])
#define RSCAN0RFPTR6HL (RSCAN0.RFPTR6.UINT8[R_IO_HL])
#define RSCAN0RFPTR6HH (RSCAN0.RFPTR6.UINT8[R_IO_HH])
#define RSCAN0RFDF06 (RSCAN0.RFDF06.UINT32)
#define RSCAN0RFDF06L (RSCAN0.RFDF06.UINT16[R_IO_L])
#define RSCAN0RFDF06LL (RSCAN0.RFDF06.UINT8[R_IO_LL])
#define RSCAN0RFDF06LH (RSCAN0.RFDF06.UINT8[R_IO_LH])
#define RSCAN0RFDF06H (RSCAN0.RFDF06.UINT16[R_IO_H])
#define RSCAN0RFDF06HL (RSCAN0.RFDF06.UINT8[R_IO_HL])
#define RSCAN0RFDF06HH (RSCAN0.RFDF06.UINT8[R_IO_HH])
#define RSCAN0RFDF16 (RSCAN0.RFDF16.UINT32)
#define RSCAN0RFDF16L (RSCAN0.RFDF16.UINT16[R_IO_L])
#define RSCAN0RFDF16LL (RSCAN0.RFDF16.UINT8[R_IO_LL])
#define RSCAN0RFDF16LH (RSCAN0.RFDF16.UINT8[R_IO_LH])
#define RSCAN0RFDF16H (RSCAN0.RFDF16.UINT16[R_IO_H])
#define RSCAN0RFDF16HL (RSCAN0.RFDF16.UINT8[R_IO_HL])
#define RSCAN0RFDF16HH (RSCAN0.RFDF16.UINT8[R_IO_HH])
#define RSCAN0RFID7 (RSCAN0.RFID7.UINT32)
#define RSCAN0RFID7L (RSCAN0.RFID7.UINT16[R_IO_L])
#define RSCAN0RFID7LL (RSCAN0.RFID7.UINT8[R_IO_LL])
#define RSCAN0RFID7LH (RSCAN0.RFID7.UINT8[R_IO_LH])
#define RSCAN0RFID7H (RSCAN0.RFID7.UINT16[R_IO_H])
#define RSCAN0RFID7HL (RSCAN0.RFID7.UINT8[R_IO_HL])
#define RSCAN0RFID7HH (RSCAN0.RFID7.UINT8[R_IO_HH])
#define RSCAN0RFPTR7 (RSCAN0.RFPTR7.UINT32)
#define RSCAN0RFPTR7L (RSCAN0.RFPTR7.UINT16[R_IO_L])
#define RSCAN0RFPTR7LL (RSCAN0.RFPTR7.UINT8[R_IO_LL])
#define RSCAN0RFPTR7LH (RSCAN0.RFPTR7.UINT8[R_IO_LH])
#define RSCAN0RFPTR7H (RSCAN0.RFPTR7.UINT16[R_IO_H])
#define RSCAN0RFPTR7HL (RSCAN0.RFPTR7.UINT8[R_IO_HL])
#define RSCAN0RFPTR7HH (RSCAN0.RFPTR7.UINT8[R_IO_HH])
#define RSCAN0RFDF07 (RSCAN0.RFDF07.UINT32)
#define RSCAN0RFDF07L (RSCAN0.RFDF07.UINT16[R_IO_L])
#define RSCAN0RFDF07LL (RSCAN0.RFDF07.UINT8[R_IO_LL])
#define RSCAN0RFDF07LH (RSCAN0.RFDF07.UINT8[R_IO_LH])
#define RSCAN0RFDF07H (RSCAN0.RFDF07.UINT16[R_IO_H])
#define RSCAN0RFDF07HL (RSCAN0.RFDF07.UINT8[R_IO_HL])
#define RSCAN0RFDF07HH (RSCAN0.RFDF07.UINT8[R_IO_HH])
#define RSCAN0RFDF17 (RSCAN0.RFDF17.UINT32)
#define RSCAN0RFDF17L (RSCAN0.RFDF17.UINT16[R_IO_L])
#define RSCAN0RFDF17LL (RSCAN0.RFDF17.UINT8[R_IO_LL])
#define RSCAN0RFDF17LH (RSCAN0.RFDF17.UINT8[R_IO_LH])
#define RSCAN0RFDF17H (RSCAN0.RFDF17.UINT16[R_IO_H])
#define RSCAN0RFDF17HL (RSCAN0.RFDF17.UINT8[R_IO_HL])
#define RSCAN0RFDF17HH (RSCAN0.RFDF17.UINT8[R_IO_HH])
#define RSCAN0CFID0 (RSCAN0.CFID0.UINT32)
#define RSCAN0CFID0L (RSCAN0.CFID0.UINT16[R_IO_L])
#define RSCAN0CFID0LL (RSCAN0.CFID0.UINT8[R_IO_LL])
#define RSCAN0CFID0LH (RSCAN0.CFID0.UINT8[R_IO_LH])
#define RSCAN0CFID0H (RSCAN0.CFID0.UINT16[R_IO_H])
#define RSCAN0CFID0HL (RSCAN0.CFID0.UINT8[R_IO_HL])
#define RSCAN0CFID0HH (RSCAN0.CFID0.UINT8[R_IO_HH])
#define RSCAN0CFPTR0 (RSCAN0.CFPTR0.UINT32)
#define RSCAN0CFPTR0L (RSCAN0.CFPTR0.UINT16[R_IO_L])
#define RSCAN0CFPTR0LL (RSCAN0.CFPTR0.UINT8[R_IO_LL])
#define RSCAN0CFPTR0LH (RSCAN0.CFPTR0.UINT8[R_IO_LH])
#define RSCAN0CFPTR0H (RSCAN0.CFPTR0.UINT16[R_IO_H])
#define RSCAN0CFPTR0HL (RSCAN0.CFPTR0.UINT8[R_IO_HL])
#define RSCAN0CFPTR0HH (RSCAN0.CFPTR0.UINT8[R_IO_HH])
#define RSCAN0CFDF00 (RSCAN0.CFDF00.UINT32)
#define RSCAN0CFDF00L (RSCAN0.CFDF00.UINT16[R_IO_L])
#define RSCAN0CFDF00LL (RSCAN0.CFDF00.UINT8[R_IO_LL])
#define RSCAN0CFDF00LH (RSCAN0.CFDF00.UINT8[R_IO_LH])
#define RSCAN0CFDF00H (RSCAN0.CFDF00.UINT16[R_IO_H])
#define RSCAN0CFDF00HL (RSCAN0.CFDF00.UINT8[R_IO_HL])
#define RSCAN0CFDF00HH (RSCAN0.CFDF00.UINT8[R_IO_HH])
#define RSCAN0CFDF10 (RSCAN0.CFDF10.UINT32)
#define RSCAN0CFDF10L (RSCAN0.CFDF10.UINT16[R_IO_L])
#define RSCAN0CFDF10LL (RSCAN0.CFDF10.UINT8[R_IO_LL])
#define RSCAN0CFDF10LH (RSCAN0.CFDF10.UINT8[R_IO_LH])
#define RSCAN0CFDF10H (RSCAN0.CFDF10.UINT16[R_IO_H])
#define RSCAN0CFDF10HL (RSCAN0.CFDF10.UINT8[R_IO_HL])
#define RSCAN0CFDF10HH (RSCAN0.CFDF10.UINT8[R_IO_HH])
#define RSCAN0CFID1 (RSCAN0.CFID1.UINT32)
#define RSCAN0CFID1L (RSCAN0.CFID1.UINT16[R_IO_L])
#define RSCAN0CFID1LL (RSCAN0.CFID1.UINT8[R_IO_LL])
#define RSCAN0CFID1LH (RSCAN0.CFID1.UINT8[R_IO_LH])
#define RSCAN0CFID1H (RSCAN0.CFID1.UINT16[R_IO_H])
#define RSCAN0CFID1HL (RSCAN0.CFID1.UINT8[R_IO_HL])
#define RSCAN0CFID1HH (RSCAN0.CFID1.UINT8[R_IO_HH])
#define RSCAN0CFPTR1 (RSCAN0.CFPTR1.UINT32)
#define RSCAN0CFPTR1L (RSCAN0.CFPTR1.UINT16[R_IO_L])
#define RSCAN0CFPTR1LL (RSCAN0.CFPTR1.UINT8[R_IO_LL])
#define RSCAN0CFPTR1LH (RSCAN0.CFPTR1.UINT8[R_IO_LH])
#define RSCAN0CFPTR1H (RSCAN0.CFPTR1.UINT16[R_IO_H])
#define RSCAN0CFPTR1HL (RSCAN0.CFPTR1.UINT8[R_IO_HL])
#define RSCAN0CFPTR1HH (RSCAN0.CFPTR1.UINT8[R_IO_HH])
#define RSCAN0CFDF01 (RSCAN0.CFDF01.UINT32)
#define RSCAN0CFDF01L (RSCAN0.CFDF01.UINT16[R_IO_L])
#define RSCAN0CFDF01LL (RSCAN0.CFDF01.UINT8[R_IO_LL])
#define RSCAN0CFDF01LH (RSCAN0.CFDF01.UINT8[R_IO_LH])
#define RSCAN0CFDF01H (RSCAN0.CFDF01.UINT16[R_IO_H])
#define RSCAN0CFDF01HL (RSCAN0.CFDF01.UINT8[R_IO_HL])
#define RSCAN0CFDF01HH (RSCAN0.CFDF01.UINT8[R_IO_HH])
#define RSCAN0CFDF11 (RSCAN0.CFDF11.UINT32)
#define RSCAN0CFDF11L (RSCAN0.CFDF11.UINT16[R_IO_L])
#define RSCAN0CFDF11LL (RSCAN0.CFDF11.UINT8[R_IO_LL])
#define RSCAN0CFDF11LH (RSCAN0.CFDF11.UINT8[R_IO_LH])
#define RSCAN0CFDF11H (RSCAN0.CFDF11.UINT16[R_IO_H])
#define RSCAN0CFDF11HL (RSCAN0.CFDF11.UINT8[R_IO_HL])
#define RSCAN0CFDF11HH (RSCAN0.CFDF11.UINT8[R_IO_HH])
#define RSCAN0CFID2 (RSCAN0.CFID2.UINT32)
#define RSCAN0CFID2L (RSCAN0.CFID2.UINT16[R_IO_L])
#define RSCAN0CFID2LL (RSCAN0.CFID2.UINT8[R_IO_LL])
#define RSCAN0CFID2LH (RSCAN0.CFID2.UINT8[R_IO_LH])
#define RSCAN0CFID2H (RSCAN0.CFID2.UINT16[R_IO_H])
#define RSCAN0CFID2HL (RSCAN0.CFID2.UINT8[R_IO_HL])
#define RSCAN0CFID2HH (RSCAN0.CFID2.UINT8[R_IO_HH])
#define RSCAN0CFPTR2 (RSCAN0.CFPTR2.UINT32)
#define RSCAN0CFPTR2L (RSCAN0.CFPTR2.UINT16[R_IO_L])
#define RSCAN0CFPTR2LL (RSCAN0.CFPTR2.UINT8[R_IO_LL])
#define RSCAN0CFPTR2LH (RSCAN0.CFPTR2.UINT8[R_IO_LH])
#define RSCAN0CFPTR2H (RSCAN0.CFPTR2.UINT16[R_IO_H])
#define RSCAN0CFPTR2HL (RSCAN0.CFPTR2.UINT8[R_IO_HL])
#define RSCAN0CFPTR2HH (RSCAN0.CFPTR2.UINT8[R_IO_HH])
#define RSCAN0CFDF02 (RSCAN0.CFDF02.UINT32)
#define RSCAN0CFDF02L (RSCAN0.CFDF02.UINT16[R_IO_L])
#define RSCAN0CFDF02LL (RSCAN0.CFDF02.UINT8[R_IO_LL])
#define RSCAN0CFDF02LH (RSCAN0.CFDF02.UINT8[R_IO_LH])
#define RSCAN0CFDF02H (RSCAN0.CFDF02.UINT16[R_IO_H])
#define RSCAN0CFDF02HL (RSCAN0.CFDF02.UINT8[R_IO_HL])
#define RSCAN0CFDF02HH (RSCAN0.CFDF02.UINT8[R_IO_HH])
#define RSCAN0CFDF12 (RSCAN0.CFDF12.UINT32)
#define RSCAN0CFDF12L (RSCAN0.CFDF12.UINT16[R_IO_L])
#define RSCAN0CFDF12LL (RSCAN0.CFDF12.UINT8[R_IO_LL])
#define RSCAN0CFDF12LH (RSCAN0.CFDF12.UINT8[R_IO_LH])
#define RSCAN0CFDF12H (RSCAN0.CFDF12.UINT16[R_IO_H])
#define RSCAN0CFDF12HL (RSCAN0.CFDF12.UINT8[R_IO_HL])
#define RSCAN0CFDF12HH (RSCAN0.CFDF12.UINT8[R_IO_HH])
#define RSCAN0CFID3 (RSCAN0.CFID3.UINT32)
#define RSCAN0CFID3L (RSCAN0.CFID3.UINT16[R_IO_L])
#define RSCAN0CFID3LL (RSCAN0.CFID3.UINT8[R_IO_LL])
#define RSCAN0CFID3LH (RSCAN0.CFID3.UINT8[R_IO_LH])
#define RSCAN0CFID3H (RSCAN0.CFID3.UINT16[R_IO_H])
#define RSCAN0CFID3HL (RSCAN0.CFID3.UINT8[R_IO_HL])
#define RSCAN0CFID3HH (RSCAN0.CFID3.UINT8[R_IO_HH])
#define RSCAN0CFPTR3 (RSCAN0.CFPTR3.UINT32)
#define RSCAN0CFPTR3L (RSCAN0.CFPTR3.UINT16[R_IO_L])
#define RSCAN0CFPTR3LL (RSCAN0.CFPTR3.UINT8[R_IO_LL])
#define RSCAN0CFPTR3LH (RSCAN0.CFPTR3.UINT8[R_IO_LH])
#define RSCAN0CFPTR3H (RSCAN0.CFPTR3.UINT16[R_IO_H])
#define RSCAN0CFPTR3HL (RSCAN0.CFPTR3.UINT8[R_IO_HL])
#define RSCAN0CFPTR3HH (RSCAN0.CFPTR3.UINT8[R_IO_HH])
#define RSCAN0CFDF03 (RSCAN0.CFDF03.UINT32)
#define RSCAN0CFDF03L (RSCAN0.CFDF03.UINT16[R_IO_L])
#define RSCAN0CFDF03LL (RSCAN0.CFDF03.UINT8[R_IO_LL])
#define RSCAN0CFDF03LH (RSCAN0.CFDF03.UINT8[R_IO_LH])
#define RSCAN0CFDF03H (RSCAN0.CFDF03.UINT16[R_IO_H])
#define RSCAN0CFDF03HL (RSCAN0.CFDF03.UINT8[R_IO_HL])
#define RSCAN0CFDF03HH (RSCAN0.CFDF03.UINT8[R_IO_HH])
#define RSCAN0CFDF13 (RSCAN0.CFDF13.UINT32)
#define RSCAN0CFDF13L (RSCAN0.CFDF13.UINT16[R_IO_L])
#define RSCAN0CFDF13LL (RSCAN0.CFDF13.UINT8[R_IO_LL])
#define RSCAN0CFDF13LH (RSCAN0.CFDF13.UINT8[R_IO_LH])
#define RSCAN0CFDF13H (RSCAN0.CFDF13.UINT16[R_IO_H])
#define RSCAN0CFDF13HL (RSCAN0.CFDF13.UINT8[R_IO_HL])
#define RSCAN0CFDF13HH (RSCAN0.CFDF13.UINT8[R_IO_HH])
#define RSCAN0CFID4 (RSCAN0.CFID4.UINT32)
#define RSCAN0CFID4L (RSCAN0.CFID4.UINT16[R_IO_L])
#define RSCAN0CFID4LL (RSCAN0.CFID4.UINT8[R_IO_LL])
#define RSCAN0CFID4LH (RSCAN0.CFID4.UINT8[R_IO_LH])
#define RSCAN0CFID4H (RSCAN0.CFID4.UINT16[R_IO_H])
#define RSCAN0CFID4HL (RSCAN0.CFID4.UINT8[R_IO_HL])
#define RSCAN0CFID4HH (RSCAN0.CFID4.UINT8[R_IO_HH])
#define RSCAN0CFPTR4 (RSCAN0.CFPTR4.UINT32)
#define RSCAN0CFPTR4L (RSCAN0.CFPTR4.UINT16[R_IO_L])
#define RSCAN0CFPTR4LL (RSCAN0.CFPTR4.UINT8[R_IO_LL])
#define RSCAN0CFPTR4LH (RSCAN0.CFPTR4.UINT8[R_IO_LH])
#define RSCAN0CFPTR4H (RSCAN0.CFPTR4.UINT16[R_IO_H])
#define RSCAN0CFPTR4HL (RSCAN0.CFPTR4.UINT8[R_IO_HL])
#define RSCAN0CFPTR4HH (RSCAN0.CFPTR4.UINT8[R_IO_HH])
#define RSCAN0CFDF04 (RSCAN0.CFDF04.UINT32)
#define RSCAN0CFDF04L (RSCAN0.CFDF04.UINT16[R_IO_L])
#define RSCAN0CFDF04LL (RSCAN0.CFDF04.UINT8[R_IO_LL])
#define RSCAN0CFDF04LH (RSCAN0.CFDF04.UINT8[R_IO_LH])
#define RSCAN0CFDF04H (RSCAN0.CFDF04.UINT16[R_IO_H])
#define RSCAN0CFDF04HL (RSCAN0.CFDF04.UINT8[R_IO_HL])
#define RSCAN0CFDF04HH (RSCAN0.CFDF04.UINT8[R_IO_HH])
#define RSCAN0CFDF14 (RSCAN0.CFDF14.UINT32)
#define RSCAN0CFDF14L (RSCAN0.CFDF14.UINT16[R_IO_L])
#define RSCAN0CFDF14LL (RSCAN0.CFDF14.UINT8[R_IO_LL])
#define RSCAN0CFDF14LH (RSCAN0.CFDF14.UINT8[R_IO_LH])
#define RSCAN0CFDF14H (RSCAN0.CFDF14.UINT16[R_IO_H])
#define RSCAN0CFDF14HL (RSCAN0.CFDF14.UINT8[R_IO_HL])
#define RSCAN0CFDF14HH (RSCAN0.CFDF14.UINT8[R_IO_HH])
#define RSCAN0CFID5 (RSCAN0.CFID5.UINT32)
#define RSCAN0CFID5L (RSCAN0.CFID5.UINT16[R_IO_L])
#define RSCAN0CFID5LL (RSCAN0.CFID5.UINT8[R_IO_LL])
#define RSCAN0CFID5LH (RSCAN0.CFID5.UINT8[R_IO_LH])
#define RSCAN0CFID5H (RSCAN0.CFID5.UINT16[R_IO_H])
#define RSCAN0CFID5HL (RSCAN0.CFID5.UINT8[R_IO_HL])
#define RSCAN0CFID5HH (RSCAN0.CFID5.UINT8[R_IO_HH])
#define RSCAN0CFPTR5 (RSCAN0.CFPTR5.UINT32)
#define RSCAN0CFPTR5L (RSCAN0.CFPTR5.UINT16[R_IO_L])
#define RSCAN0CFPTR5LL (RSCAN0.CFPTR5.UINT8[R_IO_LL])
#define RSCAN0CFPTR5LH (RSCAN0.CFPTR5.UINT8[R_IO_LH])
#define RSCAN0CFPTR5H (RSCAN0.CFPTR5.UINT16[R_IO_H])
#define RSCAN0CFPTR5HL (RSCAN0.CFPTR5.UINT8[R_IO_HL])
#define RSCAN0CFPTR5HH (RSCAN0.CFPTR5.UINT8[R_IO_HH])
#define RSCAN0CFDF05 (RSCAN0.CFDF05.UINT32)
#define RSCAN0CFDF05L (RSCAN0.CFDF05.UINT16[R_IO_L])
#define RSCAN0CFDF05LL (RSCAN0.CFDF05.UINT8[R_IO_LL])
#define RSCAN0CFDF05LH (RSCAN0.CFDF05.UINT8[R_IO_LH])
#define RSCAN0CFDF05H (RSCAN0.CFDF05.UINT16[R_IO_H])
#define RSCAN0CFDF05HL (RSCAN0.CFDF05.UINT8[R_IO_HL])
#define RSCAN0CFDF05HH (RSCAN0.CFDF05.UINT8[R_IO_HH])
#define RSCAN0CFDF15 (RSCAN0.CFDF15.UINT32)
#define RSCAN0CFDF15L (RSCAN0.CFDF15.UINT16[R_IO_L])
#define RSCAN0CFDF15LL (RSCAN0.CFDF15.UINT8[R_IO_LL])
#define RSCAN0CFDF15LH (RSCAN0.CFDF15.UINT8[R_IO_LH])
#define RSCAN0CFDF15H (RSCAN0.CFDF15.UINT16[R_IO_H])
#define RSCAN0CFDF15HL (RSCAN0.CFDF15.UINT8[R_IO_HL])
#define RSCAN0CFDF15HH (RSCAN0.CFDF15.UINT8[R_IO_HH])
#define RSCAN0TMID0 (RSCAN0.TMID0.UINT32)
#define RSCAN0TMID0L (RSCAN0.TMID0.UINT16[R_IO_L])
#define RSCAN0TMID0LL (RSCAN0.TMID0.UINT8[R_IO_LL])
#define RSCAN0TMID0LH (RSCAN0.TMID0.UINT8[R_IO_LH])
#define RSCAN0TMID0H (RSCAN0.TMID0.UINT16[R_IO_H])
#define RSCAN0TMID0HL (RSCAN0.TMID0.UINT8[R_IO_HL])
#define RSCAN0TMID0HH (RSCAN0.TMID0.UINT8[R_IO_HH])
#define RSCAN0TMPTR0 (RSCAN0.TMPTR0.UINT32)
#define RSCAN0TMPTR0L (RSCAN0.TMPTR0.UINT16[R_IO_L])
#define RSCAN0TMPTR0LL (RSCAN0.TMPTR0.UINT8[R_IO_LL])
#define RSCAN0TMPTR0LH (RSCAN0.TMPTR0.UINT8[R_IO_LH])
#define RSCAN0TMPTR0H (RSCAN0.TMPTR0.UINT16[R_IO_H])
#define RSCAN0TMPTR0HL (RSCAN0.TMPTR0.UINT8[R_IO_HL])
#define RSCAN0TMPTR0HH (RSCAN0.TMPTR0.UINT8[R_IO_HH])
#define RSCAN0TMDF00 (RSCAN0.TMDF00.UINT32)
#define RSCAN0TMDF00L (RSCAN0.TMDF00.UINT16[R_IO_L])
#define RSCAN0TMDF00LL (RSCAN0.TMDF00.UINT8[R_IO_LL])
#define RSCAN0TMDF00LH (RSCAN0.TMDF00.UINT8[R_IO_LH])
#define RSCAN0TMDF00H (RSCAN0.TMDF00.UINT16[R_IO_H])
#define RSCAN0TMDF00HL (RSCAN0.TMDF00.UINT8[R_IO_HL])
#define RSCAN0TMDF00HH (RSCAN0.TMDF00.UINT8[R_IO_HH])
#define RSCAN0TMDF10 (RSCAN0.TMDF10.UINT32)
#define RSCAN0TMDF10L (RSCAN0.TMDF10.UINT16[R_IO_L])
#define RSCAN0TMDF10LL (RSCAN0.TMDF10.UINT8[R_IO_LL])
#define RSCAN0TMDF10LH (RSCAN0.TMDF10.UINT8[R_IO_LH])
#define RSCAN0TMDF10H (RSCAN0.TMDF10.UINT16[R_IO_H])
#define RSCAN0TMDF10HL (RSCAN0.TMDF10.UINT8[R_IO_HL])
#define RSCAN0TMDF10HH (RSCAN0.TMDF10.UINT8[R_IO_HH])
#define RSCAN0TMID1 (RSCAN0.TMID1.UINT32)
#define RSCAN0TMID1L (RSCAN0.TMID1.UINT16[R_IO_L])
#define RSCAN0TMID1LL (RSCAN0.TMID1.UINT8[R_IO_LL])
#define RSCAN0TMID1LH (RSCAN0.TMID1.UINT8[R_IO_LH])
#define RSCAN0TMID1H (RSCAN0.TMID1.UINT16[R_IO_H])
#define RSCAN0TMID1HL (RSCAN0.TMID1.UINT8[R_IO_HL])
#define RSCAN0TMID1HH (RSCAN0.TMID1.UINT8[R_IO_HH])
#define RSCAN0TMPTR1 (RSCAN0.TMPTR1.UINT32)
#define RSCAN0TMPTR1L (RSCAN0.TMPTR1.UINT16[R_IO_L])
#define RSCAN0TMPTR1LL (RSCAN0.TMPTR1.UINT8[R_IO_LL])
#define RSCAN0TMPTR1LH (RSCAN0.TMPTR1.UINT8[R_IO_LH])
#define RSCAN0TMPTR1H (RSCAN0.TMPTR1.UINT16[R_IO_H])
#define RSCAN0TMPTR1HL (RSCAN0.TMPTR1.UINT8[R_IO_HL])
#define RSCAN0TMPTR1HH (RSCAN0.TMPTR1.UINT8[R_IO_HH])
#define RSCAN0TMDF01 (RSCAN0.TMDF01.UINT32)
#define RSCAN0TMDF01L (RSCAN0.TMDF01.UINT16[R_IO_L])
#define RSCAN0TMDF01LL (RSCAN0.TMDF01.UINT8[R_IO_LL])
#define RSCAN0TMDF01LH (RSCAN0.TMDF01.UINT8[R_IO_LH])
#define RSCAN0TMDF01H (RSCAN0.TMDF01.UINT16[R_IO_H])
#define RSCAN0TMDF01HL (RSCAN0.TMDF01.UINT8[R_IO_HL])
#define RSCAN0TMDF01HH (RSCAN0.TMDF01.UINT8[R_IO_HH])
#define RSCAN0TMDF11 (RSCAN0.TMDF11.UINT32)
#define RSCAN0TMDF11L (RSCAN0.TMDF11.UINT16[R_IO_L])
#define RSCAN0TMDF11LL (RSCAN0.TMDF11.UINT8[R_IO_LL])
#define RSCAN0TMDF11LH (RSCAN0.TMDF11.UINT8[R_IO_LH])
#define RSCAN0TMDF11H (RSCAN0.TMDF11.UINT16[R_IO_H])
#define RSCAN0TMDF11HL (RSCAN0.TMDF11.UINT8[R_IO_HL])
#define RSCAN0TMDF11HH (RSCAN0.TMDF11.UINT8[R_IO_HH])
#define RSCAN0TMID2 (RSCAN0.TMID2.UINT32)
#define RSCAN0TMID2L (RSCAN0.TMID2.UINT16[R_IO_L])
#define RSCAN0TMID2LL (RSCAN0.TMID2.UINT8[R_IO_LL])
#define RSCAN0TMID2LH (RSCAN0.TMID2.UINT8[R_IO_LH])
#define RSCAN0TMID2H (RSCAN0.TMID2.UINT16[R_IO_H])
#define RSCAN0TMID2HL (RSCAN0.TMID2.UINT8[R_IO_HL])
#define RSCAN0TMID2HH (RSCAN0.TMID2.UINT8[R_IO_HH])
#define RSCAN0TMPTR2 (RSCAN0.TMPTR2.UINT32)
#define RSCAN0TMPTR2L (RSCAN0.TMPTR2.UINT16[R_IO_L])
#define RSCAN0TMPTR2LL (RSCAN0.TMPTR2.UINT8[R_IO_LL])
#define RSCAN0TMPTR2LH (RSCAN0.TMPTR2.UINT8[R_IO_LH])
#define RSCAN0TMPTR2H (RSCAN0.TMPTR2.UINT16[R_IO_H])
#define RSCAN0TMPTR2HL (RSCAN0.TMPTR2.UINT8[R_IO_HL])
#define RSCAN0TMPTR2HH (RSCAN0.TMPTR2.UINT8[R_IO_HH])
#define RSCAN0TMDF02 (RSCAN0.TMDF02.UINT32)
#define RSCAN0TMDF02L (RSCAN0.TMDF02.UINT16[R_IO_L])
#define RSCAN0TMDF02LL (RSCAN0.TMDF02.UINT8[R_IO_LL])
#define RSCAN0TMDF02LH (RSCAN0.TMDF02.UINT8[R_IO_LH])
#define RSCAN0TMDF02H (RSCAN0.TMDF02.UINT16[R_IO_H])
#define RSCAN0TMDF02HL (RSCAN0.TMDF02.UINT8[R_IO_HL])
#define RSCAN0TMDF02HH (RSCAN0.TMDF02.UINT8[R_IO_HH])
#define RSCAN0TMDF12 (RSCAN0.TMDF12.UINT32)
#define RSCAN0TMDF12L (RSCAN0.TMDF12.UINT16[R_IO_L])
#define RSCAN0TMDF12LL (RSCAN0.TMDF12.UINT8[R_IO_LL])
#define RSCAN0TMDF12LH (RSCAN0.TMDF12.UINT8[R_IO_LH])
#define RSCAN0TMDF12H (RSCAN0.TMDF12.UINT16[R_IO_H])
#define RSCAN0TMDF12HL (RSCAN0.TMDF12.UINT8[R_IO_HL])
#define RSCAN0TMDF12HH (RSCAN0.TMDF12.UINT8[R_IO_HH])
#define RSCAN0TMID3 (RSCAN0.TMID3.UINT32)
#define RSCAN0TMID3L (RSCAN0.TMID3.UINT16[R_IO_L])
#define RSCAN0TMID3LL (RSCAN0.TMID3.UINT8[R_IO_LL])
#define RSCAN0TMID3LH (RSCAN0.TMID3.UINT8[R_IO_LH])
#define RSCAN0TMID3H (RSCAN0.TMID3.UINT16[R_IO_H])
#define RSCAN0TMID3HL (RSCAN0.TMID3.UINT8[R_IO_HL])
#define RSCAN0TMID3HH (RSCAN0.TMID3.UINT8[R_IO_HH])
#define RSCAN0TMPTR3 (RSCAN0.TMPTR3.UINT32)
#define RSCAN0TMPTR3L (RSCAN0.TMPTR3.UINT16[R_IO_L])
#define RSCAN0TMPTR3LL (RSCAN0.TMPTR3.UINT8[R_IO_LL])
#define RSCAN0TMPTR3LH (RSCAN0.TMPTR3.UINT8[R_IO_LH])
#define RSCAN0TMPTR3H (RSCAN0.TMPTR3.UINT16[R_IO_H])
#define RSCAN0TMPTR3HL (RSCAN0.TMPTR3.UINT8[R_IO_HL])
#define RSCAN0TMPTR3HH (RSCAN0.TMPTR3.UINT8[R_IO_HH])
#define RSCAN0TMDF03 (RSCAN0.TMDF03.UINT32)
#define RSCAN0TMDF03L (RSCAN0.TMDF03.UINT16[R_IO_L])
#define RSCAN0TMDF03LL (RSCAN0.TMDF03.UINT8[R_IO_LL])
#define RSCAN0TMDF03LH (RSCAN0.TMDF03.UINT8[R_IO_LH])
#define RSCAN0TMDF03H (RSCAN0.TMDF03.UINT16[R_IO_H])
#define RSCAN0TMDF03HL (RSCAN0.TMDF03.UINT8[R_IO_HL])
#define RSCAN0TMDF03HH (RSCAN0.TMDF03.UINT8[R_IO_HH])
#define RSCAN0TMDF13 (RSCAN0.TMDF13.UINT32)
#define RSCAN0TMDF13L (RSCAN0.TMDF13.UINT16[R_IO_L])
#define RSCAN0TMDF13LL (RSCAN0.TMDF13.UINT8[R_IO_LL])
#define RSCAN0TMDF13LH (RSCAN0.TMDF13.UINT8[R_IO_LH])
#define RSCAN0TMDF13H (RSCAN0.TMDF13.UINT16[R_IO_H])
#define RSCAN0TMDF13HL (RSCAN0.TMDF13.UINT8[R_IO_HL])
#define RSCAN0TMDF13HH (RSCAN0.TMDF13.UINT8[R_IO_HH])
#define RSCAN0TMID4 (RSCAN0.TMID4.UINT32)
#define RSCAN0TMID4L (RSCAN0.TMID4.UINT16[R_IO_L])
#define RSCAN0TMID4LL (RSCAN0.TMID4.UINT8[R_IO_LL])
#define RSCAN0TMID4LH (RSCAN0.TMID4.UINT8[R_IO_LH])
#define RSCAN0TMID4H (RSCAN0.TMID4.UINT16[R_IO_H])
#define RSCAN0TMID4HL (RSCAN0.TMID4.UINT8[R_IO_HL])
#define RSCAN0TMID4HH (RSCAN0.TMID4.UINT8[R_IO_HH])
#define RSCAN0TMPTR4 (RSCAN0.TMPTR4.UINT32)
#define RSCAN0TMPTR4L (RSCAN0.TMPTR4.UINT16[R_IO_L])
#define RSCAN0TMPTR4LL (RSCAN0.TMPTR4.UINT8[R_IO_LL])
#define RSCAN0TMPTR4LH (RSCAN0.TMPTR4.UINT8[R_IO_LH])
#define RSCAN0TMPTR4H (RSCAN0.TMPTR4.UINT16[R_IO_H])
#define RSCAN0TMPTR4HL (RSCAN0.TMPTR4.UINT8[R_IO_HL])
#define RSCAN0TMPTR4HH (RSCAN0.TMPTR4.UINT8[R_IO_HH])
#define RSCAN0TMDF04 (RSCAN0.TMDF04.UINT32)
#define RSCAN0TMDF04L (RSCAN0.TMDF04.UINT16[R_IO_L])
#define RSCAN0TMDF04LL (RSCAN0.TMDF04.UINT8[R_IO_LL])
#define RSCAN0TMDF04LH (RSCAN0.TMDF04.UINT8[R_IO_LH])
#define RSCAN0TMDF04H (RSCAN0.TMDF04.UINT16[R_IO_H])
#define RSCAN0TMDF04HL (RSCAN0.TMDF04.UINT8[R_IO_HL])
#define RSCAN0TMDF04HH (RSCAN0.TMDF04.UINT8[R_IO_HH])
#define RSCAN0TMDF14 (RSCAN0.TMDF14.UINT32)
#define RSCAN0TMDF14L (RSCAN0.TMDF14.UINT16[R_IO_L])
#define RSCAN0TMDF14LL (RSCAN0.TMDF14.UINT8[R_IO_LL])
#define RSCAN0TMDF14LH (RSCAN0.TMDF14.UINT8[R_IO_LH])
#define RSCAN0TMDF14H (RSCAN0.TMDF14.UINT16[R_IO_H])
#define RSCAN0TMDF14HL (RSCAN0.TMDF14.UINT8[R_IO_HL])
#define RSCAN0TMDF14HH (RSCAN0.TMDF14.UINT8[R_IO_HH])
#define RSCAN0TMID5 (RSCAN0.TMID5.UINT32)
#define RSCAN0TMID5L (RSCAN0.TMID5.UINT16[R_IO_L])
#define RSCAN0TMID5LL (RSCAN0.TMID5.UINT8[R_IO_LL])
#define RSCAN0TMID5LH (RSCAN0.TMID5.UINT8[R_IO_LH])
#define RSCAN0TMID5H (RSCAN0.TMID5.UINT16[R_IO_H])
#define RSCAN0TMID5HL (RSCAN0.TMID5.UINT8[R_IO_HL])
#define RSCAN0TMID5HH (RSCAN0.TMID5.UINT8[R_IO_HH])
#define RSCAN0TMPTR5 (RSCAN0.TMPTR5.UINT32)
#define RSCAN0TMPTR5L (RSCAN0.TMPTR5.UINT16[R_IO_L])
#define RSCAN0TMPTR5LL (RSCAN0.TMPTR5.UINT8[R_IO_LL])
#define RSCAN0TMPTR5LH (RSCAN0.TMPTR5.UINT8[R_IO_LH])
#define RSCAN0TMPTR5H (RSCAN0.TMPTR5.UINT16[R_IO_H])
#define RSCAN0TMPTR5HL (RSCAN0.TMPTR5.UINT8[R_IO_HL])
#define RSCAN0TMPTR5HH (RSCAN0.TMPTR5.UINT8[R_IO_HH])
#define RSCAN0TMDF05 (RSCAN0.TMDF05.UINT32)
#define RSCAN0TMDF05L (RSCAN0.TMDF05.UINT16[R_IO_L])
#define RSCAN0TMDF05LL (RSCAN0.TMDF05.UINT8[R_IO_LL])
#define RSCAN0TMDF05LH (RSCAN0.TMDF05.UINT8[R_IO_LH])
#define RSCAN0TMDF05H (RSCAN0.TMDF05.UINT16[R_IO_H])
#define RSCAN0TMDF05HL (RSCAN0.TMDF05.UINT8[R_IO_HL])
#define RSCAN0TMDF05HH (RSCAN0.TMDF05.UINT8[R_IO_HH])
#define RSCAN0TMDF15 (RSCAN0.TMDF15.UINT32)
#define RSCAN0TMDF15L (RSCAN0.TMDF15.UINT16[R_IO_L])
#define RSCAN0TMDF15LL (RSCAN0.TMDF15.UINT8[R_IO_LL])
#define RSCAN0TMDF15LH (RSCAN0.TMDF15.UINT8[R_IO_LH])
#define RSCAN0TMDF15H (RSCAN0.TMDF15.UINT16[R_IO_H])
#define RSCAN0TMDF15HL (RSCAN0.TMDF15.UINT8[R_IO_HL])
#define RSCAN0TMDF15HH (RSCAN0.TMDF15.UINT8[R_IO_HH])
#define RSCAN0TMID6 (RSCAN0.TMID6.UINT32)
#define RSCAN0TMID6L (RSCAN0.TMID6.UINT16[R_IO_L])
#define RSCAN0TMID6LL (RSCAN0.TMID6.UINT8[R_IO_LL])
#define RSCAN0TMID6LH (RSCAN0.TMID6.UINT8[R_IO_LH])
#define RSCAN0TMID6H (RSCAN0.TMID6.UINT16[R_IO_H])
#define RSCAN0TMID6HL (RSCAN0.TMID6.UINT8[R_IO_HL])
#define RSCAN0TMID6HH (RSCAN0.TMID6.UINT8[R_IO_HH])
#define RSCAN0TMPTR6 (RSCAN0.TMPTR6.UINT32)
#define RSCAN0TMPTR6L (RSCAN0.TMPTR6.UINT16[R_IO_L])
#define RSCAN0TMPTR6LL (RSCAN0.TMPTR6.UINT8[R_IO_LL])
#define RSCAN0TMPTR6LH (RSCAN0.TMPTR6.UINT8[R_IO_LH])
#define RSCAN0TMPTR6H (RSCAN0.TMPTR6.UINT16[R_IO_H])
#define RSCAN0TMPTR6HL (RSCAN0.TMPTR6.UINT8[R_IO_HL])
#define RSCAN0TMPTR6HH (RSCAN0.TMPTR6.UINT8[R_IO_HH])
#define RSCAN0TMDF06 (RSCAN0.TMDF06.UINT32)
#define RSCAN0TMDF06L (RSCAN0.TMDF06.UINT16[R_IO_L])
#define RSCAN0TMDF06LL (RSCAN0.TMDF06.UINT8[R_IO_LL])
#define RSCAN0TMDF06LH (RSCAN0.TMDF06.UINT8[R_IO_LH])
#define RSCAN0TMDF06H (RSCAN0.TMDF06.UINT16[R_IO_H])
#define RSCAN0TMDF06HL (RSCAN0.TMDF06.UINT8[R_IO_HL])
#define RSCAN0TMDF06HH (RSCAN0.TMDF06.UINT8[R_IO_HH])
#define RSCAN0TMDF16 (RSCAN0.TMDF16.UINT32)
#define RSCAN0TMDF16L (RSCAN0.TMDF16.UINT16[R_IO_L])
#define RSCAN0TMDF16LL (RSCAN0.TMDF16.UINT8[R_IO_LL])
#define RSCAN0TMDF16LH (RSCAN0.TMDF16.UINT8[R_IO_LH])
#define RSCAN0TMDF16H (RSCAN0.TMDF16.UINT16[R_IO_H])
#define RSCAN0TMDF16HL (RSCAN0.TMDF16.UINT8[R_IO_HL])
#define RSCAN0TMDF16HH (RSCAN0.TMDF16.UINT8[R_IO_HH])
#define RSCAN0TMID7 (RSCAN0.TMID7.UINT32)
#define RSCAN0TMID7L (RSCAN0.TMID7.UINT16[R_IO_L])
#define RSCAN0TMID7LL (RSCAN0.TMID7.UINT8[R_IO_LL])
#define RSCAN0TMID7LH (RSCAN0.TMID7.UINT8[R_IO_LH])
#define RSCAN0TMID7H (RSCAN0.TMID7.UINT16[R_IO_H])
#define RSCAN0TMID7HL (RSCAN0.TMID7.UINT8[R_IO_HL])
#define RSCAN0TMID7HH (RSCAN0.TMID7.UINT8[R_IO_HH])
#define RSCAN0TMPTR7 (RSCAN0.TMPTR7.UINT32)
#define RSCAN0TMPTR7L (RSCAN0.TMPTR7.UINT16[R_IO_L])
#define RSCAN0TMPTR7LL (RSCAN0.TMPTR7.UINT8[R_IO_LL])
#define RSCAN0TMPTR7LH (RSCAN0.TMPTR7.UINT8[R_IO_LH])
#define RSCAN0TMPTR7H (RSCAN0.TMPTR7.UINT16[R_IO_H])
#define RSCAN0TMPTR7HL (RSCAN0.TMPTR7.UINT8[R_IO_HL])
#define RSCAN0TMPTR7HH (RSCAN0.TMPTR7.UINT8[R_IO_HH])
#define RSCAN0TMDF07 (RSCAN0.TMDF07.UINT32)
#define RSCAN0TMDF07L (RSCAN0.TMDF07.UINT16[R_IO_L])
#define RSCAN0TMDF07LL (RSCAN0.TMDF07.UINT8[R_IO_LL])
#define RSCAN0TMDF07LH (RSCAN0.TMDF07.UINT8[R_IO_LH])
#define RSCAN0TMDF07H (RSCAN0.TMDF07.UINT16[R_IO_H])
#define RSCAN0TMDF07HL (RSCAN0.TMDF07.UINT8[R_IO_HL])
#define RSCAN0TMDF07HH (RSCAN0.TMDF07.UINT8[R_IO_HH])
#define RSCAN0TMDF17 (RSCAN0.TMDF17.UINT32)
#define RSCAN0TMDF17L (RSCAN0.TMDF17.UINT16[R_IO_L])
#define RSCAN0TMDF17LL (RSCAN0.TMDF17.UINT8[R_IO_LL])
#define RSCAN0TMDF17LH (RSCAN0.TMDF17.UINT8[R_IO_LH])
#define RSCAN0TMDF17H (RSCAN0.TMDF17.UINT16[R_IO_H])
#define RSCAN0TMDF17HL (RSCAN0.TMDF17.UINT8[R_IO_HL])
#define RSCAN0TMDF17HH (RSCAN0.TMDF17.UINT8[R_IO_HH])
#define RSCAN0TMID8 (RSCAN0.TMID8.UINT32)
#define RSCAN0TMID8L (RSCAN0.TMID8.UINT16[R_IO_L])
#define RSCAN0TMID8LL (RSCAN0.TMID8.UINT8[R_IO_LL])
#define RSCAN0TMID8LH (RSCAN0.TMID8.UINT8[R_IO_LH])
#define RSCAN0TMID8H (RSCAN0.TMID8.UINT16[R_IO_H])
#define RSCAN0TMID8HL (RSCAN0.TMID8.UINT8[R_IO_HL])
#define RSCAN0TMID8HH (RSCAN0.TMID8.UINT8[R_IO_HH])
#define RSCAN0TMPTR8 (RSCAN0.TMPTR8.UINT32)
#define RSCAN0TMPTR8L (RSCAN0.TMPTR8.UINT16[R_IO_L])
#define RSCAN0TMPTR8LL (RSCAN0.TMPTR8.UINT8[R_IO_LL])
#define RSCAN0TMPTR8LH (RSCAN0.TMPTR8.UINT8[R_IO_LH])
#define RSCAN0TMPTR8H (RSCAN0.TMPTR8.UINT16[R_IO_H])
#define RSCAN0TMPTR8HL (RSCAN0.TMPTR8.UINT8[R_IO_HL])
#define RSCAN0TMPTR8HH (RSCAN0.TMPTR8.UINT8[R_IO_HH])
#define RSCAN0TMDF08 (RSCAN0.TMDF08.UINT32)
#define RSCAN0TMDF08L (RSCAN0.TMDF08.UINT16[R_IO_L])
#define RSCAN0TMDF08LL (RSCAN0.TMDF08.UINT8[R_IO_LL])
#define RSCAN0TMDF08LH (RSCAN0.TMDF08.UINT8[R_IO_LH])
#define RSCAN0TMDF08H (RSCAN0.TMDF08.UINT16[R_IO_H])
#define RSCAN0TMDF08HL (RSCAN0.TMDF08.UINT8[R_IO_HL])
#define RSCAN0TMDF08HH (RSCAN0.TMDF08.UINT8[R_IO_HH])
#define RSCAN0TMDF18 (RSCAN0.TMDF18.UINT32)
#define RSCAN0TMDF18L (RSCAN0.TMDF18.UINT16[R_IO_L])
#define RSCAN0TMDF18LL (RSCAN0.TMDF18.UINT8[R_IO_LL])
#define RSCAN0TMDF18LH (RSCAN0.TMDF18.UINT8[R_IO_LH])
#define RSCAN0TMDF18H (RSCAN0.TMDF18.UINT16[R_IO_H])
#define RSCAN0TMDF18HL (RSCAN0.TMDF18.UINT8[R_IO_HL])
#define RSCAN0TMDF18HH (RSCAN0.TMDF18.UINT8[R_IO_HH])
#define RSCAN0TMID9 (RSCAN0.TMID9.UINT32)
#define RSCAN0TMID9L (RSCAN0.TMID9.UINT16[R_IO_L])
#define RSCAN0TMID9LL (RSCAN0.TMID9.UINT8[R_IO_LL])
#define RSCAN0TMID9LH (RSCAN0.TMID9.UINT8[R_IO_LH])
#define RSCAN0TMID9H (RSCAN0.TMID9.UINT16[R_IO_H])
#define RSCAN0TMID9HL (RSCAN0.TMID9.UINT8[R_IO_HL])
#define RSCAN0TMID9HH (RSCAN0.TMID9.UINT8[R_IO_HH])
#define RSCAN0TMPTR9 (RSCAN0.TMPTR9.UINT32)
#define RSCAN0TMPTR9L (RSCAN0.TMPTR9.UINT16[R_IO_L])
#define RSCAN0TMPTR9LL (RSCAN0.TMPTR9.UINT8[R_IO_LL])
#define RSCAN0TMPTR9LH (RSCAN0.TMPTR9.UINT8[R_IO_LH])
#define RSCAN0TMPTR9H (RSCAN0.TMPTR9.UINT16[R_IO_H])
#define RSCAN0TMPTR9HL (RSCAN0.TMPTR9.UINT8[R_IO_HL])
#define RSCAN0TMPTR9HH (RSCAN0.TMPTR9.UINT8[R_IO_HH])
#define RSCAN0TMDF09 (RSCAN0.TMDF09.UINT32)
#define RSCAN0TMDF09L (RSCAN0.TMDF09.UINT16[R_IO_L])
#define RSCAN0TMDF09LL (RSCAN0.TMDF09.UINT8[R_IO_LL])
#define RSCAN0TMDF09LH (RSCAN0.TMDF09.UINT8[R_IO_LH])
#define RSCAN0TMDF09H (RSCAN0.TMDF09.UINT16[R_IO_H])
#define RSCAN0TMDF09HL (RSCAN0.TMDF09.UINT8[R_IO_HL])
#define RSCAN0TMDF09HH (RSCAN0.TMDF09.UINT8[R_IO_HH])
#define RSCAN0TMDF19 (RSCAN0.TMDF19.UINT32)
#define RSCAN0TMDF19L (RSCAN0.TMDF19.UINT16[R_IO_L])
#define RSCAN0TMDF19LL (RSCAN0.TMDF19.UINT8[R_IO_LL])
#define RSCAN0TMDF19LH (RSCAN0.TMDF19.UINT8[R_IO_LH])
#define RSCAN0TMDF19H (RSCAN0.TMDF19.UINT16[R_IO_H])
#define RSCAN0TMDF19HL (RSCAN0.TMDF19.UINT8[R_IO_HL])
#define RSCAN0TMDF19HH (RSCAN0.TMDF19.UINT8[R_IO_HH])
#define RSCAN0TMID10 (RSCAN0.TMID10.UINT32)
#define RSCAN0TMID10L (RSCAN0.TMID10.UINT16[R_IO_L])
#define RSCAN0TMID10LL (RSCAN0.TMID10.UINT8[R_IO_LL])
#define RSCAN0TMID10LH (RSCAN0.TMID10.UINT8[R_IO_LH])
#define RSCAN0TMID10H (RSCAN0.TMID10.UINT16[R_IO_H])
#define RSCAN0TMID10HL (RSCAN0.TMID10.UINT8[R_IO_HL])
#define RSCAN0TMID10HH (RSCAN0.TMID10.UINT8[R_IO_HH])
#define RSCAN0TMPTR10 (RSCAN0.TMPTR10.UINT32)
#define RSCAN0TMPTR10L (RSCAN0.TMPTR10.UINT16[R_IO_L])
#define RSCAN0TMPTR10LL (RSCAN0.TMPTR10.UINT8[R_IO_LL])
#define RSCAN0TMPTR10LH (RSCAN0.TMPTR10.UINT8[R_IO_LH])
#define RSCAN0TMPTR10H (RSCAN0.TMPTR10.UINT16[R_IO_H])
#define RSCAN0TMPTR10HL (RSCAN0.TMPTR10.UINT8[R_IO_HL])
#define RSCAN0TMPTR10HH (RSCAN0.TMPTR10.UINT8[R_IO_HH])
#define RSCAN0TMDF010 (RSCAN0.TMDF010.UINT32)
#define RSCAN0TMDF010L (RSCAN0.TMDF010.UINT16[R_IO_L])
#define RSCAN0TMDF010LL (RSCAN0.TMDF010.UINT8[R_IO_LL])
#define RSCAN0TMDF010LH (RSCAN0.TMDF010.UINT8[R_IO_LH])
#define RSCAN0TMDF010H (RSCAN0.TMDF010.UINT16[R_IO_H])
#define RSCAN0TMDF010HL (RSCAN0.TMDF010.UINT8[R_IO_HL])
#define RSCAN0TMDF010HH (RSCAN0.TMDF010.UINT8[R_IO_HH])
#define RSCAN0TMDF110 (RSCAN0.TMDF110.UINT32)
#define RSCAN0TMDF110L (RSCAN0.TMDF110.UINT16[R_IO_L])
#define RSCAN0TMDF110LL (RSCAN0.TMDF110.UINT8[R_IO_LL])
#define RSCAN0TMDF110LH (RSCAN0.TMDF110.UINT8[R_IO_LH])
#define RSCAN0TMDF110H (RSCAN0.TMDF110.UINT16[R_IO_H])
#define RSCAN0TMDF110HL (RSCAN0.TMDF110.UINT8[R_IO_HL])
#define RSCAN0TMDF110HH (RSCAN0.TMDF110.UINT8[R_IO_HH])
#define RSCAN0TMID11 (RSCAN0.TMID11.UINT32)
#define RSCAN0TMID11L (RSCAN0.TMID11.UINT16[R_IO_L])
#define RSCAN0TMID11LL (RSCAN0.TMID11.UINT8[R_IO_LL])
#define RSCAN0TMID11LH (RSCAN0.TMID11.UINT8[R_IO_LH])
#define RSCAN0TMID11H (RSCAN0.TMID11.UINT16[R_IO_H])
#define RSCAN0TMID11HL (RSCAN0.TMID11.UINT8[R_IO_HL])
#define RSCAN0TMID11HH (RSCAN0.TMID11.UINT8[R_IO_HH])
#define RSCAN0TMPTR11 (RSCAN0.TMPTR11.UINT32)
#define RSCAN0TMPTR11L (RSCAN0.TMPTR11.UINT16[R_IO_L])
#define RSCAN0TMPTR11LL (RSCAN0.TMPTR11.UINT8[R_IO_LL])
#define RSCAN0TMPTR11LH (RSCAN0.TMPTR11.UINT8[R_IO_LH])
#define RSCAN0TMPTR11H (RSCAN0.TMPTR11.UINT16[R_IO_H])
#define RSCAN0TMPTR11HL (RSCAN0.TMPTR11.UINT8[R_IO_HL])
#define RSCAN0TMPTR11HH (RSCAN0.TMPTR11.UINT8[R_IO_HH])
#define RSCAN0TMDF011 (RSCAN0.TMDF011.UINT32)
#define RSCAN0TMDF011L (RSCAN0.TMDF011.UINT16[R_IO_L])
#define RSCAN0TMDF011LL (RSCAN0.TMDF011.UINT8[R_IO_LL])
#define RSCAN0TMDF011LH (RSCAN0.TMDF011.UINT8[R_IO_LH])
#define RSCAN0TMDF011H (RSCAN0.TMDF011.UINT16[R_IO_H])
#define RSCAN0TMDF011HL (RSCAN0.TMDF011.UINT8[R_IO_HL])
#define RSCAN0TMDF011HH (RSCAN0.TMDF011.UINT8[R_IO_HH])
#define RSCAN0TMDF111 (RSCAN0.TMDF111.UINT32)
#define RSCAN0TMDF111L (RSCAN0.TMDF111.UINT16[R_IO_L])
#define RSCAN0TMDF111LL (RSCAN0.TMDF111.UINT8[R_IO_LL])
#define RSCAN0TMDF111LH (RSCAN0.TMDF111.UINT8[R_IO_LH])
#define RSCAN0TMDF111H (RSCAN0.TMDF111.UINT16[R_IO_H])
#define RSCAN0TMDF111HL (RSCAN0.TMDF111.UINT8[R_IO_HL])
#define RSCAN0TMDF111HH (RSCAN0.TMDF111.UINT8[R_IO_HH])
#define RSCAN0TMID12 (RSCAN0.TMID12.UINT32)
#define RSCAN0TMID12L (RSCAN0.TMID12.UINT16[R_IO_L])
#define RSCAN0TMID12LL (RSCAN0.TMID12.UINT8[R_IO_LL])
#define RSCAN0TMID12LH (RSCAN0.TMID12.UINT8[R_IO_LH])
#define RSCAN0TMID12H (RSCAN0.TMID12.UINT16[R_IO_H])
#define RSCAN0TMID12HL (RSCAN0.TMID12.UINT8[R_IO_HL])
#define RSCAN0TMID12HH (RSCAN0.TMID12.UINT8[R_IO_HH])
#define RSCAN0TMPTR12 (RSCAN0.TMPTR12.UINT32)
#define RSCAN0TMPTR12L (RSCAN0.TMPTR12.UINT16[R_IO_L])
#define RSCAN0TMPTR12LL (RSCAN0.TMPTR12.UINT8[R_IO_LL])
#define RSCAN0TMPTR12LH (RSCAN0.TMPTR12.UINT8[R_IO_LH])
#define RSCAN0TMPTR12H (RSCAN0.TMPTR12.UINT16[R_IO_H])
#define RSCAN0TMPTR12HL (RSCAN0.TMPTR12.UINT8[R_IO_HL])
#define RSCAN0TMPTR12HH (RSCAN0.TMPTR12.UINT8[R_IO_HH])
#define RSCAN0TMDF012 (RSCAN0.TMDF012.UINT32)
#define RSCAN0TMDF012L (RSCAN0.TMDF012.UINT16[R_IO_L])
#define RSCAN0TMDF012LL (RSCAN0.TMDF012.UINT8[R_IO_LL])
#define RSCAN0TMDF012LH (RSCAN0.TMDF012.UINT8[R_IO_LH])
#define RSCAN0TMDF012H (RSCAN0.TMDF012.UINT16[R_IO_H])
#define RSCAN0TMDF012HL (RSCAN0.TMDF012.UINT8[R_IO_HL])
#define RSCAN0TMDF012HH (RSCAN0.TMDF012.UINT8[R_IO_HH])
#define RSCAN0TMDF112 (RSCAN0.TMDF112.UINT32)
#define RSCAN0TMDF112L (RSCAN0.TMDF112.UINT16[R_IO_L])
#define RSCAN0TMDF112LL (RSCAN0.TMDF112.UINT8[R_IO_LL])
#define RSCAN0TMDF112LH (RSCAN0.TMDF112.UINT8[R_IO_LH])
#define RSCAN0TMDF112H (RSCAN0.TMDF112.UINT16[R_IO_H])
#define RSCAN0TMDF112HL (RSCAN0.TMDF112.UINT8[R_IO_HL])
#define RSCAN0TMDF112HH (RSCAN0.TMDF112.UINT8[R_IO_HH])
#define RSCAN0TMID13 (RSCAN0.TMID13.UINT32)
#define RSCAN0TMID13L (RSCAN0.TMID13.UINT16[R_IO_L])
#define RSCAN0TMID13LL (RSCAN0.TMID13.UINT8[R_IO_LL])
#define RSCAN0TMID13LH (RSCAN0.TMID13.UINT8[R_IO_LH])
#define RSCAN0TMID13H (RSCAN0.TMID13.UINT16[R_IO_H])
#define RSCAN0TMID13HL (RSCAN0.TMID13.UINT8[R_IO_HL])
#define RSCAN0TMID13HH (RSCAN0.TMID13.UINT8[R_IO_HH])
#define RSCAN0TMPTR13 (RSCAN0.TMPTR13.UINT32)
#define RSCAN0TMPTR13L (RSCAN0.TMPTR13.UINT16[R_IO_L])
#define RSCAN0TMPTR13LL (RSCAN0.TMPTR13.UINT8[R_IO_LL])
#define RSCAN0TMPTR13LH (RSCAN0.TMPTR13.UINT8[R_IO_LH])
#define RSCAN0TMPTR13H (RSCAN0.TMPTR13.UINT16[R_IO_H])
#define RSCAN0TMPTR13HL (RSCAN0.TMPTR13.UINT8[R_IO_HL])
#define RSCAN0TMPTR13HH (RSCAN0.TMPTR13.UINT8[R_IO_HH])
#define RSCAN0TMDF013 (RSCAN0.TMDF013.UINT32)
#define RSCAN0TMDF013L (RSCAN0.TMDF013.UINT16[R_IO_L])
#define RSCAN0TMDF013LL (RSCAN0.TMDF013.UINT8[R_IO_LL])
#define RSCAN0TMDF013LH (RSCAN0.TMDF013.UINT8[R_IO_LH])
#define RSCAN0TMDF013H (RSCAN0.TMDF013.UINT16[R_IO_H])
#define RSCAN0TMDF013HL (RSCAN0.TMDF013.UINT8[R_IO_HL])
#define RSCAN0TMDF013HH (RSCAN0.TMDF013.UINT8[R_IO_HH])
#define RSCAN0TMDF113 (RSCAN0.TMDF113.UINT32)
#define RSCAN0TMDF113L (RSCAN0.TMDF113.UINT16[R_IO_L])
#define RSCAN0TMDF113LL (RSCAN0.TMDF113.UINT8[R_IO_LL])
#define RSCAN0TMDF113LH (RSCAN0.TMDF113.UINT8[R_IO_LH])
#define RSCAN0TMDF113H (RSCAN0.TMDF113.UINT16[R_IO_H])
#define RSCAN0TMDF113HL (RSCAN0.TMDF113.UINT8[R_IO_HL])
#define RSCAN0TMDF113HH (RSCAN0.TMDF113.UINT8[R_IO_HH])
#define RSCAN0TMID14 (RSCAN0.TMID14.UINT32)
#define RSCAN0TMID14L (RSCAN0.TMID14.UINT16[R_IO_L])
#define RSCAN0TMID14LL (RSCAN0.TMID14.UINT8[R_IO_LL])
#define RSCAN0TMID14LH (RSCAN0.TMID14.UINT8[R_IO_LH])
#define RSCAN0TMID14H (RSCAN0.TMID14.UINT16[R_IO_H])
#define RSCAN0TMID14HL (RSCAN0.TMID14.UINT8[R_IO_HL])
#define RSCAN0TMID14HH (RSCAN0.TMID14.UINT8[R_IO_HH])
#define RSCAN0TMPTR14 (RSCAN0.TMPTR14.UINT32)
#define RSCAN0TMPTR14L (RSCAN0.TMPTR14.UINT16[R_IO_L])
#define RSCAN0TMPTR14LL (RSCAN0.TMPTR14.UINT8[R_IO_LL])
#define RSCAN0TMPTR14LH (RSCAN0.TMPTR14.UINT8[R_IO_LH])
#define RSCAN0TMPTR14H (RSCAN0.TMPTR14.UINT16[R_IO_H])
#define RSCAN0TMPTR14HL (RSCAN0.TMPTR14.UINT8[R_IO_HL])
#define RSCAN0TMPTR14HH (RSCAN0.TMPTR14.UINT8[R_IO_HH])
#define RSCAN0TMDF014 (RSCAN0.TMDF014.UINT32)
#define RSCAN0TMDF014L (RSCAN0.TMDF014.UINT16[R_IO_L])
#define RSCAN0TMDF014LL (RSCAN0.TMDF014.UINT8[R_IO_LL])
#define RSCAN0TMDF014LH (RSCAN0.TMDF014.UINT8[R_IO_LH])
#define RSCAN0TMDF014H (RSCAN0.TMDF014.UINT16[R_IO_H])
#define RSCAN0TMDF014HL (RSCAN0.TMDF014.UINT8[R_IO_HL])
#define RSCAN0TMDF014HH (RSCAN0.TMDF014.UINT8[R_IO_HH])
#define RSCAN0TMDF114 (RSCAN0.TMDF114.UINT32)
#define RSCAN0TMDF114L (RSCAN0.TMDF114.UINT16[R_IO_L])
#define RSCAN0TMDF114LL (RSCAN0.TMDF114.UINT8[R_IO_LL])
#define RSCAN0TMDF114LH (RSCAN0.TMDF114.UINT8[R_IO_LH])
#define RSCAN0TMDF114H (RSCAN0.TMDF114.UINT16[R_IO_H])
#define RSCAN0TMDF114HL (RSCAN0.TMDF114.UINT8[R_IO_HL])
#define RSCAN0TMDF114HH (RSCAN0.TMDF114.UINT8[R_IO_HH])
#define RSCAN0TMID15 (RSCAN0.TMID15.UINT32)
#define RSCAN0TMID15L (RSCAN0.TMID15.UINT16[R_IO_L])
#define RSCAN0TMID15LL (RSCAN0.TMID15.UINT8[R_IO_LL])
#define RSCAN0TMID15LH (RSCAN0.TMID15.UINT8[R_IO_LH])
#define RSCAN0TMID15H (RSCAN0.TMID15.UINT16[R_IO_H])
#define RSCAN0TMID15HL (RSCAN0.TMID15.UINT8[R_IO_HL])
#define RSCAN0TMID15HH (RSCAN0.TMID15.UINT8[R_IO_HH])
#define RSCAN0TMPTR15 (RSCAN0.TMPTR15.UINT32)
#define RSCAN0TMPTR15L (RSCAN0.TMPTR15.UINT16[R_IO_L])
#define RSCAN0TMPTR15LL (RSCAN0.TMPTR15.UINT8[R_IO_LL])
#define RSCAN0TMPTR15LH (RSCAN0.TMPTR15.UINT8[R_IO_LH])
#define RSCAN0TMPTR15H (RSCAN0.TMPTR15.UINT16[R_IO_H])
#define RSCAN0TMPTR15HL (RSCAN0.TMPTR15.UINT8[R_IO_HL])
#define RSCAN0TMPTR15HH (RSCAN0.TMPTR15.UINT8[R_IO_HH])
#define RSCAN0TMDF015 (RSCAN0.TMDF015.UINT32)
#define RSCAN0TMDF015L (RSCAN0.TMDF015.UINT16[R_IO_L])
#define RSCAN0TMDF015LL (RSCAN0.TMDF015.UINT8[R_IO_LL])
#define RSCAN0TMDF015LH (RSCAN0.TMDF015.UINT8[R_IO_LH])
#define RSCAN0TMDF015H (RSCAN0.TMDF015.UINT16[R_IO_H])
#define RSCAN0TMDF015HL (RSCAN0.TMDF015.UINT8[R_IO_HL])
#define RSCAN0TMDF015HH (RSCAN0.TMDF015.UINT8[R_IO_HH])
#define RSCAN0TMDF115 (RSCAN0.TMDF115.UINT32)
#define RSCAN0TMDF115L (RSCAN0.TMDF115.UINT16[R_IO_L])
#define RSCAN0TMDF115LL (RSCAN0.TMDF115.UINT8[R_IO_LL])
#define RSCAN0TMDF115LH (RSCAN0.TMDF115.UINT8[R_IO_LH])
#define RSCAN0TMDF115H (RSCAN0.TMDF115.UINT16[R_IO_H])
#define RSCAN0TMDF115HL (RSCAN0.TMDF115.UINT8[R_IO_HL])
#define RSCAN0TMDF115HH (RSCAN0.TMDF115.UINT8[R_IO_HH])
#define RSCAN0TMID16 (RSCAN0.TMID16.UINT32)
#define RSCAN0TMID16L (RSCAN0.TMID16.UINT16[R_IO_L])
#define RSCAN0TMID16LL (RSCAN0.TMID16.UINT8[R_IO_LL])
#define RSCAN0TMID16LH (RSCAN0.TMID16.UINT8[R_IO_LH])
#define RSCAN0TMID16H (RSCAN0.TMID16.UINT16[R_IO_H])
#define RSCAN0TMID16HL (RSCAN0.TMID16.UINT8[R_IO_HL])
#define RSCAN0TMID16HH (RSCAN0.TMID16.UINT8[R_IO_HH])
#define RSCAN0TMPTR16 (RSCAN0.TMPTR16.UINT32)
#define RSCAN0TMPTR16L (RSCAN0.TMPTR16.UINT16[R_IO_L])
#define RSCAN0TMPTR16LL (RSCAN0.TMPTR16.UINT8[R_IO_LL])
#define RSCAN0TMPTR16LH (RSCAN0.TMPTR16.UINT8[R_IO_LH])
#define RSCAN0TMPTR16H (RSCAN0.TMPTR16.UINT16[R_IO_H])
#define RSCAN0TMPTR16HL (RSCAN0.TMPTR16.UINT8[R_IO_HL])
#define RSCAN0TMPTR16HH (RSCAN0.TMPTR16.UINT8[R_IO_HH])
#define RSCAN0TMDF016 (RSCAN0.TMDF016.UINT32)
#define RSCAN0TMDF016L (RSCAN0.TMDF016.UINT16[R_IO_L])
#define RSCAN0TMDF016LL (RSCAN0.TMDF016.UINT8[R_IO_LL])
#define RSCAN0TMDF016LH (RSCAN0.TMDF016.UINT8[R_IO_LH])
#define RSCAN0TMDF016H (RSCAN0.TMDF016.UINT16[R_IO_H])
#define RSCAN0TMDF016HL (RSCAN0.TMDF016.UINT8[R_IO_HL])
#define RSCAN0TMDF016HH (RSCAN0.TMDF016.UINT8[R_IO_HH])
#define RSCAN0TMDF116 (RSCAN0.TMDF116.UINT32)
#define RSCAN0TMDF116L (RSCAN0.TMDF116.UINT16[R_IO_L])
#define RSCAN0TMDF116LL (RSCAN0.TMDF116.UINT8[R_IO_LL])
#define RSCAN0TMDF116LH (RSCAN0.TMDF116.UINT8[R_IO_LH])
#define RSCAN0TMDF116H (RSCAN0.TMDF116.UINT16[R_IO_H])
#define RSCAN0TMDF116HL (RSCAN0.TMDF116.UINT8[R_IO_HL])
#define RSCAN0TMDF116HH (RSCAN0.TMDF116.UINT8[R_IO_HH])
#define RSCAN0TMID17 (RSCAN0.TMID17.UINT32)
#define RSCAN0TMID17L (RSCAN0.TMID17.UINT16[R_IO_L])
#define RSCAN0TMID17LL (RSCAN0.TMID17.UINT8[R_IO_LL])
#define RSCAN0TMID17LH (RSCAN0.TMID17.UINT8[R_IO_LH])
#define RSCAN0TMID17H (RSCAN0.TMID17.UINT16[R_IO_H])
#define RSCAN0TMID17HL (RSCAN0.TMID17.UINT8[R_IO_HL])
#define RSCAN0TMID17HH (RSCAN0.TMID17.UINT8[R_IO_HH])
#define RSCAN0TMPTR17 (RSCAN0.TMPTR17.UINT32)
#define RSCAN0TMPTR17L (RSCAN0.TMPTR17.UINT16[R_IO_L])
#define RSCAN0TMPTR17LL (RSCAN0.TMPTR17.UINT8[R_IO_LL])
#define RSCAN0TMPTR17LH (RSCAN0.TMPTR17.UINT8[R_IO_LH])
#define RSCAN0TMPTR17H (RSCAN0.TMPTR17.UINT16[R_IO_H])
#define RSCAN0TMPTR17HL (RSCAN0.TMPTR17.UINT8[R_IO_HL])
#define RSCAN0TMPTR17HH (RSCAN0.TMPTR17.UINT8[R_IO_HH])
#define RSCAN0TMDF017 (RSCAN0.TMDF017.UINT32)
#define RSCAN0TMDF017L (RSCAN0.TMDF017.UINT16[R_IO_L])
#define RSCAN0TMDF017LL (RSCAN0.TMDF017.UINT8[R_IO_LL])
#define RSCAN0TMDF017LH (RSCAN0.TMDF017.UINT8[R_IO_LH])
#define RSCAN0TMDF017H (RSCAN0.TMDF017.UINT16[R_IO_H])
#define RSCAN0TMDF017HL (RSCAN0.TMDF017.UINT8[R_IO_HL])
#define RSCAN0TMDF017HH (RSCAN0.TMDF017.UINT8[R_IO_HH])
#define RSCAN0TMDF117 (RSCAN0.TMDF117.UINT32)
#define RSCAN0TMDF117L (RSCAN0.TMDF117.UINT16[R_IO_L])
#define RSCAN0TMDF117LL (RSCAN0.TMDF117.UINT8[R_IO_LL])
#define RSCAN0TMDF117LH (RSCAN0.TMDF117.UINT8[R_IO_LH])
#define RSCAN0TMDF117H (RSCAN0.TMDF117.UINT16[R_IO_H])
#define RSCAN0TMDF117HL (RSCAN0.TMDF117.UINT8[R_IO_HL])
#define RSCAN0TMDF117HH (RSCAN0.TMDF117.UINT8[R_IO_HH])
#define RSCAN0TMID18 (RSCAN0.TMID18.UINT32)
#define RSCAN0TMID18L (RSCAN0.TMID18.UINT16[R_IO_L])
#define RSCAN0TMID18LL (RSCAN0.TMID18.UINT8[R_IO_LL])
#define RSCAN0TMID18LH (RSCAN0.TMID18.UINT8[R_IO_LH])
#define RSCAN0TMID18H (RSCAN0.TMID18.UINT16[R_IO_H])
#define RSCAN0TMID18HL (RSCAN0.TMID18.UINT8[R_IO_HL])
#define RSCAN0TMID18HH (RSCAN0.TMID18.UINT8[R_IO_HH])
#define RSCAN0TMPTR18 (RSCAN0.TMPTR18.UINT32)
#define RSCAN0TMPTR18L (RSCAN0.TMPTR18.UINT16[R_IO_L])
#define RSCAN0TMPTR18LL (RSCAN0.TMPTR18.UINT8[R_IO_LL])
#define RSCAN0TMPTR18LH (RSCAN0.TMPTR18.UINT8[R_IO_LH])
#define RSCAN0TMPTR18H (RSCAN0.TMPTR18.UINT16[R_IO_H])
#define RSCAN0TMPTR18HL (RSCAN0.TMPTR18.UINT8[R_IO_HL])
#define RSCAN0TMPTR18HH (RSCAN0.TMPTR18.UINT8[R_IO_HH])
#define RSCAN0TMDF018 (RSCAN0.TMDF018.UINT32)
#define RSCAN0TMDF018L (RSCAN0.TMDF018.UINT16[R_IO_L])
#define RSCAN0TMDF018LL (RSCAN0.TMDF018.UINT8[R_IO_LL])
#define RSCAN0TMDF018LH (RSCAN0.TMDF018.UINT8[R_IO_LH])
#define RSCAN0TMDF018H (RSCAN0.TMDF018.UINT16[R_IO_H])
#define RSCAN0TMDF018HL (RSCAN0.TMDF018.UINT8[R_IO_HL])
#define RSCAN0TMDF018HH (RSCAN0.TMDF018.UINT8[R_IO_HH])
#define RSCAN0TMDF118 (RSCAN0.TMDF118.UINT32)
#define RSCAN0TMDF118L (RSCAN0.TMDF118.UINT16[R_IO_L])
#define RSCAN0TMDF118LL (RSCAN0.TMDF118.UINT8[R_IO_LL])
#define RSCAN0TMDF118LH (RSCAN0.TMDF118.UINT8[R_IO_LH])
#define RSCAN0TMDF118H (RSCAN0.TMDF118.UINT16[R_IO_H])
#define RSCAN0TMDF118HL (RSCAN0.TMDF118.UINT8[R_IO_HL])
#define RSCAN0TMDF118HH (RSCAN0.TMDF118.UINT8[R_IO_HH])
#define RSCAN0TMID19 (RSCAN0.TMID19.UINT32)
#define RSCAN0TMID19L (RSCAN0.TMID19.UINT16[R_IO_L])
#define RSCAN0TMID19LL (RSCAN0.TMID19.UINT8[R_IO_LL])
#define RSCAN0TMID19LH (RSCAN0.TMID19.UINT8[R_IO_LH])
#define RSCAN0TMID19H (RSCAN0.TMID19.UINT16[R_IO_H])
#define RSCAN0TMID19HL (RSCAN0.TMID19.UINT8[R_IO_HL])
#define RSCAN0TMID19HH (RSCAN0.TMID19.UINT8[R_IO_HH])
#define RSCAN0TMPTR19 (RSCAN0.TMPTR19.UINT32)
#define RSCAN0TMPTR19L (RSCAN0.TMPTR19.UINT16[R_IO_L])
#define RSCAN0TMPTR19LL (RSCAN0.TMPTR19.UINT8[R_IO_LL])
#define RSCAN0TMPTR19LH (RSCAN0.TMPTR19.UINT8[R_IO_LH])
#define RSCAN0TMPTR19H (RSCAN0.TMPTR19.UINT16[R_IO_H])
#define RSCAN0TMPTR19HL (RSCAN0.TMPTR19.UINT8[R_IO_HL])
#define RSCAN0TMPTR19HH (RSCAN0.TMPTR19.UINT8[R_IO_HH])
#define RSCAN0TMDF019 (RSCAN0.TMDF019.UINT32)
#define RSCAN0TMDF019L (RSCAN0.TMDF019.UINT16[R_IO_L])
#define RSCAN0TMDF019LL (RSCAN0.TMDF019.UINT8[R_IO_LL])
#define RSCAN0TMDF019LH (RSCAN0.TMDF019.UINT8[R_IO_LH])
#define RSCAN0TMDF019H (RSCAN0.TMDF019.UINT16[R_IO_H])
#define RSCAN0TMDF019HL (RSCAN0.TMDF019.UINT8[R_IO_HL])
#define RSCAN0TMDF019HH (RSCAN0.TMDF019.UINT8[R_IO_HH])
#define RSCAN0TMDF119 (RSCAN0.TMDF119.UINT32)
#define RSCAN0TMDF119L (RSCAN0.TMDF119.UINT16[R_IO_L])
#define RSCAN0TMDF119LL (RSCAN0.TMDF119.UINT8[R_IO_LL])
#define RSCAN0TMDF119LH (RSCAN0.TMDF119.UINT8[R_IO_LH])
#define RSCAN0TMDF119H (RSCAN0.TMDF119.UINT16[R_IO_H])
#define RSCAN0TMDF119HL (RSCAN0.TMDF119.UINT8[R_IO_HL])
#define RSCAN0TMDF119HH (RSCAN0.TMDF119.UINT8[R_IO_HH])
#define RSCAN0TMID20 (RSCAN0.TMID20.UINT32)
#define RSCAN0TMID20L (RSCAN0.TMID20.UINT16[R_IO_L])
#define RSCAN0TMID20LL (RSCAN0.TMID20.UINT8[R_IO_LL])
#define RSCAN0TMID20LH (RSCAN0.TMID20.UINT8[R_IO_LH])
#define RSCAN0TMID20H (RSCAN0.TMID20.UINT16[R_IO_H])
#define RSCAN0TMID20HL (RSCAN0.TMID20.UINT8[R_IO_HL])
#define RSCAN0TMID20HH (RSCAN0.TMID20.UINT8[R_IO_HH])
#define RSCAN0TMPTR20 (RSCAN0.TMPTR20.UINT32)
#define RSCAN0TMPTR20L (RSCAN0.TMPTR20.UINT16[R_IO_L])
#define RSCAN0TMPTR20LL (RSCAN0.TMPTR20.UINT8[R_IO_LL])
#define RSCAN0TMPTR20LH (RSCAN0.TMPTR20.UINT8[R_IO_LH])
#define RSCAN0TMPTR20H (RSCAN0.TMPTR20.UINT16[R_IO_H])
#define RSCAN0TMPTR20HL (RSCAN0.TMPTR20.UINT8[R_IO_HL])
#define RSCAN0TMPTR20HH (RSCAN0.TMPTR20.UINT8[R_IO_HH])
#define RSCAN0TMDF020 (RSCAN0.TMDF020.UINT32)
#define RSCAN0TMDF020L (RSCAN0.TMDF020.UINT16[R_IO_L])
#define RSCAN0TMDF020LL (RSCAN0.TMDF020.UINT8[R_IO_LL])
#define RSCAN0TMDF020LH (RSCAN0.TMDF020.UINT8[R_IO_LH])
#define RSCAN0TMDF020H (RSCAN0.TMDF020.UINT16[R_IO_H])
#define RSCAN0TMDF020HL (RSCAN0.TMDF020.UINT8[R_IO_HL])
#define RSCAN0TMDF020HH (RSCAN0.TMDF020.UINT8[R_IO_HH])
#define RSCAN0TMDF120 (RSCAN0.TMDF120.UINT32)
#define RSCAN0TMDF120L (RSCAN0.TMDF120.UINT16[R_IO_L])
#define RSCAN0TMDF120LL (RSCAN0.TMDF120.UINT8[R_IO_LL])
#define RSCAN0TMDF120LH (RSCAN0.TMDF120.UINT8[R_IO_LH])
#define RSCAN0TMDF120H (RSCAN0.TMDF120.UINT16[R_IO_H])
#define RSCAN0TMDF120HL (RSCAN0.TMDF120.UINT8[R_IO_HL])
#define RSCAN0TMDF120HH (RSCAN0.TMDF120.UINT8[R_IO_HH])
#define RSCAN0TMID21 (RSCAN0.TMID21.UINT32)
#define RSCAN0TMID21L (RSCAN0.TMID21.UINT16[R_IO_L])
#define RSCAN0TMID21LL (RSCAN0.TMID21.UINT8[R_IO_LL])
#define RSCAN0TMID21LH (RSCAN0.TMID21.UINT8[R_IO_LH])
#define RSCAN0TMID21H (RSCAN0.TMID21.UINT16[R_IO_H])
#define RSCAN0TMID21HL (RSCAN0.TMID21.UINT8[R_IO_HL])
#define RSCAN0TMID21HH (RSCAN0.TMID21.UINT8[R_IO_HH])
#define RSCAN0TMPTR21 (RSCAN0.TMPTR21.UINT32)
#define RSCAN0TMPTR21L (RSCAN0.TMPTR21.UINT16[R_IO_L])
#define RSCAN0TMPTR21LL (RSCAN0.TMPTR21.UINT8[R_IO_LL])
#define RSCAN0TMPTR21LH (RSCAN0.TMPTR21.UINT8[R_IO_LH])
#define RSCAN0TMPTR21H (RSCAN0.TMPTR21.UINT16[R_IO_H])
#define RSCAN0TMPTR21HL (RSCAN0.TMPTR21.UINT8[R_IO_HL])
#define RSCAN0TMPTR21HH (RSCAN0.TMPTR21.UINT8[R_IO_HH])
#define RSCAN0TMDF021 (RSCAN0.TMDF021.UINT32)
#define RSCAN0TMDF021L (RSCAN0.TMDF021.UINT16[R_IO_L])
#define RSCAN0TMDF021LL (RSCAN0.TMDF021.UINT8[R_IO_LL])
#define RSCAN0TMDF021LH (RSCAN0.TMDF021.UINT8[R_IO_LH])
#define RSCAN0TMDF021H (RSCAN0.TMDF021.UINT16[R_IO_H])
#define RSCAN0TMDF021HL (RSCAN0.TMDF021.UINT8[R_IO_HL])
#define RSCAN0TMDF021HH (RSCAN0.TMDF021.UINT8[R_IO_HH])
#define RSCAN0TMDF121 (RSCAN0.TMDF121.UINT32)
#define RSCAN0TMDF121L (RSCAN0.TMDF121.UINT16[R_IO_L])
#define RSCAN0TMDF121LL (RSCAN0.TMDF121.UINT8[R_IO_LL])
#define RSCAN0TMDF121LH (RSCAN0.TMDF121.UINT8[R_IO_LH])
#define RSCAN0TMDF121H (RSCAN0.TMDF121.UINT16[R_IO_H])
#define RSCAN0TMDF121HL (RSCAN0.TMDF121.UINT8[R_IO_HL])
#define RSCAN0TMDF121HH (RSCAN0.TMDF121.UINT8[R_IO_HH])
#define RSCAN0TMID22 (RSCAN0.TMID22.UINT32)
#define RSCAN0TMID22L (RSCAN0.TMID22.UINT16[R_IO_L])
#define RSCAN0TMID22LL (RSCAN0.TMID22.UINT8[R_IO_LL])
#define RSCAN0TMID22LH (RSCAN0.TMID22.UINT8[R_IO_LH])
#define RSCAN0TMID22H (RSCAN0.TMID22.UINT16[R_IO_H])
#define RSCAN0TMID22HL (RSCAN0.TMID22.UINT8[R_IO_HL])
#define RSCAN0TMID22HH (RSCAN0.TMID22.UINT8[R_IO_HH])
#define RSCAN0TMPTR22 (RSCAN0.TMPTR22.UINT32)
#define RSCAN0TMPTR22L (RSCAN0.TMPTR22.UINT16[R_IO_L])
#define RSCAN0TMPTR22LL (RSCAN0.TMPTR22.UINT8[R_IO_LL])
#define RSCAN0TMPTR22LH (RSCAN0.TMPTR22.UINT8[R_IO_LH])
#define RSCAN0TMPTR22H (RSCAN0.TMPTR22.UINT16[R_IO_H])
#define RSCAN0TMPTR22HL (RSCAN0.TMPTR22.UINT8[R_IO_HL])
#define RSCAN0TMPTR22HH (RSCAN0.TMPTR22.UINT8[R_IO_HH])
#define RSCAN0TMDF022 (RSCAN0.TMDF022.UINT32)
#define RSCAN0TMDF022L (RSCAN0.TMDF022.UINT16[R_IO_L])
#define RSCAN0TMDF022LL (RSCAN0.TMDF022.UINT8[R_IO_LL])
#define RSCAN0TMDF022LH (RSCAN0.TMDF022.UINT8[R_IO_LH])
#define RSCAN0TMDF022H (RSCAN0.TMDF022.UINT16[R_IO_H])
#define RSCAN0TMDF022HL (RSCAN0.TMDF022.UINT8[R_IO_HL])
#define RSCAN0TMDF022HH (RSCAN0.TMDF022.UINT8[R_IO_HH])
#define RSCAN0TMDF122 (RSCAN0.TMDF122.UINT32)
#define RSCAN0TMDF122L (RSCAN0.TMDF122.UINT16[R_IO_L])
#define RSCAN0TMDF122LL (RSCAN0.TMDF122.UINT8[R_IO_LL])
#define RSCAN0TMDF122LH (RSCAN0.TMDF122.UINT8[R_IO_LH])
#define RSCAN0TMDF122H (RSCAN0.TMDF122.UINT16[R_IO_H])
#define RSCAN0TMDF122HL (RSCAN0.TMDF122.UINT8[R_IO_HL])
#define RSCAN0TMDF122HH (RSCAN0.TMDF122.UINT8[R_IO_HH])
#define RSCAN0TMID23 (RSCAN0.TMID23.UINT32)
#define RSCAN0TMID23L (RSCAN0.TMID23.UINT16[R_IO_L])
#define RSCAN0TMID23LL (RSCAN0.TMID23.UINT8[R_IO_LL])
#define RSCAN0TMID23LH (RSCAN0.TMID23.UINT8[R_IO_LH])
#define RSCAN0TMID23H (RSCAN0.TMID23.UINT16[R_IO_H])
#define RSCAN0TMID23HL (RSCAN0.TMID23.UINT8[R_IO_HL])
#define RSCAN0TMID23HH (RSCAN0.TMID23.UINT8[R_IO_HH])
#define RSCAN0TMPTR23 (RSCAN0.TMPTR23.UINT32)
#define RSCAN0TMPTR23L (RSCAN0.TMPTR23.UINT16[R_IO_L])
#define RSCAN0TMPTR23LL (RSCAN0.TMPTR23.UINT8[R_IO_LL])
#define RSCAN0TMPTR23LH (RSCAN0.TMPTR23.UINT8[R_IO_LH])
#define RSCAN0TMPTR23H (RSCAN0.TMPTR23.UINT16[R_IO_H])
#define RSCAN0TMPTR23HL (RSCAN0.TMPTR23.UINT8[R_IO_HL])
#define RSCAN0TMPTR23HH (RSCAN0.TMPTR23.UINT8[R_IO_HH])
#define RSCAN0TMDF023 (RSCAN0.TMDF023.UINT32)
#define RSCAN0TMDF023L (RSCAN0.TMDF023.UINT16[R_IO_L])
#define RSCAN0TMDF023LL (RSCAN0.TMDF023.UINT8[R_IO_LL])
#define RSCAN0TMDF023LH (RSCAN0.TMDF023.UINT8[R_IO_LH])
#define RSCAN0TMDF023H (RSCAN0.TMDF023.UINT16[R_IO_H])
#define RSCAN0TMDF023HL (RSCAN0.TMDF023.UINT8[R_IO_HL])
#define RSCAN0TMDF023HH (RSCAN0.TMDF023.UINT8[R_IO_HH])
#define RSCAN0TMDF123 (RSCAN0.TMDF123.UINT32)
#define RSCAN0TMDF123L (RSCAN0.TMDF123.UINT16[R_IO_L])
#define RSCAN0TMDF123LL (RSCAN0.TMDF123.UINT8[R_IO_LL])
#define RSCAN0TMDF123LH (RSCAN0.TMDF123.UINT8[R_IO_LH])
#define RSCAN0TMDF123H (RSCAN0.TMDF123.UINT16[R_IO_H])
#define RSCAN0TMDF123HL (RSCAN0.TMDF123.UINT8[R_IO_HL])
#define RSCAN0TMDF123HH (RSCAN0.TMDF123.UINT8[R_IO_HH])
#define RSCAN0TMID24 (RSCAN0.TMID24.UINT32)
#define RSCAN0TMID24L (RSCAN0.TMID24.UINT16[R_IO_L])
#define RSCAN0TMID24LL (RSCAN0.TMID24.UINT8[R_IO_LL])
#define RSCAN0TMID24LH (RSCAN0.TMID24.UINT8[R_IO_LH])
#define RSCAN0TMID24H (RSCAN0.TMID24.UINT16[R_IO_H])
#define RSCAN0TMID24HL (RSCAN0.TMID24.UINT8[R_IO_HL])
#define RSCAN0TMID24HH (RSCAN0.TMID24.UINT8[R_IO_HH])
#define RSCAN0TMPTR24 (RSCAN0.TMPTR24.UINT32)
#define RSCAN0TMPTR24L (RSCAN0.TMPTR24.UINT16[R_IO_L])
#define RSCAN0TMPTR24LL (RSCAN0.TMPTR24.UINT8[R_IO_LL])
#define RSCAN0TMPTR24LH (RSCAN0.TMPTR24.UINT8[R_IO_LH])
#define RSCAN0TMPTR24H (RSCAN0.TMPTR24.UINT16[R_IO_H])
#define RSCAN0TMPTR24HL (RSCAN0.TMPTR24.UINT8[R_IO_HL])
#define RSCAN0TMPTR24HH (RSCAN0.TMPTR24.UINT8[R_IO_HH])
#define RSCAN0TMDF024 (RSCAN0.TMDF024.UINT32)
#define RSCAN0TMDF024L (RSCAN0.TMDF024.UINT16[R_IO_L])
#define RSCAN0TMDF024LL (RSCAN0.TMDF024.UINT8[R_IO_LL])
#define RSCAN0TMDF024LH (RSCAN0.TMDF024.UINT8[R_IO_LH])
#define RSCAN0TMDF024H (RSCAN0.TMDF024.UINT16[R_IO_H])
#define RSCAN0TMDF024HL (RSCAN0.TMDF024.UINT8[R_IO_HL])
#define RSCAN0TMDF024HH (RSCAN0.TMDF024.UINT8[R_IO_HH])
#define RSCAN0TMDF124 (RSCAN0.TMDF124.UINT32)
#define RSCAN0TMDF124L (RSCAN0.TMDF124.UINT16[R_IO_L])
#define RSCAN0TMDF124LL (RSCAN0.TMDF124.UINT8[R_IO_LL])
#define RSCAN0TMDF124LH (RSCAN0.TMDF124.UINT8[R_IO_LH])
#define RSCAN0TMDF124H (RSCAN0.TMDF124.UINT16[R_IO_H])
#define RSCAN0TMDF124HL (RSCAN0.TMDF124.UINT8[R_IO_HL])
#define RSCAN0TMDF124HH (RSCAN0.TMDF124.UINT8[R_IO_HH])
#define RSCAN0TMID25 (RSCAN0.TMID25.UINT32)
#define RSCAN0TMID25L (RSCAN0.TMID25.UINT16[R_IO_L])
#define RSCAN0TMID25LL (RSCAN0.TMID25.UINT8[R_IO_LL])
#define RSCAN0TMID25LH (RSCAN0.TMID25.UINT8[R_IO_LH])
#define RSCAN0TMID25H (RSCAN0.TMID25.UINT16[R_IO_H])
#define RSCAN0TMID25HL (RSCAN0.TMID25.UINT8[R_IO_HL])
#define RSCAN0TMID25HH (RSCAN0.TMID25.UINT8[R_IO_HH])
#define RSCAN0TMPTR25 (RSCAN0.TMPTR25.UINT32)
#define RSCAN0TMPTR25L (RSCAN0.TMPTR25.UINT16[R_IO_L])
#define RSCAN0TMPTR25LL (RSCAN0.TMPTR25.UINT8[R_IO_LL])
#define RSCAN0TMPTR25LH (RSCAN0.TMPTR25.UINT8[R_IO_LH])
#define RSCAN0TMPTR25H (RSCAN0.TMPTR25.UINT16[R_IO_H])
#define RSCAN0TMPTR25HL (RSCAN0.TMPTR25.UINT8[R_IO_HL])
#define RSCAN0TMPTR25HH (RSCAN0.TMPTR25.UINT8[R_IO_HH])
#define RSCAN0TMDF025 (RSCAN0.TMDF025.UINT32)
#define RSCAN0TMDF025L (RSCAN0.TMDF025.UINT16[R_IO_L])
#define RSCAN0TMDF025LL (RSCAN0.TMDF025.UINT8[R_IO_LL])
#define RSCAN0TMDF025LH (RSCAN0.TMDF025.UINT8[R_IO_LH])
#define RSCAN0TMDF025H (RSCAN0.TMDF025.UINT16[R_IO_H])
#define RSCAN0TMDF025HL (RSCAN0.TMDF025.UINT8[R_IO_HL])
#define RSCAN0TMDF025HH (RSCAN0.TMDF025.UINT8[R_IO_HH])
#define RSCAN0TMDF125 (RSCAN0.TMDF125.UINT32)
#define RSCAN0TMDF125L (RSCAN0.TMDF125.UINT16[R_IO_L])
#define RSCAN0TMDF125LL (RSCAN0.TMDF125.UINT8[R_IO_LL])
#define RSCAN0TMDF125LH (RSCAN0.TMDF125.UINT8[R_IO_LH])
#define RSCAN0TMDF125H (RSCAN0.TMDF125.UINT16[R_IO_H])
#define RSCAN0TMDF125HL (RSCAN0.TMDF125.UINT8[R_IO_HL])
#define RSCAN0TMDF125HH (RSCAN0.TMDF125.UINT8[R_IO_HH])
#define RSCAN0TMID26 (RSCAN0.TMID26.UINT32)
#define RSCAN0TMID26L (RSCAN0.TMID26.UINT16[R_IO_L])
#define RSCAN0TMID26LL (RSCAN0.TMID26.UINT8[R_IO_LL])
#define RSCAN0TMID26LH (RSCAN0.TMID26.UINT8[R_IO_LH])
#define RSCAN0TMID26H (RSCAN0.TMID26.UINT16[R_IO_H])
#define RSCAN0TMID26HL (RSCAN0.TMID26.UINT8[R_IO_HL])
#define RSCAN0TMID26HH (RSCAN0.TMID26.UINT8[R_IO_HH])
#define RSCAN0TMPTR26 (RSCAN0.TMPTR26.UINT32)
#define RSCAN0TMPTR26L (RSCAN0.TMPTR26.UINT16[R_IO_L])
#define RSCAN0TMPTR26LL (RSCAN0.TMPTR26.UINT8[R_IO_LL])
#define RSCAN0TMPTR26LH (RSCAN0.TMPTR26.UINT8[R_IO_LH])
#define RSCAN0TMPTR26H (RSCAN0.TMPTR26.UINT16[R_IO_H])
#define RSCAN0TMPTR26HL (RSCAN0.TMPTR26.UINT8[R_IO_HL])
#define RSCAN0TMPTR26HH (RSCAN0.TMPTR26.UINT8[R_IO_HH])
#define RSCAN0TMDF026 (RSCAN0.TMDF026.UINT32)
#define RSCAN0TMDF026L (RSCAN0.TMDF026.UINT16[R_IO_L])
#define RSCAN0TMDF026LL (RSCAN0.TMDF026.UINT8[R_IO_LL])
#define RSCAN0TMDF026LH (RSCAN0.TMDF026.UINT8[R_IO_LH])
#define RSCAN0TMDF026H (RSCAN0.TMDF026.UINT16[R_IO_H])
#define RSCAN0TMDF026HL (RSCAN0.TMDF026.UINT8[R_IO_HL])
#define RSCAN0TMDF026HH (RSCAN0.TMDF026.UINT8[R_IO_HH])
#define RSCAN0TMDF126 (RSCAN0.TMDF126.UINT32)
#define RSCAN0TMDF126L (RSCAN0.TMDF126.UINT16[R_IO_L])
#define RSCAN0TMDF126LL (RSCAN0.TMDF126.UINT8[R_IO_LL])
#define RSCAN0TMDF126LH (RSCAN0.TMDF126.UINT8[R_IO_LH])
#define RSCAN0TMDF126H (RSCAN0.TMDF126.UINT16[R_IO_H])
#define RSCAN0TMDF126HL (RSCAN0.TMDF126.UINT8[R_IO_HL])
#define RSCAN0TMDF126HH (RSCAN0.TMDF126.UINT8[R_IO_HH])
#define RSCAN0TMID27 (RSCAN0.TMID27.UINT32)
#define RSCAN0TMID27L (RSCAN0.TMID27.UINT16[R_IO_L])
#define RSCAN0TMID27LL (RSCAN0.TMID27.UINT8[R_IO_LL])
#define RSCAN0TMID27LH (RSCAN0.TMID27.UINT8[R_IO_LH])
#define RSCAN0TMID27H (RSCAN0.TMID27.UINT16[R_IO_H])
#define RSCAN0TMID27HL (RSCAN0.TMID27.UINT8[R_IO_HL])
#define RSCAN0TMID27HH (RSCAN0.TMID27.UINT8[R_IO_HH])
#define RSCAN0TMPTR27 (RSCAN0.TMPTR27.UINT32)
#define RSCAN0TMPTR27L (RSCAN0.TMPTR27.UINT16[R_IO_L])
#define RSCAN0TMPTR27LL (RSCAN0.TMPTR27.UINT8[R_IO_LL])
#define RSCAN0TMPTR27LH (RSCAN0.TMPTR27.UINT8[R_IO_LH])
#define RSCAN0TMPTR27H (RSCAN0.TMPTR27.UINT16[R_IO_H])
#define RSCAN0TMPTR27HL (RSCAN0.TMPTR27.UINT8[R_IO_HL])
#define RSCAN0TMPTR27HH (RSCAN0.TMPTR27.UINT8[R_IO_HH])
#define RSCAN0TMDF027 (RSCAN0.TMDF027.UINT32)
#define RSCAN0TMDF027L (RSCAN0.TMDF027.UINT16[R_IO_L])
#define RSCAN0TMDF027LL (RSCAN0.TMDF027.UINT8[R_IO_LL])
#define RSCAN0TMDF027LH (RSCAN0.TMDF027.UINT8[R_IO_LH])
#define RSCAN0TMDF027H (RSCAN0.TMDF027.UINT16[R_IO_H])
#define RSCAN0TMDF027HL (RSCAN0.TMDF027.UINT8[R_IO_HL])
#define RSCAN0TMDF027HH (RSCAN0.TMDF027.UINT8[R_IO_HH])
#define RSCAN0TMDF127 (RSCAN0.TMDF127.UINT32)
#define RSCAN0TMDF127L (RSCAN0.TMDF127.UINT16[R_IO_L])
#define RSCAN0TMDF127LL (RSCAN0.TMDF127.UINT8[R_IO_LL])
#define RSCAN0TMDF127LH (RSCAN0.TMDF127.UINT8[R_IO_LH])
#define RSCAN0TMDF127H (RSCAN0.TMDF127.UINT16[R_IO_H])
#define RSCAN0TMDF127HL (RSCAN0.TMDF127.UINT8[R_IO_HL])
#define RSCAN0TMDF127HH (RSCAN0.TMDF127.UINT8[R_IO_HH])
#define RSCAN0TMID28 (RSCAN0.TMID28.UINT32)
#define RSCAN0TMID28L (RSCAN0.TMID28.UINT16[R_IO_L])
#define RSCAN0TMID28LL (RSCAN0.TMID28.UINT8[R_IO_LL])
#define RSCAN0TMID28LH (RSCAN0.TMID28.UINT8[R_IO_LH])
#define RSCAN0TMID28H (RSCAN0.TMID28.UINT16[R_IO_H])
#define RSCAN0TMID28HL (RSCAN0.TMID28.UINT8[R_IO_HL])
#define RSCAN0TMID28HH (RSCAN0.TMID28.UINT8[R_IO_HH])
#define RSCAN0TMPTR28 (RSCAN0.TMPTR28.UINT32)
#define RSCAN0TMPTR28L (RSCAN0.TMPTR28.UINT16[R_IO_L])
#define RSCAN0TMPTR28LL (RSCAN0.TMPTR28.UINT8[R_IO_LL])
#define RSCAN0TMPTR28LH (RSCAN0.TMPTR28.UINT8[R_IO_LH])
#define RSCAN0TMPTR28H (RSCAN0.TMPTR28.UINT16[R_IO_H])
#define RSCAN0TMPTR28HL (RSCAN0.TMPTR28.UINT8[R_IO_HL])
#define RSCAN0TMPTR28HH (RSCAN0.TMPTR28.UINT8[R_IO_HH])
#define RSCAN0TMDF028 (RSCAN0.TMDF028.UINT32)
#define RSCAN0TMDF028L (RSCAN0.TMDF028.UINT16[R_IO_L])
#define RSCAN0TMDF028LL (RSCAN0.TMDF028.UINT8[R_IO_LL])
#define RSCAN0TMDF028LH (RSCAN0.TMDF028.UINT8[R_IO_LH])
#define RSCAN0TMDF028H (RSCAN0.TMDF028.UINT16[R_IO_H])
#define RSCAN0TMDF028HL (RSCAN0.TMDF028.UINT8[R_IO_HL])
#define RSCAN0TMDF028HH (RSCAN0.TMDF028.UINT8[R_IO_HH])
#define RSCAN0TMDF128 (RSCAN0.TMDF128.UINT32)
#define RSCAN0TMDF128L (RSCAN0.TMDF128.UINT16[R_IO_L])
#define RSCAN0TMDF128LL (RSCAN0.TMDF128.UINT8[R_IO_LL])
#define RSCAN0TMDF128LH (RSCAN0.TMDF128.UINT8[R_IO_LH])
#define RSCAN0TMDF128H (RSCAN0.TMDF128.UINT16[R_IO_H])
#define RSCAN0TMDF128HL (RSCAN0.TMDF128.UINT8[R_IO_HL])
#define RSCAN0TMDF128HH (RSCAN0.TMDF128.UINT8[R_IO_HH])
#define RSCAN0TMID29 (RSCAN0.TMID29.UINT32)
#define RSCAN0TMID29L (RSCAN0.TMID29.UINT16[R_IO_L])
#define RSCAN0TMID29LL (RSCAN0.TMID29.UINT8[R_IO_LL])
#define RSCAN0TMID29LH (RSCAN0.TMID29.UINT8[R_IO_LH])
#define RSCAN0TMID29H (RSCAN0.TMID29.UINT16[R_IO_H])
#define RSCAN0TMID29HL (RSCAN0.TMID29.UINT8[R_IO_HL])
#define RSCAN0TMID29HH (RSCAN0.TMID29.UINT8[R_IO_HH])
#define RSCAN0TMPTR29 (RSCAN0.TMPTR29.UINT32)
#define RSCAN0TMPTR29L (RSCAN0.TMPTR29.UINT16[R_IO_L])
#define RSCAN0TMPTR29LL (RSCAN0.TMPTR29.UINT8[R_IO_LL])
#define RSCAN0TMPTR29LH (RSCAN0.TMPTR29.UINT8[R_IO_LH])
#define RSCAN0TMPTR29H (RSCAN0.TMPTR29.UINT16[R_IO_H])
#define RSCAN0TMPTR29HL (RSCAN0.TMPTR29.UINT8[R_IO_HL])
#define RSCAN0TMPTR29HH (RSCAN0.TMPTR29.UINT8[R_IO_HH])
#define RSCAN0TMDF029 (RSCAN0.TMDF029.UINT32)
#define RSCAN0TMDF029L (RSCAN0.TMDF029.UINT16[R_IO_L])
#define RSCAN0TMDF029LL (RSCAN0.TMDF029.UINT8[R_IO_LL])
#define RSCAN0TMDF029LH (RSCAN0.TMDF029.UINT8[R_IO_LH])
#define RSCAN0TMDF029H (RSCAN0.TMDF029.UINT16[R_IO_H])
#define RSCAN0TMDF029HL (RSCAN0.TMDF029.UINT8[R_IO_HL])
#define RSCAN0TMDF029HH (RSCAN0.TMDF029.UINT8[R_IO_HH])
#define RSCAN0TMDF129 (RSCAN0.TMDF129.UINT32)
#define RSCAN0TMDF129L (RSCAN0.TMDF129.UINT16[R_IO_L])
#define RSCAN0TMDF129LL (RSCAN0.TMDF129.UINT8[R_IO_LL])
#define RSCAN0TMDF129LH (RSCAN0.TMDF129.UINT8[R_IO_LH])
#define RSCAN0TMDF129H (RSCAN0.TMDF129.UINT16[R_IO_H])
#define RSCAN0TMDF129HL (RSCAN0.TMDF129.UINT8[R_IO_HL])
#define RSCAN0TMDF129HH (RSCAN0.TMDF129.UINT8[R_IO_HH])
#define RSCAN0TMID30 (RSCAN0.TMID30.UINT32)
#define RSCAN0TMID30L (RSCAN0.TMID30.UINT16[R_IO_L])
#define RSCAN0TMID30LL (RSCAN0.TMID30.UINT8[R_IO_LL])
#define RSCAN0TMID30LH (RSCAN0.TMID30.UINT8[R_IO_LH])
#define RSCAN0TMID30H (RSCAN0.TMID30.UINT16[R_IO_H])
#define RSCAN0TMID30HL (RSCAN0.TMID30.UINT8[R_IO_HL])
#define RSCAN0TMID30HH (RSCAN0.TMID30.UINT8[R_IO_HH])
#define RSCAN0TMPTR30 (RSCAN0.TMPTR30.UINT32)
#define RSCAN0TMPTR30L (RSCAN0.TMPTR30.UINT16[R_IO_L])
#define RSCAN0TMPTR30LL (RSCAN0.TMPTR30.UINT8[R_IO_LL])
#define RSCAN0TMPTR30LH (RSCAN0.TMPTR30.UINT8[R_IO_LH])
#define RSCAN0TMPTR30H (RSCAN0.TMPTR30.UINT16[R_IO_H])
#define RSCAN0TMPTR30HL (RSCAN0.TMPTR30.UINT8[R_IO_HL])
#define RSCAN0TMPTR30HH (RSCAN0.TMPTR30.UINT8[R_IO_HH])
#define RSCAN0TMDF030 (RSCAN0.TMDF030.UINT32)
#define RSCAN0TMDF030L (RSCAN0.TMDF030.UINT16[R_IO_L])
#define RSCAN0TMDF030LL (RSCAN0.TMDF030.UINT8[R_IO_LL])
#define RSCAN0TMDF030LH (RSCAN0.TMDF030.UINT8[R_IO_LH])
#define RSCAN0TMDF030H (RSCAN0.TMDF030.UINT16[R_IO_H])
#define RSCAN0TMDF030HL (RSCAN0.TMDF030.UINT8[R_IO_HL])
#define RSCAN0TMDF030HH (RSCAN0.TMDF030.UINT8[R_IO_HH])
#define RSCAN0TMDF130 (RSCAN0.TMDF130.UINT32)
#define RSCAN0TMDF130L (RSCAN0.TMDF130.UINT16[R_IO_L])
#define RSCAN0TMDF130LL (RSCAN0.TMDF130.UINT8[R_IO_LL])
#define RSCAN0TMDF130LH (RSCAN0.TMDF130.UINT8[R_IO_LH])
#define RSCAN0TMDF130H (RSCAN0.TMDF130.UINT16[R_IO_H])
#define RSCAN0TMDF130HL (RSCAN0.TMDF130.UINT8[R_IO_HL])
#define RSCAN0TMDF130HH (RSCAN0.TMDF130.UINT8[R_IO_HH])
#define RSCAN0TMID31 (RSCAN0.TMID31.UINT32)
#define RSCAN0TMID31L (RSCAN0.TMID31.UINT16[R_IO_L])
#define RSCAN0TMID31LL (RSCAN0.TMID31.UINT8[R_IO_LL])
#define RSCAN0TMID31LH (RSCAN0.TMID31.UINT8[R_IO_LH])
#define RSCAN0TMID31H (RSCAN0.TMID31.UINT16[R_IO_H])
#define RSCAN0TMID31HL (RSCAN0.TMID31.UINT8[R_IO_HL])
#define RSCAN0TMID31HH (RSCAN0.TMID31.UINT8[R_IO_HH])
#define RSCAN0TMPTR31 (RSCAN0.TMPTR31.UINT32)
#define RSCAN0TMPTR31L (RSCAN0.TMPTR31.UINT16[R_IO_L])
#define RSCAN0TMPTR31LL (RSCAN0.TMPTR31.UINT8[R_IO_LL])
#define RSCAN0TMPTR31LH (RSCAN0.TMPTR31.UINT8[R_IO_LH])
#define RSCAN0TMPTR31H (RSCAN0.TMPTR31.UINT16[R_IO_H])
#define RSCAN0TMPTR31HL (RSCAN0.TMPTR31.UINT8[R_IO_HL])
#define RSCAN0TMPTR31HH (RSCAN0.TMPTR31.UINT8[R_IO_HH])
#define RSCAN0TMDF031 (RSCAN0.TMDF031.UINT32)
#define RSCAN0TMDF031L (RSCAN0.TMDF031.UINT16[R_IO_L])
#define RSCAN0TMDF031LL (RSCAN0.TMDF031.UINT8[R_IO_LL])
#define RSCAN0TMDF031LH (RSCAN0.TMDF031.UINT8[R_IO_LH])
#define RSCAN0TMDF031H (RSCAN0.TMDF031.UINT16[R_IO_H])
#define RSCAN0TMDF031HL (RSCAN0.TMDF031.UINT8[R_IO_HL])
#define RSCAN0TMDF031HH (RSCAN0.TMDF031.UINT8[R_IO_HH])
#define RSCAN0TMDF131 (RSCAN0.TMDF131.UINT32)
#define RSCAN0TMDF131L (RSCAN0.TMDF131.UINT16[R_IO_L])
#define RSCAN0TMDF131LL (RSCAN0.TMDF131.UINT8[R_IO_LL])
#define RSCAN0TMDF131LH (RSCAN0.TMDF131.UINT8[R_IO_LH])
#define RSCAN0TMDF131H (RSCAN0.TMDF131.UINT16[R_IO_H])
#define RSCAN0TMDF131HL (RSCAN0.TMDF131.UINT8[R_IO_HL])
#define RSCAN0TMDF131HH (RSCAN0.TMDF131.UINT8[R_IO_HH])
#define RSCAN0THLACC0 (RSCAN0.THLACC0.UINT32)
#define RSCAN0THLACC0L (RSCAN0.THLACC0.UINT16[R_IO_L])
#define RSCAN0THLACC0LL (RSCAN0.THLACC0.UINT8[R_IO_LL])
#define RSCAN0THLACC0LH (RSCAN0.THLACC0.UINT8[R_IO_LH])
#define RSCAN0THLACC0H (RSCAN0.THLACC0.UINT16[R_IO_H])
#define RSCAN0THLACC0HL (RSCAN0.THLACC0.UINT8[R_IO_HL])
#define RSCAN0THLACC0HH (RSCAN0.THLACC0.UINT8[R_IO_HH])
#define RSCAN0THLACC1 (RSCAN0.THLACC1.UINT32)
#define RSCAN0THLACC1L (RSCAN0.THLACC1.UINT16[R_IO_L])
#define RSCAN0THLACC1LL (RSCAN0.THLACC1.UINT8[R_IO_LL])
#define RSCAN0THLACC1LH (RSCAN0.THLACC1.UINT8[R_IO_LH])
#define RSCAN0THLACC1H (RSCAN0.THLACC1.UINT16[R_IO_H])
#define RSCAN0THLACC1HL (RSCAN0.THLACC1.UINT8[R_IO_HL])
#define RSCAN0THLACC1HH (RSCAN0.THLACC1.UINT8[R_IO_HH])

#define RSCAN0_GAFLCFG0_COUNT (1)
#define RSCAN0_RMND0_COUNT (1)
#define RSCAN0_RFCC0_COUNT (8)
#define RSCAN0_RFSTS0_COUNT (8)
#define RSCAN0_RFPCTR0_COUNT (8)
#define RSCAN0_CFCC0_COUNT (6)
#define RSCAN0_CFSTS0_COUNT (6)
#define RSCAN0_CFPCTR0_COUNT (6)
#define RSCAN0_TMC0_COUNT (32)
#define RSCAN0_TMSTS0_COUNT (32)
#define RSCAN0_TMTRSTS0_COUNT (1)
#define RSCAN0_TMTARSTS0_COUNT (1)
#define RSCAN0_TMTCSTS0_COUNT (1)
#define RSCAN0_TMTASTS0_COUNT (1)
#define RSCAN0_TMIEC0_COUNT (1)
#define RSCAN0_TXQCC0_COUNT (2)
#define RSCAN0_TXQSTS0_COUNT (2)
#define RSCAN0_TXQPCTR0_COUNT (2)
#define RSCAN0_THLCC0_COUNT (2)
#define RSCAN0_THLSTS0_COUNT (2)
#define RSCAN0_THLPCTR0_COUNT (2)
#define RSCAN0_GTINTSTS0_COUNT (1)
#define RSCAN0_THLACC0_COUNT (2)


typedef struct st_rscan0
{
                                                           /* RSCAN0           */

/* start of struct st_rscan_from_rscan0cncfg */
    union iodefine_reg32_t  C0CFG;                         /*  C0CFG           */
    union iodefine_reg32_t  C0CTR;                         /*  C0CTR           */
    union iodefine_reg32_t  C0STS;                         /*  C0STS           */
    union iodefine_reg32_t  C0ERFL;                        /*  C0ERFL          */

/* end of struct st_rscan_from_rscan0cncfg */
    
/* start of struct st_rscan_from_rscan0cncfg */
    union iodefine_reg32_t  C1CFG;                         /*  C1CFG           */
    union iodefine_reg32_t  C1CTR;                         /*  C1CTR           */
    union iodefine_reg32_t  C1STS;                         /*  C1STS           */
    union iodefine_reg32_t  C1ERFL;                        /*  C1ERFL          */

/* end of struct st_rscan_from_rscan0cncfg */
    
    volatile uint8_t   dummy159[100];                          /*                  */
    union iodefine_reg32_t  GCFG;                          /*  GCFG            */
    union iodefine_reg32_t  GCTR;                          /*  GCTR            */
    union iodefine_reg32_t  GSTS;                          /*  GSTS            */
    union iodefine_reg32_t  GERFL;                         /*  GERFL           */
    union iodefine_reg32_16_t  GTSC;                       /*  GTSC            */
    union iodefine_reg32_t  GAFLECTR;                      /*  GAFLECTR        */

/* #define RSCAN0_GAFLCFG0_COUNT (1) */
    union iodefine_reg32_t  GAFLCFG0;                      /*  GAFLCFG0        */
    
    volatile uint8_t   dummy160[4];                            /*                  */
    union iodefine_reg32_t  RMNB;                          /*  RMNB            */

/* #define RSCAN0_RMND0_COUNT (1) */
    union iodefine_reg32_t  RMND0;                         /*  RMND0           */
    
    volatile uint8_t   dummy161[12];                           /*                  */

/* #define RSCAN0_RFCC0_COUNT (8) */
    union iodefine_reg32_t  RFCC0;                         /*  RFCC0           */
    union iodefine_reg32_t  RFCC1;                         /*  RFCC1           */
    union iodefine_reg32_t  RFCC2;                         /*  RFCC2           */
    union iodefine_reg32_t  RFCC3;                         /*  RFCC3           */
    union iodefine_reg32_t  RFCC4;                         /*  RFCC4           */
    union iodefine_reg32_t  RFCC5;                         /*  RFCC5           */
    union iodefine_reg32_t  RFCC6;                         /*  RFCC6           */
    union iodefine_reg32_t  RFCC7;                         /*  RFCC7           */

/* #define RSCAN0_RFSTS0_COUNT (8) */
    union iodefine_reg32_t  RFSTS0;                        /*  RFSTS0          */
    union iodefine_reg32_t  RFSTS1;                        /*  RFSTS1          */
    union iodefine_reg32_t  RFSTS2;                        /*  RFSTS2          */
    union iodefine_reg32_t  RFSTS3;                        /*  RFSTS3          */
    union iodefine_reg32_t  RFSTS4;                        /*  RFSTS4          */
    union iodefine_reg32_t  RFSTS5;                        /*  RFSTS5          */
    union iodefine_reg32_t  RFSTS6;                        /*  RFSTS6          */
    union iodefine_reg32_t  RFSTS7;                        /*  RFSTS7          */

/* #define RSCAN0_RFPCTR0_COUNT (8) */
    union iodefine_reg32_t  RFPCTR0;                       /*  RFPCTR0         */
    union iodefine_reg32_t  RFPCTR1;                       /*  RFPCTR1         */
    union iodefine_reg32_t  RFPCTR2;                       /*  RFPCTR2         */
    union iodefine_reg32_t  RFPCTR3;                       /*  RFPCTR3         */
    union iodefine_reg32_t  RFPCTR4;                       /*  RFPCTR4         */
    union iodefine_reg32_t  RFPCTR5;                       /*  RFPCTR5         */
    union iodefine_reg32_t  RFPCTR6;                       /*  RFPCTR6         */
    union iodefine_reg32_t  RFPCTR7;                       /*  RFPCTR7         */

/* #define RSCAN0_CFCC0_COUNT (6) */
    union iodefine_reg32_t  CFCC0;                         /*  CFCC0           */
    union iodefine_reg32_t  CFCC1;                         /*  CFCC1           */
    union iodefine_reg32_t  CFCC2;                         /*  CFCC2           */
    union iodefine_reg32_t  CFCC3;                         /*  CFCC3           */
    union iodefine_reg32_t  CFCC4;                         /*  CFCC4           */
    union iodefine_reg32_t  CFCC5;                         /*  CFCC5           */
    
    volatile uint8_t   dummy162[72];                           /*                  */

/* #define RSCAN0_CFSTS0_COUNT (6) */
    union iodefine_reg32_t  CFSTS0;                        /*  CFSTS0          */
    union iodefine_reg32_t  CFSTS1;                        /*  CFSTS1          */
    union iodefine_reg32_t  CFSTS2;                        /*  CFSTS2          */
    union iodefine_reg32_t  CFSTS3;                        /*  CFSTS3          */
    union iodefine_reg32_t  CFSTS4;                        /*  CFSTS4          */
    union iodefine_reg32_t  CFSTS5;                        /*  CFSTS5          */
    
    volatile uint8_t   dummy163[72];                           /*                  */

/* #define RSCAN0_CFPCTR0_COUNT (6) */
    union iodefine_reg32_t  CFPCTR0;                       /*  CFPCTR0         */
    union iodefine_reg32_t  CFPCTR1;                       /*  CFPCTR1         */
    union iodefine_reg32_t  CFPCTR2;                       /*  CFPCTR2         */
    union iodefine_reg32_t  CFPCTR3;                       /*  CFPCTR3         */
    union iodefine_reg32_t  CFPCTR4;                       /*  CFPCTR4         */
    union iodefine_reg32_t  CFPCTR5;                       /*  CFPCTR5         */
    
    volatile uint8_t   dummy164[72];                           /*                  */
    union iodefine_reg32_t  FESTS;                         /*  FESTS           */
    union iodefine_reg32_t  FFSTS;                         /*  FFSTS           */
    union iodefine_reg32_t  FMSTS;                         /*  FMSTS           */
    union iodefine_reg32_t  RFISTS;                        /*  RFISTS          */
    union iodefine_reg32_t  CFRISTS;                       /*  CFRISTS         */
    union iodefine_reg32_t  CFTISTS;                       /*  CFTISTS         */
    

/* #define RSCAN0_TMC0_COUNT (32) */
    volatile uint8_t   TMC0;                                   /*  TMC0            */
    volatile uint8_t   TMC1;                                   /*  TMC1            */
    volatile uint8_t   TMC2;                                   /*  TMC2            */
    volatile uint8_t   TMC3;                                   /*  TMC3            */
    volatile uint8_t   TMC4;                                   /*  TMC4            */
    volatile uint8_t   TMC5;                                   /*  TMC5            */
    volatile uint8_t   TMC6;                                   /*  TMC6            */
    volatile uint8_t   TMC7;                                   /*  TMC7            */
    volatile uint8_t   TMC8;                                   /*  TMC8            */
    volatile uint8_t   TMC9;                                   /*  TMC9            */
    volatile uint8_t   TMC10;                                  /*  TMC10           */
    volatile uint8_t   TMC11;                                  /*  TMC11           */
    volatile uint8_t   TMC12;                                  /*  TMC12           */
    volatile uint8_t   TMC13;                                  /*  TMC13           */
    volatile uint8_t   TMC14;                                  /*  TMC14           */
    volatile uint8_t   TMC15;                                  /*  TMC15           */
    volatile uint8_t   TMC16;                                  /*  TMC16           */
    volatile uint8_t   TMC17;                                  /*  TMC17           */
    volatile uint8_t   TMC18;                                  /*  TMC18           */
    volatile uint8_t   TMC19;                                  /*  TMC19           */
    volatile uint8_t   TMC20;                                  /*  TMC20           */
    volatile uint8_t   TMC21;                                  /*  TMC21           */
    volatile uint8_t   TMC22;                                  /*  TMC22           */
    volatile uint8_t   TMC23;                                  /*  TMC23           */
    volatile uint8_t   TMC24;                                  /*  TMC24           */
    volatile uint8_t   TMC25;                                  /*  TMC25           */
    volatile uint8_t   TMC26;                                  /*  TMC26           */
    volatile uint8_t   TMC27;                                  /*  TMC27           */
    volatile uint8_t   TMC28;                                  /*  TMC28           */
    volatile uint8_t   TMC29;                                  /*  TMC29           */
    volatile uint8_t   TMC30;                                  /*  TMC30           */
    volatile uint8_t   TMC31;                                  /*  TMC31           */
    volatile uint8_t   dummy165[96];                           /*                  */

/* #define RSCAN0_TMSTS0_COUNT (32) */
    volatile uint8_t   TMSTS0;                                 /*  TMSTS0          */
    volatile uint8_t   TMSTS1;                                 /*  TMSTS1          */
    volatile uint8_t   TMSTS2;                                 /*  TMSTS2          */
    volatile uint8_t   TMSTS3;                                 /*  TMSTS3          */
    volatile uint8_t   TMSTS4;                                 /*  TMSTS4          */
    volatile uint8_t   TMSTS5;                                 /*  TMSTS5          */
    volatile uint8_t   TMSTS6;                                 /*  TMSTS6          */
    volatile uint8_t   TMSTS7;                                 /*  TMSTS7          */
    volatile uint8_t   TMSTS8;                                 /*  TMSTS8          */
    volatile uint8_t   TMSTS9;                                 /*  TMSTS9          */
    volatile uint8_t   TMSTS10;                                /*  TMSTS10         */
    volatile uint8_t   TMSTS11;                                /*  TMSTS11         */
    volatile uint8_t   TMSTS12;                                /*  TMSTS12         */
    volatile uint8_t   TMSTS13;                                /*  TMSTS13         */
    volatile uint8_t   TMSTS14;                                /*  TMSTS14         */
    volatile uint8_t   TMSTS15;                                /*  TMSTS15         */
    volatile uint8_t   TMSTS16;                                /*  TMSTS16         */
    volatile uint8_t   TMSTS17;                                /*  TMSTS17         */
    volatile uint8_t   TMSTS18;                                /*  TMSTS18         */
    volatile uint8_t   TMSTS19;                                /*  TMSTS19         */
    volatile uint8_t   TMSTS20;                                /*  TMSTS20         */
    volatile uint8_t   TMSTS21;                                /*  TMSTS21         */
    volatile uint8_t   TMSTS22;                                /*  TMSTS22         */
    volatile uint8_t   TMSTS23;                                /*  TMSTS23         */
    volatile uint8_t   TMSTS24;                                /*  TMSTS24         */
    volatile uint8_t   TMSTS25;                                /*  TMSTS25         */
    volatile uint8_t   TMSTS26;                                /*  TMSTS26         */
    volatile uint8_t   TMSTS27;                                /*  TMSTS27         */
    volatile uint8_t   TMSTS28;                                /*  TMSTS28         */
    volatile uint8_t   TMSTS29;                                /*  TMSTS29         */
    volatile uint8_t   TMSTS30;                                /*  TMSTS30         */
    volatile uint8_t   TMSTS31;                                /*  TMSTS31         */
    volatile uint8_t   dummy166[96];                           /*                  */

/* #define RSCAN0_TMTRSTS0_COUNT (1) */
    union iodefine_reg32_t  TMTRSTS0;                      /*  TMTRSTS0        */
    
    volatile uint8_t   dummy167[12];                           /*                  */

/* #define RSCAN0_TMTARSTS0_COUNT (1) */
    union iodefine_reg32_t  TMTARSTS0;                     /*  TMTARSTS0       */
    
    volatile uint8_t   dummy168[12];                           /*                  */

/* #define RSCAN0_TMTCSTS0_COUNT (1) */
    union iodefine_reg32_t  TMTCSTS0;                      /*  TMTCSTS0        */
    
    volatile uint8_t   dummy169[12];                           /*                  */

/* #define RSCAN0_TMTASTS0_COUNT (1) */
    union iodefine_reg32_t  TMTASTS0;                      /*  TMTASTS0        */
    
    volatile uint8_t   dummy170[12];                           /*                  */

/* #define RSCAN0_TMIEC0_COUNT (1) */
    union iodefine_reg32_t  TMIEC0;                        /*  TMIEC0          */
    
    volatile uint8_t   dummy171[12];                           /*                  */

/* #define RSCAN0_TXQCC0_COUNT (2) */
    union iodefine_reg32_t  TXQCC0;                        /*  TXQCC0          */
    union iodefine_reg32_t  TXQCC1;                        /*  TXQCC1          */
    
    volatile uint8_t   dummy172[24];                           /*                  */

/* #define RSCAN0_TXQSTS0_COUNT (2) */
    union iodefine_reg32_t  TXQSTS0;                       /*  TXQSTS0         */
    union iodefine_reg32_t  TXQSTS1;                       /*  TXQSTS1         */
    
    volatile uint8_t   dummy173[24];                           /*                  */

/* #define RSCAN0_TXQPCTR0_COUNT (2) */
    union iodefine_reg32_t  TXQPCTR0;                      /*  TXQPCTR0        */
    union iodefine_reg32_t  TXQPCTR1;                      /*  TXQPCTR1        */
    
    volatile uint8_t   dummy174[24];                           /*                  */

/* #define RSCAN0_THLCC0_COUNT (2) */
    union iodefine_reg32_t  THLCC0;                        /*  THLCC0          */
    union iodefine_reg32_t  THLCC1;                        /*  THLCC1          */
    
    volatile uint8_t   dummy175[24];                           /*                  */

/* #define RSCAN0_THLSTS0_COUNT (2) */
    union iodefine_reg32_t  THLSTS0;                       /*  THLSTS0         */
    union iodefine_reg32_t  THLSTS1;                       /*  THLSTS1         */
    
    volatile uint8_t   dummy176[24];                           /*                  */

/* #define RSCAN0_THLPCTR0_COUNT (2) */
    union iodefine_reg32_t  THLPCTR0;                      /*  THLPCTR0        */
    union iodefine_reg32_t  THLPCTR1;                      /*  THLPCTR1        */
    
    volatile uint8_t   dummy177[24];                           /*                  */

/* #define RSCAN0_GTINTSTS0_COUNT (1) */
    union iodefine_reg32_t  GTINTSTS0;                     /*  GTINTSTS0       */
    
    volatile uint8_t   dummy178[4];                            /*                  */
    union iodefine_reg32_t  GTSTCFG;                       /*  GTSTCFG         */
    union iodefine_reg32_t  GTSTCTR;                       /*  GTSTCTR         */
    
    volatile uint8_t   dummy179[12];                           /*                  */
    union iodefine_reg32_16_t  GLOCKK;                     /*  GLOCKK          */
    
    volatile uint8_t   dummy180[128];                          /*                  */
    
/* start of struct st_rscan_from_rscan0gaflidj */
    union iodefine_reg32_t  GAFLID0;                       /*  GAFLID0         */
    union iodefine_reg32_t  GAFLM0;                        /*  GAFLM0          */
    union iodefine_reg32_t  GAFLP00;                       /*  GAFLP00         */
    union iodefine_reg32_t  GAFLP10;                       /*  GAFLP10         */

/* end of struct st_rscan_from_rscan0gaflidj */
    
/* start of struct st_rscan_from_rscan0gaflidj */
    union iodefine_reg32_t  GAFLID1;                       /*  GAFLID1         */
    union iodefine_reg32_t  GAFLM1;                        /*  GAFLM1          */
    union iodefine_reg32_t  GAFLP01;                       /*  GAFLP01         */
    union iodefine_reg32_t  GAFLP11;                       /*  GAFLP11         */

/* end of struct st_rscan_from_rscan0gaflidj */
    
/* start of struct st_rscan_from_rscan0gaflidj */
    union iodefine_reg32_t  GAFLID2;                       /*  GAFLID2         */
    union iodefine_reg32_t  GAFLM2;                        /*  GAFLM2          */
    union iodefine_reg32_t  GAFLP02;                       /*  GAFLP02         */
    union iodefine_reg32_t  GAFLP12;                       /*  GAFLP12         */

/* end of struct st_rscan_from_rscan0gaflidj */
    
/* start of struct st_rscan_from_rscan0gaflidj */
    union iodefine_reg32_t  GAFLID3;                       /*  GAFLID3         */
    union iodefine_reg32_t  GAFLM3;                        /*  GAFLM3          */
    union iodefine_reg32_t  GAFLP03;                       /*  GAFLP03         */
    union iodefine_reg32_t  GAFLP13;                       /*  GAFLP13         */

/* end of struct st_rscan_from_rscan0gaflidj */
    
/* start of struct st_rscan_from_rscan0gaflidj */
    union iodefine_reg32_t  GAFLID4;                       /*  GAFLID4         */
    union iodefine_reg32_t  GAFLM4;                        /*  GAFLM4          */
    union iodefine_reg32_t  GAFLP04;                       /*  GAFLP04         */
    union iodefine_reg32_t  GAFLP14;                       /*  GAFLP14         */

/* end of struct st_rscan_from_rscan0gaflidj */
    
/* start of struct st_rscan_from_rscan0gaflidj */
    union iodefine_reg32_t  GAFLID5;                       /*  GAFLID5         */
    union iodefine_reg32_t  GAFLM5;                        /*  GAFLM5          */
    union iodefine_reg32_t  GAFLP05;                       /*  GAFLP05         */
    union iodefine_reg32_t  GAFLP15;                       /*  GAFLP15         */

/* end of struct st_rscan_from_rscan0gaflidj */
    
/* start of struct st_rscan_from_rscan0gaflidj */
    union iodefine_reg32_t  GAFLID6;                       /*  GAFLID6         */
    union iodefine_reg32_t  GAFLM6;                        /*  GAFLM6          */
    union iodefine_reg32_t  GAFLP06;                       /*  GAFLP06         */
    union iodefine_reg32_t  GAFLP16;                       /*  GAFLP16         */

/* end of struct st_rscan_from_rscan0gaflidj */
    
/* start of struct st_rscan_from_rscan0gaflidj */
    union iodefine_reg32_t  GAFLID7;                       /*  GAFLID7         */
    union iodefine_reg32_t  GAFLM7;                        /*  GAFLM7          */
    union iodefine_reg32_t  GAFLP07;                       /*  GAFLP07         */
    union iodefine_reg32_t  GAFLP17;                       /*  GAFLP17         */

/* end of struct st_rscan_from_rscan0gaflidj */
    
/* start of struct st_rscan_from_rscan0gaflidj */
    union iodefine_reg32_t  GAFLID8;                       /*  GAFLID8         */
    union iodefine_reg32_t  GAFLM8;                        /*  GAFLM8          */
    union iodefine_reg32_t  GAFLP08;                       /*  GAFLP08         */
    union iodefine_reg32_t  GAFLP18;                       /*  GAFLP18         */

/* end of struct st_rscan_from_rscan0gaflidj */
    
/* start of struct st_rscan_from_rscan0gaflidj */
    union iodefine_reg32_t  GAFLID9;                       /*  GAFLID9         */
    union iodefine_reg32_t  GAFLM9;                        /*  GAFLM9          */
    union iodefine_reg32_t  GAFLP09;                       /*  GAFLP09         */
    union iodefine_reg32_t  GAFLP19;                       /*  GAFLP19         */

/* end of struct st_rscan_from_rscan0gaflidj */
    
/* start of struct st_rscan_from_rscan0gaflidj */
    union iodefine_reg32_t  GAFLID10;                      /*  GAFLID10        */
    union iodefine_reg32_t  GAFLM10;                       /*  GAFLM10         */
    union iodefine_reg32_t  GAFLP010;                      /*  GAFLP010        */
    union iodefine_reg32_t  GAFLP110;                      /*  GAFLP110        */

/* end of struct st_rscan_from_rscan0gaflidj */
    
/* start of struct st_rscan_from_rscan0gaflidj */
    union iodefine_reg32_t  GAFLID11;                      /*  GAFLID11        */
    union iodefine_reg32_t  GAFLM11;                       /*  GAFLM11         */
    union iodefine_reg32_t  GAFLP011;                      /*  GAFLP011        */
    union iodefine_reg32_t  GAFLP111;                      /*  GAFLP111        */

/* end of struct st_rscan_from_rscan0gaflidj */
    
/* start of struct st_rscan_from_rscan0gaflidj */
    union iodefine_reg32_t  GAFLID12;                      /*  GAFLID12        */
    union iodefine_reg32_t  GAFLM12;                       /*  GAFLM12         */
    union iodefine_reg32_t  GAFLP012;                      /*  GAFLP012        */
    union iodefine_reg32_t  GAFLP112;                      /*  GAFLP112        */

/* end of struct st_rscan_from_rscan0gaflidj */
    
/* start of struct st_rscan_from_rscan0gaflidj */
    union iodefine_reg32_t  GAFLID13;                      /*  GAFLID13        */
    union iodefine_reg32_t  GAFLM13;                       /*  GAFLM13         */
    union iodefine_reg32_t  GAFLP013;                      /*  GAFLP013        */
    union iodefine_reg32_t  GAFLP113;                      /*  GAFLP113        */

/* end of struct st_rscan_from_rscan0gaflidj */
    
/* start of struct st_rscan_from_rscan0gaflidj */
    union iodefine_reg32_t  GAFLID14;                      /*  GAFLID14        */
    union iodefine_reg32_t  GAFLM14;                       /*  GAFLM14         */
    union iodefine_reg32_t  GAFLP014;                      /*  GAFLP014        */
    union iodefine_reg32_t  GAFLP114;                      /*  GAFLP114        */

/* end of struct st_rscan_from_rscan0gaflidj */
    
/* start of struct st_rscan_from_rscan0gaflidj */
    union iodefine_reg32_t  GAFLID15;                      /*  GAFLID15        */
    union iodefine_reg32_t  GAFLM15;                       /*  GAFLM15         */
    union iodefine_reg32_t  GAFLP015;                      /*  GAFLP015        */
    union iodefine_reg32_t  GAFLP115;                      /*  GAFLP115        */

/* end of struct st_rscan_from_rscan0gaflidj */
    
/* start of struct st_rscan_from_rscan0rmidp */
    union iodefine_reg32_t  RMID0;                         /*  RMID0           */
    union iodefine_reg32_t  RMPTR0;                        /*  RMPTR0          */
    union iodefine_reg32_t  RMDF00;                        /*  RMDF00          */
    union iodefine_reg32_t  RMDF10;                        /*  RMDF10          */

/* end of struct st_rscan_from_rscan0rmidp */
    
/* start of struct st_rscan_from_rscan0rmidp */
    union iodefine_reg32_t  RMID1;                         /*  RMID1           */
    union iodefine_reg32_t  RMPTR1;                        /*  RMPTR1          */
    union iodefine_reg32_t  RMDF01;                        /*  RMDF01          */
    union iodefine_reg32_t  RMDF11;                        /*  RMDF11          */

/* end of struct st_rscan_from_rscan0rmidp */
    
/* start of struct st_rscan_from_rscan0rmidp */
    union iodefine_reg32_t  RMID2;                         /*  RMID2           */
    union iodefine_reg32_t  RMPTR2;                        /*  RMPTR2          */
    union iodefine_reg32_t  RMDF02;                        /*  RMDF02          */
    union iodefine_reg32_t  RMDF12;                        /*  RMDF12          */

/* end of struct st_rscan_from_rscan0rmidp */
    
/* start of struct st_rscan_from_rscan0rmidp */
    union iodefine_reg32_t  RMID3;                         /*  RMID3           */
    union iodefine_reg32_t  RMPTR3;                        /*  RMPTR3          */
    union iodefine_reg32_t  RMDF03;                        /*  RMDF03          */
    union iodefine_reg32_t  RMDF13;                        /*  RMDF13          */

/* end of struct st_rscan_from_rscan0rmidp */
    
/* start of struct st_rscan_from_rscan0rmidp */
    union iodefine_reg32_t  RMID4;                         /*  RMID4           */
    union iodefine_reg32_t  RMPTR4;                        /*  RMPTR4          */
    union iodefine_reg32_t  RMDF04;                        /*  RMDF04          */
    union iodefine_reg32_t  RMDF14;                        /*  RMDF14          */

/* end of struct st_rscan_from_rscan0rmidp */
    
/* start of struct st_rscan_from_rscan0rmidp */
    union iodefine_reg32_t  RMID5;                         /*  RMID5           */
    union iodefine_reg32_t  RMPTR5;                        /*  RMPTR5          */
    union iodefine_reg32_t  RMDF05;                        /*  RMDF05          */
    union iodefine_reg32_t  RMDF15;                        /*  RMDF15          */

/* end of struct st_rscan_from_rscan0rmidp */
    
/* start of struct st_rscan_from_rscan0rmidp */
    union iodefine_reg32_t  RMID6;                         /*  RMID6           */
    union iodefine_reg32_t  RMPTR6;                        /*  RMPTR6          */
    union iodefine_reg32_t  RMDF06;                        /*  RMDF06          */
    union iodefine_reg32_t  RMDF16;                        /*  RMDF16          */

/* end of struct st_rscan_from_rscan0rmidp */
    
/* start of struct st_rscan_from_rscan0rmidp */
    union iodefine_reg32_t  RMID7;                         /*  RMID7           */
    union iodefine_reg32_t  RMPTR7;                        /*  RMPTR7          */
    union iodefine_reg32_t  RMDF07;                        /*  RMDF07          */
    union iodefine_reg32_t  RMDF17;                        /*  RMDF17          */

/* end of struct st_rscan_from_rscan0rmidp */
    
/* start of struct st_rscan_from_rscan0rmidp */
    union iodefine_reg32_t  RMID8;                         /*  RMID8           */
    union iodefine_reg32_t  RMPTR8;                        /*  RMPTR8          */
    union iodefine_reg32_t  RMDF08;                        /*  RMDF08          */
    union iodefine_reg32_t  RMDF18;                        /*  RMDF18          */

/* end of struct st_rscan_from_rscan0rmidp */
    
/* start of struct st_rscan_from_rscan0rmidp */
    union iodefine_reg32_t  RMID9;                         /*  RMID9           */
    union iodefine_reg32_t  RMPTR9;                        /*  RMPTR9          */
    union iodefine_reg32_t  RMDF09;                        /*  RMDF09          */
    union iodefine_reg32_t  RMDF19;                        /*  RMDF19          */

/* end of struct st_rscan_from_rscan0rmidp */
    
/* start of struct st_rscan_from_rscan0rmidp */
    union iodefine_reg32_t  RMID10;                        /*  RMID10          */
    union iodefine_reg32_t  RMPTR10;                       /*  RMPTR10         */
    union iodefine_reg32_t  RMDF010;                       /*  RMDF010         */
    union iodefine_reg32_t  RMDF110;                       /*  RMDF110         */

/* end of struct st_rscan_from_rscan0rmidp */
    
/* start of struct st_rscan_from_rscan0rmidp */
    union iodefine_reg32_t  RMID11;                        /*  RMID11          */
    union iodefine_reg32_t  RMPTR11;                       /*  RMPTR11         */
    union iodefine_reg32_t  RMDF011;                       /*  RMDF011         */
    union iodefine_reg32_t  RMDF111;                       /*  RMDF111         */

/* end of struct st_rscan_from_rscan0rmidp */
    
/* start of struct st_rscan_from_rscan0rmidp */
    union iodefine_reg32_t  RMID12;                        /*  RMID12          */
    union iodefine_reg32_t  RMPTR12;                       /*  RMPTR12         */
    union iodefine_reg32_t  RMDF012;                       /*  RMDF012         */
    union iodefine_reg32_t  RMDF112;                       /*  RMDF112         */

/* end of struct st_rscan_from_rscan0rmidp */
    
/* start of struct st_rscan_from_rscan0rmidp */
    union iodefine_reg32_t  RMID13;                        /*  RMID13          */
    union iodefine_reg32_t  RMPTR13;                       /*  RMPTR13         */
    union iodefine_reg32_t  RMDF013;                       /*  RMDF013         */
    union iodefine_reg32_t  RMDF113;                       /*  RMDF113         */

/* end of struct st_rscan_from_rscan0rmidp */
    
/* start of struct st_rscan_from_rscan0rmidp */
    union iodefine_reg32_t  RMID14;                        /*  RMID14          */
    union iodefine_reg32_t  RMPTR14;                       /*  RMPTR14         */
    union iodefine_reg32_t  RMDF014;                       /*  RMDF014         */
    union iodefine_reg32_t  RMDF114;                       /*  RMDF114         */

/* end of struct st_rscan_from_rscan0rmidp */
    
/* start of struct st_rscan_from_rscan0rmidp */
    union iodefine_reg32_t  RMID15;                        /*  RMID15          */
    union iodefine_reg32_t  RMPTR15;                       /*  RMPTR15         */
    union iodefine_reg32_t  RMDF015;                       /*  RMDF015         */
    union iodefine_reg32_t  RMDF115;                       /*  RMDF115         */

/* end of struct st_rscan_from_rscan0rmidp */
    
/* start of struct st_rscan_from_rscan0rmidp */
    union iodefine_reg32_t  RMID16;                        /*  RMID16          */
    union iodefine_reg32_t  RMPTR16;                       /*  RMPTR16         */
    union iodefine_reg32_t  RMDF016;                       /*  RMDF016         */
    union iodefine_reg32_t  RMDF116;                       /*  RMDF116         */

/* end of struct st_rscan_from_rscan0rmidp */
    
/* start of struct st_rscan_from_rscan0rmidp */
    union iodefine_reg32_t  RMID17;                        /*  RMID17          */
    union iodefine_reg32_t  RMPTR17;                       /*  RMPTR17         */
    union iodefine_reg32_t  RMDF017;                       /*  RMDF017         */
    union iodefine_reg32_t  RMDF117;                       /*  RMDF117         */

/* end of struct st_rscan_from_rscan0rmidp */
    
/* start of struct st_rscan_from_rscan0rmidp */
    union iodefine_reg32_t  RMID18;                        /*  RMID18          */
    union iodefine_reg32_t  RMPTR18;                       /*  RMPTR18         */
    union iodefine_reg32_t  RMDF018;                       /*  RMDF018         */
    union iodefine_reg32_t  RMDF118;                       /*  RMDF118         */

/* end of struct st_rscan_from_rscan0rmidp */
    
/* start of struct st_rscan_from_rscan0rmidp */
    union iodefine_reg32_t  RMID19;                        /*  RMID19          */
    union iodefine_reg32_t  RMPTR19;                       /*  RMPTR19         */
    union iodefine_reg32_t  RMDF019;                       /*  RMDF019         */
    union iodefine_reg32_t  RMDF119;                       /*  RMDF119         */

/* end of struct st_rscan_from_rscan0rmidp */
    
/* start of struct st_rscan_from_rscan0rmidp */
    union iodefine_reg32_t  RMID20;                        /*  RMID20          */
    union iodefine_reg32_t  RMPTR20;                       /*  RMPTR20         */
    union iodefine_reg32_t  RMDF020;                       /*  RMDF020         */
    union iodefine_reg32_t  RMDF120;                       /*  RMDF120         */

/* end of struct st_rscan_from_rscan0rmidp */
    
/* start of struct st_rscan_from_rscan0rmidp */
    union iodefine_reg32_t  RMID21;                        /*  RMID21          */
    union iodefine_reg32_t  RMPTR21;                       /*  RMPTR21         */
    union iodefine_reg32_t  RMDF021;                       /*  RMDF021         */
    union iodefine_reg32_t  RMDF121;                       /*  RMDF121         */

/* end of struct st_rscan_from_rscan0rmidp */
    
/* start of struct st_rscan_from_rscan0rmidp */
    union iodefine_reg32_t  RMID22;                        /*  RMID22          */
    union iodefine_reg32_t  RMPTR22;                       /*  RMPTR22         */
    union iodefine_reg32_t  RMDF022;                       /*  RMDF022         */
    union iodefine_reg32_t  RMDF122;                       /*  RMDF122         */

/* end of struct st_rscan_from_rscan0rmidp */
    
/* start of struct st_rscan_from_rscan0rmidp */
    union iodefine_reg32_t  RMID23;                        /*  RMID23          */
    union iodefine_reg32_t  RMPTR23;                       /*  RMPTR23         */
    union iodefine_reg32_t  RMDF023;                       /*  RMDF023         */
    union iodefine_reg32_t  RMDF123;                       /*  RMDF123         */

/* end of struct st_rscan_from_rscan0rmidp */
    
/* start of struct st_rscan_from_rscan0rmidp */
    union iodefine_reg32_t  RMID24;                        /*  RMID24          */
    union iodefine_reg32_t  RMPTR24;                       /*  RMPTR24         */
    union iodefine_reg32_t  RMDF024;                       /*  RMDF024         */
    union iodefine_reg32_t  RMDF124;                       /*  RMDF124         */

/* end of struct st_rscan_from_rscan0rmidp */
    
/* start of struct st_rscan_from_rscan0rmidp */
    union iodefine_reg32_t  RMID25;                        /*  RMID25          */
    union iodefine_reg32_t  RMPTR25;                       /*  RMPTR25         */
    union iodefine_reg32_t  RMDF025;                       /*  RMDF025         */
    union iodefine_reg32_t  RMDF125;                       /*  RMDF125         */

/* end of struct st_rscan_from_rscan0rmidp */
    
/* start of struct st_rscan_from_rscan0rmidp */
    union iodefine_reg32_t  RMID26;                        /*  RMID26          */
    union iodefine_reg32_t  RMPTR26;                       /*  RMPTR26         */
    union iodefine_reg32_t  RMDF026;                       /*  RMDF026         */
    union iodefine_reg32_t  RMDF126;                       /*  RMDF126         */

/* end of struct st_rscan_from_rscan0rmidp */
    
/* start of struct st_rscan_from_rscan0rmidp */
    union iodefine_reg32_t  RMID27;                        /*  RMID27          */
    union iodefine_reg32_t  RMPTR27;                       /*  RMPTR27         */
    union iodefine_reg32_t  RMDF027;                       /*  RMDF027         */
    union iodefine_reg32_t  RMDF127;                       /*  RMDF127         */

/* end of struct st_rscan_from_rscan0rmidp */
    
/* start of struct st_rscan_from_rscan0rmidp */
    union iodefine_reg32_t  RMID28;                        /*  RMID28          */
    union iodefine_reg32_t  RMPTR28;                       /*  RMPTR28         */
    union iodefine_reg32_t  RMDF028;                       /*  RMDF028         */
    union iodefine_reg32_t  RMDF128;                       /*  RMDF128         */

/* end of struct st_rscan_from_rscan0rmidp */
    
/* start of struct st_rscan_from_rscan0rmidp */
    union iodefine_reg32_t  RMID29;                        /*  RMID29          */
    union iodefine_reg32_t  RMPTR29;                       /*  RMPTR29         */
    union iodefine_reg32_t  RMDF029;                       /*  RMDF029         */
    union iodefine_reg32_t  RMDF129;                       /*  RMDF129         */

/* end of struct st_rscan_from_rscan0rmidp */
    
/* start of struct st_rscan_from_rscan0rmidp */
    union iodefine_reg32_t  RMID30;                        /*  RMID30          */
    union iodefine_reg32_t  RMPTR30;                       /*  RMPTR30         */
    union iodefine_reg32_t  RMDF030;                       /*  RMDF030         */
    union iodefine_reg32_t  RMDF130;                       /*  RMDF130         */

/* end of struct st_rscan_from_rscan0rmidp */
    
/* start of struct st_rscan_from_rscan0rmidp */
    union iodefine_reg32_t  RMID31;                        /*  RMID31          */
    union iodefine_reg32_t  RMPTR31;                       /*  RMPTR31         */
    union iodefine_reg32_t  RMDF031;                       /*  RMDF031         */
    union iodefine_reg32_t  RMDF131;                       /*  RMDF131         */

/* end of struct st_rscan_from_rscan0rmidp */
    
    volatile uint8_t   dummy181[1536];                         /*                  */
    
/* start of struct st_rscan_from_rscan0rfidm */
    union iodefine_reg32_t  RFID0;                         /*  RFID0           */
    union iodefine_reg32_t  RFPTR0;                        /*  RFPTR0          */
    union iodefine_reg32_t  RFDF00;                        /*  RFDF00          */
    union iodefine_reg32_t  RFDF10;                        /*  RFDF10          */

/* end of struct st_rscan_from_rscan0rfidm */
    
/* start of struct st_rscan_from_rscan0rfidm */
    union iodefine_reg32_t  RFID1;                         /*  RFID1           */
    union iodefine_reg32_t  RFPTR1;                        /*  RFPTR1          */
    union iodefine_reg32_t  RFDF01;                        /*  RFDF01          */
    union iodefine_reg32_t  RFDF11;                        /*  RFDF11          */

/* end of struct st_rscan_from_rscan0rfidm */
    
/* start of struct st_rscan_from_rscan0rfidm */
    union iodefine_reg32_t  RFID2;                         /*  RFID2           */
    union iodefine_reg32_t  RFPTR2;                        /*  RFPTR2          */
    union iodefine_reg32_t  RFDF02;                        /*  RFDF02          */
    union iodefine_reg32_t  RFDF12;                        /*  RFDF12          */

/* end of struct st_rscan_from_rscan0rfidm */
    
/* start of struct st_rscan_from_rscan0rfidm */
    union iodefine_reg32_t  RFID3;                         /*  RFID3           */
    union iodefine_reg32_t  RFPTR3;                        /*  RFPTR3          */
    union iodefine_reg32_t  RFDF03;                        /*  RFDF03          */
    union iodefine_reg32_t  RFDF13;                        /*  RFDF13          */

/* end of struct st_rscan_from_rscan0rfidm */
    
/* start of struct st_rscan_from_rscan0rfidm */
    union iodefine_reg32_t  RFID4;                         /*  RFID4           */
    union iodefine_reg32_t  RFPTR4;                        /*  RFPTR4          */
    union iodefine_reg32_t  RFDF04;                        /*  RFDF04          */
    union iodefine_reg32_t  RFDF14;                        /*  RFDF14          */

/* end of struct st_rscan_from_rscan0rfidm */
    
/* start of struct st_rscan_from_rscan0rfidm */
    union iodefine_reg32_t  RFID5;                         /*  RFID5           */
    union iodefine_reg32_t  RFPTR5;                        /*  RFPTR5          */
    union iodefine_reg32_t  RFDF05;                        /*  RFDF05          */
    union iodefine_reg32_t  RFDF15;                        /*  RFDF15          */

/* end of struct st_rscan_from_rscan0rfidm */
    
/* start of struct st_rscan_from_rscan0rfidm */
    union iodefine_reg32_t  RFID6;                         /*  RFID6           */
    union iodefine_reg32_t  RFPTR6;                        /*  RFPTR6          */
    union iodefine_reg32_t  RFDF06;                        /*  RFDF06          */
    union iodefine_reg32_t  RFDF16;                        /*  RFDF16          */

/* end of struct st_rscan_from_rscan0rfidm */
    
/* start of struct st_rscan_from_rscan0rfidm */
    union iodefine_reg32_t  RFID7;                         /*  RFID7           */
    union iodefine_reg32_t  RFPTR7;                        /*  RFPTR7          */
    union iodefine_reg32_t  RFDF07;                        /*  RFDF07          */
    union iodefine_reg32_t  RFDF17;                        /*  RFDF17          */

/* end of struct st_rscan_from_rscan0rfidm */
    
/* start of struct st_rscan_from_rscan0cfidm */
    union iodefine_reg32_t  CFID0;                         /*  CFID0           */
    union iodefine_reg32_t  CFPTR0;                        /*  CFPTR0          */
    union iodefine_reg32_t  CFDF00;                        /*  CFDF00          */
    union iodefine_reg32_t  CFDF10;                        /*  CFDF10          */

/* end of struct st_rscan_from_rscan0cfidm */
    
/* start of struct st_rscan_from_rscan0cfidm */
    union iodefine_reg32_t  CFID1;                         /*  CFID1           */
    union iodefine_reg32_t  CFPTR1;                        /*  CFPTR1          */
    union iodefine_reg32_t  CFDF01;                        /*  CFDF01          */
    union iodefine_reg32_t  CFDF11;                        /*  CFDF11          */

/* end of struct st_rscan_from_rscan0cfidm */
    
/* start of struct st_rscan_from_rscan0cfidm */
    union iodefine_reg32_t  CFID2;                         /*  CFID2           */
    union iodefine_reg32_t  CFPTR2;                        /*  CFPTR2          */
    union iodefine_reg32_t  CFDF02;                        /*  CFDF02          */
    union iodefine_reg32_t  CFDF12;                        /*  CFDF12          */

/* end of struct st_rscan_from_rscan0cfidm */
    
/* start of struct st_rscan_from_rscan0cfidm */
    union iodefine_reg32_t  CFID3;                         /*  CFID3           */
    union iodefine_reg32_t  CFPTR3;                        /*  CFPTR3          */
    union iodefine_reg32_t  CFDF03;                        /*  CFDF03          */
    union iodefine_reg32_t  CFDF13;                        /*  CFDF13          */

/* end of struct st_rscan_from_rscan0cfidm */
    
/* start of struct st_rscan_from_rscan0cfidm */
    union iodefine_reg32_t  CFID4;                         /*  CFID4           */
    union iodefine_reg32_t  CFPTR4;                        /*  CFPTR4          */
    union iodefine_reg32_t  CFDF04;                        /*  CFDF04          */
    union iodefine_reg32_t  CFDF14;                        /*  CFDF14          */

/* end of struct st_rscan_from_rscan0cfidm */
    
/* start of struct st_rscan_from_rscan0cfidm */
    union iodefine_reg32_t  CFID5;                         /*  CFID5           */
    union iodefine_reg32_t  CFPTR5;                        /*  CFPTR5          */
    union iodefine_reg32_t  CFDF05;                        /*  CFDF05          */
    union iodefine_reg32_t  CFDF15;                        /*  CFDF15          */

/* end of struct st_rscan_from_rscan0cfidm */
    
    volatile uint8_t   dummy182[288];                          /*                  */
    
/* start of struct st_rscan_from_rscan0tmidp */
    union iodefine_reg32_t  TMID0;                         /*  TMID0           */
    union iodefine_reg32_t  TMPTR0;                        /*  TMPTR0          */
    union iodefine_reg32_t  TMDF00;                        /*  TMDF00          */
    union iodefine_reg32_t  TMDF10;                        /*  TMDF10          */

/* end of struct st_rscan_from_rscan0tmidp */
    
/* start of struct st_rscan_from_rscan0tmidp */
    union iodefine_reg32_t  TMID1;                         /*  TMID1           */
    union iodefine_reg32_t  TMPTR1;                        /*  TMPTR1          */
    union iodefine_reg32_t  TMDF01;                        /*  TMDF01          */
    union iodefine_reg32_t  TMDF11;                        /*  TMDF11          */

/* end of struct st_rscan_from_rscan0tmidp */
    
/* start of struct st_rscan_from_rscan0tmidp */
    union iodefine_reg32_t  TMID2;                         /*  TMID2           */
    union iodefine_reg32_t  TMPTR2;                        /*  TMPTR2          */
    union iodefine_reg32_t  TMDF02;                        /*  TMDF02          */
    union iodefine_reg32_t  TMDF12;                        /*  TMDF12          */

/* end of struct st_rscan_from_rscan0tmidp */
    
/* start of struct st_rscan_from_rscan0tmidp */
    union iodefine_reg32_t  TMID3;                         /*  TMID3           */
    union iodefine_reg32_t  TMPTR3;                        /*  TMPTR3          */
    union iodefine_reg32_t  TMDF03;                        /*  TMDF03          */
    union iodefine_reg32_t  TMDF13;                        /*  TMDF13          */

/* end of struct st_rscan_from_rscan0tmidp */
    
/* start of struct st_rscan_from_rscan0tmidp */
    union iodefine_reg32_t  TMID4;                         /*  TMID4           */
    union iodefine_reg32_t  TMPTR4;                        /*  TMPTR4          */
    union iodefine_reg32_t  TMDF04;                        /*  TMDF04          */
    union iodefine_reg32_t  TMDF14;                        /*  TMDF14          */

/* end of struct st_rscan_from_rscan0tmidp */
    
/* start of struct st_rscan_from_rscan0tmidp */
    union iodefine_reg32_t  TMID5;                         /*  TMID5           */
    union iodefine_reg32_t  TMPTR5;                        /*  TMPTR5          */
    union iodefine_reg32_t  TMDF05;                        /*  TMDF05          */
    union iodefine_reg32_t  TMDF15;                        /*  TMDF15          */

/* end of struct st_rscan_from_rscan0tmidp */
    
/* start of struct st_rscan_from_rscan0tmidp */
    union iodefine_reg32_t  TMID6;                         /*  TMID6           */
    union iodefine_reg32_t  TMPTR6;                        /*  TMPTR6          */
    union iodefine_reg32_t  TMDF06;                        /*  TMDF06          */
    union iodefine_reg32_t  TMDF16;                        /*  TMDF16          */

/* end of struct st_rscan_from_rscan0tmidp */
    
/* start of struct st_rscan_from_rscan0tmidp */
    union iodefine_reg32_t  TMID7;                         /*  TMID7           */
    union iodefine_reg32_t  TMPTR7;                        /*  TMPTR7          */
    union iodefine_reg32_t  TMDF07;                        /*  TMDF07          */
    union iodefine_reg32_t  TMDF17;                        /*  TMDF17          */

/* end of struct st_rscan_from_rscan0tmidp */
    
/* start of struct st_rscan_from_rscan0tmidp */
    union iodefine_reg32_t  TMID8;                         /*  TMID8           */
    union iodefine_reg32_t  TMPTR8;                        /*  TMPTR8          */
    union iodefine_reg32_t  TMDF08;                        /*  TMDF08          */
    union iodefine_reg32_t  TMDF18;                        /*  TMDF18          */

/* end of struct st_rscan_from_rscan0tmidp */
    
/* start of struct st_rscan_from_rscan0tmidp */
    union iodefine_reg32_t  TMID9;                         /*  TMID9           */
    union iodefine_reg32_t  TMPTR9;                        /*  TMPTR9          */
    union iodefine_reg32_t  TMDF09;                        /*  TMDF09          */
    union iodefine_reg32_t  TMDF19;                        /*  TMDF19          */

/* end of struct st_rscan_from_rscan0tmidp */
    
/* start of struct st_rscan_from_rscan0tmidp */
    union iodefine_reg32_t  TMID10;                        /*  TMID10          */
    union iodefine_reg32_t  TMPTR10;                       /*  TMPTR10         */
    union iodefine_reg32_t  TMDF010;                       /*  TMDF010         */
    union iodefine_reg32_t  TMDF110;                       /*  TMDF110         */

/* end of struct st_rscan_from_rscan0tmidp */
    
/* start of struct st_rscan_from_rscan0tmidp */
    union iodefine_reg32_t  TMID11;                        /*  TMID11          */
    union iodefine_reg32_t  TMPTR11;                       /*  TMPTR11         */
    union iodefine_reg32_t  TMDF011;                       /*  TMDF011         */
    union iodefine_reg32_t  TMDF111;                       /*  TMDF111         */

/* end of struct st_rscan_from_rscan0tmidp */
    
/* start of struct st_rscan_from_rscan0tmidp */
    union iodefine_reg32_t  TMID12;                        /*  TMID12          */
    union iodefine_reg32_t  TMPTR12;                       /*  TMPTR12         */
    union iodefine_reg32_t  TMDF012;                       /*  TMDF012         */
    union iodefine_reg32_t  TMDF112;                       /*  TMDF112         */

/* end of struct st_rscan_from_rscan0tmidp */
    
/* start of struct st_rscan_from_rscan0tmidp */
    union iodefine_reg32_t  TMID13;                        /*  TMID13          */
    union iodefine_reg32_t  TMPTR13;                       /*  TMPTR13         */
    union iodefine_reg32_t  TMDF013;                       /*  TMDF013         */
    union iodefine_reg32_t  TMDF113;                       /*  TMDF113         */

/* end of struct st_rscan_from_rscan0tmidp */
    
/* start of struct st_rscan_from_rscan0tmidp */
    union iodefine_reg32_t  TMID14;                        /*  TMID14          */
    union iodefine_reg32_t  TMPTR14;                       /*  TMPTR14         */
    union iodefine_reg32_t  TMDF014;                       /*  TMDF014         */
    union iodefine_reg32_t  TMDF114;                       /*  TMDF114         */

/* end of struct st_rscan_from_rscan0tmidp */
    
/* start of struct st_rscan_from_rscan0tmidp */
    union iodefine_reg32_t  TMID15;                        /*  TMID15          */
    union iodefine_reg32_t  TMPTR15;                       /*  TMPTR15         */
    union iodefine_reg32_t  TMDF015;                       /*  TMDF015         */
    union iodefine_reg32_t  TMDF115;                       /*  TMDF115         */

/* end of struct st_rscan_from_rscan0tmidp */
    
/* start of struct st_rscan_from_rscan0tmidp */
    union iodefine_reg32_t  TMID16;                        /*  TMID16          */
    union iodefine_reg32_t  TMPTR16;                       /*  TMPTR16         */
    union iodefine_reg32_t  TMDF016;                       /*  TMDF016         */
    union iodefine_reg32_t  TMDF116;                       /*  TMDF116         */

/* end of struct st_rscan_from_rscan0tmidp */
    
/* start of struct st_rscan_from_rscan0tmidp */
    union iodefine_reg32_t  TMID17;                        /*  TMID17          */
    union iodefine_reg32_t  TMPTR17;                       /*  TMPTR17         */
    union iodefine_reg32_t  TMDF017;                       /*  TMDF017         */
    union iodefine_reg32_t  TMDF117;                       /*  TMDF117         */

/* end of struct st_rscan_from_rscan0tmidp */
    
/* start of struct st_rscan_from_rscan0tmidp */
    union iodefine_reg32_t  TMID18;                        /*  TMID18          */
    union iodefine_reg32_t  TMPTR18;                       /*  TMPTR18         */
    union iodefine_reg32_t  TMDF018;                       /*  TMDF018         */
    union iodefine_reg32_t  TMDF118;                       /*  TMDF118         */

/* end of struct st_rscan_from_rscan0tmidp */
    
/* start of struct st_rscan_from_rscan0tmidp */
    union iodefine_reg32_t  TMID19;                        /*  TMID19          */
    union iodefine_reg32_t  TMPTR19;                       /*  TMPTR19         */
    union iodefine_reg32_t  TMDF019;                       /*  TMDF019         */
    union iodefine_reg32_t  TMDF119;                       /*  TMDF119         */

/* end of struct st_rscan_from_rscan0tmidp */
    
/* start of struct st_rscan_from_rscan0tmidp */
    union iodefine_reg32_t  TMID20;                        /*  TMID20          */
    union iodefine_reg32_t  TMPTR20;                       /*  TMPTR20         */
    union iodefine_reg32_t  TMDF020;                       /*  TMDF020         */
    union iodefine_reg32_t  TMDF120;                       /*  TMDF120         */

/* end of struct st_rscan_from_rscan0tmidp */
    
/* start of struct st_rscan_from_rscan0tmidp */
    union iodefine_reg32_t  TMID21;                        /*  TMID21          */
    union iodefine_reg32_t  TMPTR21;                       /*  TMPTR21         */
    union iodefine_reg32_t  TMDF021;                       /*  TMDF021         */
    union iodefine_reg32_t  TMDF121;                       /*  TMDF121         */

/* end of struct st_rscan_from_rscan0tmidp */
    
/* start of struct st_rscan_from_rscan0tmidp */
    union iodefine_reg32_t  TMID22;                        /*  TMID22          */
    union iodefine_reg32_t  TMPTR22;                       /*  TMPTR22         */
    union iodefine_reg32_t  TMDF022;                       /*  TMDF022         */
    union iodefine_reg32_t  TMDF122;                       /*  TMDF122         */

/* end of struct st_rscan_from_rscan0tmidp */
    
/* start of struct st_rscan_from_rscan0tmidp */
    union iodefine_reg32_t  TMID23;                        /*  TMID23          */
    union iodefine_reg32_t  TMPTR23;                       /*  TMPTR23         */
    union iodefine_reg32_t  TMDF023;                       /*  TMDF023         */
    union iodefine_reg32_t  TMDF123;                       /*  TMDF123         */

/* end of struct st_rscan_from_rscan0tmidp */
    
/* start of struct st_rscan_from_rscan0tmidp */
    union iodefine_reg32_t  TMID24;                        /*  TMID24          */
    union iodefine_reg32_t  TMPTR24;                       /*  TMPTR24         */
    union iodefine_reg32_t  TMDF024;                       /*  TMDF024         */
    union iodefine_reg32_t  TMDF124;                       /*  TMDF124         */

/* end of struct st_rscan_from_rscan0tmidp */
    
/* start of struct st_rscan_from_rscan0tmidp */
    union iodefine_reg32_t  TMID25;                        /*  TMID25          */
    union iodefine_reg32_t  TMPTR25;                       /*  TMPTR25         */
    union iodefine_reg32_t  TMDF025;                       /*  TMDF025         */
    union iodefine_reg32_t  TMDF125;                       /*  TMDF125         */

/* end of struct st_rscan_from_rscan0tmidp */
    
/* start of struct st_rscan_from_rscan0tmidp */
    union iodefine_reg32_t  TMID26;                        /*  TMID26          */
    union iodefine_reg32_t  TMPTR26;                       /*  TMPTR26         */
    union iodefine_reg32_t  TMDF026;                       /*  TMDF026         */
    union iodefine_reg32_t  TMDF126;                       /*  TMDF126         */

/* end of struct st_rscan_from_rscan0tmidp */
    
/* start of struct st_rscan_from_rscan0tmidp */
    union iodefine_reg32_t  TMID27;                        /*  TMID27          */
    union iodefine_reg32_t  TMPTR27;                       /*  TMPTR27         */
    union iodefine_reg32_t  TMDF027;                       /*  TMDF027         */
    union iodefine_reg32_t  TMDF127;                       /*  TMDF127         */

/* end of struct st_rscan_from_rscan0tmidp */
    
/* start of struct st_rscan_from_rscan0tmidp */
    union iodefine_reg32_t  TMID28;                        /*  TMID28          */
    union iodefine_reg32_t  TMPTR28;                       /*  TMPTR28         */
    union iodefine_reg32_t  TMDF028;                       /*  TMDF028         */
    union iodefine_reg32_t  TMDF128;                       /*  TMDF128         */

/* end of struct st_rscan_from_rscan0tmidp */
    
/* start of struct st_rscan_from_rscan0tmidp */
    union iodefine_reg32_t  TMID29;                        /*  TMID29          */
    union iodefine_reg32_t  TMPTR29;                       /*  TMPTR29         */
    union iodefine_reg32_t  TMDF029;                       /*  TMDF029         */
    union iodefine_reg32_t  TMDF129;                       /*  TMDF129         */

/* end of struct st_rscan_from_rscan0tmidp */
    
/* start of struct st_rscan_from_rscan0tmidp */
    union iodefine_reg32_t  TMID30;                        /*  TMID30          */
    union iodefine_reg32_t  TMPTR30;                       /*  TMPTR30         */
    union iodefine_reg32_t  TMDF030;                       /*  TMDF030         */
    union iodefine_reg32_t  TMDF130;                       /*  TMDF130         */

/* end of struct st_rscan_from_rscan0tmidp */
    
/* start of struct st_rscan_from_rscan0tmidp */
    union iodefine_reg32_t  TMID31;                        /*  TMID31          */
    union iodefine_reg32_t  TMPTR31;                       /*  TMPTR31         */
    union iodefine_reg32_t  TMDF031;                       /*  TMDF031         */
    union iodefine_reg32_t  TMDF131;                       /*  TMDF131         */

/* end of struct st_rscan_from_rscan0tmidp */
    
    volatile uint8_t   dummy183[1536];                         /*                  */

/* #define RSCAN0_THLACC0_COUNT (2) */
    union iodefine_reg32_t  THLACC0;                       /*  THLACC0         */
    union iodefine_reg32_t  THLACC1;                       /*  THLACC1         */
    
} r_io_rscan0_t;


typedef struct st_rscan_from_rscan0cncfg
{
 
    union iodefine_reg32_t  CnCFG;                         /*  CnCFG           */
    union iodefine_reg32_t  CnCTR;                         /*  CnCTR           */
    union iodefine_reg32_t  CnSTS;                         /*  CnSTS           */
    union iodefine_reg32_t  CnERFL;                        /*  CnERFL          */
} r_io_rscan_from_rscan0cncfg_t;


typedef struct st_rscan_from_rscan0gaflidj
{
 
    union iodefine_reg32_t  GAFLIDj;                       /*  GAFLIDj         */
    union iodefine_reg32_t  GAFLMj;                        /*  GAFLMj          */
    union iodefine_reg32_t  GAFLP0j;                       /*  GAFLP0j         */
    union iodefine_reg32_t  GAFLP1j;                       /*  GAFLP1j         */
} r_io_rscan_from_rscan0gaflidj_t;


typedef struct st_rscan_from_rscan0rmidp
{
 
    union iodefine_reg32_t  RMIDp;                         /*  RMIDp           */
    union iodefine_reg32_t  RMPTRp;                        /*  RMPTRp          */
    union iodefine_reg32_t  RMDF0p;                        /*  RMDF0p          */
    union iodefine_reg32_t  RMDF1p;                        /*  RMDF1p          */
} r_io_rscan_from_rscan0rmidp_t;


typedef struct st_rscan_from_rscan0rfidm
{
 
    union iodefine_reg32_t  RFIDm;                         /*  RFIDm           */
    union iodefine_reg32_t  RFPTRm;                        /*  RFPTRm          */
    union iodefine_reg32_t  RFDF0m;                        /*  RFDF0m          */
    union iodefine_reg32_t  RFDF1m;                        /*  RFDF1m          */
} r_io_rscan_from_rscan0rfidm_t;


typedef struct st_rscan_from_rscan0tmidp
{
 
    union iodefine_reg32_t  TMIDp;                         /*  TMIDp           */
    union iodefine_reg32_t  TMPTRp;                        /*  TMPTRp          */
    union iodefine_reg32_t  TMDF0p;                        /*  TMDF0p          */
    union iodefine_reg32_t  TMDF1p;                        /*  TMDF1p          */
} r_io_rscan_from_rscan0tmidp_t;


typedef struct st_rscan_from_rscan0cfidm
{
 
    union iodefine_reg32_t  CFIDm;                         /*  CFIDm           */
    union iodefine_reg32_t  CFPTRm;                        /*  CFPTRm          */
    union iodefine_reg32_t  CFDF0m;                        /*  CFDF0m          */
    union iodefine_reg32_t  CFDF1m;                        /*  CFDF1m          */
} r_io_rscan_from_rscan0cfidm_t;


/* Channel array defines of RSCAN0 (2)*/
#ifdef  DECLARE_RSCAN_FROM_RSCAN0_CFIDm_CHANNELS
volatile struct st_rscan_from_rscan0cfidm*  RSCAN_FROM_RSCAN0_CFIDm[ RSCAN_FROM_RSCAN0_CFIDm_COUNT ] =
    /* ->MISRA 11.3 */ /* ->SEC R2.7.1 */
    RSCAN_FROM_RSCAN0_CFIDm_ADDRESS_LIST;
    /* <-MISRA 11.3 */ /* <-SEC R2.7.1 */
#endif  /* DECLARE_RSCAN_FROM_RSCAN0_CFIDm_CHANNELS */

#ifdef  DECLARE_RSCAN_FROM_RSCAN0_TMIDp_CHANNELS
volatile struct st_rscan_from_rscan0tmidp*  RSCAN_FROM_RSCAN0_TMIDp[ RSCAN_FROM_RSCAN0_TMIDp_COUNT ] =
    /* ->MISRA 11.3 */ /* ->SEC R2.7.1 */
    RSCAN_FROM_RSCAN0_TMIDp_ADDRESS_LIST;
    /* <-MISRA 11.3 */ /* <-SEC R2.7.1 */
#endif  /* DECLARE_RSCAN_FROM_RSCAN0_TMIDp_CHANNELS */

#ifdef  DECLARE_RSCAN_FROM_RSCAN0_RFIDm_CHANNELS
volatile struct st_rscan_from_rscan0rfidm*  RSCAN_FROM_RSCAN0_RFIDm[ RSCAN_FROM_RSCAN0_RFIDm_COUNT ] =
    /* ->MISRA 11.3 */ /* ->SEC R2.7.1 */
    RSCAN_FROM_RSCAN0_RFIDm_ADDRESS_LIST;
    /* <-MISRA 11.3 */ /* <-SEC R2.7.1 */
#endif  /* DECLARE_RSCAN_FROM_RSCAN0_RFIDm_CHANNELS */

#ifdef  DECLARE_RSCAN_FROM_RSCAN0_RMIDp_CHANNELS
volatile struct st_rscan_from_rscan0rmidp*  RSCAN_FROM_RSCAN0_RMIDp[ RSCAN_FROM_RSCAN0_RMIDp_COUNT ] =
    /* ->MISRA 11.3 */ /* ->SEC R2.7.1 */
    RSCAN_FROM_RSCAN0_RMIDp_ADDRESS_LIST;
    /* <-MISRA 11.3 */ /* <-SEC R2.7.1 */
#endif  /* DECLARE_RSCAN_FROM_RSCAN0_RMIDp_CHANNELS */

#ifdef  DECLARE_RSCAN_FROM_RSCAN0_GAFLIDj_CHANNELS
volatile struct st_rscan_from_rscan0gaflidj*  RSCAN_FROM_RSCAN0_GAFLIDj[ RSCAN_FROM_RSCAN0_GAFLIDj_COUNT ] =
    /* ->MISRA 11.3 */ /* ->SEC R2.7.1 */
    RSCAN_FROM_RSCAN0_GAFLIDj_ADDRESS_LIST;
    /* <-MISRA 11.3 */ /* <-SEC R2.7.1 */
#endif  /* DECLARE_RSCAN_FROM_RSCAN0_GAFLIDj_CHANNELS */

#ifdef  DECLARE_RSCAN_FROM_RSCAN0_CnCFG_CHANNELS
volatile struct st_rscan_from_rscan0cncfg*  RSCAN_FROM_RSCAN0_CnCFG[ RSCAN_FROM_RSCAN0_CnCFG_COUNT ] =
    /* ->MISRA 11.3 */ /* ->SEC R2.7.1 */
    RSCAN_FROM_RSCAN0_CnCFG_ADDRESS_LIST;
    /* <-MISRA 11.3 */ /* <-SEC R2.7.1 */
#endif  /* DECLARE_RSCAN_FROM_RSCAN0_CnCFG_CHANNELS */
/* End of channel array defines of RSCAN0 (2)*/


/* <-SEC M1.10.1 */
/* <-MISRA 18.4 */ /* <-SEC M1.6.2 */
/* <-QAC 0857 */
/* <-QAC 0639 */
#endif
