/*
* Copyright (C) 2006 TES Electronic Solutions GmbH,
* All Rights Reserved.
* This source code and any compilation or derivative thereof is the
* proprietary information of TES Electronic Solutions GmbH
* and is confidential in nature.
* Under no circumstances is this software to be exposed to or placed
* under an Open Source License of any type without the expressed
* written permission of TES Electronic Solutions GmbH
*
*############################################################
*/

/******************************************************************************
* PROJECT: Guiliani
*******************************************************************************
*
* MODULE: GUIInputExample.cpp
*
* Archive: $URL: https://10.25.129.51:3690/svn/Guiliani/branches/Releases/2.1/src/platform/RZA1H/GUIInputExample.cpp $
*
* Date created: 2004.10.01
*
*
*
* Author: sbo
*
*******************************************************************************
* MODIFICATIONS
*******************************************************************************
* ID
* -----------------------------------------------------------------------------
* $Id: GUIInputExample.cpp 4780 2017-02-21 16:00:16Z abhijeet.badurkar $
*
******************************************************************************/

#include "GUIInputExample.h"


extern "C"
{
#include "riic_rskrza1h.h"
#include "dev_drv.h"
}
#include "eC_String.h"
#include "GUIEvent.h"
#include "GUITimer.h"
#include "GfxWrap.h"
#include "GUI.h"
#include "GUIEventHandler.h"
#include "GUITrace.h"
#include "GUIMemLeakWatcher.h"
#include "WindowsLeakWatcher.h"

typedef enum
{
    TOUCH_COUNT = 2,
    TOUCH_X1_HIGH = 3,
    TOUCH_X1_LOW = 4,
    TOUCH_Y1_HIGH = 5,
    TOUCH_Y1_LOW = 6,
    TOUCH_X2_HIGH = 9,
    TOUCH_X2_LOW = 10,
    TOUCH_Y2_HIGH = 11,
    TOUCH_Y2_LOW = 12,
    TOUCH_X3_HIGH = 15,
    TOUCH_X3_LOW = 16,
    TOUCH_Y3_HIGH = 17,
    TOUCH_Y3_LOW = 18,
    TOUCH_X4_HIGH = 21,
    TOUCH_X4_LOW = 22,
    TOUCH_Y4_HIGH = 23,
    TOUCH_Y4_LOW = 24,
    TOUCH_X5_HIGH = 27,
    TOUCH_X5_LOW = 28,
    TOUCH_Y5_HIGH = 29,
    TOUCH_Y5_LOW = 30
} touch_data_offset_t;

const eC_Int TOUCHSCREEN_HEIGHT = 479;
const eC_Int TOUCHSCREEN_WIDTH = 799;

extern int32_t  g_touch_read_request;
CCGUIInputExample::CCGUIInputExample() :
    m_iLBtnPressedMouseX(0),
    m_iLBtnPressedMouseY(0),
    m_bLeftButtonPressed(false),
    m_bMouseMoved(false),
    m_bClicked(false),
    m_bStopIdle(false)
{

}

CCGUIInputExample::~CCGUIInputExample()
{
}

void CCGUIInputExample::CreateInstance()
{
    if (NULL == ms_pInputMedia)
    {
        ms_pInputMedia = new CCGUIInputExample();
    }
}

void CCGUIInputExample::StopIdle()
{
    m_bStopIdle = true;
}

CGUIEvent* CCGUIInputExample::GetEvent(eC_UInt uiIdleTime)
{
    CGUIEvent *pEvent = NULL;

    const eC_UInt cuiDataSize = 32;
    uint8_t  data[cuiDataSize];
    int32_t  ret = DEVDRV_ERROR;
    const eC_UInt uiSleepInterval = 10;
    const eC_UInt uiSleepCycles = uiIdleTime / uiSleepInterval;

    // wait for driver until new event arrives or Idle time reached
    if (uiIdleTime)
    {
        for (eC_UInt uiSleep = 0; uiSleep < uiSleepCycles; ++uiSleep)
        {
            R_OS_TaskSleep(uiSleepInterval);
            
            if (m_bStopIdle)
                break;

            if (g_touch_read_request)
                break;
        }
    }
    
    m_bStopIdle = false;
    if (g_touch_read_request != 0)
    {
        g_touch_read_request = 0;
        ret = R_RIIC_rza1h_rsk_read(DEVDRV_CH_0, RZA1H_APP_I2C_FT5216, 0, cuiDataSize, data);

        if (ret == DEVDRV_SUCCESS)
        {
            eC_UInt uiDown = data[TOUCH_COUNT];
            if (uiDown > 0)
            {
                m_bLeftButtonPressed = true;

                //touchscreen origin lies at right-bottom corner
                eC_Int iLBtnPressedMouseX = TOUCHSCREEN_WIDTH - (((data[TOUCH_X1_HIGH] & 0x7) << 8) + data[TOUCH_X1_LOW]);  //inverted value
                eC_Int iLBtnPressedMouseY = TOUCHSCREEN_HEIGHT - (((data[TOUCH_Y1_HIGH] & 0x7) << 8) + data[TOUCH_Y1_LOW]); //inverted value

                if (m_bMouseMoved)
                {
                    pEvent = new CGUIMouseEvent(ET_MOUSEMOVE, iLBtnPressedMouseX, iLBtnPressedMouseY, true, false);
                }
                else
                {
                    pEvent = new CGUIMouseEvent(ET_LBUTTONDOWN, iLBtnPressedMouseX, iLBtnPressedMouseY, true);
                    m_bClicked = true;
                }
                //Remember the clicked point.
                m_iLBtnPressedMouseX = iLBtnPressedMouseX;
                m_iLBtnPressedMouseY = iLBtnPressedMouseY;

                //Set moved to true
                m_bMouseMoved = true;

            }
            else if (uiDown == 0)
            {
                m_bLeftButtonPressed = false;

                if (m_bClicked)
                {
                    pEvent = new CGUIMouseEvent(ET_LBUTTONUP, m_iLBtnPressedMouseX, m_iLBtnPressedMouseY);
                    m_bClicked = false;
                }
                //Mouse hasn't moved
                m_bMouseMoved = false;
            }
        }
    }
    return pEvent;
}
