/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#ifndef DCWRAP_NULL__H_
#define DCWRAP_NULL__H_

#include "DCWrap.h"

#include "GUILayerConfig.h"

class CGfxWrap;
class CGUIObject;

/**
    This is the base class for abstracting the use of display-controllers.

    @ingroup GUILIANI_GRAPHICS
*/
class CDCWrapNull : public CDCWrap
{
public:
    /// Destructor
    virtual ~CDCWrapNull(void) {}

    CDCWrapNull() :
        CDCWrap()
    {}

    eC_Bool IsNull() { return true; }

protected:
    /** Copy-constructor.
        @param kSource Source object to be copied.
    */
    CDCWrapNull(const CDCWrapNull& kSource);

    /** Operator= method.
        @param kSource Source object to be copied.
        @return This instance.
    */
    CDCWrapNull& operator=(const CDCWrapNull& kSource);
};

#endif
