/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#ifndef GUIIMAGEDECODERBMP__H_
#define GUIIMAGEDECODERBMP__H_

#include "eC_Types.h"
#include "eC_String.h"
#include "eC_File.h"
#include "GUIImageData.h"

#include "GUIImageDecoder.h"


/// Class GUIImageDecoderBMP which loads an image and returns a pointer to a GUIImageData object.

class CGUIImageDecoderBMP : public CGUIImageDecoder
{
public:
    CGUIImageDecoderBMP();

    virtual eC_Bool LoadImg(CGUIImageData& rkImageData, eC_File* pkImageFile);

private:
    /** Struct for the Bitmap header. */
    struct BitmapHeader_t
    {
        char acType[2];
        unsigned char acSize[4];
        char acR1[4];
        unsigned char acOffBits[4];
    };

    /** Struct for the Bitmap info */
    struct BitmapInfo_t
    {
        unsigned long ulSize;
        long lWidth;
        long lHeight;
        unsigned short usPlanes;
        unsigned short usBitCount;
        unsigned long ulCompression;
        unsigned long ulSizeImage;
        long lXPPM;
        long lYPPM;
        unsigned long ulTotalColors;
        unsigned long ulImportantColors;
    };

private:
    /** Reverts the bytes of the whole data pointer.
    ATTENTION: If use this method, please ensure that
    the pubData has really the given length.
    @param pubData pointer to the data.
    @param uiLen Length of the data pointed to in bytes.
    */
    void RevertBytes(eC_UByte* pubData, const eC_UInt& uiLen);

    eC_UInt GetColorFromPalette(const eC_UByte& ubIndex);

private:
    eC_Bool m_bIsPalettized;
    eC_UInt* m_pkPalette;
    eC_UInt m_uiPaletteSize;
};

#endif
