/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#if !defined GUI_TEXT_TYPE_RESOURCE_H
#define GUI_TEXT_TYPE_RESOURCE_H
#include <limits.h>

/// @file GUITextTypeResource.h @ref page_helpermacros
// 
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
//

/** The types of text classes.
    When adding new types here, adjust the start tag to make sure that
    TT_DUMMY_TEXT is zero.
  */
//Add Guiliani-TextType resources here and adapt TT_START_TAG so that TT_DUMMY_TEXT is equal to 0.
#define TEXTTYPE_TABLE            \
ENTRY(TT_RICH_TEXT, CGUIRichText) \
ENTRY(TT_SCROLLING_TEXT, CGUIScrollingText) \
ENTRY(TT_STANDARD_TEXT, CGUIText) \
ENTRY(TT_EDITABLE_TEXT, CGUIEditableText) 

#ifndef GUILIANI_GUILIANILIB
#include "UserTextTypeResource.h"
#endif

/// List of text type resource ids.
enum TextTypeID_t
{
    TT_START_TAG = -5,
#define ENTRY_ENUM(a) a, ///< \ref page_helpermacros
#define ENTRY(a, b) a, ///< \ref page_helpermacros
    TEXTTYPE_TABLE

    TT_DUMMY_TEXT=0,
#ifndef GUILIANI_GUILIANILIB
    USER_TEXTTYPE_TABLE
#endif
#undef ENTRY
#undef ENTRY_ENUM
    GUILIANI_INTERNAL_TT = INT_MAX // Do not touch this. Required for ensuring consistent enum type size across libraries.
};

#endif // GUI_TEXT_TYPE_RESOURCE_H
