/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#ifndef GUI_TEXT_RESOURCE__H_
#define GUI_TEXT_RESOURCE__H_
#include "eC_Types.h"
#include <limits.h>

/// @file GUITextResource.h @ref page_helpermacros
// 
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
//

// -----------------------------------------------------------------------------------------
///  Text resources
#define TEXT_TABLE     \
    ENTRY(DUMMY_TEXT)

// Calculate the value for the START_TAG used in th enum definition below.
#define ENTRY_ENUM(a) -1 ///< \ref page_helpermacros
#define ENTRY(a) -1///< \ref page_helpermacros
const int ciCalculatedTextStartTag = TEXT_TABLE; ///< preprocessor generates for all entries of TEXT_TABLE: -1 -1 -1..., resulting in a mathematical expression, that will be evaluated to -1*(Number of entries of IMAGE_TABLE 
#undef ENTRY
#undef ENTRY_ENUM

#ifndef GUILIANI_GUILIANILIB
    #include "UserTextResource.h"
#endif

/// List of text resource ids.
enum TextResource_t
{
    TEXT_START_TAG = ciCalculatedTextStartTag,
#define ENTRY_ENUM(a) a, ///< \ref page_helpermacros
#define ENTRY(a) a, ///< \ref page_helpermacros
    TEXT_TABLE
    // There are no default texts! All texts that are subject to internationalization are defined
    // by the user.
#ifndef GUILIANI_GUILIANILIB
    USER_TEXT_TABLE
#endif
#undef ENTRY
#undef ENTRY_ENUM
    NOF_TEXTRESOURCES,
    GUILIANI_INTERNAL_TEXT = INT_MAX // Do not touch this. Required for ensuring consistent enum type size across libraries.
};


// Check if the DUMMY value is always 0. If not compile error!
typedef int static_assert_something[(DUMMY_TEXT == 0) ? 1 : -1]; ///< Will throw compile error negative subscript if DUMMY_TEXT is NOT 0!

/// Map TextResource_t to interval 0 to NOF_TEXTRESOURCES
#define MAP_TEXTID_TO_ARRAY(TEXT_ID) static_cast<eC_UInt>(TEXT_ID-TEXT_START_TAG-1)
/// Unmap TextResource_t from interval 0 to NOF_TEXTRESOURCES
#define UNMAP_TEXTENTRY_TO_ARRAY(TEXT_ENTRY) static_cast<TextResource_t>(TEXT_ENTRY+TEXT_START_TAG+1)
// Amount of resources.
extern const eC_UInt cuiNOFTextResources; ///< Used to contain the highest index cuiNOFXXXClasses = MAP_PROPID_TO_ARRAY(NOF_XXXCLASSES);

#endif
