/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#ifndef GUI_SOUND_RESOURCE__H_
#define GUI_SOUND_RESOURCE__H_
#include "eC_Types.h"
#include <limits.h>

/// @file GUISoundResource.h @ref page_helpermacros
// 
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
//

// -----------------------------------------------------------------------------------------
///  sound resources
// Attention: If a sound ID is added, please also change the number of SND_START_TAG,
// so that DUMMY_SOUND is always 0, which should guarantee that the user
// ID numbers will not be affected when adding Guiliani IDs.
// If you add a new Guiliani control you should add it in front of the enumeration
// so that the other Guiliani IDs will not be shifted, i.e. add the
// new Guiliani ID right after SND_START_TAG.

//Add Guiliani-SoundResources here:
#define SOUND_TABLE            \
ENTRY(DUMMY_SOUND, "DUMMY_SOUND", true)

// Calculate the value for the START_TAG used in th enum definition below.
#define ENTRY_ENUM(a) -1 ///< \ref page_helpermacros
#define ENTRY(snd, snd_filename, snd_permanent) -1///< \ref page_helpermacros
const int ciCalculatedSndStartTag = SOUND_TABLE; ///< preprocessor generates for all entries of SOUND_TABLE: -1 -1 -1..., resulting in a mathematical expression, that will be evaluated to -1*(Number of entries of IMAGE_TABLE 
#undef ENTRY
#undef ENTRY_ENUM

#ifndef GUILIANI_GUILIANILIB
#include "UserSoundResource.h"
#endif

/// List of sound resource ids.
enum SoundResource_t
{
    SND_START_TAG = ciCalculatedSndStartTag,
#define ENTRY_ENUM(a) a, ///< \ref page_helpermacros
#define ENTRY(snd, snd_filename, snd_permanent) snd, ///< \ref page_helpermacros
    SOUND_TABLE
#ifndef GUILIANI_GUILIANILIB
    USER_SOUND_TABLE
#endif
#undef ENTRY
#undef ENTRY_ENUM
    NOF_SOUNDRESOURCES,
    GUILIANI_INTERNAL_SND = INT_MAX // Do not touch this. Required for ensuring consistent enum type size across libraries.
};

// Check if the DUMMY value is always 0. If not compile error!
typedef int static_assert_something[(DUMMY_SOUND == 0) ? 1 : -1]; ///< Will throw compile error negative subscript if DUMMY_SOUND is NOT 0!


/// Map SoundIDs to interval 0 to NOF_SOUNDRESOURCES
#define MAP_SNDID_TO_ARRAY(SND_ID) static_cast<eC_UInt>(SND_ID-SND_START_TAG-1)
/// Unmap SoundIDs to interval 0 to NOF_SOUNDRESOURCES
#define UNMAP_SNDENTRY_TO_ARRAY(SND_ENTRY) static_cast<SoundResource_t>(SND_ENTRY+SND_START_TAG+1)
// Amount of resources.
extern const eC_UInt cuiNOFSoundResources; ///< Used to contain the highest index cuiNOFXXXClasses = MAP_PROPID_TO_ARRAY(NOF_XXXCLASSES);

#endif
