/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

/// @file GUIPropertyResource.h @ref page_helpermacros
// 
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
//

#ifndef GUI_PROPERTY_RESOURCE__H_
#define GUI_PROPERTY_RESOURCE__H_

#include "eC_Types.h"

#include <limits.h>

// -----------------------------------------------------------------------------------------
/// IDs for global properties. They are set per default in CGUI::Init(). The user can either
/// call this method in
/// its own GUI-init-routine in order to use them or he or she can overwrite them.
/// If CGUI::Init() is called one must be sure that the graphics wrapper is already
/// instantiated!


    //Add Guiliani-GlobalProperties here (with negative IDs, DUMMY_PROPERTY has to stay 0):
#define PROPERTY_TABLE            \
    ENTRY(GUI_PROP_DEFAULT_LINE_WIDTH, 3, CGUIValue::EC_INT) \
    ENTRY(GUI_PROP_DEFAULT_TEXT_ALIGNMENT, CGUIText::H_LEFT, CGUIValue::EC_INT) \
    ENTRY(GUI_PROP_DEFAULT_TEXT_COLOR, 0xFF444444, CGUIValue::EC_HEX)  \
    ENTRY(GUI_PROP_DEFAULT_PRESSED_TEXT_COLOR, 0xFF646464, CGUIValue::EC_HEX)  \
    ENTRY(GUI_PROP_DEFAULT_HIGHLIGHT_TEXT_COLOR, 0xFF7D7D7D, CGUIValue::EC_HEX)  \
    ENTRY(GUI_PROP_DEFAULT_COLOR, 0xFFADADAD, CGUIValue::EC_HEX)  \
    ENTRY(GUI_PROP_DEFAULT_PRESSED_COLOR, 0xFF3D3D3D, CGUIValue::EC_HEX)  \
    ENTRY(GUI_PROP_DEFAULT_HIGHLIGHT_COLOR, 0xFFDFDFDF, CGUIValue::EC_HEX)  \
    ENTRY(GUI_PROP_DEFAULT_FOREGROUND_COLOR, 0xFFFFFFFF, CGUIValue::EC_HEX)  \
    ENTRY(GUI_PROP_DEFAULT_BACKGROUND_COLOR, 0xFF000000, CGUIValue::EC_HEX)  \
    ENTRY(GUI_PROP_DEFAULT_FONT, FNT_DEFAULT, CGUIValue::EC_INT)  \
    ENTRY(GUI_PROP_DEFAULT_FONT_SIZE, 13.0, CGUIValue::EC_FLOAT)  \
    ENTRY(GUI_PROP_DEFAULT_FONT_SPACING, 0.0, CGUIValue::EC_FLOAT)  \
    ENTRY(GUI_PROP_DEFAULT_BG_LIGHT_COLOR, 0xFF999999, CGUIValue::EC_HEX)  \
    ENTRY(GUI_PROP_DEFAULT_BG_DARK_COLOR, 0xFF777777, CGUIValue::EC_HEX)  \
    ENTRY(GUI_PROP_SLIDER_KNOB_SIZE, 16, CGUIValue::EC_INT)  \
    ENTRY(GUI_PROP_LISTBOX_DRAGGED_FRAME_COLOR, 0x80a6b6df, CGUIValue::EC_HEX)  \
    ENTRY(GUI_PROP_USE_STANDARD_IMAGES, true, CGUIValue::EC_BOOL)  \
    ENTRY(DUMMY_PROPERTY, 0, CGUIValue::EC_INT)

// Calculate the value for the START_TAG used in th enum definition below.
#define ENTRY_ENUM(a) -1 ///< \ref page_helpermacros
#define ENTRY(prop_name, prop_value, prop_type) -1///< \ref page_helpermacros
const int ciCalculatedPropStartTag = PROPERTY_TABLE; ///< preprocessor generates for all entries of PROPERTY_TABLE: -1 -1 -1..., resulting in a mathematical expression, that will be evaluated to -1*(Number of entries of IMAGE_TABLE 
#undef ENTRY
#undef ENTRY_ENUM

#ifndef GUILIANI_GUILIANILIB
    #include "UserPropertyResource.h" 
#endif

/// List of property resource ids.
enum GlobalProperty_t
{
    GUI_PROP_START_TAG = ciCalculatedPropStartTag,
#define ENTRY_ENUM(a) a, ///< \ref page_helpermacros
#define ENTRY(prop_name, prop_value, prop_type) prop_name, ///< \ref page_helpermacros
    PROPERTY_TABLE
#ifndef GUILIANI_GUILIANILIB
    USER_PROPERTY_TABLE
#endif
#undef ENTRY
#undef ENTRY_ENUM
    NOF_PROPERTIES,        // Please do not change this entry!!!
    GUILIANI_INTERNAL_GUI_PROP = INT_MAX // Do not touch this. Required for ensuring consistent enum type size across libraries.
};

// Check if the DUMMY value is always 0. If not compile error!
typedef int static_assert_something[(DUMMY_PROPERTY == 0) ? 1 : -1]; ///< Will throw compile error negative subscript if DUMMY_PROPERTY is NOT 0!

/// Map GlobalProperty_t to interval 0 to NOF_PROPERTIES
#define MAP_PROPID_TO_ARRAY(PROP_ID) static_cast<eC_UInt>(PROP_ID-GUI_PROP_START_TAG-1)
/// Unmap GlobalProperty_t from interval 0 to NOF_PROPERTIES
#define UNMAP_PROPENTRY_TO_ARRAY(PROP_ENTRY) static_cast<GlobalProperty_t>(PROP_ENTRY+GUI_PROP_START_TAG+1)
// Amount of resources.
extern const eC_UInt cuiNOFGlobalProperties; ///< Used to contain the highest index cuiNOFXXXClasses = MAP_PROPID_TO_ARRAY(NOF_XXXCLASSES);

#endif
