/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#ifndef GUI_OBJECTHANDLE_RESOURCE__H_
#define GUI_OBJECTHANDLE_RESOURCE__H_
#include "eC_Types.h"
#include <limits.h>

/// @file GUIObjectHandleResource.h @ref page_helpermacros
// 
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
//

// -----------------------------------------------------------------------------------------
///  Object Handles
// Attention: If a new ID is added, please also change the number of OBJ_START_TAG,
// so that NO_HANDLE is always 0, which should guarantee that the user
// ID numbers will not be affected when adding Guiliani IDs.
// If you add a new Guiliani ID you should add it in front of the enumeration
// so that the other Guiliani IDs will not be shifted, i.e. add the
// new Guiliani ID below.

// Please add Guiliani ObjectIDs right here:
#define OBJECTID_TABLE            \
ENTRY(OBJ_MSGBOX_SAVEAS) \
ENTRY(OBJ_MSGBOX_SAVE) \
ENTRY(OBJ_MSGBOX_CANCEL) \
ENTRY(OBJ_MSGBOX_OK) \
ENTRY(OBJ_KEYBOARD_LAYOUT_ABC_CAPITAL) \
ENTRY(OBJ_KEYBOARD_LAYOUT_ABC) \
ENTRY(OBJ_KEYBOARD_LAYOUT_123) \
ENTRY(OBJ_KEYBOARD_LAYOUT_SYM) 

// Calculate the value for the START_TAG used in th enum definition below.
#define ENTRY_ENUM(a) -1 ///< \ref page_helpermacros
#define ENTRY(obj_id) -1///< \ref page_helpermacros
const int ciCalculatedObjStartTag = OBJECTID_TABLE; ///< preprocessor generates for all entries of OBJECTID_TABLE: -1 -1 -1..., resulting in a mathematical expression, that will be evaluated to -1*(Number of entries of IMAGE_TABLE
#undef ENTRY
#undef ENTRY_ENUM

#ifndef GUILIANI_GUILIANILIB
    #include "UserObjectResource.h"
#endif

/// List of object resource ids.
enum ObjectHandle_t
{
    OBJ_START_TAG = ciCalculatedObjStartTag-1,
#define ENTRY_ENUM(a) a, ///< \ref page_helpermacros
#define ENTRY(obj_id) obj_id, ///< \ref page_helpermacros
    OBJECTID_TABLE
    NO_HANDLE, // must be a constant 0
#ifndef GUILIANI_GUILIANILIB
    USER_OBJECTID_TABLE
#endif
#undef ENTRY
#undef ENTRY_ENUM
    NOF_OBJECTHANDLES,
    GUILIANI_INTERNAL_ID = INT_MAX // Do not touch this. Required for ensuring consistent enum type size across libraries.
};

// Check if the DUMMY value is always 0. If not compile error!
typedef int static_assert_something[(NO_HANDLE == 0) ? 1 : -1]; ///< Will throw compile error negative subscript if NO_HANDLE is NOT 0!

/// Map Object Handles to interval 0 to NOF_OBJECTHANDLES
#define MAP_OBJID_TO_ARRAY(OBJ_ID) static_cast<eC_UInt>(OBJ_ID-OBJ_START_TAG-1)
/// Unmap Object Handles from interval 0 to NOF_OBJECTHANDLES
#define UNMAP_OBJENTRY_TO_ARRAY(OBJ_ENTRY) static_cast<ObjectHandle_t>(OBJ_ENTRY+OBJ_START_TAG+1)
// Amount of resources.
extern const eC_UInt cuiNOFObjectHandles; ///< Used to contain the highest index cuiNOFXXXClasses = MAP_PROPID_TO_ARRAY(NOF_XXXCLASSES);

#endif
