/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#ifndef GUI_LOCALE_RESOURCE__H_
#define GUI_LOCALE_RESOURCE__H_
#include "eC_Types.h"
#include <limits.h>

/// @file GUILocaleResource.h @ref page_helpermacros
// 
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
//

// -----------------------------------------------------------------------------------------
///  Locale Handles
#ifndef GUILIANI_GUILIANILIB
    #include "UserLocaleResource.h"
#endif

#define LOCALE_TABLE
// ENTRY(GERMAN)
//Add Guiliani-LocaleHandle_t here (Last Guiliani Locale Handle has to stay 0)

/// List of locale resource ids.
enum LocaleHandle_t
{
    LOC_START_TAG=-1,
#define ENTRY_ENUM(a) a, ///< \ref page_helpermacros
#define ENTRY(id) id, ///< \ref page_helpermacros
    LOCALE_TABLE
    L_DEFAULT=0,
#ifndef GUILIANI_GUILIANILIB
    USER_LOCALE_TABLE
#endif
#undef ENTRY
#undef ENTRY_ENUM
    NOF_LOCALEHANDLES,
    GUILIANI_INTERNAL_LOC = INT_MAX // Do not touch this. Required for ensuring consistent enum type size across libraries.
};
/// Map LocaleHandle_t to interval 0 to NOF_LOCALEHANDLES
#define MAP_LOCID_TO_ARRAY(LOC_ID) static_cast<eC_UInt>(LOC_ID-LOC_START_TAG-1)
/// Unmap LocaleHandle_t from interval 0 to NOF_LOCALEHANDLES
#define UNMAP_LOCENTRY_TO_ARRAY(LOC_ENTRY) static_cast<LocaleHandle_t>(LOC_ENTRY+LOC_START_TAG+1)
// Amount of resources.
extern const eC_UInt cuiNOFLocaleHandles; ///< Used to contain the highest index cuiNOFXXXClasses = MAP_PROPID_TO_ARRAY(NOF_XXXCLASSES);

#endif
