/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#ifndef GUI_LAYOUTER_RESOURCE__H_
#define GUI_LAYOUTER_RESOURCE__H_
#include <limits.h>

/// @file GUILayouterResource.h @ref page_helpermacros
// 
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
//

// -----------------------------------------------------------------------------------------
///  LayouterIDs
#define LAYOUTER_TABLE            \
ENTRY(LAYOUTER_PERCENTAGE, CGUILayouterPercentage) \
ENTRY(LAYOUTER_ALIGN_TO_PARENT, CGUILayouterAlignToParent) \
ENTRY(LAYOUTER_LIST, CGUILayouterList) \
ENTRY(LAYOUTER_GRID, CGUILayouterGrid) \
ENTRY(LAYOUTER_REPOSITION, CGUILayouterReposition) \
ENTRY(LAYOUTER_ANCHOR, CGUILayouterAnchor) 

// Calculate the value for the START_TAG used in th enum definition below.
#define ENTRY_ENUM(a) -1 ///< \ref page_helpermacros
#define ENTRY(lay, layclass) -1///< \ref page_helpermacros
const int ciCalculatedLayStartTag = LAYOUTER_TABLE; ///< preprocessor generates for all entries of SOUND_TABLE: -1 -1 -1..., resulting in a mathematical expression, that will be evaluated to -1*(Number of entries of IMAGE_TABLE 
#undef ENTRY
#undef ENTRY_ENUM

/// List of layouter resource ids.
enum LayouterClassID_t
{
    LAYOUTER_START_TAG = ciCalculatedLayStartTag - 1, // we left out DUMMY_LAYOUTER

#define ENTRY_ENUM(a) a, ///< \ref page_helpermacros
#define ENTRY(layouter_id, layouter_classname) layouter_id, ///< \ref page_helpermacros
    LAYOUTER_TABLE

    DUMMY_LAYOUTER, // must be a constant 0
#undef ENTRY
#undef ENTRY_ENUM

    GUILIANI_INTERNAL_LAYOUTER = INT_MAX // Do not touch this. Required for ensuring consistent enum type size across libraries.
};

// Check if the DUMMY value is always 0. If not compile error!
typedef int static_assert_something[(DUMMY_LAYOUTER == 0) ? 1 : -1]; ///< Will throw compile error negative subscript if DUMMY_LAYOUTER is NOT 0!

#endif
