/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#ifndef GUI_IMAGE_RESOURCE__H_
#define GUI_IMAGE_RESOURCE__H_
#include "eC_Types.h"
#include <limits.h>

/// @file GUIImageResource.h @ref page_helpermacros
// 
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
//

// -----------------------------------------------------------------------------------------
//  image resources
// Attention: If an image ID is added, please also change the number of IMG_START_TAG,
// so that DUMMY_IMAGE is always 0, which should guarantee that the user
// ID numbers will not be affected when adding Guiliani IDs.
// If you add a new Guiliani image you should add it in front of the enumeration
// so that the other Guiliani IDs will not be shifted, i.e. add the
// new Guiliani ID right after IMG_START_TAG.

//Add Guiliani-ImageResources here:
/// Enum table of all Guiliani internal images.
#define IMAGE_TABLE            \
    ENTRY(IMG_STDCTRL_SEGMENT_UNFILLED, "SegmentUnfilled.png", true) \
    ENTRY(IMG_STDCTRL_SEGMENT_FILLED, "SegmentFilled.png", true) \
    ENTRY(IMG_STDCTRL_KNOB_BG, "KnobBG.png", true) \
    ENTRY(IMG_STDCTRL_KNOB_HANDLE, "KnobHandle.png", true) \
    ENTRY(IMG_STDCTRL_CIRCULAR_BG, "CircularBG.png", true) \
    ENTRY(IMG_STDCTRL_CIRCULAR_KNOB, "CircularKnob.png", true) \
    ENTRY(IMG_STDCTRL_CIRCULAR_KNOB_H, "CircularKnobH.png", true) \
    ENTRY(IMG_STDCTRL_CIRCULAR_KNOB_P, "CircularKnobP.png", true) \
    ENTRY(IMG_STDCTRL_CIRCULAR_KNOB_G, "CircularKnobG.png", true) \
    ENTRY(IMG_STDCTRL_CLOCK_BG, "ClockBackground.png", true) \
    ENTRY(IMG_STDCTRL_CLOCK_HOUR, "ClockHour.png", true) \
    ENTRY(IMG_STDCTRL_CLOCK_MINUTE, "ClockMinute.png", true) \
    ENTRY(IMG_STDCTRL_CLOCK_SECOND, "ClockSecond.png", true) \
    ENTRY(IMG_STDCTRL_COMBOBOX_BTN, "ComboButton.png", true) \
    ENTRY(IMG_STDCTRL_COMBOBOX_BTN_H, "ComboButton_H.png", true) \
    ENTRY(IMG_STDCTRL_COMBOBOX_BTN_P, "ComboButton_P.png", true) \
    ENTRY(IMG_STDCTRL_COMBOBOX_BTN_G, "ComboButton_G.png", true) \
    ENTRY(IMG_STDCTRL_COMBOBOX_BTN_F, "ComboButton_F.png", true) \
    ENTRY(IMG_STDCTRL_BUTTON_LEFT, "ButtonLeft.png", true) \
    ENTRY(IMG_STDCTRL_BUTTON_RIGHT, "ButtonRight.png", true) \
    ENTRY(IMG_STDCTRL_BUTTON_UP, "ButtonUp.png", true) \
    ENTRY(IMG_STDCTRL_BUTTON_DOWN, "ButtonDown.png", true) \
    ENTRY(IMG_STDCTRL_SCROLLBAR_BACK_H, "ScrollbarBackH.png", true) \
    ENTRY(IMG_STDCTRL_SCROLLBAR_SLD_H, "ScrollbarSliderH.png", true) \
    ENTRY(IMG_STDCTRL_SCROLLBAR_BACK_V, "ScrollbarBackV.png", true) \
    ENTRY(IMG_STDCTRL_SCROLLBAR_SLD_V, "ScrollbarSliderV.png", true) \
    ENTRY(IMG_STDCTRL_PROGRESS_BG, "ProgressBack.png", true) \
    ENTRY(IMG_STDCTRL_PROGRESS_H, "ProgressH.png", true) \
    ENTRY(IMG_STDCTRL_PROGRESS_V, "ProgressV.png", true) \
    ENTRY(IMG_STDCTRL_FAKE_MOUSE_CURSOR, "FakeMouseCursor.png", true) \
    ENTRY(IMG_STDCTRL_GAUGE_NEEDLE, "GaugeNeedle.png", true) \
    ENTRY(IMG_STDCTRL_GAUGE, "Gauge.png", true)    \
    ENTRY(IMG_STDCTRL_KEYBOARDBTN_FOCUSED, "KeyboardButtonFocussed.png", true)    \
    ENTRY(IMG_STDCTRL_KEYBOARDBTN_PRESSED, "KeyboardButtonPressed.png", true)    \
    ENTRY(IMG_STDCTRL_KEYBOARDBTN_HIGHLIGHTED, "KeyboardButtonHighlighted.png", true)    \
    ENTRY(IMG_STDCTRL_KEYBOARDBTN_GRAYED_OUT, "KeyboardButtonGrayedOut.png", true)    \
    ENTRY(IMG_STDCTRL_KEYBOARDBTN_STANDARD, "KeyboardButtonStandard.png", true)    \
    ENTRY(IMG_STDCTRL_INPUTFIELD_STANDARD, "InputFieldStandard.png", true)    \
    ENTRY(IMG_STDCTRL_INPUTFIELD_HIGHLIGHTED, "InputFieldHighlighted.png", true)    \
    ENTRY(IMG_STDCTRL_INPUTFIELD_FOCUSSED, "InputFieldFocussed.png",true)    \
    ENTRY(IMG_STDCTRL_INPUTFIELD_GRAYEDOUT, "InputFieldGrayedout.png", true)    \
    ENTRY(IMG_STDCTRL_PLACEHOLDER, "PlaceHolder.png", true)    \
    ENTRY(IMG_STDCTRL_MENUITEM_SELECTED, "ButtonFocussed.png", true)    \
    ENTRY(IMG_STDCTRL_MENUITEM_FOCUSED, "ButtonFocussed.png", true)    \
    ENTRY(IMG_STDCTRL_MENUITEM_PRESSED, "ButtonPressed.png", true)    \
    ENTRY(IMG_STDCTRL_MENUITEM_HIGHLIGHTED, "ButtonHighlighted.png", true)    \
    ENTRY(IMG_STDCTRL_MENUITEM_GRAYED_OUT, "ButtonGrayedout.png", true)    \
    ENTRY(IMG_STDCTRL_MENUITEM_STANDARD, "ButtonStandard.png", true)    \
    ENTRY(IMG_STDCTRL_IMGBTN_FOCUSED, "ButtonFocussed.png", true)    \
    ENTRY(IMG_STDCTRL_IMGBTN_PRESSED, "ButtonPressed.png", true)    \
    ENTRY(IMG_STDCTRL_IMGBTN_HIGHLIGHTED, "ButtonHighlighted.png", true)    \
    ENTRY(IMG_STDCTRL_IMGBTN_GRAYED_OUT, "ButtonGrayedout.png", true)    \
    ENTRY(IMG_STDCTRL_IMGBTN_STANDARD, "ButtonStandard.png", true)    \
    ENTRY(IMG_STDCTRL_SLD_BG, "SliderNormalBG.png", true)    \
    ENTRY(IMG_STDCTRL_SLD_KNOB_NORMAL, "SliderNormalKnob.png", true)    \
    ENTRY(IMG_STDCTRL_SLD_KNOB_HIGHLIGHTED, "SliderHighlightedKnob.png", true)    \
    ENTRY(IMG_STDCTRL_SLD_KNOB_PRESSED, "SliderPressedKnob.png", true)    \
    ENTRY(IMG_STDCTRL_RB_SELECTED_FOCUSSED, "RBSelectedFocussed.png", true)    \
    ENTRY(IMG_STDCTRL_RB_SELECTED_HIGHLIGHTED, "RBSelectedHighlighted.png", true)    \
    ENTRY(IMG_STDCTRL_RB_SELECTED_PRESSED, "RBSelectedPressed.png", true)    \
    ENTRY(IMG_STDCTRL_RB_SELECTED_NORMAL, "RBSelectedNormal.png", true)    \
    ENTRY(IMG_STDCTRL_RB_SELECTED_GRAYEDOUT, "RBSelectedGrayedOut.png", true)    \
    ENTRY(IMG_STDCTRL_RB_NOTSELECTED_FOCUSSED, "RBNotSelectedFocussed.png", true)    \
    ENTRY(IMG_STDCTRL_RB_NOTSELECTED_HIGHLIGHTED, "RBNotSelectedHighlighted.png", true)    \
    ENTRY(IMG_STDCTRL_RB_NOTSELECTED_PRESSED, "RBNotSelectedPressed.png", true)    \
    ENTRY(IMG_STDCTRL_RB_NOTSELECTED_NORMAL, "RBNotSelectedNormal.png", true)    \
    ENTRY(IMG_STDCTRL_RB_NOTSELECTED_GRAYEDOUT, "RBNotSelectedGrayedOut.png", true)    \
    ENTRY(IMG_STDCTRL_CHECKBOX_NOTSELECTED_FOCUSSED, "CheckBoxNotSelectedFocussed.png", true)    \
    ENTRY(IMG_STDCTRL_CHECKBOX_NOTSELECTED_HIGHLIGHTED, "CheckBoxNotSelectedHighlighted.png", true)    \
    ENTRY(IMG_STDCTRL_CHECKBOX_NOTSELECTED_PRESSED, "CheckBoxNotSelectedPressed.png", true)    \
    ENTRY(IMG_STDCTRL_CHECKBOX_NOTSELECTED_NORMAL, "CheckBoxNotSelectedNormal.png", true)    \
    ENTRY(IMG_STDCTRL_CHECKBOX_NOTSELECTED_GRAYEDOUT, "CheckBoxNotSelectedGrayedOut.png", true)    \
    ENTRY(IMG_STDCTRL_CHECKBOX_SELECTED_FOCUSSED, "CheckBoxSelectedFocussed.png", true)    \
    ENTRY(IMG_STDCTRL_CHECKBOX_SELECTED_HIGHLIGHTED, "CheckBoxSelectedHighlighted.png", true)    \
    ENTRY(IMG_STDCTRL_CHECKBOX_SELECTED_PRESSED, "CheckBoxSelectedPressed.png", true)    \
    ENTRY(IMG_STDCTRL_CHECKBOX_SELECTED_NORMAL, "CheckBoxSelectedNormal.png", true)    \
    ENTRY(IMG_STDCTRL_CHECKBOX_SELECTED_GRAYEDOUT, "CheckBoxSelectedGrayedOut.png", true)   \
    ENTRY(DUMMY_IMAGE, "DUMMY_IMAGE", true)

// Calculate the value for the START_TAG used in th enum definition below.
#define ENTRY_ENUM(a) -1 ///< \ref page_helpermacros
#define ENTRY(img, img_filename, img_permanent) -1///< \ref page_helpermacros
const int ciCalculatedImgStartTag = IMAGE_TABLE; ///< preprocessor generates for all entries of IMAGE_TABLE: -1 -1 -1..., resulting in a mathematical expression, that will be evaluated to -1*(Number of entries of IMAGE_TABLE 
#undef ENTRY
#undef ENTRY_ENUM

#ifndef GUILIANI_GUILIANILIB
#include "UserImageResource.h"
#endif

/// Enumeration of image resource ids. 
enum ImageResource_t
{
    IMG_START_TAG = ciCalculatedImgStartTag,
#define ENTRY_ENUM(a) a, ///< \ref page_helpermacros
#define ENTRY(img, img_filename, img_permanent) img, ///< \ref page_helpermacros
    IMAGE_TABLE
#ifndef GUILIANI_GUILIANILIB
    USER_IMAGE_TABLE
#endif
#undef ENTRY
#undef ENTRY_ENUM
/// Number of image resources. 
    NOF_IMAGERESOURCES,
    GUILIANI_INTERNAL_IMG = INT_MAX // Do not touch this. Required for ensuring consistent enum type size across libraries.
};

// Check if the DUMMY value is always 0. If not compile error!
typedef int static_assert_something[(DUMMY_IMAGE == 0) ? 1 : -1]; ///< Will throw compile error negative subscript if DUMMY_IMAGE is NOT 0!

/// Map ImageIDs to interval 0 to NOF_IMAGERESOURCES
#define MAP_IMGID_TO_ARRAY(IMG_ID) (static_cast<eC_UInt>((IMG_ID-IMG_START_TAG-1)))
/// Unmap ImageIDs from interval 0 to NOF_IMAGERESOURCES
#define UNMAP_IMGENTRY_TO_ARRAY(IMG_ENTRY) (static_cast<ImageResource_t>(IMG_ENTRY+IMG_START_TAG+1))
// Amount of resources.
extern const eC_UInt cuiNOFImageResources; ///< Used to contain the highest index cuiNOFXXXClasses = MAP_PROPID_TO_ARRAY(NOF_XXXCLASSES);

#endif
