/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#if !defined(GUI_GENERAL_RESOURCE__H_)
#define GUI_GENERAL_RESOURCE__H_
#include "eC_Types.h"
#include <limits.h>

/// @file GUIGeneralResource.h @ref page_helpermacros
// 
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
//

// -----------------------------------------------------------------------------------------
///  abstract resource files
// Attention: If a general resource ID is added, please also change the number of RES_START_TAG,
// so that DUMMY_RESOURCE is always 0, which should guarantee that the user
// ID numbers will not be affected when adding Guiliani IDs.
// If you add a new general resource you should add it in front of the enumeration
// so that the other Guiliani IDs will not be shifted, i.e. add the
// new Guiliani ID right after RES_START_TAG.

//Add Guiliani-GeneralResources here:
#define GENERAL_RESOURCES_TABLE            \
ENTRY(KBD_LAYOUT_GERMAN, "keyboard_layout_german.bin", true) \
ENTRY(KBD_LAYOUT_ENGLISH, "keyboard_layout_english.bin", true) \
ENTRY(KBD_LAYOUT_RUSSIAN, "keyboard_layout_russian.bin", true) \
ENTRY(KBD_LAYOUT_ARABIC, "keyboard_layout_arabic.bin", true) \
ENTRY(DUMMY_RESOURCE, "DUMMY_RESOURCE", true)

// Calculate the value for the START_TAG used in th enum definition below.
#define ENTRY_ENUM(a) -1 ///< \ref page_helpermacros
#define ENTRY(res, res_filename, res_permanent) -1///< \ref page_helpermacros
const int ciCalculatedResStartTag = GENERAL_RESOURCES_TABLE; ///< preprocessor generates for all entries of GENERAL_RESOURCES_TABLE: -1 -1 -1..., resulting in a mathematical expression, that will be evaluated to -1*(Number of entries of IMAGE_TABLE 
#undef ENTRY
#undef ENTRY_ENUM

#ifndef GUILIANI_GUILIANILIB
#include "UserGeneralResource.h"
#endif

/// List of general resource ids.
enum GeneralResource_t
{
    RES_START_TAG = ciCalculatedResStartTag,
#define ENTRY_ENUM(a) a, ///< \ref page_helpermacros
#define ENTRY(res, res_filename, res_permanent) res, ///< \ref page_helpermacros
    GENERAL_RESOURCES_TABLE
#ifndef GUILIANI_GUILIANILIB
    USER_GENERAL_RESOURCES_TABLE
#endif
#undef ENTRY
#undef ENTRY_ENUM
    NOF_GENERALRESOURCES,
    GUILIANI_INTERNAL_RES = INT_MAX // Do not touch this. Required for ensuring consistent enum type size across libraries.
};

// Check if the DUMMY value is always 0. If not compile error!
typedef int static_assert_something[(DUMMY_RESOURCE == 0) ? 1 : -1]; ///< Will throw compile error negative subscript if DUMMY_RESOURCE is NOT 0!

/// Map general resource ids to interval 0 to NOF_GENERALRESOURCES
#define MAP_RESID_TO_ARRAY(RES_ID) (static_cast<eC_UInt>(RES_ID-RES_START_TAG-1))
/// Unmap general resource ids from interval 0 to NOF_GENERALRESOURCES
#define UNMAP_RESENTRY_TO_ARRAY(RES_ENTRY) (static_cast<GeneralResource_t>(RES_ENTRY+RES_START_TAG+1))
// Amount of resources.
extern const eC_UInt cuiNOFGeneralResources; ///< Used to contain the highest index cuiNOFXXXClasses = MAP_PROPID_TO_ARRAY(NOF_XXXCLASSES);

#endif // GUI_GENERAL_RESOURCE__H_
