/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#ifndef GUI_FONT_RESOURCE__H_
#define GUI_FONT_RESOURCE__H_
#include "eC_Types.h"
#include <limits.h>

/// @file GUIFontResource.h @ref page_helpermacros
// 
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
//

// -----------------------------------------------------------------------------------------
/// Font resources.
// Attention: If anew ID is added, please also change the number of FNT_START_TAG,
// so that DUMMY_FONT is always 0, which should guarantee that the user
// ID numbers will not be affected when adding Guiliani IDs.
// If you add a new Guiliani ID you should add it in front of the enumeration
// so that the other Guiliani IDs will not be shifted, i.e. add the
// new Guiliani ID right after FNT_START_TAG.

// Add Guiliani-FontResources here:
// The definition for Guiliani fonts uses only the enum value (the single parameter).
// We cannot use the same parameters as in the USER_FONT_TABLE, because Guiliani does
// not know which font wrapper the application will use. In addition an app can choose 
// which real font will be used.
#define FONT_TABLE            \
ENTRY(FNT_KEYBOARD)   \
ENTRY(FNT_DEFAULT)    \
ENTRY(DUMMY_FONT)   

// Calculate the value for the START_TAG used in th enum definition below.
#define ENTRY_ENUM(a) -1 ///< \ref page_helpermacros
#define ENTRY(fnt) -1///< \ref page_helpermacros
const int ciCalculatedFntStartTag = FONT_TABLE; ///< preprocessor generates for all entries of FONT_TABLE: -1 -1 -1..., resulting in a mathematical expression, that will be evaluated to -1*(Number of entries of IMAGE_TABLE 
#undef ENTRY
#undef ENTRY_ENUM

#ifndef GUILIANI_GUILIANILIB
#include "UserFontResource.h"
#endif

/// List of font resource ids.
enum FontResource_t
{
    FNT_START_TAG = ciCalculatedFntStartTag,
#define ENTRY_ENUM(a) a, ///< \ref page_helpermacros
#define ENTRY(a) a, ///< \ref page_helpermacros
    FONT_TABLE
#undef ENTRY

#define ENTRY(fnt, fnt_filename, fnt_size, fnt_style, fnt_permanent) fnt,
#ifndef GUILIANI_GUILIANILIB
    USER_FONT_TABLE
#endif
#undef ENTRY
#undef ENTRY_ENUM
    NOF_FONTRESOURCES,
    GUILIANI_INTERNAL_FNT = INT_MAX // Do not touch this. Required for ensuring consistent enum type size across libraries.
};

// Check if the DUMMY value is always 0. If not compile error!
typedef int static_assert_something[(DUMMY_FONT == 0) ? 1 : -1]; ///< Will throw compile error negative subscript if DUMMY_FONT is NOT 0!

/// Map FontIDs to interval 0 to NOF_FONTRESOURCES
#define MAP_FNTID_TO_ARRAY(FNT_ID) (static_cast<eC_UInt>((FNT_ID-FNT_START_TAG)-1))
/// Unmap FontIDs from interval 0 to NOF_FONTRESOURCES
#define UNMAP_FNTENTRY_TO_ARRAY(FNT_ENTRY) (static_cast<FontResource_t>(FNT_ENTRY+FNT_START_TAG+1))
// Amount of resources.
extern const eC_UInt cuiNOFFontResources; ///< Used to contain the highest index cuiNOFXXXClasses = MAP_PROPID_TO_ARRAY(NOF_XXXCLASSES);


#endif
