/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#ifndef GUI_EVENT_TYPES__H_
#define GUI_EVENT_TYPES__H_
#include <limits.h>

// 
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
//
/** For an overview of the mappings of these events to the handling methods in
    CGUIBehaviour, see @ref subsec_event_slot_mapping @ref page_helpermacros.
    @file GUIEventTypeResource.h
*/

/** @brief Guiliani event types.
*/

#define EVENTTYPE_TABLE \
/** A key was pressed down. */ \
ENTRY(ET_KEYDOWN) \
/** A key was released. */ \
ENTRY(ET_KEYUP) \
/** A character key was pressed. */ \
ENTRY(ET_CHAR) \
/** The mouse was moved while a button was pressed. */ \
ENTRY(DEPRECATED_ET_MOUSEDRAG) \
/** The mouse was moved while all buttons were released. */ \
ENTRY(ET_MOUSEMOVE) \
/** The mousewheel was used. */ \
ENTRY(ET_MOUSEWHEEL) \
/** The left mouse button was released. */ \
ENTRY(ET_LBUTTONUP) \
/** The left mouse button was pressed. */ \
ENTRY(ET_LBUTTONDOWN) \
/** The left mouse button was double clicked. @ref CGUIEventHandler::GetDoubleClickTime() */ \
ENTRY(DEPRECATED_ET_LBUTTONDBLCLK) \
/** The right mouse button was released. */ \
ENTRY(ET_RBUTTONUP) \
/** The right mouse button was pressed. */ \
ENTRY(ET_RBUTTONDOWN) \
/** The left mouse button was pressed longer than @ref CGUIEventHandler::GetLongClickTime(). */ \
ENTRY(DEPRECATED_ET_LBUTTONLONGCLICK) \
/** A hot key was pressed (used on e.g. smart phones)*/ \
ENTRY(ET_HOTKEYDOWN) \
/** A hot key was released (used on e.g. smart phones)*/ \
ENTRY(ET_HOTKEYUP)

#ifndef GUILIANI_GUILIANILIB
    #include "UserEventTypeResource.h"
#endif

/// List of event type ids.
enum EventType_t
{
#define ENTRY_ENUM(a) a,  ///< \ref page_helpermacros
#define ENTRY(a) a,  ///< \ref page_helpermacros
    EVENTTYPE_TABLE
#ifndef GUILIANI_GUILIANILIB
    USER_EVENTTYPE_TABLE
#endif
#undef ENTRY
#undef ENTRY_ENUM
    GUILIANI_INTERNAL_ET = INT_MAX ///< Do not touch this. Required for ensuring consistent enum type size across libraries.
};

/// Definition of all key event types.
#define KEYIDENTIFIER_TABLE \
ENTRY(GK_NONE) \
ENTRY(GK_ACTION) \
ENTRY(GK_DOWN) \
ENTRY(GK_UP) \
ENTRY(GK_LEFT) \
ENTRY(GK_RIGHT) \
ENTRY(GK_PAGEDOWN) \
ENTRY(GK_PAGEUP) \
ENTRY(GK_ESCAPE) \
ENTRY(GK_INSERT) \
ENTRY(GK_DELETE) \
ENTRY(GK_BACKSPACE) \
ENTRY(GK_TAB) \
ENTRY(GK_HOME) \
ENTRY(GK_END) \
ENTRY(GK_SELECT_ALL) \
ENTRY(GK_COPY) \
ENTRY(GK_PASTE) \
ENTRY(GK_CUT) \
/** Intermittent event (for multi-tapping on smartphones).*/ \
ENTRY(GK_INTERMIT) \
/* char keys */ \
ENTRY(GK_A) \
ENTRY(GK_B) \
ENTRY(GK_C) \
ENTRY(GK_D) \
ENTRY(GK_E) \
ENTRY(GK_F) \
ENTRY(GK_G) \
ENTRY(GK_H) \
ENTRY(GK_I) \
ENTRY(GK_J) \
ENTRY(GK_K) \
ENTRY(GK_L) \
ENTRY(GK_M) \
ENTRY(GK_N) \
ENTRY(GK_O) \
ENTRY(GK_P) \
ENTRY(GK_Q) \
ENTRY(GK_R) \
ENTRY(GK_S) \
ENTRY(GK_T) \
ENTRY(GK_U) \
ENTRY(GK_V) \
ENTRY(GK_W) \
ENTRY(GK_X) \
ENTRY(GK_Y) \
ENTRY(GK_Z) \
/* number keys */ \
ENTRY(GK_0) \
ENTRY(GK_1) \
ENTRY(GK_2) \
ENTRY(GK_3) \
ENTRY(GK_4) \
ENTRY(GK_5) \
ENTRY(GK_6) \
ENTRY(GK_7) \
ENTRY(GK_8) \
ENTRY(GK_9) \
/* symbol char keys */ \
/** 'SPC' key */ \
ENTRY(GK_SPACE) \
/** '!' key */ \
ENTRY(GK_EXCLAIM) \
/** '"' key - double quote */ \
ENTRY(GK_QUOTEDBL) \
/** '#' key */ \
ENTRY(GK_HASH) \
/** '$' key */ \
ENTRY(GK_DOLLAR) \
/** '%' key */ \
ENTRY(GK_PERCENT) \
/** '&' key */ \
ENTRY(GK_AMPERSAND) \
/** ''' key - single quote */ \
ENTRY(GK_QUOTE) \
/** '(' key */ \
ENTRY(GK_LEFTPAREN) \
/** ')' key */ \
ENTRY(GK_RIGHTPAREN) \
/** '*' key */ \
ENTRY(GK_ASTERISK) \
/** '+' key */ \
ENTRY(GK_PLUS) \
/** ',' key */ \
ENTRY(GK_COMMA) \
/** '-' key */ \
ENTRY(GK_MINUS) \
/** '.' key */ \
ENTRY(GK_PERIOD) \
/** '/' key */ \
ENTRY(GK_SLASH) \
/*Numpad */ \
ENTRY(GK_NUMPAD0) \
ENTRY(GK_NUMPAD1) \
ENTRY(GK_NUMPAD2) \
ENTRY(GK_NUMPAD3) \
ENTRY(GK_NUMPAD4) \
ENTRY(GK_NUMPAD5) \
ENTRY(GK_NUMPAD6) \
ENTRY(GK_NUMPAD7) \
ENTRY(GK_NUMPAD8) \
ENTRY(GK_NUMPAD9) \
ENTRY(GK_MULTIPLY) \
ENTRY(GK_ADD) \
ENTRY(GK_SEPARATOR) \
ENTRY(GK_SUBTRACT) \
ENTRY(GK_DECIMAL) \
ENTRY(GK_DIVIDE) \
/* function keys */ \
ENTRY(GK_F1) \
ENTRY(GK_F2) \
ENTRY(GK_F3) \
ENTRY(GK_F4) \
ENTRY(GK_F5) \
ENTRY(GK_F6) \
ENTRY(GK_F7) \
ENTRY(GK_F8) \
ENTRY(GK_F9) \
ENTRY(GK_F10) 

#ifndef GUILIANI_GUILIANILIB
    #include "UserKeyboardEventTypeResource.h"
#endif

/** @brief Platform independent key identifiers
*/
enum GUIKeyIdentifier_t
{
#define ENTRY_ENUM(a) a,
#define ENTRY(a) a,
    KEYIDENTIFIER_TABLE
#ifndef GUILIANI_GUILIANILIB
    USER_KEYIDENTIFIER_TABLE
#endif
#undef ENTRY
#undef ENTRY_ENUM

    GUILIANI_INTERNAL_GK = INT_MAX // Do not touch this. Required for ensuring consistent enum type size across libraries.
};

#endif
