/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#ifndef GUI_DATAPOOL_RESOURCE__H_
#define GUI_DATAPOOL_RESOURCE__H_
#include "eC_Types.h"
#include <limits.h>

/// @file GUIDataPoolResource.h @ref page_helpermacros
// 
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
//

// -----------------------------------------------------------------------------------------
///  Data Pool resources

#define DATAPOOL_TABLE 
// There are no default datapool resources
//ENTRY(XXX)

#ifndef GUILIANI_GUILIANILIB
    #include "UserDataPoolResource.h"
#endif

/// List of data pool resource ids.
enum DataPoolResource_t 
{
    DATAPOOL_START_TAG=-1,
#define ENTRY_ENUM(a) a, ///< \ref page_helpermacros
#define ENTRY(a) a, ///< \ref page_helpermacros
    DATAPOOL_TABLE
    DUMMY_DATAPOOLRESOURCE = 0,
#ifndef GUILIANI_GUILIANILIB
    USER_DATAPOOL_TABLE
#endif
#undef ENTRY
#undef ENTRY_ENUM
    NOF_DATAPOOLRESOURCES,

    GUILIANI_INTERNAL_DATAPOOLRESOURCE = INT_MAX // Do not touch this. Required for ensuring consistent enum type size across libraries.
};

/// Map DataPoolResource_t to interval 0 to NOF_DATAPOOLRESOURCES
#define MAP_DATAPOOLID_TO_ARRAY(DATAPOOL_ID) static_cast<eC_UInt>(DATAPOOL_ID-DATAPOOL_START_TAG-1)
/// Unmap DataPoolResource_t from interval 0 to NOF_DATAPOOLRESOURCES
#define UNMAP_DATAPOOLENTRY_TO_ARRAY(DATAPOOL_ENTRY) static_cast<DataPoolResource_t>(DATAPOOL_ENTRY+DATAPOOL_START_TAG+1)
// Amount of resources.
extern const eC_UInt cuiNOFDataPoolResources; ///< Used to contain the highest index cuiNOFXXXClasses = MAP_PROPID_TO_ARRAY(NOF_XXXCLASSES);

#endif
