/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#ifndef GUI_CONTROL_RESOURCE__H_
#define GUI_CONTROL_RESOURCE__H_
#include <limits.h>

/// @file GUIControlResource.h @ref page_helpermacros
// 
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
//

// -----------------------------------------------------------------------------------------
///  ControlClassIDs
// Attention: If a control ID is added, please also change the number of CTRL_START_TAG,
// so that DUMMY_CONTROL is always 0, which should guarantee that the user
// ControlClassID numbers will not be affected when adding Guiliani ControlClassIDs.
// If you add a new Guiliani control you should add it in front of the enumeration
// so that the other Guiliani ControlClassIDs will not be shifted, i.e. add the
// new Guiliani ControlClassID right after CTRL_START_TAG.

#define CONTROL_TABLE            \
ENTRY(GUI_UNUSED16, CGUIObject) \
ENTRY(GUI_UNUSED15, CGUIObject) \
ENTRY(GUI_UNUSED14, CGUIObject) \
ENTRY(GUI_UNUSED13, CGUIObject) \
ENTRY(GUI_UNUSED12, CGUIObject) \
ENTRY(GUI_UNUSED11, CGUIObject) \
ENTRY(GUI_UNUSED10, CGUIObject) \
ENTRY(GUI_UNUSED9, CGUIObject) \
ENTRY(GUI_UNUSED8, CGUIObject) \
ENTRY(GUI_UNUSED7, CGUIObject) \
ENTRY(GUI_UNUSED6, CGUIObject) \
ENTRY(GUI_UNUSED5, CGUIObject) \
ENTRY(GUI_UNUSED4, CGUIObject) \
ENTRY(GUI_UNUSED3, CGUIObject) \
ENTRY(GUI_UNUSED2, CGUIObject) \
ENTRY(GUI_UNUSED1, CGUIObject) \
ENTRY(GUI_RADIALSLIDER, CGUIRadialSlider) \
ENTRY(GUI_RADIALPROGRESSBAR, CGUIRadialProgressBar) \
ENTRY(GUI_TABCLIENTAREA, CGUITabClientArea) \
ENTRY(GUI_GRAPH, CGUIGraph) \
ENTRY(GUI_LAYERCONTAINER, CGUILayerContainer) \
ENTRY(GUI_VIDEO, CGUIVideo) \
ENTRY(GUI_PAGECONTAINER, CGUIPageContainer) \
ENTRY(GUI_WHEELCONTAINER, CGUIWheelContainer) \
ENTRY(GUI_GROUPCONTAINER, CGUIGroupContainer) \
ENTRY(GUI_RANGESLIDER, CGUIRangeSlider) \
ENTRY(GUI_CLOCK, CGUIClock) \
ENTRY(GUI_CALENDAR, CGUICalendar) \
ENTRY(GUI_SEGMENTBAR, CGUISegmentBar) \
ENTRY(GUI_KNOB, CGUIKnob) \
ENTRY(GUI_FRAGMENTCONTAINER, CGUIFragmentContainer) \
ENTRY(GUI_CHART, CGUIChart) \
ENTRY(GUI_TABITEM, CGUITabItem) \
ENTRY(GUI_SPLITCONTAINER, CGUISplitContainer) \
ENTRY(GUI_TABCONTAINER, CGUITabContainer) \
ENTRY(GUI_PRIMITIVE_BUTTON, CGUIPrimitiveButton) \
ENTRY(GUI_WHEEL, CGUIWheel) \
ENTRY(GUI_TOUCHSCROLLVIEW, CGUITouchScrollView) \
ENTRY(GUI_SCROLLING_TEXTFIELD, CGUIScrollingTextField) \
ENTRY(GUI_IMAGE_STACK, CGUIImageStack) \
ENTRY(GUI_EDITABLE_TEXT_CONTAINER, CGUITextContainer) \
ENTRY(GUI_MULTILINEEDIT, CGUIMultiLineEdit) \
ENTRY(GUI_TEXTFIELD, CGUITextField) \
ENTRY(GUI_CAROUSEL, CGUICarousel) \
ENTRY(GUI_ANIMATEDIMAGE, CGUIAnimatedImage) \
ENTRY(GUI_INPUTFIELD, CGUIInputField) \
ENTRY(GUI_MENUITEM, CGUIMenuItem) \
ENTRY(GUI_MENUITEMSEPARATOR, CGUIMenuItemSeparator) \
ENTRY(GUI_MENU, CGUIMenu) \
ENTRY(GUI_MENU_BAR, CGUIMenuBar) \
ENTRY(GUI_LISTBOX, CGUIListBox) \
ENTRY(GUI_LISTITEM, CGUIListItem) \
ENTRY(GUI_COMBOBOXHEADER, CGUIComboBoxHeader) \
ENTRY(GUI_COMBOBOX, CGUIComboBox) \
ENTRY(GUI_TABLEVIEW, CGUITableView) \
ENTRY(GUI_CENTERFOCUSCONTAINER, CGUICenterFocusContainer) \
ENTRY(GUI_SCROLLVIEW, CGUIScrollView) \
ENTRY(GUI_EDIT, CGUIEdit) \
ENTRY(GUI_BLENDBUTTON, CGUIBlendButton) \
ENTRY(GUI_EXPANDINGCOMPOSITE, CGUIExpandingComposite) \
ENTRY(GUI_CHECKBOX, CGUICheckBox) \
ENTRY(GUI_RADIOBUTTONGROUP, CGUIRadioButtonGroup) \
ENTRY(GUI_MULTITOGGLEBUTTON, CGUIObject) \
ENTRY(GUI_OBJECT, CGUIObject) \
ENTRY(GUI_COMPOSITEOBJECT, CGUICompositeObject) \
ENTRY(GUI_BUTTON, CGUIButton) \
ENTRY(GUI_BASEBUTTON, CGUIBaseButton) \
ENTRY(GUI_IMAGE, CGUIImage) \
ENTRY(GUI_BASESLIDER, CGUIBaseSlider) \
ENTRY(GUI_SLIDER, CGUISlider) \
ENTRY(GUI_BASERADIOBUTTON, CGUIBaseRadioButton) \
ENTRY(GUI_RADIOBUTTON, CGUIRadioButton) \
ENTRY(GUI_BASETEXTFIELD, CGUIBaseTextField) \
ENTRY(GUI_GAUGE, CGUIGauge) \
ENTRY(GUI_GEOMETRYOBJECT, CGUIGeometryObject) \
ENTRY(GUI_BASECHECKBOX, CGUIBaseCheckBox) \
ENTRY(GUI_PLOT, CGUIPlot) \
ENTRY(GUI_BASEINPUTFIELD, CGUIBaseInputField) \
ENTRY(GUI_BASEMESSAGEBOX, CGUIBaseMessageBox) \
ENTRY(GUI_CIRCULARSLIDER, CGUICircularSlider) \
ENTRY(GUI_KEYBOARD, CGUIKeyboard) \
ENTRY(GUI_SCROLLBAR, CGUIScrollBar) \
ENTRY(GUI_REPOSITION_COMPOSITE_OBJECT, CGUIRepositionCompositeObject) \
ENTRY(GUI_ICONBUTTON, CGUIIconButton) \
ENTRY(GUI_PROGRESSBAR, CGUIProgressBar) 

// Calculate the value for the START_TAG used in th enum definition below.
#define ENTRY_ENUM(a) -1 ///< \ref page_helpermacros
#define ENTRY(controld_id, control_classname) -1///< \ref page_helpermacros
const int ciCalculatedCTRLStartTag = CONTROL_TABLE; ///< preprocessor generates for all entries of CONTROL_TABLE: -1 -1 -1..., resulting in a mathematical expression, that will be evaluated to -1*(Number of entries of IMAGE_TABLE 
#undef ENTRY
#undef ENTRY_ENUM

/// List of control class ids.
enum ControlClassID_t
{
    CTRL_START_TAG = ciCalculatedCTRLStartTag -1,
    // Please add Guiliani ControlClassIDs right here:
#define ENTRY_ENUM(a) a, ///< \ref page_helpermacros
#define ENTRY(controld_id, control_classname) controld_id, ///< \ref page_helpermacros
    CONTROL_TABLE

    DUMMY_CONTROL, // must be a constant 0
#undef ENTRY
#undef ENTRY_ENUM


    GUILIANI_INTERNAL_CONTROL = INT_MAX // Do not touch this. Required for ensuring consistent enum type size across libraries.
};

typedef int static_assert_something[(DUMMY_CONTROL == 0) ? 1 : -1]; ///< Will throw compile error negative subscript if DUMMY_CONTROL is NOT 0!

#endif
