/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#ifndef GUI_COMMAND_RESOURCE__H_
#define GUI_COMMAND_RESOURCE__H_
#include "eC_Types.h"
#include <limits.h>

/// @file GUICommandResource.h @ref page_helpermacros
// 
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
//

// -----------------------------------------------------------------------------------------
///  CommandClassIDs

//Add Guiliani-CommandClassID_t here (with negative IDs, DUMMY_COMMAND has to stay 0, see COMMAND_START_TAG below)
// always add new commands as the first entry!!
#define COMMAND_TABLE            \
ENTRY(CMD_SETDATAPOOL, CGUISetDataPoolCmd) \
ENTRY(CMD_STOP_ANIMATIONCHAIN, CGUIStopAnimationChainCmd) \
ENTRY(CMD_CALLAPI, CGUICallAPICmd) \
ENTRY(CMD_DELAY, CGUIDelayCmd) \
ENTRY(CMD_SETOBJECTVISUALS, CGUISetObjectVisualsCmd) \
ENTRY(CMD_SWITCH_RESOURCESETS, CGUISwitchResourceSetsCmd) \
ENTRY(CMD_START_ANIMATIONCHAIN, CGUIStartAnimationChainCmd) \
ENTRY(CMD_LOAD_ANIMATIONS, CGUILoadAnimationsCmd) \
ENTRY(CMD_SETOBJECTSTATE, CGUISetObjectStateCmd) \
ENTRY(CMD_DIALOG_TRANSITION, CGUITransitionCmd) \
ENTRY(CMD_PLAYBACK_SOUND, CGUIPlaybackSoundCmd) \
ENTRY(CMD_LOAD_DIALOG, CGUILoadDialogCmd) \
ENTRY(CMD_QUIT, CGUIQuitCmd)

// Calculate the value for the START_TAG used in th enum definition below.
#define ENTRY_ENUM(a) -1 ///< \ref page_helpermacros
#define ENTRY(cmd, cmdclass) -1///< \ref page_helpermacros
const int ciCalculatedCmdStartTag = COMMAND_TABLE; ///< preprocessor generates for all entries of SOUND_TABLE: -1 -1 -1..., resulting in a mathematical expression, that will be evaluated to -1*(Number of entries of IMAGE_TABLE 
#undef ENTRY
#undef ENTRY_ENUM

/// List of command class ids.
enum CommandClassID_t
{
    COMMAND_START_TAG = ciCalculatedCmdStartTag - 1, // we left out DUMMY_COMMAND
 #define ENTRY_ENUM(a) a, ///< \ref page_helpermacros
 #define ENTRY(cmd_id, cmd_classname) cmd_id, ///< \ref page_helpermacros
    COMMAND_TABLE

    DUMMY_COMMAND,
#undef ENTRY
#undef ENTRY_ENUM
    NOF_COMMANDCLASSES,
    GUILIANI_INTERNAL_CMD = INT_MAX // Do not touch this. Required for ensuring consistent enum type size across libraries.
};

// Check if the DUMMY value is always 0. If not compile error!
typedef int static_assert_something[(DUMMY_COMMAND == 0) ? 1 : -1]; ///< Will throw compile error negative subscript if DUMMY_COMMAND is NOT 0!

extern const eC_UInt cuiNOFCommandClasses; ///< Used to contain the highest index cuiNOFXXXClasses = MAP_PROPID_TO_ARRAY(NOF_XXXCLASSES);
#endif
