/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#ifndef GUI_COLOR_RESOURCE__H_
#define GUI_COLOR_RESOURCE__H_
#include "eC_Types.h"
#include <limits.h>

/// @file GUIColorResource.h @ref page_helpermacros
// 
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
//

// -----------------------------------------------------------------------------------------
///  Color resources

#define COLOR_TABLE \
ENTRY(COLOR000, 0xffffffff) \
ENTRY(COLOR001, 0xff000000) \
ENTRY(COLOR002, 0xffff0000) \
ENTRY(COLOR003, 0xff00ff00) \
ENTRY(COLOR004, 0xff0000ff) \
ENTRY(COLOR005, 0xffffff00) \
ENTRY(COLOR006, 0xffff00ff) \
ENTRY(COLOR007, 0xff00ffff) \
ENTRY(COLOR008, 0xff880000) \
ENTRY(COLOR009, 0xff008800) \
ENTRY(COLOR010, 0xffffebee) \
ENTRY(COLOR011, 0xffffcdd2) \
ENTRY(COLOR012, 0xffef9a9a) \
ENTRY(COLOR013, 0xffe57373) \
ENTRY(COLOR014, 0xffef5350) \
ENTRY(COLOR015, 0xfff44336) \
ENTRY(COLOR016, 0xffe53935) \
ENTRY(COLOR017, 0xffd32f2f) \
ENTRY(COLOR018, 0xffc62828) \
ENTRY(COLOR019, 0xffb71c1c) \
ENTRY(COLOR020, 0xfffce4ec) \
ENTRY(COLOR021, 0xfff8bbd0) \
ENTRY(COLOR022, 0xfff48fb1) \
ENTRY(COLOR023, 0xfff06292) \
ENTRY(COLOR024, 0xffec407a) \
ENTRY(COLOR025, 0xffe91e63) \
ENTRY(COLOR026, 0xffd81b60) \
ENTRY(COLOR027, 0xffc2185b) \
ENTRY(COLOR028, 0xffad1457) \
ENTRY(COLOR029, 0xff880e4f) \
ENTRY(COLOR030, 0xfff3e5f5) \
ENTRY(COLOR031, 0xffe1bee7) \
ENTRY(COLOR032, 0xffce93d8) \
ENTRY(COLOR033, 0xffba68c8) \
ENTRY(COLOR034, 0xffab47bc) \
ENTRY(COLOR035, 0xff9c27b0) \
ENTRY(COLOR036, 0xff8e24aa) \
ENTRY(COLOR037, 0xff7b1fa2) \
ENTRY(COLOR038, 0xff6a1b9a) \
ENTRY(COLOR039, 0xff4a148c) \
ENTRY(COLOR040, 0xffede7f6) \
ENTRY(COLOR041, 0xffd1c4e9) \
ENTRY(COLOR042, 0xffb39ddb) \
ENTRY(COLOR043, 0xff9575cd) \
ENTRY(COLOR044, 0xff7e57c2) \
ENTRY(COLOR045, 0xff673ab7) \
ENTRY(COLOR046, 0xff5e35b1) \
ENTRY(COLOR047, 0xff512da8) \
ENTRY(COLOR048, 0xff4527a0) \
ENTRY(COLOR049, 0xff311b92) \
ENTRY(COLOR050, 0xffe8eaf6) \
ENTRY(COLOR051, 0xffc5cae9) \
ENTRY(COLOR052, 0xff9fa8da) \
ENTRY(COLOR053, 0xff7986cb) \
ENTRY(COLOR054, 0xff5c6bc0) \
ENTRY(COLOR055, 0xff3f51b5) \
ENTRY(COLOR056, 0xff3949ab) \
ENTRY(COLOR057, 0xff303f9f) \
ENTRY(COLOR058, 0xff283593) \
ENTRY(COLOR059, 0xff1a237e) \
ENTRY(COLOR060, 0xffe3f2fd) \
ENTRY(COLOR061, 0xffbbdefb) \
ENTRY(COLOR062, 0xff90caf9) \
ENTRY(COLOR063, 0xff64b5f6) \
ENTRY(COLOR064, 0xff42a5f5) \
ENTRY(COLOR065, 0xff2196f3) \
ENTRY(COLOR066, 0xff1e88e5) \
ENTRY(COLOR067, 0xff1976d2) \
ENTRY(COLOR068, 0xff1565c0) \
ENTRY(COLOR069, 0xff0d47a1) \
ENTRY(COLOR070, 0xffe1f5fe) \
ENTRY(COLOR071, 0xffb3e5fc) \
ENTRY(COLOR072, 0xff81d4fa) \
ENTRY(COLOR073, 0xff4fc3f7) \
ENTRY(COLOR074, 0xff29b6f6) \
ENTRY(COLOR075, 0xff03a9f4) \
ENTRY(COLOR076, 0xff039be5) \
ENTRY(COLOR077, 0xff0288d1) \
ENTRY(COLOR078, 0xff0277bd) \
ENTRY(COLOR079, 0xff01579b) \
ENTRY(COLOR080, 0xffe0f7fa) \
ENTRY(COLOR081, 0xffb2ebf2) \
ENTRY(COLOR082, 0xff80deea) \
ENTRY(COLOR083, 0xff4dd0e1) \
ENTRY(COLOR084, 0xff26c6da) \
ENTRY(COLOR085, 0xff00bcd4) \
ENTRY(COLOR086, 0xff00acc1) \
ENTRY(COLOR087, 0xff0097a7) \
ENTRY(COLOR088, 0xff00838f) \
ENTRY(COLOR089, 0xff006064) \
ENTRY(COLOR090, 0xffe0f2f1) \
ENTRY(COLOR091, 0xffb2dfdb) \
ENTRY(COLOR092, 0xff80cbc4) \
ENTRY(COLOR093, 0xff4bb6ac) \
ENTRY(COLOR094, 0xff26a69a) \
ENTRY(COLOR095, 0xff009688) \
ENTRY(COLOR096, 0xff00897b) \
ENTRY(COLOR097, 0xff00796b) \
ENTRY(COLOR098, 0xff00695c) \
ENTRY(COLOR099, 0xff004d40) \
ENTRY(COLOR100, 0xffe8f5e9) \
ENTRY(COLOR101, 0xffc8e6c9) \
ENTRY(COLOR102, 0xffa5d6a7) \
ENTRY(COLOR103, 0xff81c784) \
ENTRY(COLOR104, 0xff66bb6a) \
ENTRY(COLOR105, 0xff4caf50) \
ENTRY(COLOR106, 0xff43a047) \
ENTRY(COLOR107, 0xff388e3c) \
ENTRY(COLOR108, 0xff2e7d32) \
ENTRY(COLOR109, 0xff1b5e20) \
ENTRY(COLOR110, 0xfff1f8e9) \
ENTRY(COLOR111, 0xffdcedc8) \
ENTRY(COLOR112, 0xffc5e1a5) \
ENTRY(COLOR113, 0xffaed581) \
ENTRY(COLOR114, 0xff9ccc65) \
ENTRY(COLOR115, 0xff8bc34a) \
ENTRY(COLOR116, 0xff7cb342) \
ENTRY(COLOR117, 0xff689f38) \
ENTRY(COLOR118, 0xff558b2f) \
ENTRY(COLOR119, 0xff33691e) \
ENTRY(COLOR120, 0xfff9fbe7) \
ENTRY(COLOR121, 0xfff0f4c3) \
ENTRY(COLOR122, 0xffe6ee9c) \
ENTRY(COLOR123, 0xffdce775) \
ENTRY(COLOR124, 0xffd4e157) \
ENTRY(COLOR125, 0xffcddc39) \
ENTRY(COLOR126, 0xffc0ca33) \
ENTRY(COLOR127, 0xffafb42b) \
ENTRY(COLOR128, 0xff9e9d24) \
ENTRY(COLOR129, 0xff827717) \
ENTRY(COLOR130, 0xfffffde7) \
ENTRY(COLOR131, 0xfffff9c4) \
ENTRY(COLOR132, 0xfffff59d) \
ENTRY(COLOR133, 0xfffff176) \
ENTRY(COLOR134, 0xffffee58) \
ENTRY(COLOR135, 0xffffeb3b) \
ENTRY(COLOR136, 0xfffdd835) \
ENTRY(COLOR137, 0xfffbc02d) \
ENTRY(COLOR138, 0xfff9a825) \
ENTRY(COLOR139, 0xfff57f17) \
ENTRY(COLOR140, 0xfffff8e1) \
ENTRY(COLOR141, 0xffffecb3) \
ENTRY(COLOR142, 0xffffe082) \
ENTRY(COLOR143, 0xffffd54f) \
ENTRY(COLOR144, 0xffffca28) \
ENTRY(COLOR145, 0xffffc107) \
ENTRY(COLOR146, 0xffffb300) \
ENTRY(COLOR147, 0xffffa000) \
ENTRY(COLOR148, 0xffff8f00) \
ENTRY(COLOR149, 0xffff6f00) \
ENTRY(COLOR150, 0xfffff3e0) \
ENTRY(COLOR151, 0xffffe0b2) \
ENTRY(COLOR152, 0xffffcc80) \
ENTRY(COLOR153, 0xffffb74d) \
ENTRY(COLOR154, 0xffffa726) \
ENTRY(COLOR155, 0xffff9800) \
ENTRY(COLOR156, 0xfffb8c00) \
ENTRY(COLOR157, 0xfff57c00) \
ENTRY(COLOR158, 0xffef6c00) \
ENTRY(COLOR159, 0xffe65100) \
ENTRY(COLOR160, 0xfffbe9e7) \
ENTRY(COLOR161, 0xffffccbc) \
ENTRY(COLOR162, 0xffffab91) \
ENTRY(COLOR163, 0xffff8a65) \
ENTRY(COLOR164, 0xffff7043) \
ENTRY(COLOR165, 0xffff5722) \
ENTRY(COLOR166, 0xfff4511e) \
ENTRY(COLOR167, 0xffe64a19) \
ENTRY(COLOR168, 0xffd84315) \
ENTRY(COLOR169, 0xffbf360c) \
ENTRY(COLOR170, 0xffefebe9) \
ENTRY(COLOR171, 0xffd7ccc8) \
ENTRY(COLOR172, 0xffbcaaa4) \
ENTRY(COLOR173, 0xffa1887f) \
ENTRY(COLOR174, 0xff8d6e63) \
ENTRY(COLOR175, 0xff795548) \
ENTRY(COLOR176, 0xff6d4c41) \
ENTRY(COLOR177, 0xff5d4037) \
ENTRY(COLOR178, 0xff4e342e) \
ENTRY(COLOR179, 0xff3e2723) \
ENTRY(COLOR180, 0xfffafafa) \
ENTRY(COLOR181, 0xfff5f5f5) \
ENTRY(COLOR182, 0xffeeeeee) \
ENTRY(COLOR183, 0xffe0e0e0) \
ENTRY(COLOR184, 0xffbdbdbd) \
ENTRY(COLOR185, 0xff9e9e9e) \
ENTRY(COLOR186, 0xff757575) \
ENTRY(COLOR187, 0xff616161) \
ENTRY(COLOR188, 0xff424242) \
ENTRY(COLOR189, 0xff212121) \
ENTRY(COLOR190, 0xffeceff1) \
ENTRY(COLOR191, 0xffcfd8dc) \
ENTRY(COLOR192, 0xffb0bec5) \
ENTRY(COLOR193, 0xff90a4ae) \
ENTRY(COLOR194, 0xff78909c) \
ENTRY(COLOR195, 0xff607d8b) \
ENTRY(COLOR196, 0xff546e7a) \
ENTRY(COLOR197, 0xff455a64) \
ENTRY(COLOR198, 0xff37474f) \
ENTRY(COLOR199, 0xff263228) \
ENTRY(DUMMY_COLOR, 0xff000000)

// Calculate the value for the START_TAG used in th enum definition below.
#define ENTRY_ENUM(a) -1 ///< \ref page_helpermacros
#define ENTRY(color, value) -1///< \ref page_helpermacros
const int ciCalculatedColorStartTag = COLOR_TABLE;///< preprocessor generates for all entries of COLOR_TABLE: -1 -1 -1..., resulting in a mathematical expression, that will be evaluated to -1*(Number of entries of COLOR_TABLE 
#undef ENTRY
#undef ENTRY_ENUM

#ifndef GUILIANI_GUILIANILIB
#include "UserColorResource.h"
#endif

/// List of color-resource ids.
enum ColorResource_t
{
    COLOR_START_TAG = ciCalculatedColorStartTag,
#define ENTRY_ENUM(a) a, ///< \ref page_helpermacros
#define ENTRY(color, value) color, ///< \ref page_helpermacros
    COLOR_TABLE
#ifndef GUILIANI_GUILIANILIB
    USER_COLOR_TABLE
#endif
#undef ENTRY
#undef ENTRY_ENUM
    NOF_COLORRESOURCES,
    GUILIANI_INTERNAL_COLORRESOURCE = INT_MAX // Do not touch this. Required for ensuring consistent enum type size across libraries.
};

// Check if the DUMMY value is always 0. If not compile error!
///< Will throw compile error negative subscript if DUMMY_COLOR is NOT 0!
typedef int static_assert_something[(DUMMY_COLOR == 0) ? 1 : -1];

/// Map ColorResource_t to interval 0 to NOF_COLORRESOURCES
#define MAP_COLORID_TO_ARRAY(COLOR_ID) static_cast<eC_UInt>(COLOR_ID-COLOR_START_TAG-1)
/// Unmap ColorResource_t from interval 0 to NOF_COLORRESOURCES
#define UNMAP_COLORENTRY_TO_ARRAY(COLOR_ENTRY) static_cast<ColorResource_t>(COLOR_ENTRY+COLOR_START_TAG+1)
// Amount of resources.
extern const eC_UInt cuiNOFColorResources; ///< Used to contain the highest index cuiNOFXXXClasses = MAP_PROPID_TO_ARRAY(NOF_XXXCLASSES);

#endif
