/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#ifndef GUI_BEHAVIOUR_RESOURCE__H_
#define GUI_BEHAVIOUR_RESOURCE__H_
#include <limits.h>

/// @file GUIBehaviourResource.h @ref page_helpermacros
// 
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
//

// -----------------------------------------------------------------------------------------
///  BehaviourClassIDs

//Add Guiliani-BehaviourClassIDs here (with negative IDs, DUMMY_BEHAVIOUR has to stay 0, see BEHAVIOUR_START_TAG below)

#define BEHAVIOUR_TABLE            \
ENTRY(BEHAVIOUR_OBJECT_VISUALS, CGUIObjectVisualsBehaviour) \
ENTRY(BEHAVIOUR_TABSWITCH, CGUITabSwitchBehaviour) \
ENTRY(BEHAVIOUR_AUTOREPEAT, CGUIAutoRepeatBehaviour) \
ENTRY(BEHAVIOUR_KEYBOARD, CGUIKeyboardBehaviour) \
ENTRY(BEHAVIOUR_OBJECT_STATE, CGUIObjectStateBehaviour) \
ENTRY(BEHAVIOUR_COMPOSITE, CGUICompositeBehaviour) \
ENTRY(BEHAVIOUR_HOTKEY, CGUIHotkeysBehaviour) \
ENTRY(BEHAVIOUR_SINGLE_CMD, CGUISingleCmdBehaviour) \
ENTRY(BEHAVIOUR_MULTI_CMD, CGUIMultiCmdBehaviour)

// Calculate the value for the START_TAG used in th enum definition below.
#define ENTRY_ENUM(a) -1 ///< \ref page_helpermacros
#define ENTRY(bhv, bhvclass) -1///< \ref page_helpermacros
const int ciCalculatedBhvStartTag = BEHAVIOUR_TABLE; ///< preprocessor generates for all entries of SOUND_TABLE: -1 -1 -1..., resulting in a mathematical expression, that will be evaluated to -1*(Number of entries of IMAGE_TABLE 
#undef ENTRY
#undef ENTRY_ENUM

/// List of behaviour class ids.
enum BehaviourClassID_t 
{
    BEHAVIOUR_START_TAG = ciCalculatedBhvStartTag - 1, // we left out DUMMY_BEHAVIOUR

#define ENTRY_ENUM(a) a, ///< \ref page_helpermacros
#define ENTRY(beh_id, beh_classname) beh_id, ///< \ref page_helpermacros
    BEHAVIOUR_TABLE

    DUMMY_BEHAVIOUR,
#undef ENTRY
#undef ENTRY_ENUM

    GUILIANI_INTERNAL_BHV = INT_MAX // Do not touch this. Required for ensuring consistent enum type size across libraries.
};

// Check if the DUMMY value is always 0. If not compile error!
typedef int static_assert_something[(DUMMY_BEHAVIOUR == 0) ? 1 : -1]; ///< Will throw compile error negative subscript if DUMMY_BEHAVIOUR is NOT 0!

#endif
