/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#ifndef GUI_ANIMATIONTYPE_RESOURCE__H_
#define GUI_ANIMATIONTYPE_RESOURCE__H_

#include <limits.h>

/// @file GUIAnimationTypeResource.h @ref page_helpermacros
// 
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
//
// -----------------------------------------------------------------------------------------
///  AnimationTypes
//Add Guiliani-AnimationType_t here (with negative IDs, DUMMY_ANIMATION_TYPE has to stay 0)
#ifdef GUILIANI_ANIMATION_ACTIVE
#define ANIMATION_TYPE_TABLE \
ENTRY(ANIMATION_TRIGGER, CGUIAnimationTrigger) \
ENTRY(ANIMATION_ATTRIBUTE, CGUIAnimationAttribute) \
ENTRY(ANIMATION_STDGUIOBJECT, CGUIAnimationStdGUIObject) \
ENTRY(ANIMATION_BLINKING, CGUIAnimationBlinking) \
ENTRY(ANIMATION_MOVE_IN_OUT, CGUIAnimationMoveInOut) \
ENTRY(ANIMATION_SIZE, CGUIAnimationSize) \
ENTRY(ANIMATION_MOVE, CGUIAnimationMove)
#else
#define ANIMATION_TYPE_TABLE \
ENTRY(ANIMATION, CGUIAnimation)
#endif

// Calculate the value for the START_TAG used in th enum definition below.
#define ENTRY_ENUM(a) -1 ///< \ref page_helpermacros
#define ENTRY(anim_type_id, anim_type_classname) -1///< \ref page_helpermacros
const int ciCalculatedAnimTypeStartTag = ANIMATION_TYPE_TABLE; ///< preprocessor generates for all entries of ANIMATION_TYPE_TABLE: -1 -1 -1..., resulting in a mathematical expression, that will be evaluated to -1*(Number of entries of IMAGE_TABLE 
#undef ENTRY
#undef ENTRY_ENUM

/// List of animation resource ids.
enum AnimationType_t
{
     ANIMATION_TYPE_START_TAG = ciCalculatedAnimTypeStartTag - 1, // we left out DUMMY_ANIMATION_TYPE

#define ENTRY_ENUM(a) a, ///< \ref page_helpermacros
#define ENTRY(anim_type_id, anim_type_classname) anim_type_id,  ///< \ref page_helpermacros
     ANIMATION_TYPE_TABLE
     DUMMY_ANIMATION_TYPE,
#undef ENTRY
#undef ENTRY_ENUM

     GUILIANI_INTERNAL_ANIMATION_TYPE = INT_MAX // Do not touch this. Required for ensuring consistent enum type size across libraries.
};

// Check if the DUMMY value is always 0. If not compile error!
typedef int static_assert_something[(DUMMY_ANIMATION_TYPE == 0) ? 1 : -1]; ///< Will throw compile error negative subscript if DUMMY_ANIMATION_TYPE is NOT 0!

#endif
