/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#ifndef GUI_ANIMATION_RESOURCE__H_
#define GUI_ANIMATION_RESOURCE__H_

#include "eC_Types.h"
#include <limits.h>

/// @file GUIAnimationResource.h @ref page_helpermacros
// 
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
// DO NOT EDIT THIS FILE!!! Add your own IDS within UserXXXResource.h files!
//

// -----------------------------------------------------------------------------------------
///  AnimationIDs
// Attention: If a new ID is added, please also change the number of OBJ_START_TAG,
// so that DUMMY_ANIMATION is always 0, which should guarantee that the user
// ID numbers will not be affected when adding Guiliani IDs.
// If you add a new Guiliani ID you should add it in front of the enumeration
// so that the other Guiliani IDs will not be shifted, i.e. add the
// new Guiliani ID below.

// Please add Guiliani AnimationIDs right here:
#define ANIMATION_TABLE \
    ENTRY(DUMMY_ANIMATION)

// Calculate the value for the START_TAG used in th enum definition below.
#define ENTRY_ENUM(a) -1 ///< \ref page_helpermacros
#define ENTRY(anim_id) -1///< \ref page_helpermacros
const int ciCalculatedAnimStartTag = ANIMATION_TABLE; ///< preprocessor generates for all entries of ANIMATION_TABLE: -1 -1 -1..., resulting in a mathematical expression, that will be evaluated to -1*(Number of entries of IMAGE_TABLE
#undef ENTRY
#undef ENTRY_ENUM

#ifndef GUILIANI_GUILIANILIB
    #include "UserAnimationResource.h"
#endif

/// List of animation resource ids.
enum AnimationHandle_t
{
    ANIMATION_START_TAG = ciCalculatedAnimStartTag,
#define ENTRY_ENUM(a) a, ///< \ref page_helpermacros
#define ENTRY(anim_id) anim_id, ///< \ref page_helpermacros
    ANIMATION_TABLE
#ifndef GUILIANI_GUILIANILIB
    USER_ANIMATION_TABLE
#endif
#undef ENTRY
#undef ENTRY_ENUM
    NOF_ANIMATIONIDS,
    GUILIANI_INTERNAL_ANIMID = INT_MAX // Do not touch this. Required for ensuring consistent enum type size across libraries.
};

// Check if the DUMMY value is always 0. If not compile error!
typedef int static_assert_something[(DUMMY_ANIMATION == 0) ? 1 : -1]; ///< Will throw compile error negative subscript if NO_HANDLE is NOT 0!

/// Map Animation Handles to interval 0 to NOF_ANIMATIONS
#define MAP_ANIMID_TO_ARRAY(ANIM_ID) static_cast<eC_UInt>(ANIM_ID-ANIMATION_START_TAG-1)
/// Unmap Animation Handles from interval 0 to NOF_ANIMATIONS
#define UNMAP_ANIM_ENTRY_TO_ARRAY(ANIM_ENTRY) static_cast<AnimationHandle_t>(ANIM_ENTRY+ANIMATION_START_TAG+1)
// Amount of resources.
extern const eC_UInt cuiNOFAnimationHandles; ///< Used to contain the highest index cuiNOFXXXClasses = MAP_PROPID_TO_ARRAY(NOF_XXXCLASSES);

#endif
