/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#if !defined(CUSTOM_EXTENSION_FACTORY_H)
#define CUSTOM_EXTENSION_FACTORY_H

#include "GUIFactory.h"

#include "GUIControlResource.h"
#include "GUIBehaviourResource.h"
#include "GUICommandResource.h"
#include "GUILayouterResource.h"

#include <string>
#include <map>
#include <vector>

#define GETEXTENSIONSFACTORY CustomExtensionFactory::GetInstance()

/** An example for a custom factory.

    This factory must be able to create all custom extensions that are
    registered in the editor.
  */
class CustomExtensionFactory : public CGUIFactory
{
public:
    virtual ~CustomExtensionFactory();

    static CustomExtensionFactory* GetInstance();

public:
    virtual CGUIObject* CreateControl(ControlClassID_t eControlID);

    virtual CGUILayouter* CreateLayouter(LayouterClassID_t eLayouterID);

    virtual CGUIBehaviourDecorator* CreateBehaviour(BehaviourClassID_t eBehaviourID);

    virtual CGUICommand* CreateCommand(CommandClassID_t eCommandID);

    virtual CGUIText* CreateText(TextTypeID_t eTextType);

#ifdef GUILIANI_ANIMATION_ACTIVE
    virtual CGUIAnimation* CreateAnimation(AnimationType_t eAnimation);
#endif

protected:
    // default constructor is private due to singleton
    CustomExtensionFactory();

    /** Copy-constructor.
    Dummy implementation to avoid unintended use of compiler-generated default    */
    CustomExtensionFactory(const CustomExtensionFactory& kSource);

    /** Assignment operator.
    Dummy implementation to avoid unintended use of compiler-generated default    */
    CustomExtensionFactory& operator=(const CustomExtensionFactory& kSource);

private:
    static CustomExtensionFactory* ms_pkInstance;
};
#endif
