#ifndef __VIDEODECODER_MJPEG_H__
#define __VIDEODECODER_MJPEG_H__

#include "eC_Types.h"
#include "eC_File.h"
#include "GUIImageResource.h"

#include "GUIVideoDecoder.h"

/** Reads a raw-image
*/
class CGUIVideoDecoderMJPEG : public CGUIVideoDecoder
{
public:
    static const eC_UShort STREAM0 = 0x3030; ///< ID for stream-no. 0 '00'
    static const eC_UShort TYPEDC = 0x6364; ///< ID for Video-stream 'dc'
    static const eC_UInt LISTck = 0x5453494c; ///< ID for list 'LIST'

    CGUIVideoDecoderMJPEG();
    ~CGUIVideoDecoderMJPEG();

    /** Get currently set frame
    @return current frame
    */
    eC_UInt GetCurrentFrame() const
    {
        return m_uiCurrentFrame;
    }

    virtual eC_Bool Decode(CGUIVideoData &pImageData, eC_File *pTempImageFile);

    virtual void DecodeFrame(const eC_UByte* const pkData, const eC_UInt& uiLength, eC_UByte* pkDestination);

    virtual void SetBPP(const eC_UByte& ubBPP);
    virtual void SetDestinationFormat(const CGUICommonEnums::ImageType_t& eDestinationFormat);

private:
    void FillFrameOffsets(CGUIVideoData& kVideoData, const eC_UInt& uiNumFrames);

    eC_UInt GetU32(const eC_UByte* pkData);
    eC_UShort GetU16(const eC_UByte* pkData);

private:
    struct RGB
    {
        eC_UByte R;
        eC_UByte G;
        eC_UByte B;
    };

    struct MainAVIHeader_t
    {
        eC_UInt MicroSecPerFrame;
        eC_UInt MaxBytesPerSec;
        eC_UInt PaddingGranularity;
        eC_UInt Flags;
        eC_UInt TotalFrames;
        eC_UInt InitialFrames;
        eC_UInt Streams;
        eC_UInt SuggestedBufferSize;
        eC_UInt Width;
        eC_UInt Height;
        eC_UInt Reserved[4];
    };

    eC_UByte* m_pkScanLineBuffer;

    eC_UInt m_uiCurrentFrame;
    eC_UInt m_uiCurrentOffset;
    eC_UInt m_uiOffsetOfFirstFrame;
    eC_UInt m_uiOffsetOfLastFrameEnd;
    eC_Bool m_b16BitColor;
    CGUICommonEnums::ImageType_t m_eDestinationFormat;

    eC_UByte* m_pkHuffmanTable;
    eC_UInt m_uiHuffmanTableLength;
};

#endif
