/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#ifndef __GUIMEMPROFILE_H__
#define __GUIMEMPROFILE_H__

#include "GUIAnimatable.h"

#include "GUIFontResource.h"
#include "GUIRect.h"
#include "eC_String.h"
#include "GfxWrap.h"

#define GETMEMPROFILE CGUIMemProfile::GetInstance()

/**
GUI FPS measarument class.GUILIANI
Class for generating FPS measurements of the  components
using standard GfxWrapper calls. There already two default FPS counter:
- DEFAULT_FPS (0) meassures only the time needed for drawing GUILIANI controls
- DEFAULT_ABS_FPS (1) meassures the time for a complete loop in CGUI::Run
*/
class CGUIMemProfile : public CGUIAnimatable
{
public:
    friend class CGfxWrap; ///< for private access

    /** Method to access the one and only instance (Singleton)
    @return The instance of this class.
    */
    static CGUIMemProfile& GetInstance();

    /** Set profiling to active
    @param bActive
    */
    void SetActive(const eC_Bool& bActive);

    virtual void DoAnimate(const eC_Value &vTimes = eC_FromInt(1));

    /** Set the updating interval
    @param uiUpdateInterval time in milliseconds
    */
    void SetUpdateInterval(const eC_UInt& uiUpdateInterval);

    /** Set the background-color
    @param uiBackColor color in ARGB
    */
    void SetBackColor(const eC_UInt& uiBackColor);

    /** Set the text-color
    @param uiTextColor color in ARGB
    */
    void SetTextColor(const eC_UInt& uiTextColor);

    /** Set the font-id
    @param eFontID used font
    */
    void SetFont(const FontResource_t& eFontID);

    /** Set the position for the output
    @param vX x-position
    @param vY y-position
    */
    void SetPosition(const eC_Value& vX, const eC_Value& vY);

    /** Get the width of the text in pixels
    @return width of text
    */
    eC_Value GetTextWidth();

private:
    /// the one and only framerate instance
    static CGUIMemProfile* ms_pkInstance;

    /**stanadrd CGUIFramerate constructor
    @see SetPosition*/
    CGUIMemProfile();

    /** CGUIFramerate destructor*/
    virtual ~CGUIMemProfile();

    /** The single instance needs to be deleted*/
    static void DeleteInstance();

    /** calculates the current FPS for all counters*/
    void Update();

    /** draws all visible FPS counters on the screen*/
    void Draw() const;

    void CalcBackRectangle();

private:
    eC_Bool m_bActive;

    eC_UInt m_uiUpdateInterval;

    eC_UInt m_uiBackColor;
    eC_UInt m_uiTextColor;
    FontResource_t m_eFontID;

    eC_Value m_vPosX;
    eC_Value m_vPosY;
    eC_Value m_vLineHeight;

    CGUIRect m_kBackRect;

    eC_String m_kUsedMemory;
    eC_String m_kMaxUsedMemory;
    eC_String m_kLargestObject;
};

#endif
