/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#ifndef __GUIBITMAPWRITER_H__
#define __GUIBITMAPWRITER_H__

#include "eC_Types.h"
#include "eC_String.h"
#include "GUIBitmapPlane.h"

/**
@brief this class will create a bmp-file with the data of a bitmap-plane
and save it to disk.
*/
class CGUIBitmapWriter
{
public:
    /// header of bitmap
    typedef struct BITMAPINFOHEADER
    {
        eC_UInt bmp_size; ///< file size
        eC_UInt bmp_app; ///< 0
        eC_UInt bmp_offset; ///< offset to image data
    } BMP;

    /// dib-header of bitmap
    typedef struct DIB_HEADER
    {
        eC_UInt dib_size; ///< size
        eC_UInt dib_w; ///< width
        eC_UInt dib_h; ///< height
        eC_UShort dib_planes; ///< number of planes
        eC_UShort dib_bits; ///< bits
        eC_UInt dib_compression; ///< compression
        eC_UInt dib_rawsize; ///< size of raw data
        eC_UInt dib_xres; ///< x-resolution
        eC_UInt dib_yres; ///< y-resolution
        eC_UInt dib_palette; ///< data for palette
        eC_UInt dib_important; ///< important
    } DIB;

public:
    /** Write a bitmap-plane to BMP-file
    @param kFileNameAndPath filename
    @param eBitmapPlaneID id of bitmap-plane
    */
    static void WriteBMP(
        const eC_String &kFileNameAndPath,
        const GUIBitmapPlaneID_t& eBitmapPlaneID);

    /** Create a screenshot
    @param kFilename filename
    */
    static void CreateScreenshot(const eC_String& kFilename);
};

#endif
