/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#ifndef __GUIBIDIHELPER_H__
#define __GUIBIDIHELPER_H__

#include "eC_Types.h"
#include "eC_String.h"

/** This class is used to activate BiDi-support (bi-directional text) in Guiliani.
If BiDi is not activated, no conversion for input or display of strings is done.
*/
class CGUIBiDiHelper
{
public:
    /** This method activates/deactivates conversion of text for BiDi-support
    ATTENTION:
    - texts in languages needing BiDi-conversion will not be displayed properly if this setting inactive
    - if conversion is active the performance might drop and memory consumption might rise
    - when changing the setting during runtime, the whole GUI needs to be invalidated
    @param bActive setting for BiDi-conversion
    */
    static void SetActive(const eC_Bool& bActive);

    /** Determine if BiDi-conversion is currently active or not
    @return true if active else false
    */
    static eC_Bool IsActive();

    /** Check if provided text contains any potential BiDi-text
    this method returns false if bidi is not active.
    @param kInputString input text
    @return true if potentially BiDi
    */
    static eC_Bool IsBiDi(const eC_String& kInputString);

private:
    static eC_Bool ms_bActive;
};

#endif
