#ifndef CSVGSHAPE_H
#define CSVGSHAPE_H

#include "eC_Types.h"
#include "eC_Math.h"

/** This class represents an SVG-gradient */
class CSVGGradient
{
public:
    CSVGGradient() :
        m_eGradientType(LINEAR),
        m_eSpread(PAD),
        m_bIsStroke(false),
        m_afXform(),
        m_vFx(eC_FromFloat(1.f)),
        m_vFy(eC_FromFloat(1.f))
    {
    }

    /** Gradient-stop
    */
    struct GradientStop_t
    {
        eC_UInt m_uiColor; ///< color
        float m_vOffset; ///< offset
    };

    /** Gradient-type for paths
    */
    typedef enum
    {
        LINEAR, ///< linear
        RADIAL ///< radial
    } GradientType_t;

    /** Spreading-type
    */
    typedef enum
    {
        PAD, ///< pad
        REFLECT, ///< reflect
        REPEAT ///< repeat
    } Spread_t;

    GradientType_t m_eGradientType; ///< the used gradient-type
    Spread_t m_eSpread; ///< the used spread-type

    eC_Bool m_bIsStroke; ///< has stroke?

    eC_Float m_afXform[6]; ///< deforming matrix

    eC_Value m_vFx; ///< focalpoint x
    eC_Value m_vFy; ///< focalpoint y
    std::vector<GradientStop_t> m_akGradientStops; ///< gradient-stops
};

/** This class represents a SVG-form.
A SVG-image is just a row of objects from this type.
*/
class CSVGShape
{
public:
    /** This class is used to define a path.
    */
    struct Path_t
    {
        //a sequence of cubic bezier-curves
        eC_Bool m_bClosed; ///< is closed?
        std::vector<float> m_avCoords; ///< coordinates x,y,x,y,x,y...
    };

    CSVGShape() :
        m_eType(JUST_STROKE),
        m_eCapstyle(SQUARE_CAP),
        m_eJoinstyle(MITER_JOIN),
        m_eFillrule(NON_ZERO),
        m_vStrokeDashOffset(eC_FromFloat(0.0f)),
        m_ubOpacity(),
        m_uiFillColor(0),
        m_uiStrokeColor(0),
        m_vStrokeWidth(eC_FromInt(0)),
        m_avBounds()
    {
    }

    /** Filling-type
    */
    typedef enum
    {
        JUST_STROKE, ///< stroking
        JUST_FILL, ///< normal filling
        STROKE_AND_FILL ///< stroking and filling
    } Form_Type_t;

    /** Caping-style
    */
    typedef enum
    {
        BUTT_CAP, ///< butt-cap
        ROUND_CAP, ///< round-cap
        SQUARE_CAP ///< square-cap
    } Capstyle_t;

    /** Joining-style
    */
    typedef enum
    {
        BEVEL_JOIN, ///< bevel join
        ROUND_JOIN, ///< round join
        MITER_JOIN ///< miter join
    } Joinstyle_t;

    /** Filling-rule
    */
    typedef enum
    {
        NON_ZERO, ///< non-zero
        EVEN_ODD ///< even and odd
    } Fillrule_t;

    Form_Type_t m_eType; ///< used form-type
    Capstyle_t  m_eCapstyle; ///< used cap-style
    Joinstyle_t m_eJoinstyle; ///< used join-style
    Fillrule_t  m_eFillrule; ///< used filling-rule

    eC_Value m_vStrokeDashOffset; ///< stroking dash-offset
    std::vector<eC_Value> m_avStrokeDashArray; ///< max size from NanoSVG = 8

    eC_UByte    m_ubOpacity; ///< opacity 0 = fully transparent; 255 = fully opaque
    eC_UInt     m_uiFillColor; ///< filling-color
    eC_UInt     m_uiStrokeColor; ///< stroke-color
    eC_Value    m_vStrokeWidth; ///< stroke-width

    eC_Float m_avBounds[4]; ///< tight bounding box of the shape [minx,miny,maxx,maxy].

    std::vector<CSVGGradient> m_akGradients; ///< the used gradients
    std::vector<Path_t> m_akPaths; ///< the used paths
};

#endif // CSVGSHAPE_H
