/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#ifndef GUICOMMONTYPES_H
#define GUICOMMONTYPES_H

#include "GUIPropertyResource.h"

/// enumeration for color-types
enum ColorType_t
{
    CT_COLOR, ///< color as 32bit-value
    CT_PROPERTY ///< color as property
};

/// structure used to stream colors
struct ColorValue_t
{
    /// default-constructor
    ColorValue_t()
    {
        eType = CT_COLOR;
        uiColor = 0;
    }

    /** constructor
    @param Property id of property
    */
    ColorValue_t(const eC_Int& Property)
    {
        eType = CT_PROPERTY;
        iProperty = Property;
    }

    /** constructor
    @param Color color-value
    */
    ColorValue_t(const eC_UInt& Color)
    {
        eType = CT_COLOR;
        uiColor = Color;
    }

    /** constructor
    @param bIsProperty is property
    @param eProperty id of property
    @param uiValue color-value
    */
    ColorValue_t(const eC_Bool& bIsProperty, const GlobalProperty_t& eProperty, const eC_UInt& uiValue)
    {
        if (bIsProperty)
        {
            eType = CT_PROPERTY;
            iProperty = static_cast<eC_Int>(eProperty);
        }
        else
        {
            eType = CT_COLOR;
            uiColor = uiValue;
        }
    }

    ColorType_t eType; ///< value

    /// union for the value
    union
    {
        eC_UInt uiColor; ///< color
        eC_Int iProperty; ///< property
    };
};

#endif
