/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#ifndef CGUIRADIALPROGRESSBAR__H_
#define CGUIRADIALPROGRESSBAR__H_

#include "GUIRadialBar.h"

#include "GUIImageResource.h"
#include "GUICommonEnums.h"
#include "GUINinePatch.h"

/// A primitive-based radial progress bar.

// @guiliani_doxygen toplevel_control Radial Progress Bar
/**
    <table border="0">
        <tr>
            <td width="200">@image html radial_progress_bar.png</td>
            <td>
                The "radial progress bar" control is used to give the user an indication of how long an operation is going to take,
                and show that the running task is still in progress. The radial progress bar is drawn in a radial way with variable
                angles and colors.
            </td>
        </tr>
    </table>
*/
// @endguiliani_doxygen
/**
    @ingroup GUILIANI_CONTROLS
*/
class CGUIRadialProgressBar : public CGUIRadialBar
{
public:
    /** Constructor.
        @param pParent Pointer to parent object.
        @param vX X position relative to its parent object.
        @param vY Y position relative to its parent object.
        @param vWidth Width of the control.
        @param vHeight Height of the control.
        @param eID object handle for the control.
    */
    CGUIRadialProgressBar(
        CGUICompositeObject *const pParent,
        const eC_Value &vX, const eC_Value &vY,
        const eC_Value &vWidth, const eC_Value &vHeight,
        const ObjectHandle_t &eID = NO_HANDLE);

    /** Constructor.
        @param pParent Pointer to parent object.
        @param kRect rectangle area
        @param eID object handle for the control.
    */
    CGUIRadialProgressBar(
        CGUICompositeObject *const pParent,
        const CGUIRect& kRect,
        const ObjectHandle_t &eID = NO_HANDLE);

    /** Copy-constructor of the CGUIRadialProgressBar class.
        @param kSource Source object to be copied.
    */
    CGUIRadialProgressBar(const CGUIRadialProgressBar& kSource);

    /** Operator= method of the CGUIRadialProgressBar class.
        @param kSource Source object to be copied.
        @return Copied object.
    */
    CGUIRadialProgressBar& operator=(const CGUIRadialProgressBar& kSource);

    /** Increases the level/percentage of the bar by the value that is set with
        SetStepSize().
        @return True if successful, False otherwise
    */
    eC_Bool Increase();

    /** Decreases the level/percentage of the bar by the value that is set with
        SetStepSize().
        @return True if successful, False otherwise
    */
    eC_Bool Decrease();

    ///    Destructor
    virtual ~CGUIRadialProgressBar();

    /** Change the width of this control. The progressing area is changed proportionally.
        @param vWidth Width of the control.
    */
    virtual void SetWidth(const eC_Value &vWidth);

    /** Change the height of this control. The progressing area is changed proportionally.
        @param vHeight Height of the control.
    */
    virtual void SetHeight(const eC_Value &vHeight);

#ifdef GUILIANI_STREAM_GUI
    CGUIRadialProgressBar();

    virtual void ReadFromStream();
#endif

#ifdef GUILIANI_WRITE_GUI
    virtual void WriteToStream(const eC_Bool bWriteClassID = false);
#endif

    virtual eC_Bool IsHighlightable() const { return false; }

protected:
    /** Internal method called by Increase() and Decrease().
        @param bInc true to increase a step, false to decrease a step.
        @return Always True
    */
    eC_Bool IncrementValue(eC_Bool bInc);

    /** Help function to initialize the control.
    */
    void Init();

    /** Copy attributes from source control to this control.
        @param kSource Source object to be copied.
    */
    void CopyAttributes(const CGUIRadialProgressBar& kSource);

    /// Deinitialize the control and free the resources.
    void DeInit();
};
#endif
