/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#if !defined(GUI_SWITCH_RESOURCESETS_CMD_H)
#define GUI_SWITCH_RESOURCESETS_CMD_H

#include "GUITypes.h"

#include "GUICommand.h"

/**
@brief This command can be used to switch to other resource-sets during runtime.
*/
class CGUISwitchResourceSetsCmd : public CGUICommand
{
public:
    /** Constructor
    @param eResourceType
    @param kResourceSetName
    */
    CGUISwitchResourceSetsCmd(const ResourceType_t eResourceType, const eC_String kResourceSetName);

#if defined(GUILIANI_STREAM_GUI)
    CGUISwitchResourceSetsCmd();
    virtual void ReadFromStream();
#endif

#if defined(GUILIANI_WRITE_GUI)
    virtual void WriteToStream(const eC_Bool bWriteClassID = false);
#endif

#if defined(GUILIANI_STREAM_GUI) || defined(GUILIANI_WRITE_GUI)
    static const eC_Char XMLTAG_RESOURCETYPE[]; ///< resource-type
    static const eC_Char XMLTAG_RESOURCESETNAME[]; ///< resource-setname
#endif

protected:
    ~CGUISwitchResourceSetsCmd();
    virtual void Do();

private:
    ResourceType_t m_eResourceType;
    eC_String m_kResourceSetName;
};

#endif
