/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#ifndef GUI_STOP_ANIMATIONCHAIN_CMD_H
#define GUI_STOP_ANIMATIONCHAIN_CMD_H

#include "GUICommand.h"
#include "GUIAnimationResource.h"

/** This command by default stops specified animation-chain.
If bStopAllChains is true, all currently running chains are stopped

@ingroup GUILIANI_COMMANDS
*/
class CGUIStopAnimationChainCmd : public CGUICommand
{
public:
    /** Constructs an CGUIStartAnimationsCmd.
    @param eAnimationChainID The chain that should be stopped
    @param bStopAllChains true if all chains should be stopped
    */
    CGUIStopAnimationChainCmd(
        const AnimationHandle_t& eAnimationChainID,
        const eC_Bool& bStopAllChains);

    /** Standard constructor
    */
    CGUIStopAnimationChainCmd();

#if defined(GUILIANI_STREAM_GUI)
    virtual void ReadFromStream();
#endif

#if defined(GUILIANI_WRITE_GUI)
    virtual void WriteToStream(const eC_Bool bWriteClassID = false);
#endif

protected:
    virtual void Do();

private:
    AnimationHandle_t m_eAnimationChainID;
    eC_Bool m_bStopAllChains;
};

#endif
