/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#ifndef GUI_START_ANIMATIONCHAIN_CMD_H
#define GUI_START_ANIMATIONCHAIN_CMD_H

#include "GUIAnimationResource.h"
#include "GUICommand.h"

/** This command by default starts all animation chains. This will result in starting
of all animations contained within an animation chain.

@ingroup GUILIANI_COMMANDS
*/
class CGUIStartAnimationChainCmd : public CGUICommand
{
public:
    /** Constructs an CGUIStartAnimationsCmd.
    @param eAnimationChainID The chain that should be started
    */
    CGUIStartAnimationChainCmd(const AnimationHandle_t& eAnimationChainID);

    /** Standard constructor
    */
    CGUIStartAnimationChainCmd();

#if defined(GUILIANI_STREAM_GUI)
    virtual void ReadFromStream();
#endif

#if defined(GUILIANI_WRITE_GUI)
    virtual void WriteToStream(const eC_Bool bWriteClassID = false);
#endif

protected:
    virtual void Do();

private:
    AnimationHandle_t m_eAnimationChainID;
};

#endif
