/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#ifndef GUI_SETDATAPOOL_CMD_H
#define GUI_SETDATAPOOL_CMD_H

#include "GUICommand.h"

#include "GUIDataPool.h"

/**
@brief This command can be used to execute specific code inside the application
*/
class CGUISetDataPoolCmd : public CGUICommand
{
public:
    /// Default constructor used by streaming factory
    CGUISetDataPoolCmd();

    /** Constructor.
    @param eDataPoolID id of datapool-resource
    @param kValue value
    @param uiX x-coordinate in two-dimensional array
    @param uiY y-coordinate in two-dimensional array
    */
    CGUISetDataPoolCmd(
        const DataPoolResource_t& eDataPoolID,
        const CGUIValue& kValue,
        const eC_UInt& uiX,
        const eC_UInt& uiY);

#if defined(GUILIANI_STREAM_GUI)
    /** Reads all attributes from streaming file.
    This method is called by CGUIFactoryManager after one of the registered
    factories has created an instance of this class.
    */
    virtual void ReadFromStream();
#endif

#if defined(GUILIANI_WRITE_GUI)
    /** Writes all attributes to the streaming file. A CGUIStreamWriter
    has to be initialized first.
    @param bWriteClassID This flag is used to select if writing of command
    class ID, leading and trailing tags is performed.
    */
    virtual void WriteToStream(const eC_Bool bWriteClassID = false);
#endif

protected:
    /// Implements the actual command functionality.
    void Do();

    DataPoolResource_t m_eDataPoolID; ///< id of datapool-resource

    CGUIValue m_kValue; ///< value

    eC_UInt m_uiX; ///< x-coordinate
    eC_UInt m_uiY; ///< y-coordinate
};

#endif
