/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#ifndef GUI_DELAY_CMD_H
#define GUI_DELAY_CMD_H

#include "GUICommand.h"

/**
@brief This command can be used to execute other commands after a specific period of time.
*/
class CGUIDelayCmd : public CGUICommand
{
public:
    /// default constructor
    CGUIDelayCmd();

    /**
    constructor
    @param uiDuration delay-duration
    */
    CGUIDelayCmd(eC_UInt uiDuration);

#if defined(GUILIANI_STREAM_GUI)
    virtual void ReadFromStream();
#endif

#if defined(GUILIANI_WRITE_GUI)
    virtual void WriteToStream(const eC_Bool bWriteClassID = false);
#endif

protected:
    ~CGUIDelayCmd() {}
    virtual void Do();

private:
    eC_UInt m_uiDuration; ///< duration to wait before execution of the next command
    eC_Bool m_bTimerStarted; ///< indicates if timer has started
};

#endif
