/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#ifndef GUI_CALLAPI_CMD_H
#define GUI_CALLAPI_CMD_H

#include "GUICommand.h"
#include "eC_String.h"

/**
@brief This command can be used to execute specific code inside the application
*/
class CGUICallAPICmd : public CGUICommand
{
public:
    /// Default constructor used by streaming factory
    CGUICallAPICmd();

    /** Constructor.
    @param kAPI String which will be forwarded to CMyGUI::CallApplicationAPI to identify which application API to call
    @param kParam Optional parameter which will be handed over to CMyGUI::CallApplicationAPI as well */
    CGUICallAPICmd(const eC_String& kAPI, const eC_String& kParam);

#if defined(GUILIANI_STREAM_GUI)
    /** Reads all attributes from streaming file.
    This method is called by CGUIFactoryManager after one of the registered
    factories has created an instance of this class.
    */
    virtual void ReadFromStream();
#endif

#if defined(GUILIANI_WRITE_GUI)
    /** Writes all attributes to the streaming file. A CGUIStreamWriter
    has to be initialized first.
    @param bWriteClassID This flag is used to select if writing of command
    class ID, leading and trailing tags is performed.
    */
    virtual void WriteToStream(const eC_Bool bWriteClassID = false);
#endif

protected:
    /// Implements the actual command functionality.
    void Do();

    /// API which is called
    eC_String m_kAPI;

    /// Parameter which is used
    eC_String m_kParam;
};

#endif // CALLAPPLICATIONAPICMD_H
